/* -----------------------------------------------------------------------------
Software License for The Fraunhofer FDK AAC Codec Library for Android

© Copyright  1995 - 2018 Fraunhofer-Gesellschaft zur Förderung der angewandten
Forschung e.V. All rights reserved.

 1.    INTRODUCTION
The Fraunhofer FDK AAC Codec Library for Android ("FDK AAC Codec") is software
that implements the MPEG Advanced Audio Coding ("AAC") encoding and decoding
scheme for digital audio. This FDK AAC Codec software is intended to be used on
a wide variety of Android devices.

AAC's HE-AAC and HE-AAC v2 versions are regarded as today's most efficient
general perceptual audio codecs. AAC-ELD is considered the best-performing
full-bandwidth communications codec by independent studies and is widely
deployed. AAC has been standardized by ISO and IEC as part of the MPEG
specifications.

Patent licenses for necessary patent claims for the FDK AAC Codec (including
those of Fraunhofer) may be obtained through Via Licensing
(www.vialicensing.com) or through the respective patent owners individually for
the purpose of encoding or decoding bit streams in products that are compliant
with the ISO/IEC MPEG audio standards. Please note that most manufacturers of
Android devices already license these patent claims through Via Licensing or
directly from the patent owners, and therefore FDK AAC Codec software may
already be covered under those patent licenses when it is used for those
licensed purposes only.

Commercially-licensed AAC software libraries, including floating-point versions
with enhanced sound quality, are also available from Fraunhofer. Users are
encouraged to check the Fraunhofer website for additional applications
information and documentation.

2.    COPYRIGHT LICENSE

Redistribution and use in source and binary forms, with or without modification,
are permitted without payment of copyright license fees provided that you
satisfy the following conditions:

You must retain the complete text of this software license in redistributions of
the FDK AAC Codec or your modifications thereto in source code form.

You must retain the complete text of this software license in the documentation
and/or other materials provided with redistributions of the FDK AAC Codec or
your modifications thereto in binary form. You must make available free of
charge copies of the complete source code of the FDK AAC Codec and your
modifications thereto to recipients of copies in binary form.

The name of Fraunhofer may not be used to endorse or promote products derived
from this library without prior written permission.

You may not charge copyright license fees for anyone to use, copy or distribute
the FDK AAC Codec software or your modifications thereto.

Your modified versions of the FDK AAC Codec must carry prominent notices stating
that you changed the software and the date of any change. For modified versions
of the FDK AAC Codec, the term "Fraunhofer FDK AAC Codec Library for Android"
must be replaced by the term "Third-Party Modified Version of the Fraunhofer FDK
AAC Codec Library for Android."

3.    NO PATENT LICENSE

NO EXPRESS OR IMPLIED LICENSES TO ANY PATENT CLAIMS, including without
limitation the patents of Fraunhofer, ARE GRANTED BY THIS SOFTWARE LICENSE.
Fraunhofer provides no warranty of patent non-infringement with respect to this
software.

You may use this FDK AAC Codec software or modifications thereto only for
purposes that are authorized by appropriate patent licenses.

4.    DISCLAIMER

This FDK AAC Codec software is provided by Fraunhofer on behalf of the copyright
holders and contributors "AS IS" and WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
including but not limited to the implied warranties of merchantability and
fitness for a particular purpose. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE for any direct, indirect, incidental, special, exemplary,
or consequential damages, including but not limited to procurement of substitute
goods or services; loss of use, data, or profits, or business interruption,
however caused and on any theory of liability, whether in contract, strict
liability, or tort (including negligence), arising in any way out of the use of
this software, even if advised of the possibility of such damage.

5.    CONTACT INFORMATION

Fraunhofer Institute for Integrated Circuits IIS
Attention: Audio and Multimedia Departments - FDK AAC LL
Am Wolfsmantel 33
91058 Erlangen, Germany

www.iis.fraunhofer.de/amm
amm-info@iis.fraunhofer.de
----------------------------------------------------------------------------- */

/******************* Library for basic calculation routines ********************

   Author(s):   Omer Osman

   Description: MPEG-D SAC/USAC/SAOC Huffman Part0 Tables

*******************************************************************************/

#include "huff_nodes.h"

const HUFF_PT0_NODES FDK_huffPart0Nodes = {
    {{2, 1},     {4, 3},     {6, 5},     {8, 7},    {10, 9},    {12, 11},
     {14, 13},   {-8, 15},   {-9, 16},   {-10, 17}, {-18, 18},  {-17, -19},
     {-16, 19},  {-11, -20}, {-15, -21}, {-7, 20},  {-22, 21},  {-12, -14},
     {-13, -23}, {23, 22},   {-24, -31}, {-6, 24},  {-25, -26}, {26, 25},
     {-5, -27},  {-28, 27},  {-4, 28},   {-29, 29}, {-1, -30},  {-2, -3}},
    {{2, 1}, {-5, 3}, {-4, -6}, {-3, 4}, {-2, 5}, {-1, 6}, {-7, -8}},
    {{-1, 1}, {-8, 2}, {-2, 3}, {5, 4}, {-7, 6}, {-3, -5}, {-4, -6}},
    {{-1, 1},
     {3, 2},
     {-8, 4},
     {6, 5},
     {-16, 7},
     {9, 8},
     {11, 10},
     {-2, -7},
     {-6, 12},
     {-4, -5},
     {-3, 13},
     {-10, 14},
     {-11, -12},
     {-14, -15},
     {-9, -13}},
    {{2, 1},     {4, 3},     {6, 5},     {8, 7},    {10, 9},    {12, 11},
     {14, 13},   {16, 15},   {18, 17},   {20, 19},  {22, 21},   {24, 23},
     {26, 25},   {28, 27},   {30, 29},   {32, 31},  {-47, 33},  {-54, 34},
     {-46, 35},  {-48, 36},  {-23, -27}, {-45, 37}, {-55, 38},  {-22, -49},
     {-24, -53}, {-44, 39},  {-57, 40},  {-28, 41}, {-52, -56}, {-43, 42},
     {-50, 43},  {-25, -26}, {-29, -64}, {-62, 44}, {-21, -51}, {-58, 45},
     {-32, 46},  {-31, -42}, {-60, 47},  {-30, 48}, {-20, -61}, {-41, -63},
     {-19, -59}, {-40, 49},  {-18, -38}, {-39, 50}, {-36, -37}, {-35, 51},
     {-17, 52},  {-16, -34}, {-33, 53},  {-15, 54}, {-14, 55},  {-13, 56},
     {-12, 57},  {-11, 58},  {-10, 59},  {-9, 60},  {-7, 61},   {-1, -4},
     {-6, 62},   {-5, -8},   {-2, -3}}};

const HUFF_LAV_NODES FDK_huffLavIdxNodes = {{{-1, 1}, {-2, 2}, {-3, -4}}};

static const HUFF_ICC_NOD_1D FDK_huffICCNodes_h1D_0 = {
    {{-1, 1}, {-2, 2}, {-3, 3}, {-4, 4}, {-5, 5}, {-6, 6}, {-7, -8}}};

static const HUFF_ICC_NOD_2D FDK_huffICCNodes_h2D_0_0 = {
    {{-1, 1}, {-18, 2}, {-2, -17}},
    {{2, 1},
     {-1, -52},
     {-2, 3},
     {5, 4},
     {-51, 6},
     {-18, 7},
     {-17, 8},
     {-3, 9},
     {-36, 10},
     {-19, -50},
     {-35, 11},
     {-4, 12},
     {-34, 13},
     {-33, 14},
     {-20, -49}},
    {{2, 1},     {-86, 3},  {-1, 4},   {6, 5},     {-2, 7},    {-85, 8},
     {-18, 9},   {11, 10},  {-17, 12}, {14, 13},   {-70, 15},  {-3, -19},
     {-69, 16},  {-84, 17}, {-68, 18}, {-20, -35}, {-34, -83}, {20, 19},
     {-4, 21},   {-33, 22}, {-5, 23},  {-53, 24},  {-36, -52}, {-67, 25},
     {-21, -82}, {-54, 26}, {-6, 27},  {-51, 28},  {-50, 29},  {-49, 30},
     {-37, 31},  {-38, 0},  {0, 0},    {0, 0},     {0, 0}},
    {{2, 1},     {4, 3},     {-1, -120}, {6, 5},      {8, 7},     {-18, 9},
     {-2, 10},   {12, 11},   {14, 13},   {-17, -119}, {16, 15},   {-103, 17},
     {-104, 18}, {-52, 19},  {21, 20},   {-69, 22},   {24, 23},   {-3, -35},
     {-19, 25},  {-34, -85}, {27, 26},   {-86, 28},   {-118, 29}, {-37, 30},
     {32, 31},   {-102, 33}, {-20, -22}, {-4, -117},  {-87, 34},  {-100, 35},
     {-33, -36}, {37, 36},   {-70, -88}, {-101, 38},  {-5, 39},   {-51, -53},
     {-50, 40},  {-115, 41}, {-21, 42},  {-116, 43},  {-38, 44},  {-23, -84},
     {-49, -99}, {46, 45},   {-6, -114}, {-7, -72},   {-71, 47},  {-8, 0},
     {0, 0},     {0, 0},     {0, 0},     {0, 0},      {0, 0},     {0, 0},
     {0, 0},     {0, 0},     {0, 0},     {0, 0},      {0, 0},     {0, 0},
     {0, 0},     {0, 0},     {0, 0}}};
static const HUFF_ICC_NOD_2D FDK_huffICCNodes_h2D_0_1 = {
    {{-1, 1}, {-18, 2}, {-2, -17}},
    {{2, 1},
     {-1, -52},
     {-17, 3},
     {5, 4},
     {-36, 6},
     {-2, 7},
     {-18, -33},
     {9, 8},
     {-20, 10},
     {-34, -51},
     {-49, 11},
     {-35, 12},
     {-19, 13},
     {-3, 14},
     {-4, -50}},
    {{2, 1},     {-86, 3},   {-1, 4},   {-17, 5},   {7, 6},    {-70, 8},
     {-33, 9},   {-18, 10},  {-2, 11},  {-54, 12},  {-49, 13}, {-38, 14},
     {-34, -65}, {-85, 15},  {-50, 16}, {-69, 17},  {-22, 18}, {-53, 19},
     {21, 20},   {-19, -81}, {-66, 22}, {-3, -35},  {24, 23},  {-37, 25},
     {-68, -84}, {-51, 26},  {28, 27},  {-20, -52}, {30, 29},  {-4, -36},
     {-83, 31},  {-67, 32},  {-82, 33}, {-21, 34},  {-5, -6}},
    {{2, 1},     {-1, 3},     {-120, 4},  {-17, 5},    {7, 6},      {-104, 8},
     {-33, 9},   {11, 10},    {13, 12},   {-49, 14},   {-88, 15},   {-18, -97},
     {-65, 16},  {-40, 17},   {-2, -72},  {19, 18},    {-113, 20},  {-34, 21},
     {-56, -81}, {23, 22},    {-50, 24},  {-82, -119}, {-24, -103}, {26, 25},
     {28, 27},   {30, 29},    {-55, -87}, {-66, 31},   {33, 32},    {-98, 34},
     {-35, -67}, {-19, 35},   {-70, 36},  {-71, 37},   {-51, -52},  {-3, 38},
     {40, 39},   {-86, -118}, {42, 41},   {-39, -69},  {-54, -83},  {44, 43},
     {-102, 45}, {-101, 46},  {-68, -85}, {-36, -53},  {-5, 0},     {0, 0},
     {0, 0},     {0, 0},      {0, 0},     {0, 0},      {0, 0},      {0, 0},
     {0, 0},     {0, 0},      {0, 0},     {0, 0},      {0, 0},      {0, 0},
     {0, 0},     {0, 0},      {0, 0}}};
static const HUFF_ICC_NOD_2D FDK_huffICCNodes_h2D_1_0 = {
    {{-1, 1}, {-18, 2}, {-2, -17}},
    {{-52, 1},
     {-1, 2},
     {4, 3},
     {-2, -17},
     {-18, 5},
     {-36, 6},
     {-51, 7},
     {9, 8},
     {-33, 10},
     {-34, 11},
     {-35, 12},
     {-19, -20},
     {-3, 13},
     {-49, 14},
     {-4, -50}},
    {{-1, 1},    {-86, 2},  {4, 3},     {-17, 5},  {-2, 6},    {-18, 7},
     {-70, 8},   {-85, 9},  {11, 10},   {13, 12},  {-33, 14},  {16, 15},
     {-34, -54}, {-69, 17}, {-38, 18},  {-50, 19}, {-35, -53}, {-49, 20},
     {-19, 21},  {-3, 22},  {-65, 23},  {-68, 24}, {-22, 25},  {-81, -84},
     {-66, 26},  {-37, 27}, {-20, -51}, {29, 28},  {-52, 30},  {-4, -83},
     {-36, 31},  {-67, 32}, {-5, 33},   {-82, 34}, {-21, 0}},
    {{-1, 1},    {-120, 2},  {4, 3},     {-17, 5},   {-2, 6},     {8, 7},
     {-18, 9},   {-104, 10}, {12, 11},   {14, 13},   {16, 15},    {-119, 17},
     {-81, 18},  {20, 19},   {-33, 21},  {-88, 22},  {-103, 23},  {-34, 24},
     {-56, 25},  {-72, 26},  {-49, 27},  {-82, 28},  {-50, 29},   {-65, 30},
     {-55, -87}, {-19, 31},  {-67, 32},  {-35, -40}, {34, 33},    {-52, -71},
     {-66, 35},  {-70, 36},  {38, 37},   {-51, -97}, {-86, -102}, {-3, 39},
     {-118, 40}, {42, 41},   {-24, -85}, {-54, 43},  {-39, 44},   {-98, -113},
     {-36, -37}, {-20, -69}, {-4, 45},   {-5, 46},   {-21, 0},    {0, 0},
     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},      {0, 0},
     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},      {0, 0},
     {0, 0},     {0, 0},     {0, 0}}};
static const HUFF_ICC_NOD_2D FDK_huffICCNodes_h2D_1_1 = {
    {{-1, 1}, {-18, 2}, {-2, -17}},
    {{-52, 1},
     {-1, 2},
     {4, 3},
     {-2, 5},
     {-17, -18},
     {-51, 6},
     {-36, 7},
     {9, 8},
     {-35, 10},
     {-3, 11},
     {-19, -34},
     {-33, 12},
     {-50, 13},
     {-20, 14},
     {-4, -49}},
    {{2, 1},    {-86, 3},   {-1, 4},    {6, 5},     {-18, 7},  {-2, -17},
     {9, 8},    {-70, 10},  {-69, -85}, {-35, 11},  {13, 12},  {-34, 14},
     {-19, 15}, {-53, 16},  {-68, 17},  {-33, 18},  {-3, -52}, {20, 19},
     {-54, 21}, {-84, 22},  {-50, 23},  {-20, -51}, {-36, 24}, {26, 25},
     {-83, 27}, {-4, -38},  {-49, 28},  {-37, 29},  {-67, 30}, {-5, 31},
     {-21, 32}, {-65, -66}, {-82, 33},  {-22, 34},  {-6, -81}},
    {{2, 1},     {-1, -120}, {4, 3},     {6, 5},     {-18, 7},    {9, 8},
     {-17, 10},  {-2, 11},   {-103, 12}, {-52, 13},  {-35, -104}, {-119, 14},
     {16, 15},   {-69, -86}, {18, 17},   {-34, 19},  {-19, 20},   {22, 21},
     {-70, 23},  {-87, 24},  {-102, 25}, {-85, 26},  {-33, 27},   {-36, 28},
     {-3, 29},   {-88, 30},  {-51, 31},  {-118, 32}, {34, 33},    {-68, 35},
     {-53, 36},  {-67, 37},  {-20, 38},  {-101, 39}, {-50, 40},   {42, 41},
     {-37, 43},  {-116, 44}, {-117, 45}, {-49, 46},  {-21, -100}, {48, 47},
     {-55, -71}, {-4, 49},   {-22, -84}, {-115, 50}, {-66, -82},  {-72, 51},
     {-5, -6},   {-54, 52},  {-38, 53},  {-83, 54},  {-40, 55},   {-39, 56},
     {-99, 57},  {-23, -56}, {-7, 58},   {-65, -97}, {-8, 0},     {0, 0},
     {0, 0},     {0, 0},     {0, 0}}};

const HUFF_ICC_NODES FDK_huffICCNodes = {
    {&FDK_huffICCNodes_h1D_0, &FDK_huffICCNodes_h1D_0, &FDK_huffICCNodes_h1D_0},
    {{&FDK_huffICCNodes_h2D_0_0, &FDK_huffICCNodes_h2D_0_1},
     {&FDK_huffICCNodes_h2D_1_0, &FDK_huffICCNodes_h2D_1_1},
     {&FDK_huffICCNodes_h2D_0_1, &FDK_huffICCNodes_h2D_0_1}}};

static const HUFF_CLD_NOD_1D FDK_huffCLDNodes_h1D_0 = {
    {{-1, 1},   {-2, 2},   {-3, 3},    {-4, 4},    {-5, 5},    {-6, 6},
     {-7, 7},   {-8, 8},   {-9, 9},    {-10, 10},  {-11, 11},  {-12, 12},
     {-13, 13}, {15, 14},  {-14, 16},  {-15, 17},  {-16, 18},  {-17, 19},
     {-18, 20}, {-19, 21}, {-20, -21}, {-23, 22},  {-22, 23},  {-24, 24},
     {-25, 25}, {27, 26},  {29, 28},   {-30, -31}, {-28, -29}, {-26, -27}}};
static const HUFF_CLD_NOD_1D FDK_huffCLDNodes_h1D_1 = {
    {{-1, 1},   {-2, 2},    {-3, 3},   {-4, 4},    {-5, 5},    {-6, 6},
     {-7, 7},   {9, 8},     {-8, 10},  {-9, 11},   {-10, 12},  {-11, 13},
     {-12, 14}, {-13, 15},  {-14, 16}, {-15, 17},  {-16, 18},  {-17, 19},
     {-18, 20}, {-19, -20}, {-21, 21}, {-22, 22},  {-23, 23},  {25, 24},
     {-24, 26}, {-25, 27},  {29, 28},  {-26, -31}, {-29, -30}, {-27, -28}}};

static const HUFF_CLD_NOD_2D FDK_huffCLDNodes_h2_0_0 = {
    {{2, 1},
     {-1, -52},
     {4, 3},
     {-2, 5},
     {-51, 6},
     {-17, -18},
     {8, 7},
     {10, 9},
     {-3, -36},
     {-19, 11},
     {-35, -50},
     {-34, 12},
     {-4, 13},
     {-33, 14},
     {-20, -49}},
    {{2, 1},     {4, 3},     {-86, 5},  {7, 6},    {9, 8},     {-1, -2},
     {-85, 10},  {-18, 11},  {-17, 12}, {14, 13},  {-70, 15},  {17, 16},
     {-19, -69}, {-84, 18},  {-3, 19},  {21, 20},  {-34, -68}, {-20, 22},
     {-35, 23},  {-83, 24},  {-33, 25}, {-4, 26},  {-53, 27},  {-54, -67},
     {-36, 28},  {-21, -52}, {-82, 29}, {-5, -50}, {-51, 30},  {-38, 31},
     {-37, -49}, {-6, 32},   {-66, 33}, {-65, 34}, {-22, -81}},
    {{2, 1},      {4, 3},      {-120, 5},  {7, 6},      {9, 8},     {11, 10},
     {-1, 12},    {-18, -119}, {-2, 13},   {15, 14},    {-17, 16},  {-104, 17},
     {19, 18},    {-19, 20},   {-103, 21}, {-118, 22},  {24, 23},   {-3, 25},
     {27, 26},    {-34, 28},   {-102, 29}, {-20, 30},   {-35, 31},  {33, 32},
     {-117, 34},  {-33, 35},   {-88, 36},  {-4, 37},    {-87, 38},  {40, 39},
     {-36, -101}, {-86, 41},   {-21, -37}, {-85, -100}, {-52, 42},  {-22, 43},
     {-116, 44},  {-50, 45},   {47, 46},   {-5, -51},   {-115, 48}, {-70, 49},
     {-84, 50},   {-38, -49},  {-72, -99}, {-53, 51},   {-69, -71}, {-23, 52},
     {-6, -67},   {-114, 53},  {-7, 54},   {-66, -68},  {-55, 55},  {57, 56},
     {-54, -65},  {-8, -56},   {-82, -83}, {59, 58},    {-39, -40}, {-81, 60},
     {-98, 61},   {-97, 62},   {-24, -113}},
    {{2, 1},      {4, 3},      {6, 5},      {-154, 7},    {9, 8},
     {11, 10},    {13, 12},    {15, 14},    {-18, 16},    {-153, 17},
     {-1, -2},    {19, 18},    {-138, 20},  {-17, 21},    {23, 22},
     {25, 24},    {-19, -137}, {27, 26},    {-152, 28},   {30, 29},
     {-3, -34},   {32, 31},    {34, 33},    {36, 35},     {-136, 37},
     {-35, 38},   {-20, 39},   {-122, 40},  {-151, 41},   {-33, 42},
     {-121, 43},  {45, 44},    {47, 46},    {-4, 48},     {-36, -120},
     {-135, 49},  {51, 50},    {-21, 52},   {54, 53},     {56, 55},
     {-50, -150}, {58, 57},    {-51, 59},   {61, 60},     {-119, 62},
     {-52, 63},   {-5, 64},    {-37, 65},   {-117, -134}, {-39, -54},
     {-22, 66},   {-106, 67},  {-69, -102}, {-132, 68},   {-105, 69},
     {-49, 70},   {-149, 71},  {-24, -104}, {73, 72},     {-53, 74},
     {-38, -118}, {-103, 75},  {-6, 76},    {-66, -87},   {-133, -147},
     {-23, 77},   {-67, 78},   {-68, -86},  {-70, -101},  {-40, -148},
     {-116, 79},  {-55, 80},   {-84, -131}, {82, 81},     {-89, -90},
     {-7, -25},   {-85, -88},  {-65, 83},   {-72, -146},  {85, 84},
     {-9, -71},   {-83, 86},   {-82, 87},   {-8, 88},     {-100, 89},
     {-74, -99},  {-73, 90},   {-10, -81},  {-56, 91},    {-57, -98},
     {93, 92},    {-58, -114}, {-97, -115}, {95, 94},     {-41, 96},
     {-42, 97},   {-26, -129}, {-113, 98},  {-130, -145}}};
static const HUFF_CLD_NOD_2D FDK_huffCLDNodes_h2_0_1 = {
    {{-1, 1},
     {-52, 2},
     {-17, 3},
     {5, 4},
     {-36, 6},
     {-33, 7},
     {-2, -18},
     {-20, 8},
     {10, 9},
     {-34, -49},
     {-51, 11},
     {-35, 12},
     {-19, 13},
     {-3, 14},
     {-4, -50}},
    {{2, 1},    {4, 3},     {-86, 5},  {-1, 6},   {-17, 7},   {-70, 8},
     {10, 9},   {-18, 11},  {-33, 12}, {-54, 13}, {-2, 14},   {-34, 15},
     {-38, 16}, {-49, 17},  {-85, 18}, {-50, 19}, {-69, 20},  {-53, -65},
     {-22, 21}, {-66, 22},  {-19, 23}, {-37, 24}, {-35, -81}, {-3, 25},
     {-51, 26}, {-68, -84}, {-52, 27}, {29, 28},  {-20, 30},  {-4, -36},
     {-83, 31}, {-67, 32},  {-21, 33}, {-5, 34},  {-6, -82}},
    {{2, 1},     {4, 3},     {6, 5},     {-120, 7},  {-17, 8},   {-1, -104},
     {10, 9},    {12, 11},   {-18, 13},  {-33, -88}, {15, 14},   {17, 16},
     {-2, 18},   {-34, 19},  {-72, 20},  {-49, 21},  {-119, 22}, {-50, 23},
     {-103, 24}, {-56, 25},  {-65, 26},  {28, 27},   {-40, -87}, {-66, 29},
     {-82, 30},  {32, 31},   {-19, -81}, {-71, 33},  {-97, 34},  {-35, -55},
     {-24, 35},  {37, 36},   {-3, -98},  {-51, 38},  {-67, 39},  {-39, -118},
     {-113, 40}, {-102, 41}, {-86, 42},  {-70, -83}, {44, 43},   {-20, -54},
     {-52, 45},  {-36, 46},  {-4, 47},   {-68, 48},  {-85, 49},  {-101, -117},
     {-69, 50},  {52, 51},   {-21, -37}, {-53, 53},  {55, 54},   {-5, -100},
     {-116, 56}, {-84, 57},  {-38, 58},  {-22, -99}, {-115, 59}, {-6, 60},
     {-23, 61},  {-7, 62},   {-114, 0}},
    {{2, 1},      {4, 3},       {6, 5},       {-154, 7},    {9, 8},
     {-17, 10},   {-138, 11},   {-1, 12},     {14, 13},     {16, 15},
     {-33, -122}, {-18, 17},    {19, 18},     {-34, 20},    {-2, 21},
     {-106, 22},  {-49, 23},    {25, 24},     {-50, 26},    {-153, 27},
     {-90, 28},   {-137, 29},   {-65, 30},    {32, 31},     {-66, 33},
     {-121, 34},  {-74, 35},    {-81, 36},    {38, 37},     {-42, 39},
     {-82, 40},   {-105, 41},   {-19, -114},  {-58, 42},    {-35, 43},
     {-97, 44},   {46, 45},     {-129, 47},   {-26, -89},   {-57, -98},
     {-51, 48},   {-3, 49},     {-113, 50},   {-130, 51},   {-152, 52},
     {-67, -73},  {-99, -136},  {-145, 53},   {-120, 54},   {-41, 55},
     {-83, 56},   {-72, 57},    {-104, 58},   {-115, 59},   {-20, 60},
     {62, 61},    {-36, -88},   {-84, 63},    {-52, -56},   {65, 64},
     {-4, -87},   {-68, 66},    {-151, 67},   {-100, -135}, {69, 68},
     {-69, -119}, {-103, 70},   {-71, 71},    {73, 72},     {-21, 74},
     {-85, 75},   {-37, -53},   {-86, 76},    {78, 77},     {-102, -150},
     {-5, 79},    {-134, 80},   {-118, 81},   {-54, -117},  {83, 82},
     {-38, -70},  {-22, 84},    {-6, 85},     {87, 86},     {-55, 88},
     {-101, 89},  {-133, -149}, {-24, -39},   {91, 90},     {-132, 92},
     {-23, 93},   {-7, 94},     {-147, -148}, {-116, -131}, {-25, 95},
     {-40, 0},    {0, 0},       {0, 0},       {0, 0}}};
static const HUFF_CLD_NOD_2D FDK_huffCLDNodes_h2_1_0 = {
    {{-1, 1},
     {-52, 2},
     {-17, 3},
     {5, 4},
     {-2, -36},
     {-18, 6},
     {8, 7},
     {-51, 9},
     {-33, 10},
     {-34, 11},
     {-20, -35},
     {-19, 12},
     {-3, 13},
     {-49, 14},
     {-4, -50}},
    {{2, 1},     {-86, 3},   {-1, 4},   {-17, 5},   {7, 6},    {-70, 8},
     {-2, -18},  {10, 9},    {12, 11},  {-85, 13},  {-33, 14}, {-34, -54},
     {16, 15},   {-69, 17},  {19, 18},  {-50, -53}, {-19, 20}, {-38, 21},
     {-35, -49}, {-3, 22},   {24, 23},  {-68, 25},  {-84, 26}, {-65, 27},
     {-51, -66}, {-22, -37}, {-52, 28}, {-20, 29},  {-36, 30}, {-81, 31},
     {-4, -83},  {-67, 32},  {-21, 33}, {-5, 34},   {-6, -82}},
    {{2, 1},     {-120, 3},   {-1, 4},     {6, 5},      {-17, 7},   {-104, 8},
     {-18, 9},   {-2, 10},    {12, 11},    {14, 13},    {-119, 15}, {-33, 16},
     {-34, -88}, {-103, 17},  {19, 18},    {21, 20},    {23, 22},   {25, 24},
     {-19, -72}, {-50, 26},   {-49, 27},   {-87, 28},   {30, 29},   {32, 31},
     {-3, -35},  {34, 33},    {-56, 35},   {-65, -66},  {-40, 36},  {-82, -118},
     {-71, 37},  {-55, 38},   {-67, -102}, {-51, 39},   {-70, 40},  {42, 41},
     {-81, 43},  {-86, 44},   {-52, -97},  {-98, 45},   {-24, -39}, {-20, 46},
     {-54, -83}, {-36, 47},   {-85, 48},   {-68, 49},   {-4, 50},   {-69, -113},
     {-117, 51}, {-37, -101}, {-53, 52},   {-21, 53},   {55, 54},   {-84, -100},
     {-5, 56},   {-116, 57},  {-22, 58},   {-38, -115}, {60, 59},   {-6, -99},
     {-23, 61},  {-114, 62},  {-7, -8}},
    {{2, 1},     {-154, 3},    {5, 4},      {-1, 6},      {8, 7},
     {-17, 9},   {-138, 10},   {-18, 11},   {-2, 12},     {14, 13},
     {16, 15},   {-153, 17},   {-34, 18},   {-33, -122},  {20, 19},
     {22, 21},   {-137, 23},   {25, 24},    {27, 26},     {-106, 28},
     {30, 29},   {-50, 31},    {-19, 32},   {-49, -121},  {34, 33},
     {36, 35},   {-35, 37},    {-90, 38},   {-66, 39},    {-3, 40},
     {42, 41},   {-65, 43},    {-105, 44},  {46, 45},     {-74, 47},
     {-51, 48},  {-82, -152},  {-136, 49},  {-81, 50},    {-42, -89},
     {-114, 51}, {53, 52},     {-57, -58},  {-120, 54},   {-98, 55},
     {-67, 56},  {-97, 57},    {59, 58},    {-99, 60},    {-73, -104},
     {-72, 61},  {-113, 62},   {-20, -83},  {-84, -130},  {-36, 63},
     {-26, 64},  {-41, 65},    {-52, -129}, {-87, -88},   {67, 66},
     {-115, 68}, {-68, 69},    {-56, -69},  {-4, -100},   {-151, 70},
     {-135, 71}, {-103, -119}, {73, 72},    {-71, -145},  {-102, 74},
     {76, 75},   {-53, -85},   {-37, 77},   {-21, -86},   {79, 78},
     {-5, 80},   {-54, -134},  {-150, 81},  {-118, 82},   {-70, 83},
     {-117, 84}, {-22, -38},   {-101, 85},  {-55, 86},    {-149, 87},
     {-39, 88},  {-133, 89},   {-6, 90},    {-116, 91},   {-24, 92},
     {-7, -132}, {-23, 93},    {-40, 94},   {-131, -148}, {-25, 95},
     {-147, 96}, {-146, 97},   {-8, 0},     {0, 0}}};
static const HUFF_CLD_NOD_2D FDK_huffCLDNodes_h2_1_1 = {
    {{-1, 1},
     {-52, 2},
     {4, 3},
     {-2, 5},
     {-17, 6},
     {-18, 7},
     {-36, -51},
     {9, 8},
     {-35, 10},
     {-34, 11},
     {-19, -33},
     {-3, 12},
     {-20, 13},
     {-50, 14},
     {-4, -49}},
    {{2, 1},    {-86, 3},   {5, 4},     {-1, 6},   {8, 7},    {-17, -18},
     {-2, 9},   {-70, 10},  {-85, 11},  {13, 12},  {-69, 14}, {-34, 15},
     {17, 16},  {-19, 18},  {-33, -35}, {-54, 19}, {-53, 20}, {-3, 21},
     {-68, 22}, {-84, 23},  {-50, 24},  {-52, 25}, {-51, 26}, {-20, -36},
     {-49, 27}, {-38, 28},  {-37, 29},  {-4, -83}, {-67, 30}, {-66, 31},
     {-21, 32}, {-22, -65}, {-5, 33},   {-82, 34}, {-6, -81}},
    {{2, 1},     {4, 3},      {-120, 5},   {7, 6},      {9, 8},     {-1, 10},
     {-18, 11},  {-17, 12},   {-2, -104},  {-119, 13},  {15, 14},   {-103, 16},
     {18, 17},   {-34, 19},   {-19, 20},   {22, 21},    {-35, 23},  {-33, 24},
     {-88, 25},  {-87, 26},   {28, 27},    {-3, -102},  {-86, 29},  {-52, -118},
     {31, 30},   {-50, 32},   {-51, 33},   {-70, 34},   {-36, 35},  {-85, 36},
     {-20, 37},  {39, 38},    {-69, -71},  {-72, 40},   {-49, -67}, {42, 41},
     {-68, 43},  {-4, -101},  {-53, -117}, {-37, 44},   {-66, 45},  {-55, 46},
     {48, 47},   {-54, 49},   {-21, 50},   {-84, -100}, {-56, -65}, {52, 51},
     {-82, -83}, {54, 53},    {-5, -116},  {-22, 55},   {-38, 56},  {-39, -40},
     {58, 57},   {-81, -115}, {-98, -99},  {-6, 59},    {-23, 60},  {-24, 61},
     {-7, -97},  {-114, 62},  {-8, -113}},
    {{2, 1},       {4, 3},      {-154, 5},    {7, 6},      {9, 8},
     {11, 10},     {-1, 12},    {-18, 13},    {-17, 14},   {-2, -138},
     {16, 15},     {-153, 17},  {-137, 18},   {20, 19},    {22, 21},
     {-34, 23},    {-19, 24},   {-35, 25},    {27, 26},    {29, 28},
     {-121, 30},   {-120, 31},  {-136, 32},   {-33, -122}, {34, 33},
     {-152, 35},   {-3, 36},    {-51, 37},    {-52, 38},   {-69, 39},
     {-36, 40},    {-50, 41},   {43, 42},     {-20, 44},   {-104, 45},
     {-103, 46},   {-87, 47},   {-119, 48},   {-105, 49},  {-86, 50},
     {-102, 51},   {-106, 52},  {-49, -135},  {-68, 53},   {55, 54},
     {-53, 56},    {-67, -151}, {-4, 57},     {-84, 58},   {-85, 59},
     {-66, 60},    {-37, 61},   {-70, 62},    {-54, -88},  {-21, 63},
     {65, 64},     {-89, 66},   {-118, 67},   {-72, 68},   {-90, 69},
     {-71, 70},    {-65, -134}, {-150, 71},   {-83, 72},   {-5, 73},
     {-101, -117}, {-82, 74},   {76, 75},     {-99, 77},   {-38, 78},
     {-100, 79},   {-22, 80},   {-73, 81},    {-39, -74},  {83, 82},
     {-55, -81},   {-57, 84},   {-133, -149}, {-56, 85},   {-6, 86},
     {-98, 87},    {-132, 88},  {-23, 89},    {-114, 90},  {-116, 91},
     {-58, -115},  {-24, 92},   {-97, -148},  {-40, -41},  {-7, -42},
     {-147, 93},   {95, 94},    {-131, 96},   {-8, -130},  {-25, -113},
     {-9, 97},     {-26, -129}, {-146, 98},   {-10, -145}}};

const HUFF_CLD_NODES FDK_huffCLDNodes = {
    {&FDK_huffCLDNodes_h1D_0, &FDK_huffCLDNodes_h1D_1, &FDK_huffCLDNodes_h1D_1},
    {{&FDK_huffCLDNodes_h2_0_0, &FDK_huffCLDNodes_h2_0_1},
     {&FDK_huffCLDNodes_h2_1_0, &FDK_huffCLDNodes_h2_1_1},
     {&FDK_huffCLDNodes_h2_0_1, &FDK_huffCLDNodes_h2_0_1}}};

const HUFF_RES_NODES FDK_huffReshapeNodes = {
    {{2, 1},    {4, 3},     {6, 5},     {-33, 7},  {-17, 8},  {-49, 9},
     {-34, 10}, {12, 11},   {-18, -35}, {-50, 13}, {15, 14},  {-40, 16},
     {-36, 17}, {-19, 18},  {-1, -37},  {-51, 19}, {21, 20},  {-38, -65},
     {-2, -39}, {-20, 22},  {-52, 23},  {25, 24},  {-21, 26}, {-66, 27},
     {-53, 28}, {-3, 29},   {31, 30},   {-22, 32}, {-54, 33}, {-4, 34},
     {-56, 35}, {-24, -67}, {-23, -55}, {-8, -72}, {-5, 36},  {-68, 37},
     {-6, 38},  {-7, -69},  {-70, -71}}};

const HUFF_IPD_NODES FDK_huffIPDNodes = {
    {{{{-1, 1}, {-8, 2}, {-2, 3}, {5, 4}, {-3, -7}, {-6, 6}, {-4, -5}}},
     {{{-1, 1}, {-2, 2}, {-8, 3}, {-3, 4}, {-7, 5}, {-4, 6}, {-5, -6}}},
     {{{-1, 1}, {-8, 2}, {-2, 3}, {5, 4}, {-3, -7}, {-6, 6}, {-4, -5}}}},
    {{{{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {-36, 2},
        {-18, 3},
        {-35, 4},
        {-52, 5},
        {7, 6},
        {-34, 8},
        {-33, -49},
        {-20, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},    {5, 4},     {-86, 6},   {-66, 7},  {9, 8},
        {11, 10},   {-18, 12}, {-51, 13},  {-37, -52}, {-69, 14}, {-38, 15},
        {-53, 16},  {-35, 17}, {-50, -70}, {-22, -49}, {-33, 18}, {-17, 19},
        {-34, -65}, {-81, 20}, {-54, 0},   {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0}},
       {{2, 1},    {4, 3},       {-1, 5},    {-69, 6},   {-120, 7}, {-68, 8},
        {10, 9},   {12, 11},     {14, 13},   {-52, -54}, {-18, 15}, {-70, 16},
        {-67, 17}, {19, 18},     {-17, 20},  {-113, 21}, {23, 22},  {-83, 24},
        {-24, 25}, {-103, -104}, {-51, -55}, {27, 26},   {-71, 28}, {-86, 29},
        {-35, 30}, {-66, 31},    {-39, -50}, {-82, -98}, {-72, 32}, {-56, -87},
        {-34, 33}, {-33, -88},   {-40, -97}, {-65, 34},  {-49, 35}, {-81, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0}}},
      {{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {-36, 2},
        {-18, 3},
        {-35, 4},
        {-52, 5},
        {7, 6},
        {-34, 8},
        {-33, -49},
        {-20, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},    {5, 4},     {-86, 6},   {-66, 7},  {9, 8},
        {11, 10},   {-18, 12}, {-51, 13},  {-37, -52}, {-69, 14}, {-38, 15},
        {-53, 16},  {-35, 17}, {-50, -70}, {-22, -49}, {-33, 18}, {-17, 19},
        {-34, -65}, {-81, 20}, {-54, 0},   {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0}},
       {{2, 1},    {4, 3},       {-1, 5},    {-69, 6},   {-120, 7}, {-68, 8},
        {10, 9},   {12, 11},     {14, 13},   {-52, -54}, {-18, 15}, {-70, 16},
        {-67, 17}, {19, 18},     {-17, 20},  {-113, 21}, {23, 22},  {-83, 24},
        {-24, 25}, {-103, -104}, {-51, -55}, {27, 26},   {-71, 28}, {-86, 29},
        {-35, 30}, {-66, 31},    {-39, -50}, {-82, -98}, {-72, 32}, {-56, -87},
        {-34, 33}, {-33, -88},   {-40, -97}, {-65, 34},  {-49, 35}, {-81, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0}}}},
     {{{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {3, 2},
        {-18, 4},
        {-52, 5},
        {-34, -36},
        {-35, 6},
        {-17, 7},
        {-33, 8},
        {-20, 9},
        {-49, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},   {-52, 4},   {-86, 5}, {-35, 6},   {-53, 7},
        {-70, 8},   {-17, 9}, {-37, 10},  {12, 11}, {-38, -66}, {-18, 13},
        {-51, 14},  {16, 15}, {-34, -69}, {18, 17}, {-54, -65}, {-50, 19},
        {-33, -49}, {-22, 0}, {0, 0},     {0, 0},   {0, 0},     {0, 0},
        {0, 0},     {0, 0},   {0, 0},     {0, 0},   {0, 0},     {0, 0},
        {0, 0},     {0, 0},   {0, 0},     {0, 0},   {0, 0}},
       {{-1, 1},    {-69, 2},   {4, 3},     {-120, 5},  {7, 6},     {-113, 8},
        {-68, 9},   {11, 10},   {-17, 12},  {-52, 13},  {-24, 14},  {-18, 15},
        {17, 16},   {-104, 18}, {20, 19},   {-54, -70}, {22, 21},   {24, 23},
        {-86, -97}, {-103, 25}, {-83, 26},  {-35, 27},  {-34, -98}, {-40, 28},
        {-39, -67}, {30, 29},   {-33, -51}, {-87, 31},  {-88, 32},  {-82, 33},
        {-55, -81}, {-56, -71}, {-72, 34},  {-50, -66}, {-65, 35},  {-49, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0}}},
      {{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {3, 2},
        {-18, 4},
        {-52, 5},
        {-34, -36},
        {-35, 6},
        {-17, 7},
        {-33, 8},
        {-20, 9},
        {-49, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},   {-52, 4},   {-86, 5}, {-35, 6},   {-53, 7},
        {-70, 8},   {-17, 9}, {-37, 10},  {12, 11}, {-38, -66}, {-18, 13},
        {-51, 14},  {16, 15}, {-34, -69}, {18, 17}, {-54, -65}, {-50, 19},
        {-33, -49}, {-22, 0}, {0, 0},     {0, 0},   {0, 0},     {0, 0},
        {0, 0},     {0, 0},   {0, 0},     {0, 0},   {0, 0},     {0, 0},
        {0, 0},     {0, 0},   {0, 0},     {0, 0},   {0, 0}},
       {{-1, 1},    {-69, 2},   {4, 3},     {-120, 5},  {7, 6},     {-113, 8},
        {-68, 9},   {11, 10},   {-17, 12},  {-52, 13},  {-24, 14},  {-18, 15},
        {17, 16},   {-104, 18}, {20, 19},   {-54, -70}, {22, 21},   {24, 23},
        {-86, -97}, {-103, 25}, {-83, 26},  {-35, 27},  {-34, -98}, {-40, 28},
        {-39, -67}, {30, 29},   {-33, -51}, {-87, 31},  {-88, 32},  {-82, 33},
        {-55, -81}, {-56, -71}, {-72, 34},  {-50, -66}, {-65, 35},  {-49, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},     {0, 0},
        {0, 0},     {0, 0},     {0, 0}}}},
     {{{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {-36, 2},
        {-18, 3},
        {-35, 4},
        {-52, 5},
        {7, 6},
        {-34, 8},
        {-33, -49},
        {-20, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},    {5, 4},     {-86, 6},   {-66, 7},  {9, 8},
        {11, 10},   {-18, 12}, {-51, 13},  {-37, -52}, {-69, 14}, {-38, 15},
        {-53, 16},  {-35, 17}, {-50, -70}, {-22, -49}, {-33, 18}, {-17, 19},
        {-34, -65}, {-81, 20}, {-54, 0},   {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0}},
       {{2, 1},    {4, 3},       {-1, 5},    {-69, 6},   {-120, 7}, {-68, 8},
        {10, 9},   {12, 11},     {14, 13},   {-52, -54}, {-18, 15}, {-70, 16},
        {-67, 17}, {19, 18},     {-17, 20},  {-113, 21}, {23, 22},  {-83, 24},
        {-24, 25}, {-103, -104}, {-51, -55}, {27, 26},   {-71, 28}, {-86, 29},
        {-35, 30}, {-66, 31},    {-39, -50}, {-82, -98}, {-72, 32}, {-56, -87},
        {-34, 33}, {-33, -88},   {-40, -97}, {-65, 34},  {-49, 35}, {-81, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0}}},
      {{{-1, 1}, {-18, 2}, {-17, 0}},
       {{-1, 1},
        {-36, 2},
        {-18, 3},
        {-35, 4},
        {-52, 5},
        {7, 6},
        {-34, 8},
        {-33, -49},
        {-20, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0},
        {0, 0}},
       {{-1, 1},    {3, 2},    {5, 4},     {-86, 6},   {-66, 7},  {9, 8},
        {11, 10},   {-18, 12}, {-51, 13},  {-37, -52}, {-69, 14}, {-38, 15},
        {-53, 16},  {-35, 17}, {-50, -70}, {-22, -49}, {-33, 18}, {-17, 19},
        {-34, -65}, {-81, 20}, {-54, 0},   {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},     {0, 0},    {0, 0},     {0, 0},     {0, 0}},
       {{2, 1},    {4, 3},       {-1, 5},    {-69, 6},   {-120, 7}, {-68, 8},
        {10, 9},   {12, 11},     {14, 13},   {-52, -54}, {-18, 15}, {-70, 16},
        {-67, 17}, {19, 18},     {-17, 20},  {-113, 21}, {23, 22},  {-83, 24},
        {-24, 25}, {-103, -104}, {-51, -55}, {27, 26},   {-71, 28}, {-86, 29},
        {-35, 30}, {-66, 31},    {-39, -50}, {-82, -98}, {-72, 32}, {-56, -87},
        {-34, 33}, {-33, -88},   {-40, -97}, {-65, 34},  {-49, 35}, {-81, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0},     {0, 0},     {0, 0},    {0, 0},
        {0, 0},    {0, 0},       {0, 0}}}}}};

static const HUFF_OLD_NOD_1D huffOLDNodes_h1D_0 = {{{-1, 1},
                                                    {3, 2},
                                                    {-2, 4},
                                                    {-3, 5},
                                                    {-4, 6},
                                                    {-5, 7},
                                                    {-6, -8},
                                                    {-7, 8},
                                                    {10, 9},
                                                    {12, 11},
                                                    {-9, -11},
                                                    {-10, 13},
                                                    {-12, 14},
                                                    {-13, -16},
                                                    {-14, -15}}};

static const HUFF_OLD_NOD_1D huffOLDNodes_h1D_1 = {{{-1, 1},
                                                    {-2, 2},
                                                    {4, 3},
                                                    {-3, 5},
                                                    {-4, 6},
                                                    {-5, 7},
                                                    {-6, -8},
                                                    {-7, 8},
                                                    {10, 9},
                                                    {12, 11},
                                                    {-9, 13},
                                                    {-16, 14},
                                                    {-10, -15},
                                                    {-11, -12},
                                                    {-13, -14}}};

static const HUFF_OLD_NOD_2D huffOLDNodes_h2D_0_0 = {
    {{2, 1},
     {-1, 3},
     {5, 4},
     {-2, 6},
     {-3, -4},
     {-17, 7},
     {-18, 8},
     {-19, 9},
     {-20, 10},
     {-52, 11},
     {-33, 12},
     {-34, -35},
     {-36, 13},
     {-51, 14},
     {-49, -50}},
    {{-1, 1},    {3, 2},     {5, 4},     {7, 6},      {-103, 8}, {10, 9},
     {12, 11},   {-18, 13},  {15, 14},   {-2, 16},    {-86, 17}, {-35, 18},
     {20, 19},   {-102, 21}, {23, 22},   {-69, 24},   {-87, 25}, {-3, 26},
     {-17, 27},  {-19, 28},  {-52, 29},  {-34, -101}, {31, 30},  {-85, 32},
     {34, 33},   {-20, -70}, {-4, 35},   {-71, -100}, {-5, -33}, {-50, 36},
     {-36, -55}, {-54, -84}, {38, 37},   {-51, -53},  {-21, 39}, {-6, -99},
     {-37, -68}, {-83, 40},  {-7, -49},  {-22, -98},  {42, 41},  {44, 43},
     {-66, 45},  {-67, 46},  {-38, -39}, {-65, -82},  {-23, 47}, {-81, -97}},
    {{-1, 1},     {3, 2},       {5, 4},      {7, 6},      {9, 8},
     {11, 10},    {13, 12},     {15, 14},    {-154, 16},  {-103, 17},
     {19, 18},    {21, 20},     {-18, 22},   {24, 23},    {26, 25},
     {28, 27},    {-137, 29},   {31, 30},    {-2, -51},   {33, 32},
     {-35, 34},   {-26, 35},    {37, 36},    {-8, 38},    {-70, -153},
     {40, 39},    {-120, 41},   {-52, 42},   {44, 43},    {-3, -138},
     {46, 45},    {48, 47},     {-34, 49},   {-7, 50},    {-19, 51},
     {-17, 52},   {-152, 53},   {-4, -151},  {-33, 54},   {-106, 55},
     {-53, -122}, {-105, -136}, {-121, 56},  {-104, 57},  {-50, -118},
     {-20, 58},   {-5, 59},     {-38, 60},   {-133, 61},  {-148, 62},
     {-23, -135}, {-36, 63},    {-6, 64},    {66, 65},    {-21, -150},
     {68, 67},    {-49, 69},    {-134, 70},  {-119, 71},  {-37, 72},
     {-149, 73},  {-9, 74},     {-69, 75},   {-86, 76},   {-22, 77},
     {-68, 78},   {80, 79},     {82, 81},    {84, 83},    {-88, 85},
     {-132, 86},  {-90, 87},    {-10, -117}, {-67, 88},   {-71, 89},
     {-87, 90},   {-54, -66},   {-25, 91},   {-89, 92},   {-72, 93},
     {-131, 94},  {-113, -115}, {-99, 95},   {-73, -116}, {-24, -85},
     {-84, -102}, {-39, 96},    {-55, -98},  {-81, -97},  {-82, -83},
     {-114, 97},  {-146, -147}, {-42, -101}, {-57, -100}, {-65, -130},
     {-74, 98},   {-56, -58},   {-40, -129}, {-41, -145}},
    {{2, 1},       {4, 3},       {6, 5},       {8, 7},       {10, 9},
     {12, 11},     {-4, 13},     {-11, -28},   {-21, 14},    {-1, 15},
     {17, 16},     {19, 18},     {-38, 20},    {22, 21},     {24, 23},
     {26, 25},     {28, 27},     {-54, 29},    {31, 30},     {-44, 32},
     {-45, 33},    {-37, 34},    {-5, 35},     {-27, 36},    {38, 37},
     {40, 39},     {-53, 41},    {-12, 42},    {-22, 43},    {-20, 44},
     {-36, 45},    {-43, 46},    {-6, 47},     {-205, 48},   {-51, -52},
     {-35, 49},    {-34, 50},    {-13, 51},    {-42, 52},    {-29, 53},
     {-18, -41},   {55, 54},     {-17, -26},   {-19, 56},    {-7, 57},
     {-23, -188},  {59, 58},     {-10, 60},    {62, 61},     {-39, 63},
     {-33, 64},    {-2, 65},     {-204, 66},   {68, 67},     {-189, 69},
     {-171, 70},   {72, 71},     {74, 73},     {-203, 75},   {-3, -25},
     {-24, 76},    {78, 77},     {80, 79},     {82, 81},     {-173, 83},
     {-172, -187}, {85, 84},     {-86, 86},    {-50, 87},    {-202, 88},
     {90, 89},     {-154, 91},   {93, 92},     {-120, 94},   {96, 95},
     {-186, 97},   {99, 98},     {-69, 100},   {-156, -157}, {102, 101},
     {104, 103},   {-170, -201}, {-103, 105},  {107, 106},   {-155, 108},
     {-137, 109},  {-185, 110},  {-49, 111},   {-8, 112},    {-66, 113},
     {-67, 114},   {116, 115},   {-169, 117},  {-141, 118},  {120, 119},
     {122, 121},   {-200, 123},  {-68, -121},  {125, 124},   {-136, 126},
     {-140, 127},  {-71, 128},   {-139, 129},  {-151, -184}, {-82, 130},
     {-56, -101},  {132, 131},   {-9, -153},   {-40, 133},   {-138, 134},
     {-83, -199},  {-84, 135},   {-90, -168},  {-65, -91},   {-102, 136},
     {-135, -166}, {-72, -183},  {-87, -150},  {-181, 137},  {-125, 138},
     {-55, -70},   {-85, -152},  {-106, -124}, {-89, -123},  {-198, 139},
     {-57, 140},   {-105, 141},  {-167, -196}, {-81, -122},  {-182, 142},
     {-99, -180},  {-100, -104}, {-116, -165}, {-98, 143},   {-117, -119},
     {-88, -134},  {-197, 144},  {-73, -195},  {-92, -149},  {-118, -164},
     {-58, -108},  {-107, -179}, {-109, 145},  {-93, -97},   {-115, -194},
     {-114, 146},  {-113, 147},  {149, 148},   {151, 150},   {153, 152},
     {155, 154},   {157, 156},   {159, 158},   {161, 160},   {163, 162},
     {165, 164},   {167, 166},   {-178, -193}, {-163, -177}, {-161, -162},
     {-147, -148}, {-145, -146}, {-132, -133}, {-130, -131}, {-77, -129},
     {-75, -76},   {-61, -74},   {-59, -60}}};

static const HUFF_OLD_NOD_2D huffOLDNodes_h2D_0_1 = {
    {{-1, 1},
     {3, 2},
     {5, 4},
     {-52, 6},
     {-49, 7},
     {9, 8},
     {-17, 10},
     {-36, 11},
     {-18, 12},
     {-2, -3},
     {-35, 13},
     {-34, -50},
     {-4, -33},
     {-20, 14},
     {-19, -51}},
    {{-1, 1},     {3, 2},    {-103, 4},   {6, 5},     {8, 7},    {-18, 9},
     {11, 10},    {-87, 12}, {-17, 13},   {15, 14},   {-86, 16}, {18, 17},
     {-71, 19},   {21, 20},  {-33, -35},  {-34, 22},  {-55, 23}, {-2, 24},
     {-50, -102}, {26, 25},  {-49, 27},   {-69, -70}, {-39, 28}, {-65, 29},
     {-66, 30},   {-54, 31}, {-19, 32},   {-23, -52}, {-51, 33}, {-81, 34},
     {-82, 35},   {-3, -38}, {-85, -101}, {-67, -97}, {37, 36},  {-20, -53},
     {-36, 38},   {40, 39},  {-100, 41},  {-4, -84},  {-68, 42}, {-21, 43},
     {-37, 44},   {-99, 45}, {-5, -83},   {-22, 46},  {-98, 47}, {-6, -7}},
    {{-1, 1},    {3, 2},       {5, 4},       {7, 6},       {9, 8},
     {-154, 10}, {12, 11},     {14, 13},     {-18, 15},    {17, 16},
     {19, 18},   {21, 20},     {-17, 22},    {-137, 23},   {-35, 24},
     {-138, 25}, {27, 26},     {-113, 28},   {-34, 29},    {31, 30},
     {33, 32},   {-122, 34},   {-33, 35},    {-73, 36},    {38, 37},
     {40, 39},   {-106, 41},   {-52, 42},    {-58, -120},  {-50, 43},
     {45, 44},   {-49, 46},    {-10, -103},  {-36, 47},    {-54, -90},
     {-53, 48},  {-2, 49},     {-98, -153},  {-121, 50},   {-66, 51},
     {-65, -72}, {-51, 52},    {-74, 53},    {-9, 54},     {-105, 55},
     {-71, -82}, {-19, -55},   {-81, 56},    {58, 57},     {-83, 59},
     {-68, -88}, {-89, -97},   {-70, 60},    {-3, 61},     {-67, 62},
     {64, 63},   {-69, 65},    {-104, 66},   {-136, -152}, {68, 67},
     {-8, -26},  {-37, 69},    {-4, 70},     {72, 71},     {-22, 73},
     {-42, 74},  {-7, -20},    {76, 75},     {78, 77},     {-6, 79},
     {-114, 80}, {-25, -135},  {-119, -151}, {-24, 81},    {-57, 82},
     {-5, 83},   {-99, 84},    {-23, -130},  {-129, 85},   {-118, 86},
     {-21, -41}, {-86, 87},    {-115, -145}, {-84, 88},    {-87, -150},
     {-38, -56}, {-134, 89},   {-100, 90},   {-85, -133},  {-149, 91},
     {-102, 92}, {-117, -148}, {94, 93},     {-39, 95},    {-101, 96},
     {-116, 97}, {-131, -132}, {-40, 98},    {-146, -147}},
    {{2, 1},       {-1, 3},      {5, 4},       {7, 6},      {9, 8},
     {-205, 10},   {12, 11},     {14, 13},     {16, 15},    {-18, 17},
     {19, 18},     {21, 20},     {23, 22},     {-189, 24},  {-188, 25},
     {27, 26},     {-17, 28},    {-173, 29},   {31, 30},    {33, 32},
     {-34, -157},  {-35, 34},    {-33, 35},    {37, 36},    {39, 38},
     {41, 40},     {-50, 42},    {-49, 43},    {-141, 44},  {-204, 45},
     {-2, -171},   {-172, 46},   {-66, 47},    {49, 48},    {51, 50},
     {-65, 52},    {-125, 53},   {-156, 54},   {-82, 55},   {57, 56},
     {59, 58},     {-19, -52},   {61, 60},     {-81, 62},   {64, 63},
     {-109, -140}, {-51, 65},    {67, 66},     {-98, 68},   {70, 69},
     {72, 71},     {-67, -93},   {74, 73},     {-203, 75},  {-154, 76},
     {-124, 77},   {-97, -187},  {-114, 78},   {-61, 79},   {-155, 80},
     {82, 81},     {-113, 83},   {-3, -146},   {-83, 84},   {-108, 85},
     {-20, 86},    {-76, 87},    {-45, -77},   {-139, 88},  {90, 89},
     {-69, -130},  {-129, 91},   {-36, 92},    {-99, -161}, {94, 93},
     {-92, -162},  {-68, 95},    {-29, 96},    {-86, 97},   {-60, 98},
     {-123, -177}, {-145, 99},   {-91, -131},  {101, 100},  {-137, -178},
     {-115, 102},  {-84, -116},  {-147, 103},  {-4, 104},   {-106, -202},
     {106, 105},   {-132, -186}, {-107, 107},  {-193, 108}, {-100, -120},
     {-75, -170},  {-44, 109},   {-122, -163}, {-138, 110}, {-90, 111},
     {-37, 112},   {-101, 113},  {-121, 114},  {116, 115},  {-103, 117},
     {-74, -201},  {-21, -85},   {-53, -59},   {-117, 118}, {-148, 119},
     {-5, 120},    {-169, 121},  {-105, -185}, {123, 122},  {-102, -133},
     {-136, 124},  {-153, 125},  {127, 126},   {-54, 128},  {130, 129},
     {-22, -104},  {-38, 131},   {-89, -118},  {-184, 132}, {-71, 133},
     {-87, 134},   {-70, 135},   {-200, 136},  {-168, 137}, {-152, 138},
     {-6, -23},    {-39, 139},   {-119, -199}, {141, 140},  {-55, 142},
     {-7, -151},   {-183, 143},  {145, 144},   {-135, 146}, {-56, 147},
     {-150, 148},  {-40, 149},   {-72, -198},  {-88, 150},  {-57, -134},
     {-41, 151},   {-166, -167}, {-25, -165},  {-9, 152},   {-8, -24},
     {-73, -181},  {-182, 153},  {155, 154},   {-197, 156}, {-42, -180},
     {158, 157},   {-43, -149},  {-196, 159},  {-58, -164}, {-26, 160},
     {162, 161},   {164, 163},   {166, 165},   {-195, 167}, {-179, -194},
     {-27, -28},   {-12, -13},   {-10, -11}}};

static const HUFF_OLD_NOD_2D huffOLDNodes_h2D_1_0 = {
    {{-1, 1},
     {-52, 2},
     {4, 3},
     {-18, 5},
     {7, 6},
     {-17, 8},
     {-36, 9},
     {-35, 10},
     {-2, 11},
     {-19, 12},
     {-33, -51},
     {-20, -34},
     {14, 13},
     {-3, -49},
     {-4, -50}},
    {{-1, 1},    {3, 2},    {5, 4},     {-103, 6},  {8, 7},      {-18, 9},
     {11, 10},   {13, 12},  {-86, 14},  {-87, 15},  {17, 16},    {-35, 18},
     {-17, 19},  {21, 20},  {-34, -71}, {23, 22},   {-50, -55},  {-33, 24},
     {-69, 25},  {-2, -70}, {27, 26},   {-102, 28}, {-49, 29},   {-66, 30},
     {-39, -54}, {-52, 31}, {-51, 32},  {-65, 33},  {-19, 34},   {-38, -82},
     {-23, -85}, {-67, 35}, {-81, 36},  {-3, 37},   {-53, -101}, {-20, -97},
     {39, 38},   {-36, 40}, {-84, 41},  {-100, 42}, {-4, -68},   {-21, 43},
     {-37, 44},  {-83, 45}, {-5, -99},  {-22, 46},  {-98, 47},   {-6, -7}},
    {{-1, 1},      {3, 2},      {5, 4},      {7, 6},      {9, 8},
     {-154, 10},   {12, 11},    {14, 13},    {-18, 15},   {17, 16},
     {-113, 18},   {20, 19},    {-137, 21},  {23, 22},    {25, 24},
     {27, 26},     {-35, 28},   {-138, 29},  {-58, 30},   {-103, 31},
     {-98, 32},    {34, 33},    {-122, 35},  {-120, 36},  {-17, -73},
     {-34, 37},    {-106, 38},  {-50, 39},   {-83, -90},  {-74, 40},
     {-52, 41},    {-66, -121}, {-33, -88},  {43, 42},    {-82, -105},
     {-49, 44},    {-68, -153}, {-2, -89},   {-51, -65},  {-67, 45},
     {-81, -97},   {47, 46},    {-104, 48},  {-19, 49},   {51, 50},
     {53, 52},     {55, 54},    {-136, 56},  {-152, 57},  {-3, 58},
     {60, 59},     {62, 61},    {64, 63},    {-36, 65},   {-20, 66},
     {-53, 67},    {-114, 68},  {-57, -99},  {-72, 69},   {-69, 70},
     {-42, 71},    {-151, 72},  {-119, 73},  {-84, -118}, {-135, 74},
     {-4, -130},   {-115, 75},  {-26, -41},  {-87, 76},   {-56, -86},
     {-100, 77},   {-37, -129}, {-21, 78},   {-38, 79},   {-71, -145},
     {-134, 80},   {-85, 81},   {-150, 82},  {-5, 83},    {-133, 84},
     {-102, 85},   {-22, 86},   {-23, 87},   {-54, 88},   {-149, 89},
     {-117, -148}, {-70, 90},   {-6, -101},  {92, 91},    {-8, -55},
     {-7, 93},     {-132, 94},  {-39, -116}, {-24, 95},   {-147, 96},
     {-40, 97},    {-10, -131}, {-146, 98},  {-9, -25}},
    {{2, 1},       {-1, 3},      {5, 4},       {7, 6},       {9, 8},
     {11, 10},     {13, 12},     {-205, 14},   {16, 15},     {18, 17},
     {20, 19},     {-18, 21},    {23, 22},     {25, 24},     {27, 26},
     {29, 28},     {-188, 30},   {32, 31},     {34, 33},     {36, 35},
     {-189, 37},   {39, 38},     {-35, 40},    {42, 41},     {44, 43},
     {46, 45},     {-173, 47},   {49, 48},     {-34, 50},    {-17, 51},
     {53, 52},     {-157, 54},   {56, 55},     {58, 57},     {-171, 59},
     {-50, 60},    {62, 61},     {-66, -141},  {-172, 63},   {-125, 64},
     {66, 65},     {-33, 67},    {-52, 68},    {-204, 69},   {-82, 70},
     {-156, 71},   {-2, 72},     {74, 73},     {-109, 75},   {-51, -98},
     {77, 76},     {-49, -140},  {79, 78},     {-146, 80},   {-124, 81},
     {-61, -93},   {-19, -76},   {-81, -154},  {-65, -114},  {83, 82},
     {-83, -108},  {-67, 84},    {-77, 85},    {-130, 86},   {-99, -155},
     {88, 87},     {-97, 89},    {-69, -91},   {-92, 90},    {-131, 91},
     {93, 92},     {-116, -187}, {-123, 94},   {-60, 95},    {-86, -139},
     {97, 96},     {-68, -162},  {99, 98},     {-45, -113},  {-147, -203},
     {-115, 100},  {-75, 101},   {-84, -106},  {-129, 102},  {-3, 103},
     {-137, 104},  {-132, 105},  {-44, -120},  {-107, 106},  {-20, -100},
     {-36, 107},   {-90, -163},  {-161, 108},  {-59, -145},  {-101, 109},
     {-29, -138},  {-121, 110},  {-177, -178}, {-186, 111},  {-122, -148},
     {-117, 112},  {-85, -170},  {-202, 113},  {-4, 114},    {-37, -105},
     {-74, 115},   {-133, 116},  {-102, 117},  {119, 118},   {-89, -193},
     {-103, 120},  {-21, -53},   {-153, 121},  {123, 122},   {125, 124},
     {-185, 126},  {-104, -169}, {-201, 127},  {-136, 128},  {-118, 129},
     {-87, 130},   {-5, 131},    {-38, 132},   {-54, 133},   {-70, -184},
     {-71, -168},  {-22, 134},   {136, 135},   {-151, -152}, {-55, 137},
     {-6, 138},    {-39, -72},   {-200, 139},  {-167, 140},  {142, 141},
     {-119, -166}, {-88, 143},   {-23, -135},  {-199, 144},  {-165, 145},
     {-56, -150},  {-57, -183},  {-7, 146},    {-41, 147},   {-181, 148},
     {-134, 149},  {-24, -25},   {-40, 150},   {-73, 151},   {-9, 152},
     {-43, 153},   {-182, -197}, {-8, -195},   {-198, 154},  {-149, 155},
     {157, 156},   {159, 158},   {161, 160},   {163, 162},   {165, 164},
     {167, 166},   {-194, -196}, {-179, -180}, {-58, -164},  {-28, -42},
     {-26, -27},   {-12, -13},   {-10, -11}}};

static const HUFF_OLD_NOD_2D huffOLDNodes_h2D_1_1 = {
    {{-1, 1},
     {-52, 2},
     {4, 3},
     {6, 5},
     {-18, 7},
     {-2, 8},
     {-17, 9},
     {-35, 10},
     {-36, -51},
     {-34, 11},
     {-33, 12},
     {-19, 13},
     {-3, -20},
     {-50, 14},
     {-4, -49}},
    {{-1, 1},   {3, 2},      {5, 4},     {-103, 6},  {8, 7},     {-18, 9},
     {11, 10},  {13, 12},    {-86, 14},  {16, 15},   {-2, -35},  {-17, 17},
     {-87, 18}, {-102, 19},  {21, 20},   {-69, 22},  {-34, 23},  {-19, 24},
     {26, 25},  {-3, 27},    {-52, -70}, {-33, -71}, {-85, 28},  {-101, 29},
     {31, 30},  {-50, 32},   {-51, 33},  {-20, 34},  {-36, 35},  {-4, -55},
     {-54, 36}, {-49, -100}, {-53, 37},  {-84, 38},  {-68, 39},  {41, 40},
     {-5, 42},  {-21, 43},   {-65, -66}, {-67, 44},  {-37, -99}, {-39, 45},
     {-6, 46},  {-38, -83},  {-22, 47},  {-81, -82}, {-7, -98},  {-23, -97}},
    {{-1, 1},      {3, 2},      {5, 4},      {7, 6},      {9, 8},
     {-154, 10},   {-103, 11},  {13, 12},    {-18, 14},   {16, 15},
     {-137, 17},   {19, 18},    {-35, 20},   {22, 21},    {-120, 23},
     {25, 24},     {-52, 26},   {-2, 27},    {-138, 28},  {-153, 29},
     {-17, 30},    {32, 31},    {34, 33},    {-34, 35},   {-19, 36},
     {38, 37},     {40, 39},    {-3, 41},    {-121, 42},  {-122, 43},
     {-136, -152}, {-33, 44},   {-104, 45},  {-105, 46},  {-51, -106},
     {-50, 47},    {-36, 48},   {-20, 49},   {-53, -119}, {-4, 50},
     {-135, -151}, {-68, 51},   {53, 52},    {-49, 54},   {56, 55},
     {-118, 57},   {-88, 58},   {60, 59},    {-5, -8},    {-38, 61},
     {63, 62},     {-21, 64},   {-37, -83},  {-67, 65},   {-66, -133},
     {-6, 66},     {-150, 67},  {-134, 68},  {-23, -65},  {-73, -90},
     {-69, -89},   {-148, 69},  {-7, -22},   {-98, -113}, {71, 70},
     {-82, 72},    {-86, -149}, {-58, -81},  {-74, 73},   {75, 74},
     {77, 76},     {-87, -97},  {-102, 78},  {80, 79},    {-84, 81},
     {-85, 82},    {-54, 83},   {-70, 84},   {-72, 85},   {-117, 86},
     {-71, 87},    {-99, 88},   {-101, 89},  {-39, -100}, {-55, 90},
     {-57, 91},    {-132, 92},  {-56, 93},   {-24, -114}, {-115, 94},
     {-40, -116},  {-42, -147}, {-9, -41},   {-131, 95},  {97, 96},
     {-129, 98},   {-25, -130}, {-26, -146}, {-10, -145}},
    {{2, 1},       {-1, 3},      {5, 4},       {7, 6},       {9, 8},
     {11, 10},     {13, 12},     {-205, 14},   {16, 15},     {18, 17},
     {-18, 19},    {21, 20},     {23, 22},     {-188, 24},   {26, 25},
     {28, 27},     {30, 29},     {-35, 31},    {33, 32},     {35, 34},
     {-171, 36},   {-189, 37},   {-204, 38},   {40, 39},     {-2, 41},
     {43, 42},     {-17, 44},    {-52, 45},    {-34, 46},    {-19, 47},
     {49, 48},     {-154, 50},   {52, 51},     {54, 53},     {-172, 55},
     {-173, 56},   {-69, -187},  {-203, 57},   {59, 58},     {-86, 60},
     {-3, 61},     {63, 62},     {-33, -50},   {-51, 64},    {-36, 65},
     {-137, 66},   {-20, 67},    {69, 68},     {-120, 70},   {72, 71},
     {-156, -157}, {-155, 73},   {-170, 74},   {76, 75},     {-186, -202},
     {78, 77},     {80, 79},     {82, 81},     {-4, -67},    {-49, -103},
     {-66, 83},    {-68, 84},    {-53, 85},    {-21, 86},    {-37, 87},
     {89, 88},     {91, 90},     {93, 92},     {-138, 94},   {-140, 95},
     {-141, -153}, {-139, 96},   {-201, 97},   {-185, 98},   {-121, 99},
     {-169, 100},  {-5, 101},    {-136, 102},  {-65, -84},   {-83, -85},
     {-82, 103},   {-70, 104},   {-54, 105},   {-38, 106},   {108, 107},
     {-101, 109},  {-22, -102},  {-122, -123}, {111, 110},   {113, 112},
     {-125, 114},  {-87, -124},  {-71, 115},   {-168, 116},  {-6, -200},
     {-184, 117},  {-152, 118},  {-81, 119},   {121, 120},   {-105, 122},
     {-106, 123},  {-99, 124},   {-98, -100},  {-23, 125},   {-104, 126},
     {-39, 127},   {-135, 128},  {-55, -151},  {130, 129},   {-91, -119},
     {-7, -199},   {-183, 131},  {-107, -108}, {-116, 132},  {-109, -117},
     {-56, -167},  {-97, 133},   {-90, 134},   {-72, 135},   {-115, -118},
     {-92, 136},   {-93, -166},  {-24, -114},  {-89, 137},   {-88, -150},
     {139, 138},   {-8, 140},    {-40, 141},   {-198, 142},  {-134, 143},
     {-113, 144},  {-182, 145},  {147, 146},   {-41, 148},   {-57, -181},
     {-131, 149},  {151, 150},   {-25, 152},   {-132, 153},  {155, 154},
     {-9, -76},    {-42, -165},  {-73, -133},  {-77, 156},   {-130, 157},
     {-75, -149},  {-10, -146},  {-26, 158},   {-197, 159},  {-180, 160},
     {-147, -196}, {-58, -74},   {-27, 161},   {-129, -148}, {-11, -61},
     {-60, 162},   {-59, 163},   {-43, -145},  {-12, -164},  {-161, 164},
     {-163, 165},  {-162, -195}, {-179, 166},  {-177, 167},  {-28, -178},
     {-45, -194},  {-29, -44},   {-13, -193}}};

const HUFF_OLD_NODES huffOLDNodes = {
    {&huffOLDNodes_h1D_0, &huffOLDNodes_h1D_1, &huffOLDNodes_h1D_1},
    {{&huffOLDNodes_h2D_0_0, &huffOLDNodes_h2D_0_1},
     {&huffOLDNodes_h2D_1_0, &huffOLDNodes_h2D_1_1},
     {&huffOLDNodes_h2D_0_1, &huffOLDNodes_h2D_0_1}}};
