'\"
'\" Generated from file '/home/aku/Projects/Tcllib/tklib/embedded/man/files/modules/khim/khim\&.n' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "khim" n 1\&.0 tklib "Kevin's Hacky Input Method"
.BS
.SH NAME
khim \- Provides key bindings for entering international characters on a keyboard that does not support them
.SH SYNOPSIS
package require \fBTcl \fR
.sp
package require \fBkhim  ?1\&.0?\fR
.sp
\fB::khim::getOptions\fR \fIpath\fR
.sp
\fB::khim::getConfig\fR
.sp
\fB::khim::setConfig\fR \fIversion\fR \fIenabled\fR \fIcompose\fR \fImap\fR
.sp
\fB::khim::showHelp\fR \fIpath\fR
.sp
.BE
.SH DESCRIPTION
This package provides a set of key bindings to allow
a user to enter arbitrary characters on a keyboard that
does not support them\&.  It works by designating some seldom-used key
of the keyboard as a "Compose" key (this key is distinct from any key
so labeled, and is often "Pause," "F12" or "L2"), and having the
"Compose" key, followed by a two-key sequence, have the effect of
inserting some character in a widget\&.
In addition, the "Compose" key, when struck twice in succession,
brings up a dialog containing a Unicode character map, allowing
arbitrary characters to be inserted\&.
.PP
The vast bulk of the package's functionality is implemented in a
single bindtag, \fBKHIM\fR\&.  An application can request that any
text or entry widget use the package to allow for entry of arbitrary
characters by placing this binding tag ahead of the \fBText\fR or
\fBEntry\fR binding tag for the widget:
.CS


text \&.t -width 80 -height 24
bindtags \&.t {\&.t KHIM Text \&. all}

.CE
Note that the \fBKHIM\fR tag must precede the \fBText\fR or
\fBEntry\fR class binding, or the package will not function
correctly\&.
.SH PROCEDURES
In addition to commands supporting the KHIM binding tag, the following
commands are exported from the package:
.TP
\fB::khim::getOptions\fR \fIpath\fR
Posts a top-level modal dialog with the path name \fIpath\fR that
prompts the user for KHIM options\&.  The user is allowed to reconfigure
the key sequences for the "Compose" key, change the choice of key to
use for the "Compose" function, and enable/disable the KHIM key
bindings entirely\&.
.TP
\fB::khim::getConfig\fR
Returns a Tcl script that restores the current configuration of KHIM:
the enabled/disabled state, the choice of "Compose" key, and the key
sequences that may be composed\&.  This script is designed to be
saved to a configuration file for use in a subsequent invocation of
the same application:
.CS


# Save KHIM configuration
set f [open ~/\&.khimrc w]
puts $f [::khim::getConfig]
close $f

# Restore KHIM configuration
source ~/\&.khimrc

.CE
.TP
\fB::khim::setConfig\fR \fIversion\fR \fIenabled\fR \fIcompose\fR \fImap\fR
Restores an earlier saved configuration\&.  Few, if any, applications
will call this command in any other way than to evaluate it as
returned from \fB::khim::getConfig\fR\&.
.TP
\fB::khim::showHelp\fR \fIpath\fR
Displays a top-level dialog giving user-level help for KHIM; the
dialog will have the path name \fIpath\fR\&.
.PP
.SH LOCALISATION
.PP
Programmers who wish to make KHIM available in a non-English-speaking
locale may do so by providing a \fB\&.msg\fR file with the appropriate
localised text\&.  The catalog requires the following messages:
.TP
\fBApply\fR
Text that will appear on the "Apply" button in the dialog that sets
KHIM options\&.
.TP
\fBCancel\fR
Text that will appear on the "Cancel" button in several dialogs\&.
.TP
\fBChange\fR
Text that will appear on the "Change" button, which alters the binding
of a pair of composed characters (creating or replacing as
appropriate)\&.
.TP
\fBCharacter\fR
Text that will appear on the label of the entry widget that accepts a
character resulting from a composed sequence\&.
.TP
\fB{Compose Key}\fR
Window title for a dialog that prompts the user to strike the key that
will be used for the "Compose" key\&.
.TP
\fB{Compose key:}\fR
Label that identifies a component showing the "Compose" key choice in
the KHIM options dialog\&.
.TP
\fB{Composed sequence must be two characters long}\fR
Error message that is displayed if the user attempts to define a
"Compose" sequence that is shorter or longer than two characters\&.
.TP
\fBDelete\fR
Text for a button that deletes a "Compose" sequence\&.
.TP
\fBHelp\&.\&.\&.\fR
Text for a button that displays the KHIM user help dialog\&.
.TP
\fBHELPTEXT\fR
Complete text for the user-level help for KHIM\&.  Refer to
"\fIen\&.msg\fR" for the English-language version of the help\&.
.TP
\fB{Input key sequence}\fR
Text for a label of the entry widget that prompts the user for a
two-character sequence to use with the "Compose" key\&.
.TP
\fB{Insert Character}\fR
Window title of the dialog box that displays a Unicode character map
and prompts the user to select a character to insert\&.
.TP
\fB{Key sequences}\fR
Text for a label at the head of a listbox showing the composed
sequences that are currently bound\&.
.TP
\fB{KHIM Controls}\fR
Window title for the dialog box that prompts for KHIM settings\&.
.TP
\fB{KHIM Help}\fR
Window title for the window that display help text for KHIM\&.
.TP
\fBOK\fR
Label for the OK button on several dialogs\&.
.TP
\fBSelect code page:\fR
Label for a spinbox that prompts the user for a Unicode code page number\&.
.TP
\fBSELECT COMPOSE KEY\fR
A message, which should be composed in short lines, prompting the user
to press the key that will become the "Compose" key in KHIM\&.
.TP
\fBUnicode\&.\&.\&.\fR
Text for a button that brings up the character map to select the
character to which a composed sequence binds\&.
.TP
\fB{Use KHIM}\fR
Text for a checkbutton that asks whether the user wishes to use KHIM
to manage composed key sequences\&.
.PP
.SH ACKNOWLEDGMENTS
KHIM was originally inspired by the key bindings that Brent Welch
developed for the 'sedit' editor used in the 'exmh' mail user agent\&.
The code for KHIM is entirely separate from that for 'sedit'\&.
.SH KEYWORDS
character, i18n, input, international, method