if (arch = RbConfig::CONFIG["arch"]) == "powerpc64le-linux-gnu"
  puts "I: skipping tests on #{arch}"
  exit(0)
end

# HACK: force-set native extension load path via RUBYLIB
# otherwise the logic in lib/bootsnap/explicit_require.rb will wipe
# the path set by gem2deb-test-runner
require "bootsnap"
require "bootsnap/bootsnap"
require "pathname"
# Find where the loaded bootsnap.so is by inspecting loaded files
candidate_paths = $LOADED_FEATURES.filter { |v| v =~ /bootsnap\.so/ }.map { |v| Pathname.new("#{v}/../..").cleanpath().to_s() }
# Append the path explicitly to RUBYLIB
ENV['RUBYLIB'] = candidate_paths.join(':')

require 'gem2deb/rake/testtask'

Gem2Deb::Rake::TestTask.new do |t|
  t.libs = ['test']
  t.test_files = FileList['test/**/*_test.rb'] + FileList['test/**/test_*.rb']
end
