#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2010-2012 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
# 
# PyHoca is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# PyHoca is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import os

from setuptools import setup, find_packages

for line in file(os.path.join('pyhoca', 'cli', '__init__.py')).readlines():
    if (line.startswith('__VERSION__')):
        exec(line.strip())
PROGRAM_VERSION = __VERSION__

setup(
    name = "PyHoca-CLI",
    version = PROGRAM_VERSION,
    description = "PyHoca-CLI is a cross-platform (Windows, MacOS X, Linux) X2Go client for the command line.",
    license = 'AGPLv3+',
    author = 'Mike Gabriel',
    url = 'http://www.x2go.org',
    namespace_packages = [ 'pyhoca', ],
    packages = [ 'pyhoca.cli', ],
    package_dir = {'': '.'},
    exclude = [ 'pyhoca.cli.x2go', ],
    install_requires = [ 'setuptools', ]
)
