var count = (function toString(Big) {
    var start = +new Date(),
        log,
        error,
        passed = 0,
        total = 0;

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!Big && typeof require === 'function') Big = require('../big');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
           error('\n Test number: ' + total + ' failed');
           error(' Expected: ' + expected);
           error(' Actual:   ' + actual);
           //process.exit();
        }
        else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function assertException(func, message) {
        total++;
        try {
            func();
            error('\n Test number: ' + total + ' failed');
            error('\n Expected: ' + message + ' to throw an exception');
            error(' Actual:   no exception');
            //process.exit();
        } catch (e) {
            passed++;
            //log('\n Expected and actual: ' + e);
        }
    }

    function T(expected, value) {
        assert(expected, new Big(value).toString())
    }

    log('\n Testing toString...');

    Big.E_NEG = -7;
    Big.E_POS = 21;

    // ---------------------------------------------------------------------- v8

    T('0', 0);
    T('9', 9);
    T('90', 90);
    T('90.12', 90.12);
    T('0.1', 0.1);
    T('0.01', 0.01);
    T('0.0123', 0.0123);
    T('1111111111111111111',   '1111111111111111111');
    T('11111111111111111111',  '11111111111111111111');
    T('111111111111111111111', '111111111111111111111');
    T('0.00001', 0.00001);
    T('0.000001', 0.000001);

    T('1e-7', 0.0000001);
    T('1.2e-7', 0.00000012);
    T('1.23e-7', 0.000000123);
    T('1e-8', 0.00000001);
    T('1.2e-8', 0.000000012);
    T('1.23e-8', 0.0000000123);
    T('-1e-7', -0.0000001);
    T('-1.2e-7', -0.00000012);
    T('-1.23e-7', -0.000000123);
    T('-1e-8', -0.00000001);
    T('-1.2e-8', -0.000000012);
    T('-1.23e-8', -0.0000000123);

    T('0', -0);
    T('-9', -9);
    T('-90', -90);
    T('-90.12', -90.12);
    T('-0.1', -0.1);
    T('-0.01', -0.01);
    T('-0.0123', -0.0123);
    T('-1111111111111111111',  '-1111111111111111111');
    T('-11111111111111111111', '-11111111111111111111');
    T('-111111111111111111111', '-111111111111111111111');
    T('-0.00001', -0.00001);
    T('-0.000001', -0.000001);

    // ------------------------------------------------------------------ v8 end

    T('-0.00002880972004499178518524380571906338098072371970938177432917135459615370973', '-2.880972004499178518524380571906338098072371970938177432917135459615370973e-5');
    T('0.004062', '4.062e-3');
    T('-0.206499585624247', '-2.06499585624247e-1');
    T('-3217152390551.3480681585096', '-3.2171523905513480681585096e+12');
    T('-0.40559318155029357183161762311247760893712676112986144952', '-4.0559318155029357183161762311247760893712676112986144952e-1');
    T('0.67557005614746', '6.7557005614746e-1');
    T('2151.831421496', '2.151831421496e+3');
    T('-0.1022172129444977165472535878409456456335734198775387674763620211', '-1.022172129444977165472535878409456456335734198775387674763620211e-1');
    T('-230807.1307795', '-2.308071307795e+5');
    T('0.002624512719656034051820141160621618555340964456445', '2.624512719656034051820141160621618555340964456445e-3');
    T('0.00001327437838824505056', '1.327437838824505056e-5');
    T('-9951290509.3429612599596526988511098538865484988394', '-9.9512905093429612599596526988511098538865484988394e+9');
    T('-3427642993691330.341017204453', '-3.427642993691330341017204453e+15');
    T('-37824866439491973.50741863066968911367117518074717651871061595', '-3.782486643949197350741863066968911367117518074717651871061595e+16');
    T('-752565.9663775', '-7.525659663775e+5');
    T('0.0410317752667061957691693201', '4.10317752667061957691693201e-2');
    T('2.5', '2.5e+0');
    T('0.001164502035787451528115883000625978204981335782911350225248841560576941', '1.164502035787451528115883000625978204981335782911350225248841560576941e-3');
    T('-92525086100.53245', '-9.252508610053245e+10');
    T('71909248250.092670577', '7.1909248250092670577e+10');
    T('-0.000029839925870209739408399', '-2.9839925870209739408399e-5');
    T('-223.93', '-2.2393e+2');
    T('-0.000259240816662184155275574744458044334917585', '-2.59240816662184155275574744458044334917585e-4');
    T('485824484771564977316.86962509957823510727432', '4.8582448477156497731686962509957823510727432e+20');
    T('-18257504137.6607202783942428100860671852104', '-1.82575041376607202783942428100860671852104e+10');
    T('1207719.135268928473061847066565333537875194537162', '1.207719135268928473061847066565333537875194537162e+6');
    T('-3', '-3e+0');
    T('-31621064264859.749410561631439237598765358', '-3.1621064264859749410561631439237598765358e+13');
    T('-54.47464', '-5.447464e+1');
    T('-11.5', '-1.15e+1');
    T('0.569182274127', '5.69182274127e-1');
    T('5', '5e+0');
    T('381.62010663178723664752926995655828448751389488899637765782586264', '3.8162010663178723664752926995655828448751389488899637765782586264e+2');
    T('18668065.48', '1.866806548e+7');
    T('223807275510855910.6988025822523469037817173438124946663186', '2.238072755108559106988025822523469037817173438124946663186e+17');
    T('15173665864491.945786', '1.5173665864491945786e+13');
    T('-251.56445330169957142953167749737702776442537230366599', '-2.5156445330169957142953167749737702776442537230366599e+2');
    T('0.0000747343483945109530854605989856965703549253246797858230222012', '7.47343483945109530854605989856965703549253246797858230222012e-5');
    T('-3095291.956', '-3.095291956e+6');
    T('8590.419179188907071273310109584707017019342529023922994463304837665', '8.590419179188907071273310109584707017019342529023922994463304837665e+3');
    T('-0.000002681085217615878927905287650187567705621444210005590775053806026369', '-2.681085217615878927905287650187567705621444210005590775053806026369e-6');
    T('0.00000248044514182', '2.48044514182e-6');
    T('-1.38339', '-1.38339e+0');
    T('265815510006244.257349767564387359753901857238', '2.65815510006244257349767564387359753901857238e+14');
    T('288046583927539014.556402201511015', '2.88046583927539014556402201511015e+17');
    T('6459.1', '6.4591e+3');
    T('446.1824', '4.461824e+2');
    T('2.616635870641879', '2.616635870641879e+0');
    T('-4085948139.5804686188882798', '-4.0859481395804686188882798e+9');
    T('45458990.221135', '4.5458990221135e+7');
    T('229849.695421', '2.29849695421e+5');
    T('7.85927694849110186784769009469', '7.85927694849110186784769009469e+0');
    T('697498231.03150555927', '6.9749823103150555927e+8');
    T('-1090915789387.96911391171700684', '-1.09091578938796911391171700684e+12');
    T('-0.120429337172718', '-1.20429337172718e-1');
    T('913792605266.5301219', '9.137926052665301219e+11');
    T('0.0873642688709634', '8.73642688709634e-2');
    T('-21603884141633471.858655613534445827759992354862479336548698767', '-2.1603884141633471858655613534445827759992354862479336548698767e+16');
    T('12.91982044990511129067920212999349413176623775307358115384657666844065', '1.291982044990511129067920212999349413176623775307358115384657666844065e+1');
    T('0.0019086760429407683234932444875158352387775521972728951440817006035554', '1.9086760429407683234932444875158352387775521972728951440817006035554e-3');
    T('-78330.1825415413331166762813674735976496678', '-7.83301825415413331166762813674735976496678e+4');
    T('4560775.849', '4.560775849e+6');
    T('199832274592037770879.2236', '1.998322745920377708792236e+20');
    T('-20.74300801013397685207589423690045359233', '-2.074300801013397685207589423690045359233e+1');
    T('-6505752.09135542952252455354085623', '-6.50575209135542952252455354085623e+6');
    T('0', '0e+0');
    T('-218837142747859.23497622147534484506798006756785404226264059321898534689', '-2.1883714274785923497622147534484506798006756785404226264059321898534689e+14');
    T('992610690.16', '9.9261069016e+8');
    T('-0.0000364256683518569714198080887356701966951222545151062855406806097704164', '-3.64256683518569714198080887356701966951222545151062855406806097704164e-5');
    T('0.00000928774725799597452720977358774052299631189443', '9.28774725799597452720977358774052299631189443e-6');
    T('-0.005434426149751121309048951009022312656054485654112967897440271106066', '-5.434426149751121309048951009022312656054485654112967897440271106066e-3');
    T('2.1714946', '2.1714946e+0');
    T('0.000006781622347012320873794747282794246412400005134449059641940179', '6.781622347012320873794747282794246412400005134449059641940179e-6');
    T('2.13', '2.13e+0');
    T('-28.0725174096', '-2.80725174096e+1');
    T('0.000050052572229552162438382075420392610439202759423472256249007310645', '5.0052572229552162438382075420392610439202759423472256249007310645e-5');
    T('-28190608186955.67000386761846269433359128370160432', '-2.819060818695567000386761846269433359128370160432e+13');
    T('6115836580.06931776667946472', '6.11583658006931776667946472e+9');
    T('3127055.98', '3.12705598e+6');
    T('-0.00000278086669318447179655304', '-2.78086669318447179655304e-6');
    T('-19854.337795671507151567789137457495269813344795660135609697504472', '-1.9854337795671507151567789137457495269813344795660135609697504472e+4');
    T('16557108569.03005723004894135118172469151458', '1.655710856903005723004894135118172469151458e+10');
    T('8447179435644004778.514210275024009', '8.447179435644004778514210275024009e+18');
    T('33024.01969986989181558', '3.302401969986989181558e+4');
    T('-0.00000702495553976446537245326608574770080797449009928127905658985785323597741349', '-7.02495553976446537245326608574770080797449009928127905658985785323597741349e-6');
    T('0.0001097914385362789240230012522029502986760487614749277', '1.097914385362789240230012522029502986760487614749277e-4');
    T('1.67669241', '1.67669241e+0');
    T('5.0598473256548127', '5.0598473256548127e+0');
    T('146398550409534.32', '1.4639855040953432e+14');
    T('-55339611176.494079841526043079614', '-5.5339611176494079841526043079614e+10');
    T('602222732065006149.6', '6.022227320650061496e+17');
    T('-4600698101679072.64824427288266592988058099344507821735484', '-4.60069810167907264824427288266592988058099344507821735484e+15');
    T('0.13255667462360854362969930852', '1.3255667462360854362969930852e-1');
    T('-61525865178604724426.398', '-6.1525865178604724426398e+19');
    T('15187995032.00996401112180591408712891586', '1.518799503200996401112180591408712891586e+10');
    T('159950633.980480337780026144119910434350827825760366', '1.59950633980480337780026144119910434350827825760366e+8');
    T('-764.8', '-7.648e+2');
    T('-31.662121934648835053529869160168892970483', '-3.1662121934648835053529869160168892970483e+1');
    T('0.03666727306518206862708073', '3.666727306518206862708073e-2');
    T('-0.00028843261916109', '-2.8843261916109e-4');
    T('478.49', '4.7849e+2');
    T('-62.627190076223933399553699369552867555985635522', '-6.2627190076223933399553699369552867555985635522e+1');
    T('156548216895997686.578615255', '1.56548216895997686578615255e+17');
    T('8388218102792.292405470516', '8.388218102792292405470516e+12');
    T('0.0036317133235', '3.6317133235e-3');
    T('4514788796646646.42224023997023', '4.51478879664664642224023997023e+15');
    T('41201.30645135922512', '4.120130645135922512e+4');
    T('0.004502698911439375781698700519896', '4.502698911439375781698700519896e-3');
    T('1', '1e+0');
    T('3555.0291', '3.5550291e+3');
    T('-3591377193611873751.3353113792', '-3.5913771936118737513353113792e+18');
    T('-27081149345253.645950476439003274', '-2.7081149345253645950476439003274e+13');
    T('633675232487518.576287395312347', '6.33675232487518576287395312347e+14');
    T('547.912745337206643', '5.47912745337206643e+2');
    T('-1369789020071.5871864408090320565841144805', '-1.3697890200715871864408090320565841144805e+12');
    T('14.37', '1.437e+1');
    T('-352890772277830924312.60265470726', '-3.5289077227783092431260265470726e+20');
    T('-0.8263363420562821806512025997732471776', '-8.263363420562821806512025997732471776e-1');
    T('-3.90321003458651663108762157', '-3.90321003458651663108762157e+0');
    T('14353.2834182', '1.43532834182e+4');
    T('-0.0000071527952119', '-7.1527952119e-6');
    T('3237586.98790145745425063520074214062128950915646430035937338199676', '3.23758698790145745425063520074214062128950915646430035937338199676e+6');
    T('-20.891434', '-2.0891434e+1');
    T('7869302.9900499', '7.8693029900499e+6');
    T('-146423440.13', '-1.4642344013e+8');
    T('0.0001507', '1.507e-4');
    T('-0.00026117760659270894594481410304037863053', '-2.6117760659270894594481410304037863053e-4');
    T('2123550805855611.6796631', '2.1235508058556116796631e+15');
    T('-2267146878608434212.0596889', '-2.2671468786084342120596889e+18');
    T('-39589210486412.3716342418324338321', '-3.95892104864123716342418324338321e+13');
    T('-11323534649360.42945605732789', '-1.132353464936042945605732789e+13');
    T('-253480938953960.03129886270901867817052499', '-2.5348093895396003129886270901867817052499e+14');
    T('878485741141478152036.782', '8.78485741141478152036782e+20');
    T('40.72', '4.072e+1');
    T('0.00000419651493687959734699558527', '4.19651493687959734699558527e-6');
    T('-5539611145832.73638919574913889280760421', '-5.53961114583273638919574913889280760421e+12');
    T('988848038030744178.1829136155908503186753749975178', '9.888480380307441781829136155908503186753749975178e+17');
    T('-49.655', '-4.9655e+1');
    T('-92019024363681427.51', '-9.201902436368142751e+16');
    T('0.40179862349934895209970133009437007843603241944946845532608648027', '4.0179862349934895209970133009437007843603241944946845532608648027e-1');
    T('0.00027323435290229', '2.7323435290229e-4');
    T('-287.307413075519263341', '-2.87307413075519263341e+2');
    T('489173.689099058495720286', '4.89173689099058495720286e+5');
    T('0.00000147215454893076048653261289571696023288538969518393799203798', '1.47215454893076048653261289571696023288538969518393799203798e-6');
    T('0.000074449450587117231184246544545675658438023541362', '7.4449450587117231184246544545675658438023541362e-5');
    T('1.169311569', '1.169311569e+0');
    T('-21949352412.9904826825522111998359879599288366014040193774185970714131093', '-2.19493524129904826825522111998359879599288366014040193774185970714131093e+10');
    T('-218879937679551392.189024', '-2.18879937679551392189024e+17');
    T('1541540107.1145132154683674', '1.5415401071145132154683674e+9');
    T('-7509.580144660349789159418324905916726', '-7.509580144660349789159418324905916726e+3');
    T('798968.361269712405243689738', '7.98968361269712405243689738e+5');
    T('-23914810.356', '-2.3914810356e+7');
    T('-0.0000011686639705418429850704560989878569387703202111178051017322584', '-1.1686639705418429850704560989878569387703202111178051017322584e-6');
    T('66398146.86494006855852173107370871122679', '6.639814686494006855852173107370871122679e+7');
    T('-13061.00785831952599100135398795', '-1.306100785831952599100135398795e+4');
    T('24386.12747311816804599078050671055594988810784455859', '2.438612747311816804599078050671055594988810784455859e+4');
    T('23.1482440256844245825852224454660373564879353266268453019435951916384499', '2.31482440256844245825852224454660373564879353266268453019435951916384499e+1');
    T('-12.066', '-1.2066e+1');
    T('3824249690.744942003288636719934967371432', '3.824249690744942003288636719934967371432e+9');
    T('-4035.15351126', '-4.03515351126e+3');
    T('-186385.04210983462432868870963586536412803139826621335', '-1.8638504210983462432868870963586536412803139826621335e+5');
    T('-0.0008554911175315826215076839473647265', '-8.554911175315826215076839473647265e-4');
    T('0.00126070187425794865401', '1.26070187425794865401e-3');
    T('0.0016431437584973628209451788', '1.6431437584973628209451788e-3');
    T('-78797.344273597515126427785281070901556', '-7.8797344273597515126427785281070901556e+4');
    T('0.000027197516733214969419979043489', '2.7197516733214969419979043489e-5');
    T('34231.6666792804527911832867793479095', '3.42316666792804527911832867793479095e+4');
    T('-0.0016026339968302068544304748262863', '-1.6026339968302068544304748262863e-3');
    T('1.1489744061887', '1.1489744061887e+0');
    T('34.802794480472992829077222920294423597551', '3.4802794480472992829077222920294423597551e+1');
    T('-0.13968357011235485005920820153289818014836286594729971084655744864563', '-1.3968357011235485005920820153289818014836286594729971084655744864563e-1');
    T('36782356.605705226582252036652683058', '3.6782356605705226582252036652683058e+7');
    T('-0.0000041171213382692649586879633642089089959393863795', '-4.1171213382692649586879633642089089959393863795e-6');
    T('19.387350669785', '1.9387350669785e+1');
    T('-22867.530537', '-2.2867530537e+4');
    T('-7115.37994036808268478263377221529848', '-7.11537994036808268478263377221529848e+3');
    T('-1837.414453982931593965797407518506', '-1.837414453982931593965797407518506e+3');
    T('-0.00038303400838648252101595120613261049796436260145181784', '-3.8303400838648252101595120613261049796436260145181784e-4');
    T('199834393757638560.48365651429302047', '1.9983439375763856048365651429302047e+17');
    T('64706.4911792715', '6.47064911792715e+4');
    T('-2', '-2e+0');
    T('-0.000001886004002403469961362572546672', '-1.886004002403469961362572546672e-6');
    T('-0.0000310103946215031028586927929479250572359767776057431945832', '-3.10103946215031028586927929479250572359767776057431945832e-5');
    T('-55060735.322112208733188720279601757782733608564', '-5.5060735322112208733188720279601757782733608564e+7');
    T('-1.1', '-1.1e+0');
    T('54839153693259579.9795', '5.48391536932595799795e+16');
    T('0.0041759310069240548770474304055254667169662955214058456572', '4.1759310069240548770474304055254667169662955214058456572e-3');
    T('0.0001955365160381498364947545', '1.955365160381498364947545e-4');
    T('3.27323', '3.27323e+0');
    T('70.6', '7.06e+1');
    T('-0.026508636799607573347975491', '-2.6508636799607573347975491e-2');
    T('25188781.150611', '2.5188781150611e+7');
    T('-0.018894991938338647856502400607763862237528708988761254099175589727552', '-1.8894991938338647856502400607763862237528708988761254099175589727552e-2');
    T('617807816691763257.508357656061659471644432794446692740861', '6.17807816691763257508357656061659471644432794446692740861e+17');
    T('73183170035928.81575660902505', '7.318317003592881575660902505e+13');
    T('0.0000164455107650189184357371', '1.64455107650189184357371e-5');
    T('-0.93599961', '-9.3599961e-1');
    T('14734.9184214899580591121', '1.47349184214899580591121e+4');
    T('15946.29165654625272129', '1.594629165654625272129e+4');
    T('122966441.290185145609340122412', '1.22966441290185145609340122412e+8');
    T('-129.654371704230659398725613745012717737573933658257', '-1.29654371704230659398725613745012717737573933658257e+2');
    T('0.0001761377819621266803778554313207263082401264088237246981620072', '1.761377819621266803778554313207263082401264088237246981620072e-4');
    T('-7', '-7e+0');
    T('-15309785476025143.756408973719659838', '-1.5309785476025143756408973719659838e+16');
    T('-3670228393526736.52', '-3.67022839352673652e+15');
    T('0.000731', '7.31e-4');
    T('5.6183847424066950657818656796546070156921299115031071', '5.6183847424066950657818656796546070156921299115031071e+0');
    T('-1.1', '-1.1e+0');
    T('20.7271796351', '2.07271796351e+1');
    T('-3.7', '-3.7e+0');
    T('-24017356010538845.10861917433652302066375691548110464881649', '-2.401735601053884510861917433652302066375691548110464881649e+16');
    T('-0.00952946836809535253950074785587127807727767', '-9.52946836809535253950074785587127807727767e-3');
    T('0.00012968834094598251424610958860395289575847', '1.2968834094598251424610958860395289575847e-4');
    T('-0.3459913', '-3.459913e-1');
    T('-158067352.4', '-1.580673524e+8');
    T('-0.000014790343125179690326739', '-1.4790343125179690326739e-5');
    T('0.0193943717016794836655634658134262659293302509313781667025177208', '1.93943717016794836655634658134262659293302509313781667025177208e-2');
    T('113542357.4117024541705333527869936887227315756680969573589892339805447390658', '1.135423574117024541705333527869936887227315756680969573589892339805447390658e+8');
    T('-0.154220377', '-1.54220377e-1');
    T('0.0427523', '4.27523e-2');
    T('1085202870092846001.489480354353962808914322', '1.085202870092846001489480354353962808914322e+18');
    T('-52122.564', '-5.2122564e+4');
    T('-69', '-6.9e+1');
    T('45453557279.70926480053', '4.545355727970926480053e+10');
    T('-8459227194561.009568405224959256810337570435527435', '-8.459227194561009568405224959256810337570435527435e+12');
    T('0.16711094626502869265467433959064784065092439761523318705', '1.6711094626502869265467433959064784065092439761523318705e-1');
    T('758439672656.17494756140912792', '7.5843967265617494756140912792e+11');
    T('-0.0000108140557920934375827728189164762', '-1.08140557920934375827728189164762e-5');
    T('1134838730.3350646724840481462521912', '1.1348387303350646724840481462521912e+9');
    T('0.001816435719305977', '1.816435719305977e-3');
    T('-0.0940451841857620585410399891420224321683214142', '-9.40451841857620585410399891420224321683214142e-2');
    T('0.7088984300959367781273668039450998309536026408287804482', '7.088984300959367781273668039450998309536026408287804482e-1');
    T('10.11847', '1.011847e+1');
    T('27512.990770009509682231716955970446038275546', '2.7512990770009509682231716955970446038275546e+4');
    T('-262611924651.02616702076749905814718436605807480522286301086176286', '-2.6261192465102616702076749905814718436605807480522286301086176286e+11');
    T('18176137775866581965.65220583044244674108496842671900180386069435393', '1.817613777586658196565220583044244674108496842671900180386069435393e+19');
    T('3', '3e+0');
    T('39632.958108', '3.9632958108e+4');
    T('0.00001549607612980463131760552343556214', '1.549607612980463131760552343556214e-5');
    T('-0.0002821935547414936046805564857061667284704668', '-2.821935547414936046805564857061667284704668e-4');
    T('-551423700538313.88650175935008238', '-5.5142370053831388650175935008238e+14');
    T('-301262672059247735962.5446352061744371', '-3.012626720592477359625446352061744371e+20');
    T('9798548.38', '9.79854838e+6');
    T('614106949056.88254499703107', '6.1410694905688254499703107e+11');
    T('-843417433172646.11103502049784353019792165900544779976', '-8.4341743317264611103502049784353019792165900544779976e+14');
    T('71772998054220350.6199053786417894454778759434551', '7.17729980542203506199053786417894454778759434551e+16');
    T('26127.67128955864044319543855168943866783836987763512222412737570813263582', '2.612767128955864044319543855168943866783836987763512222412737570813263582e+4');
    T('0.2174051275943', '2.174051275943e-1');
    T('14819984281.646113452644795447671498797132793211504582', '1.4819984281646113452644795447671498797132793211504582e+10');
    T('-6.1055742757466659414848358753699291', '-6.1055742757466659414848358753699291e+0');
    T('-0.00278009647645774520888672', '-2.78009647645774520888672e-3');
    T('-8', '-8e+0');
    T('0.0001932756987116', '1.932756987116e-4');
    T('-1427.55676936', '-1.42755676936e+3');
    T('-4308265.450990136180314017965687867619821782418765402651680879802', '-4.308265450990136180314017965687867619821782418765402651680879802e+6');
    T('-14764.295551728', '-1.4764295551728e+4');
    T('32407196483712.858', '3.2407196483712858e+13');
    T('-9031613841.5599312282178947560345781775076023374702435675', '-9.0316138415599312282178947560345781775076023374702435675e+9');
    T('1.181276663040786318554659584401553323591140011739928518544', '1.181276663040786318554659584401553323591140011739928518544e+0');
    T('-340504354335.733698674534076124', '-3.40504354335733698674534076124e+11');
    T('124.62', '1.2462e+2');
    T('1224195207.8161779474322009098689115570439412639424248684652463172151', '1.2241952078161779474322009098689115570439412639424248684652463172151e+9');
    T('1119.12718', '1.11912718e+3');
    T('0.000027598900625749819216061372512462013369951813779259177038113519776430637', '2.7598900625749819216061372512462013369951813779259177038113519776430637e-5');
    T('-0.2378864924178403430225587451225421820351977716909', '-2.378864924178403430225587451225421820351977716909e-1');
    T('1', '1e+0');
    T('3723294.2192478', '3.7232942192478e+6');
    T('-5505758244567677.6279234027709813', '-5.5057582445676776279234027709813e+15');
    T('-67.0310470315', '-6.70310470315e+1');
    T('-151649585771.1467103869359504134', '-1.516495857711467103869359504134e+11');
    T('0.0000306096040904601918096649004656293448975968675516', '3.06096040904601918096649004656293448975968675516e-5');
    T('721.283', '7.21283e+2');
    T('-48637044145.4786442129095136', '-4.86370441454786442129095136e+10');
    T('-2572238801890.2521824', '-2.5722388018902521824e+12');
    T('-5316372473.4757358803014', '-5.3163724734757358803014e+9');
    T('0.00118776973921526839247261123686159477417394701902220530418', '1.18776973921526839247261123686159477417394701902220530418e-3');
    T('-12290.8999158558', '-1.22908999158558e+4');
    T('-0.000486', '-4.86e-4');
    T('-0.09334438126859174540560942334639938787877', '-9.334438126859174540560942334639938787877e-2');
    T('-4.4317453027359230155416285', '-4.4317453027359230155416285e+0');
    T('-107574728665451963465.18', '-1.0757472866545196346518e+20');
    T('-31471643511178362029.433469935596411784231062585793111687', '-3.1471643511178362029433469935596411784231062585793111687e+19');
    T('-0.00689091184682954564861', '-6.89091184682954564861e-3');
    T('897286.69761140449', '8.9728669761140449e+5');
    T('0.0197267269633964192530888893336737249549912519516905709516379279382', '1.97267269633964192530888893336737249549912519516905709516379279382e-2');
    T('-9085745140296646707.595729912921842871369180815000510589645209971992', '-9.085745140296646707595729912921842871369180815000510589645209971992e+18');
    T('-0.1206187959034199776275871', '-1.206187959034199776275871e-1');
    T('-7303259015078.2453854196594173144674112623228862616652102923', '-7.3032590150782453854196594173144674112623228862616652102923e+12');
    T('0.0124798567886469061363033042342515652221', '1.24798567886469061363033042342515652221e-2');
    T('-113159474049511294445.875473787888549291049337833665002583025055', '-1.13159474049511294445875473787888549291049337833665002583025055e+20');
    T('-1767673140861267.59335300185', '-1.76767314086126759335300185e+15');
    T('-362026.3406455024496951023882', '-3.620263406455024496951023882e+5');
    T('-0.000091257315403724519002125296591299372846887214', '-9.1257315403724519002125296591299372846887214e-5');
    T('-1433099765.1252592306982244284995211', '-1.4330997651252592306982244284995211e+9');
    T('1.2', '1.2e+0');
    T('0.000001078352855066736570899140253900227918125178107068596442799409510188996', '1.078352855066736570899140253900227918125178107068596442799409510188996e-6');
    T('0.2046210986820378299960504393721912824755038800128253512921731', '2.046210986820378299960504393721912824755038800128253512921731e-1');
    T('0.04759871903104957602393025435745858', '4.759871903104957602393025435745858e-2');
    T('3941893.3', '3.9418933e+6');
    T('36459.755727713692495264456', '3.6459755727713692495264456e+4');
    T('-0.9863195151850363629459822385967', '-9.863195151850363629459822385967e-1');
    T('-0.0047144819909257048872723283151182', '-4.7144819909257048872723283151182e-3');
    T('-0.0007825511268515549890552260085443398197863467224984', '-7.825511268515549890552260085443398197863467224984e-4');
    T('0.1786123901436175166432952958', '1.786123901436175166432952958e-1');
    T('-0.0000016969302866616445296068120590400816410860690384878', '-1.6969302866616445296068120590400816410860690384878e-6');
    T('0.079976989296930785672456071832470472475914984294362190190730923812662757', '7.9976989296930785672456071832470472475914984294362190190730923812662757e-2');
    T('16881328018550470208.942960851501308073802548', '1.6881328018550470208942960851501308073802548e+19');
    T('-5951003297737895799.841739942862465868357642531643122454214301', '-5.951003297737895799841739942862465868357642531643122454214301e+18');
    T('-4037564747.647', '-4.037564747647e+9');
    T('44119091159998694.71442', '4.411909115999869471442e+16');
    T('1561110432.12799413048007605058613974053266', '1.56111043212799413048007605058613974053266e+9');
    T('0.000003007102939303342333402218226698428440002400951915007001166', '3.007102939303342333402218226698428440002400951915007001166e-6');
    T('-55847888288344304.865241671241495088591034962915279623356071', '-5.5847888288344304865241671241495088591034962915279623356071e+16');
    T('1.21112353237213949208471024255232051', '1.21112353237213949208471024255232051e+0');
    T('-791987705442.0227619406612893', '-7.919877054420227619406612893e+11');
    T('20.8', '2.08e+1');
    T('254033508236704262.8992302274070247770891804917317', '2.540335082367042628992302274070247770891804917317e+17');
    T('-102.2687519172273078355962447671534215318126300048752740587224098724123', '-1.022687519172273078355962447671534215318126300048752740587224098724123e+2');
    T('0.014484528239940798124452074106184521879025484379395881', '1.4484528239940798124452074106184521879025484379395881e-2');
    T('2842598.4491035879', '2.8425984491035879e+6');
    T('-67549074172216.85407160955443945802615', '-6.754907417221685407160955443945802615e+13');
    T('-293288764.9432794053102151638', '-2.932887649432794053102151638e+8');
    T('-0.0062466936313091302417170977289146375265791892052', '-6.2466936313091302417170977289146375265791892052e-3');
    T('69487883846161660.509624572036661', '6.9487883846161660509624572036661e+16');
    T('-2', '-2e+0');
    T('-0.00054', '-5.4e-4');
    T('57.708753151244573709600243187251875445184', '5.7708753151244573709600243187251875445184e+1');
    T('-0.00000119509808657632201069297269593462344072593188585', '-1.19509808657632201069297269593462344072593188585e-6');
    T('78514461833.1571270663922179997230597716173376662749823', '7.85144618331571270663922179997230597716173376662749823e+10');
    T('-618.03100300670845771157553', '-6.1803100300670845771157553e+2');
    T('-0.11598629818600582366847595835479040075597499305328943857503067559', '-1.1598629818600582366847595835479040075597499305328943857503067559e-1');
    T('0.00224964517052591032873552760076273924665415', '2.24964517052591032873552760076273924665415e-3');
    T('10725742038533.46395717314609612', '1.072574203853346395717314609612e+13');
    T('7591352.1076282059615946593668291506154510833280005974236964814275', '7.5913521076282059615946593668291506154510833280005974236964814275e+6');
    T('0.135379403', '1.35379403e-1');
    T('760337.442', '7.60337442e+5');
    T('0.00058411840245061832782892155140034320223933924', '5.8411840245061832782892155140034320223933924e-4');
    T('319997434.346732329628912176299', '3.19997434346732329628912176299e+8');
    T('-2.669081046235095182496478130547267975025950071921248479294750262645', '-2.669081046235095182496478130547267975025950071921248479294750262645e+0');
    T('0.32923741648480183876', '3.2923741648480183876e-1');
    T('55686749246728.336621021460055199967992', '5.5686749246728336621021460055199967992e+13');
    T('4260394830751775145.907785939337', '4.260394830751775145907785939337e+18');
    T('0.00058575109', '5.8575109e-4');
    T('-24466.8906205389026747706267675206851135617876689626802954345221098167623', '-2.44668906205389026747706267675206851135617876689626802954345221098167623e+4');
    T('-709382861315295.5996571957727269594', '-7.093828613152955996571957727269594e+14');
    T('-84705935480446.9473914181433', '-8.47059354804469473914181433e+13');
    T('819079787657398.2675812804332223869667707898614571098025213849', '8.190797876573982675812804332223869667707898614571098025213849e+14');
    T('-0.000033545119955625859536337261247', '-3.3545119955625859536337261247e-5');
    T('2.085565771', '2.085565771e+0');
    T('33685255.01', '3.368525501e+7');
    T('-2979.6281804', '-2.9796281804e+3');
    T('-303466.3743338129', '-3.034663743338129e+5');
    T('2399645.6206920447867357096707234643063930403917610472', '2.3996456206920447867357096707234643063930403917610472e+6');
    T('30512072102832075901.09815665631', '3.051207210283207590109815665631e+19');
    T('0.1244547630367243681193698926963558579', '1.244547630367243681193698926963558579e-1');
    T('-0.000025', '-2.5e-5');
    T('-0.00000387300446776730031837', '-3.87300446776730031837e-6');
    T('-3141685265.9', '-3.1416852659e+9');
    T('-1015.63657', '-1.01563657e+3');
    T('-3140896193615.468892710764300529263282372823931548225985252292756193730991', '-3.140896193615468892710764300529263282372823931548225985252292756193730991e+12');
    T('-342518749.376998', '-3.42518749376998e+8');
    T('-11396.7', '-1.13967e+4');
    T('0.0001838944804619', '1.838944804619e-4');
    T('2.6', '2.6e+0');
    T('-0.0001889410809224060217135271843', '-1.889410809224060217135271843e-4');
    T('65.9219184', '6.59219184e+1');
    T('-76589629724495621800.5726446', '-7.65896297244956218005726446e+19');
    T('-5705.557', '-5.705557e+3');
    T('66743.9228199198730325761372147436413412', '6.67439228199198730325761372147436413412e+4');
    T('-276692974283735.635166475417554126625507482799949004176929579144', '-2.76692974283735635166475417554126625507482799949004176929579144e+14');
    T('910289.71137606239294325630961514165048773642477', '9.1028971137606239294325630961514165048773642477e+5');
    T('-0.003765993413779666', '-3.765993413779666e-3');
    T('0.00045881406314145316229', '4.5881406314145316229e-4');
    T('0.000327718523270256955212608280725886870087594582134246261128222025053', '3.27718523270256955212608280725886870087594582134246261128222025053e-4');
    T('138961.4542815', '1.389614542815e+5');
    T('2.5098', '2.5098e+0');
    T('448844063459829899379.2627682', '4.488440634598298993792627682e+20');
    T('-346607997015501569044.86', '-3.4660799701550156904486e+20');
    T('497555865514.3258452484621441', '4.975558655143258452484621441e+11');
    T('613695.52408485402', '6.1369552408485402e+5');
    T('-2291443086470.412635620629728511864', '-2.291443086470412635620629728511864e+12');
    T('1336.4003426285098', '1.3364003426285098e+3');
    T('0.003798035051087452366417482608781759250533001029858715488014309401340765', '3.798035051087452366417482608781759250533001029858715488014309401340765e-3');
    T('1087205.5496041394985269591889885762299', '1.0872055496041394985269591889885762299e+6');
    T('1872605076211495.42428231075', '1.87260507621149542428231075e+15');
    T('23.07', '2.307e+1');
    T('-12.582985395776722428', '-1.2582985395776722428e+1');
    T('3.227', '3.227e+0');
    T('-225575588286911.7100970797432948551', '-2.255755882869117100970797432948551e+14');
    T('-0.0001469439295087278762772093799427071737626195283246829284494882708', '-1.469439295087278762772093799427071737626195283246829284494882708e-4');
    T('-29932162823.48', '-2.993216282348e+10');
    T('0.00000206944808232414578854574331051', '2.06944808232414578854574331051e-6');
    T('26.8793', '2.68793e+1');
    T('-1488326590691960451.6', '-1.4883265906919604516e+18');
    T('0.00605', '6.05e-3');
    T('-0.00830238387765944110622350441919871', '-8.30238387765944110622350441919871e-3');
    T('-52506.14124', '-5.250614124e+4');
    T('4312.7252426581254371982029', '4.3127252426581254371982029e+3');
    T('12143292068.81075135630101492', '1.214329206881075135630101492e+10');
    T('4933672204.6654294524881069977955050371687512110143094601085142859763675', '4.9336722046654294524881069977955050371687512110143094601085142859763675e+9');
    T('0.0253845928061595101414943', '2.53845928061595101414943e-2');
    T('0.04562403666212652405', '4.562403666212652405e-2');
    T('-1.57938213', '-1.57938213e+0');
    T('0.0012878658618462071626559', '1.2878658618462071626559e-3');
    T('11763.7953454890805125069825497313330552079913', '1.17637953454890805125069825497313330552079913e+4');
    T('-519071565674013084.2611', '-5.190715656740130842611e+17');
    T('-775188599801.6', '-7.751885998016e+11');
    T('-30.084887956777177722', '-3.0084887956777177722e+1');
    T('94832470785207548599.67992871', '9.483247078520754859967992871e+19');
    T('0', '0e+0');
    T('-616275944415819696013.2602703308667690013023817761903225173', '-6.162759444158196960132602703308667690013023817761903225173e+20');
    T('0.000321408291220652310916288991857553443674150442809554094732922147', '3.21408291220652310916288991857553443674150442809554094732922147e-4');
    T('15802596862708758325.17480858', '1.580259686270875832517480858e+19');
    T('-114.173689050215691920564150090469271', '-1.14173689050215691920564150090469271e+2');
    T('0.00019088007970084191568800513166969901510303536098212624726153383274', '1.9088007970084191568800513166969901510303536098212624726153383274e-4');
    T('545848247156447694.6984243876166001697519634919415844932835780995', '5.458482471564476946984243876166001697519634919415844932835780995e+17');
    T('-0.0051', '-5.1e-3');
    T('309.50165777266482496347070821', '3.0950165777266482496347070821e+2');
    T('-1072.215707969991971767213276642022682961756602343287936341684', '-1.072215707969991971767213276642022682961756602343287936341684e+3');
    T('0.0065374581634020855090532059615401', '6.5374581634020855090532059615401e-3');
    T('-1388719742558148.5032', '-1.3887197425581485032e+15');
    T('-187602.7661839329168039', '-1.876027661839329168039e+5');
    T('26.400917323220285', '2.6400917323220285e+1');
    T('-170728931943.641200548180472865801740274276', '-1.70728931943641200548180472865801740274276e+11');
    T('51014.685022932885073621811424', '5.1014685022932885073621811424e+4');
    T('-18.21642915281034540610129', '-1.821642915281034540610129e+1');
    T('-0.6227138273085978906908505332587962401137210861249000879893374399933692', '-6.227138273085978906908505332587962401137210861249000879893374399933692e-1');
    T('1499847247119687.2252994442469150323324026983', '1.4998472471196872252994442469150323324026983e+15');
    T('36388528379321.055813719364046', '3.6388528379321055813719364046e+13');
    T('17581398705.03527479664950417525259898597', '1.758139870503527479664950417525259898597e+10');
    T('-1924971375972.85907827180789678254401122044538', '-1.92497137597285907827180789678254401122044538e+12');
    T('-17095684686.85093592645458637877226118519253882682991902616917', '-1.709568468685093592645458637877226118519253882682991902616917e+10');
    T('-167.1383605966', '-1.671383605966e+2');
    T('-0.6254865939943957356340728255129772571', '-6.254865939943957356340728255129772571e-1');
    T('28.4640302041251739', '2.84640302041251739e+1');
    T('-109933356061408370.80557196152390301897627539', '-1.0993335606140837080557196152390301897627539e+17');
    T('-0.0000087160755423395617232', '-8.7160755423395617232e-6');
    T('1585538525614.196440989810246491408', '1.585538525614196440989810246491408e+12');
    T('0.52290891220265741430171810512051732402724658702481831285148819376', '5.2290891220265741430171810512051732402724658702481831285148819376e-1');
    T('4627609920.49521518014082557093474836905001622', '4.62760992049521518014082557093474836905001622e+9');
    T('4158893562112.7510192473', '4.1588935621127510192473e+12');
    T('1436.317', '1.436317e+3');
    T('-9717.3574589', '-9.7173574589e+3');
    T('-5.9311', '-5.9311e+0');
    T('248582.46466183', '2.4858246466183e+5');
    T('51365850972458.020253272518944754', '5.1365850972458020253272518944754e+13');
    T('5.3', '5.3e+0');
    T('0.000015561742553844994399730412968933732917659524683895437294775665328358153833', '1.5561742553844994399730412968933732917659524683895437294775665328358153833e-5');
    T('18468.55140897970661437091391172784331', '1.846855140897970661437091391172784331e+4');
    T('45955143297422.842822135126974402481015478328651290339068428', '4.5955143297422842822135126974402481015478328651290339068428e+13');
    T('92479750799.813227775777657670884090127390669952952357', '9.2479750799813227775777657670884090127390669952952357e+10');
    T('-170157.2824', '-1.701572824e+5');
    T('-193370285.538938', '-1.93370285538938e+8');
    T('-1232107269218.80635234018899385974055760073429439374', '-1.23210726921880635234018899385974055760073429439374e+12');
    T('37068310121876.02935716633548864953989273236', '3.706831012187602935716633548864953989273236e+13');
    T('-0.001926064141589895', '-1.926064141589895e-3');
    T('-12969801.42859202295406', '-1.296980142859202295406e+7');
    T('1.446706519403338261442417', '1.446706519403338261442417e+0');
    T('-15364761976988617820.97', '-1.536476197698861782097e+19');
    T('98.8', '9.88e+1');
    T('-27222876350.64584691135937995025336477676676997618', '-2.722287635064584691135937995025336477676676997618e+10');
    T('-0.07070551', '-7.070551e-2');
    T('-81.3', '-8.13e+1');
    T('-0.986349607617211324597412', '-9.86349607617211324597412e-1');
    T('0.1473237069657530481921451180563', '1.473237069657530481921451180563e-1');
    T('0.178593896967188202891449920680850621329927355608091167388280234380926', '1.78593896967188202891449920680850621329927355608091167388280234380926e-1');
    T('-5517709380633866.96041387468501211138', '-5.51770938063386696041387468501211138e+15');
    T('-0.0007746616564605653338849241691095223040637242453', '-7.746616564605653338849241691095223040637242453e-4');
    T('0', '0e+0');
    T('-0.060169186984251066154082076310779822638630488081688602956563304157289', '-6.0169186984251066154082076310779822638630488081688602956563304157289e-2');
    T('25383101422.4423854978224', '2.53831014224423854978224e+10');
    T('0.000001722331291720493399327096', '1.722331291720493399327096e-6');
    T('746.87', '7.4687e+2');
    T('-168143.3769474876407', '-1.681433769474876407e+5');
    T('-5696.889543735', '-5.696889543735e+3');
    T('336439.45265', '3.3643945265e+5');
    T('1405.59846856945543583453508', '1.40559846856945543583453508e+3');
    T('237446896515913.955792070004418707549459070646017081232295929', '2.37446896515913955792070004418707549459070646017081232295929e+14');
    T('-1000.806', '-1.000806e+3');
    T('123389.374454689364681116404843180604778353643', '1.23389374454689364681116404843180604778353643e+5');
    T('1.1176839366', '1.1176839366e+0');
    T('-2254615348477.19', '-2.25461534847719e+12');
    T('1446096738774.77917774857571753701305096816', '1.44609673877477917774857571753701305096816e+12');
    T('11659236.7999737683550493270191771518647632989491765069037625661009', '1.16592367999737683550493270191771518647632989491765069037625661009e+7');
    T('474525.3', '4.745253e+5');
    T('306457.9939898334603303298655114440891592833271455597935704', '3.064579939898334603303298655114440891592833271455597935704e+5');
    T('0.00002847515780360138119033679045297679454', '2.847515780360138119033679045297679454e-5');
    T('1596804598940.4813258', '1.5968045989404813258e+12');
    T('-0.000006391170621716959617919740565820486739065193514093521742460547264', '-6.391170621716959617919740565820486739065193514093521742460547264e-6');
    T('-473076308.649120345473011', '-4.73076308649120345473011e+8');
    T('-878207964247462.8', '-8.782079642474628e+14');
    T('-11128557966827.22966', '-1.112855796682722966e+13');
    T('-0.000014354892348825211423874345573543139903584975953081203832383875537', '-1.4354892348825211423874345573543139903584975953081203832383875537e-5');
    T('1163290187581.915546961178403317', '1.163290187581915546961178403317e+12');
    T('66576328239778.9221010881719386547426171', '6.65763282397789221010881719386547426171e+13');
    T('16813819268503.43', '1.681381926850343e+13');
    T('7.608', '7.608e+0');
    T('11.451', '1.1451e+1');
    T('0.1922806905431647016463821', '1.922806905431647016463821e-1');
    T('44848451452586076.092278628409241023', '4.4848451452586076092278628409241023e+16');
    T('4686238000150.70382', '4.68623800015070382e+12');
    T('-4695.35', '-4.69535e+3');
    T('-1983.891808001543469238', '-1.983891808001543469238e+3');
    T('-1889.02703741954574174912952944455', '-1.88902703741954574174912952944455e+3');
    T('35457.09614', '3.545709614e+4');
    T('32.1', '3.21e+1');
    T('17.191386008285', '1.7191386008285e+1');
    T('72079850.05005464262982', '7.207985005005464262982e+7');
    T('-255013711.584', '-2.55013711584e+8');
    T('-1811484.668115', '-1.811484668115e+6');
    T('0.00363319', '3.63319e-3');
    T('869661.973264908396349783701', '8.69661973264908396349783701e+5');
    T('0.05192167736562581786679001500854748090234383575716316', '5.192167736562581786679001500854748090234383575716316e-2');
    T('1.9487431397621384432294662785541135947571028102', '1.9487431397621384432294662785541135947571028102e+0');
    T('-40.4495090522601103979', '-4.04495090522601103979e+1');
    T('28464851104.22990107740844', '2.846485110422990107740844e+10');
    T('9057355.112792', '9.057355112792e+6');
    T('2345.0874442435', '2.3450874442435e+3');
    T('-0.0004587666076676070018', '-4.587666076676070018e-4');
    T('25644837433.052', '2.5644837433052e+10');
    T('-0.0813033', '-8.13033e-2');
    T('104270936.663424352561033777037436212287235735086698002099393', '1.04270936663424352561033777037436212287235735086698002099393e+8');
    T('-0.0001278605520852616671853139997654658857207788577296192382717356659507903', '-1.278605520852616671853139997654658857207788577296192382717356659507903e-4');
    T('3.2', '3.2e+0');
    T('0.00004385545212765103340926', '4.385545212765103340926e-5');
    T('617298348206916139928.4280232746359395559755', '6.172983482069161399284280232746359395559755e+20');
    T('-1039598802845498.9', '-1.0395988028454989e+15');
    T('-136472767053355263.803357925713228523834700927', '-1.36472767053355263803357925713228523834700927e+17');
    T('6686106.00966845277017671235008645686364712952519700429650727', '6.68610600966845277017671235008645686364712952519700429650727e+6');
    T('-1.28437447589675625894263646', '-1.28437447589675625894263646e+0');
    T('7255816.80175928465638553952', '7.25581680175928465638553952e+6');
    T('1.913186249682945262', '1.913186249682945262e+0');
    T('-239610.078286802134757752042940657560396207793018', '-2.39610078286802134757752042940657560396207793018e+5');
    T('1824062535.125953860448793680581', '1.824062535125953860448793680581e+9');
    T('143663085933469033811.845726707878', '1.43663085933469033811845726707878e+20');
    T('-2.623365', '-2.623365e+0');
    T('51.4', '5.14e+1');
    T('-0.002713956452636791112860101983746083147835473825563663197299641194994291', '-2.713956452636791112860101983746083147835473825563663197299641194994291e-3');
    T('23683475.76857523129953167', '2.368347576857523129953167e+7');
    T('438888090072164.446744747716480585', '4.38888090072164446744747716480585e+14');
    T('-18795766590.876227458586674', '-1.8795766590876227458586674e+10');
    T('1', '1e+0');
    T('-0.00052634985121596383285768913499081865029860268677', '-5.2634985121596383285768913499081865029860268677e-4');
    T('105829462968115.1975', '1.058294629681151975e+14');
    T('468435.28992053729', '4.6843528992053729e+5');
    T('1846489897520109.8715192525464204', '1.8464898975201098715192525464204e+15');
    T('52376.8738438780776514097903786413319412608929071044928019', '5.23768738438780776514097903786413319412608929071044928019e+4');
    T('-3116.0382285086879890762181552', '-3.1160382285086879890762181552e+3');
    T('-32.3', '-3.23e+1');
    T('4381.835863935170505493389465883363', '4.381835863935170505493389465883363e+3');
    T('-165246341553.196523942434377973750070062506177191779164855705595256077559', '-1.65246341553196523942434377973750070062506177191779164855705595256077559e+11');
    T('131463737561555.227840078959933769449', '1.31463737561555227840078959933769449e+14');
    T('-64274482438198.12338384', '-6.427448243819812338384e+13');
    T('-55.454727', '-5.5454727e+1');
    T('0.00009717525025399550713686849913956172026124576144750225419737337393085648', '9.717525025399550713686849913956172026124576144750225419737337393085648e-5');
    T('308.25959181284769470446754944967753432202198524450589150147579', '3.0825959181284769470446754944967753432202198524450589150147579e+2');
    T('-0.0004788485313310332561375607045337471634311364865082251102927546302522', '-4.788485313310332561375607045337471634311364865082251102927546302522e-4');
    T('-0.00001674901333535441800495', '-1.674901333535441800495e-5');
    T('0.0002109152895285069571392567905111065321238498247841125198378', '2.109152895285069571392567905111065321238498247841125198378e-4');
    T('1.8231876866378834252226768', '1.8231876866378834252226768e+0');
    T('93303195849247612.1179468353063516778756323', '9.33031958492476121179468353063516778756323e+16');
    T('29250048.5238', '2.92500485238e+7');
    T('39114.2994953333700262004334845808507590484518898551674729031', '3.91142994953333700262004334845808507590484518898551674729031e+4');
    T('0.0005054595146099124050321344193608438', '5.054595146099124050321344193608438e-4');
    T('-0.00000261573741630302119', '-2.61573741630302119e-6');
    T('-3942.464375', '-3.942464375e+3');
    T('-3516832336235414.4', '-3.5168323362354144e+15');
    T('2932.653064227619313029108820790178', '2.932653064227619313029108820790178e+3');
    T('1774849188.5', '1.7748491885e+9');
    T('-0.0002027560662251712073209658732784123702', '-2.027560662251712073209658732784123702e-4');
    T('0.00444876564937645706130197514776656311551429', '4.44876564937645706130197514776656311551429e-3');
    T('240253285740.838116226498651453699832893449270360277233', '2.40253285740838116226498651453699832893449270360277233e+11');
    T('-7812.5', '-7.8125e+3');
    T('0.00001908835118349029561417171733623571576159447', '1.908835118349029561417171733623571576159447e-5');
    T('0.2384', '2.384e-1');
    T('10276060261519.01008', '1.027606026151901008e+13');
    T('-624.68608', '-6.2468608e+2');
    T('1908594605470.78947212', '1.90859460547078947212e+12');
    T('-28710692938.0080069772', '-2.87106929380080069772e+10');
    T('9322478927859.7226939388', '9.3224789278597226939388e+12');
    T('462.39278989717', '4.6239278989717e+2');
    T('-292431845.123982205', '-2.92431845123982205e+8');
    T('25360.527879143279940028900068932', '2.5360527879143279940028900068932e+4');
    T('-5243.17', '-5.24317e+3');
    T('-887126.1', '-8.871261e+5');
    T('-178855521286448910.81847', '-1.7885552128644891081847e+17');
    T('144.2512', '1.442512e+2');
    T('0.27596543435213575657016815774010982522459215678803', '2.7596543435213575657016815774010982522459215678803e-1');
    T('-253740766.92573966065983255295671290684914', '-2.5374076692573966065983255295671290684914e+8');
    T('39700389548445.6259811459023887888', '3.97003895484456259811459023887888e+13');
    T('-1892773154533250.9175616099286242603674149016132592843892582', '-1.8927731545332509175616099286242603674149016132592843892582e+15');
    T('-296875635.459708175104685570522448224822586239556382712456482872564385186', '-2.96875635459708175104685570522448224822586239556382712456482872564385186e+8');
    T('6024461977597039.793', '6.024461977597039793e+15');
    T('96939842474248948569.99133712747636693', '9.693984247424894856999133712747636693e+19');
    T('-2349', '-2.349e+3');
    T('12.37220312294423096847137245814517168644123454251402373', '1.237220312294423096847137245814517168644123454251402373e+1');
    T('-0.000762219', '-7.62219e-4');
    T('-5037872113222595.853342945932403900813107', '-5.037872113222595853342945932403900813107e+15');
    T('0.013627449843979201277465601769', '1.3627449843979201277465601769e-2');
    T('367.73299807918251456434671994008495006247774681820454975695966689163', '3.6773299807918251456434671994008495006247774681820454975695966689163e+2');
    T('-1774201339889.272577961174157286022083347159', '-1.774201339889272577961174157286022083347159e+12');
    T('0.383405861086782832620684731034382', '3.83405861086782832620684731034382e-1');
    T('-0.000026', '-2.6e-5');
    T('49.430443587', '4.9430443587e+1');
    T('-5.1913887226490591309931479', '-5.1913887226490591309931479e+0');
    T('-15717762.475111621342076', '-1.5717762475111621342076e+7');
    T('-4', '-4e+0');
    T('-4631.0846464039792793925640221891309792535940896378049095621424621', '-4.6310846464039792793925640221891309792535940896378049095621424621e+3');
    T('1413738075378069949.56029998552506378068322011', '1.41373807537806994956029998552506378068322011e+18');
    T('46931268921942747.2708649335933082133203056020370678708294465898173515', '4.69312689219427472708649335933082133203056020370678708294465898173515e+16');
    T('0.00093414', '9.3414e-4');
    T('-1.58705863899010271178421', '-1.58705863899010271178421e+0');
    T('-0.0164558511781215799863524531521382142453343', '-1.64558511781215799863524531521382142453343e-2');
    T('-0.000033962690504168429144', '-3.3962690504168429144e-5');
    T('0.0000591597601664039239323473979662138718624059870072', '5.91597601664039239323473979662138718624059870072e-5');
    T('4861599649260088570.0003442852280303481644428810265', '4.8615996492600885700003442852280303481644428810265e+18');
    T('-6581.92178891754198277809950661445424444', '-6.58192178891754198277809950661445424444e+3');
    T('0.000443442744', '4.43442744e-4');
    T('862885496525896.393004927631306078', '8.62885496525896393004927631306078e+14');
    T('-409.565286307201', '-4.09565286307201e+2');
    T('-749168762.7771507445838618797279002344648652959333491', '-7.491687627771507445838618797279002344648652959333491e+8');
    T('-4.182', '-4.182e+0');
    T('-0.0043097149091842239110508832659037353003224', '-4.3097149091842239110508832659037353003224e-3');
    T('2.95560963', '2.95560963e+0');
    T('0.000001082047849865643097457831831148083', '1.082047849865643097457831831148083e-6');
    T('0.0510067515295825124101945807336780815643699536571457299156099', '5.10067515295825124101945807336780815643699536571457299156099e-2');
    T('153.466306', '1.53466306e+2');
    T('2793067936490.72982349', '2.79306793649072982349e+12');
    T('-138901662.313822438', '-1.38901662313822438e+8');
    T('0.000620515986219', '6.20515986219e-4');
    T('0', '0e+0');
    T('3206026277639.0275609', '3.2060262776390275609e+12');
    T('290.10236', '2.9010236e+2');
    T('0.7811084054', '7.811084054e-1');
    T('0.00003711588621150377156474674880860543078563', '3.711588621150377156474674880860543078563e-5');
    T('3.31960901176478283939912192394193264568314426394636493469769291109662224', '3.31960901176478283939912192394193264568314426394636493469769291109662224e+0');
    T('0.0000791778413118107043058411496928', '7.91778413118107043058411496928e-5');
    T('-0.00000576468043734782848403816473286085118790737089898', '-5.76468043734782848403816473286085118790737089898e-6');
    T('-3912585254.19202315528932215114', '-3.91258525419202315528932215114e+9');
    T('137338031.6', '1.373380316e+8');
    T('30.6932491548981985262774346527488686091809', '3.06932491548981985262774346527488686091809e+1');
    T('-66086832545865997366.195847618443721060270259871066071067306791701732791373', '-6.6086832545865997366195847618443721060270259871066071067306791701732791373e+19');
    T('0', '0e+0');
    T('-13.722117', '-1.3722117e+1');
    T('-248974688672485931.4590191059407968746631', '-2.489746886724859314590191059407968746631e+17');
    T('91240.086239589202214406295668563051026987384777308158011222153', '9.1240086239589202214406295668563051026987384777308158011222153e+4');
    T('-3.5338148998559444417330716022294390666021991', '-3.5338148998559444417330716022294390666021991e+0');
    T('2.6', '2.6e+0');
    T('1734825599220.52', '1.73482559922052e+12');
    T('-57170562.129942072027205098329198887303', '-5.7170562129942072027205098329198887303e+7');
    T('20544612.11313', '2.054461211313e+7');
    T('70939237017.42726', '7.093923701742726e+10');
    T('462378955285.99297', '4.6237895528599297e+11');
    T('0.000021', '2.1e-5');
    T('20.525076131988', '2.0525076131988e+1');
    T('-4', '-4e+0');
    T('-47404317.48625779235567137343123255675323465033029752022294', '-4.740431748625779235567137343123255675323465033029752022294e+7');
    T('-55857.8945831230338325704270665815655', '-5.58578945831230338325704270665815655e+4');
    T('15619130.056541672746265564818', '1.5619130056541672746265564818e+7');
    T('-509103.24488138920961073312263453791501627781957', '-5.0910324488138920961073312263453791501627781957e+5');
    T('-2244957856765271.426502853008077', '-2.244957856765271426502853008077e+15');
    T('0.000017030812826690437402788006802232371231953628', '1.7030812826690437402788006802232371231953628e-5');
    T('-0.0000014775344940131996506012024340852769516067326910849981594100829151750930077', '-1.4775344940131996506012024340852769516067326910849981594100829151750930077e-6');
    T('6.77583900119174558047', '6.77583900119174558047e+0');
    T('18031872515950.28615557432172221913302696131248029', '1.803187251595028615557432172221913302696131248029e+13');
    T('-0.000025191400016242244719402602345892709609', '-2.5191400016242244719402602345892709609e-5');
    T('5.254', '5.254e+0');
    T('8853.6719', '8.8536719e+3');
    T('-26.2912940386', '-2.62912940386e+1');

    T('3.171194102379077141557759899307946350455841e+27', '3171194102379077141557759899.307946350455841');
    T('4.924353466898191177698653319742594890634579e+37', '49243534668981911776986533197425948906.34579');
    T('5.690616778176956027307884725933410349604387915634524e+49', '56906167781769560273078847259334103496043879156345.24');
    T('6.4986735507448912857131832908423940757e+38', '649867355074489128571318329084239407570.0');
    T('1.25934313355319666474752550204680303068865719647e+33', '1259343133553196664747525502046803.03068865719647');
    T('1.23014105337660651106978059198916100450966081493207e+27', '1230141053376606511069780591.98916100450966081493207');
    T('1.386164712267169624993434287237e+23', '138616471226716962499343.4287237');
    T('1.39853642894726883996875746770529e+28', '13985364289472688399687574677.0529');
    T('5.10614446965318674547416709785208086304398889160563e+28', '51061444696531867454741670978.5208086304398889160563');
    T('1.46685947134456101512731611558e+23', '146685947134456101512731.6115580');
    T('3.69960105771344554151928256518906564810300119e+25', '36996010577134455415192825.6518906564810300119');
    T('3.05345735395805567424714891401667575466462830113819e+48', '3053457353958055674247148914016675754664628301138.19');
    T('1.559806666149836070330006415033e+24', '1559806666149836070330006.415033');
    T('2.8416297367859233303497847667971781197616950846e+28', '28416297367859233303497847667.971781197616950846');
    T('2.1364951568189836563102481625533538320051163977e+41', '213649515681898365631024816255335383200511.63977');
    T('9.034542832410912578330021146413119399e+28', '90345428324109125783300211464.13119399');
    T('7.026094393430852002585511641212897686956090955e+39', '7026094393430852002585511641212897686956.090955');
    T('9.435538492497050138580201734902181057468044875e+43', '94355384924970501385802017349021810574680448.75');
    T('2.315089265590404012562599592854156357726817712e+26', '231508926559040401256259959.2854156357726817712');
    T('9.85209894663520857685703881781194082356123765e+39', '9852098946635208576857038817811940823561.23765');
    T('2.65213505469049775997232325076980590625670234690917845e+41', '265213505469049775997232325076980590625670.234690917845');
    T('9.023159535576504097005203913521871601640521009e+36', '9023159535576504097005203913521871601.640521009');
    T('2.456680359828937628024631306792185367572610021e+43', '24566803598289376280246313067921853675726100.21');
    T('3.20634106832106387482375790792609337383007782520694e+24', '3206341068321063874823757.90792609337383007782520694');
    T('2.717780449744210117995586561524987067807146882e+43', '27177804497442101179955865615249870678071468.82');
    T('2.86757572635270377540170639151e+22', '28675757263527037754017.0639151');
    T('1.08862827358094757110520739146065028362703e+30', '1088628273580947571105207391460.65028362703');
    T('1.696622337138949329874242519485119916519994150606e+39', '1696622337138949329874242519485119916519.994150606');
    T('4.958075942313945962737499249994583773691625306e+36', '4958075942313945962737499249994583773.691625306');
    T('8.67210047206219429882716380856729877038463e+37', '86721004720621942988271638085672987703.8463');
    T('1.35467074874780607458660332165839e+30', '1354670748747806074586603321658.39');
    T('5.21963089810195859130639819168579622e+24', '5219630898101958591306398.19168579622');
    T('1.8688440918945220036354844302195749309220888e+26', '186884409189452200363548443.02195749309220888');
    T('2.556582211914618427489836174964272160475e+25', '25565822119146184274898361.74964272160475');
    T('7.4140139575523848563560806694561950037847e+26', '741401395755238485635608066.94561950037847');
    T('1.9191049758936644006660416648962209488e+24', '1919104975893664400666041.66489622094880');
    T('1.5893308320910765122063972428358196502e+36', '1589330832091076512206397242835819650.2');
    T('1.350769554904381289856048945926109233407469025099095e+35', '135076955490438128985604894592610923.3407469025099095');
    T('3.4955955888709903930650733178004053283303e+27', '3495595588870990393065073317.8004053283303');
    T('3.765499741127994356229674741445362678695091917e+28', '37654997411279943562296747414.453626786950919170');
    T('3.770936274989628272472264790077542e+21', '3770936274989628272472.264790077542');
    T('6.62710314240271241900085261e+21', '6627103142402712419000.85261');
    T('1.316934076085443594506478729911134464048168888698e+42', '1316934076085443594506478729911134464048168.888698');
    T('2.9510339604105305444519680156145845428324011e+35', '295103396041053054445196801561458454.28324011');
    T('2.32664625710064626302675792506518986748623800519362825e+45', '2326646257100646263026757925065189867486238005.19362825');
    T('9.05841068683497571038524585222884373e+29', '905841068683497571038524585222.884373');
    T('2.104525700707071438146923949322482428742115356534e+28', '21045257007070714381469239493.22482428742115356534');
    T('7.024685053227353728838050757013069476546171879163e+24', '7024685053227353728838050.757013069476546171879163');
    T('7.2863751084180259357725026103712116366349e+23', '728637510841802593577250.26103712116366349');
    T('9.71891517062070497407760297561206525471485e+27', '9718915170620704974077602975.61206525471485');
    T('6.4741508681889057488168545664375944171354681e+23', '647415086818890574881685.45664375944171354681');
    T('1.6942797476135028024654429183339522530812281e+31', '16942797476135028024654429183339.522530812281');
    T('3.87899618892199653560586133205982498365799449e+27', '3878996188921996535605861332.05982498365799449');
    T('6.2615173898555524447350478811537912100608066376e+42', '6261517389855552444735047881153791210060806.6376');
    T('8.34563827640030036035405e+22', '83456382764003003603540.5');
    T('5.73284757676406662905522205317450204e+31', '57328475767640666290552220531745.0204');
    T('1.09314948671137385444979381052e+26', '109314948671137385444979381.052');
    T('8.86015267575800230944962406406137570452e+28', '88601526757580023094496240640.6137570452');
    T('8.7435115902725784785213467357972025071925716822259e+38', '874351159027257847852134673579720250719.25716822259');
    T('1.511686617338690801597376192985164124335711475e+36', '1511686617338690801597376192985164124.335711475');
    T('3.862183052662673704009308528932528900914181684535e+42', '3862183052662673704009308528932528900914181.684535');
    T('3.862360154857656116978304538802550298055142749413e+37', '38623601548576561169783045388025502980.55142749413');
    T('1.7557601024183018471184139748851879933153788645e+26', '175576010241830184711841397.48851879933153788645');
    T('4.1705118500557863903425612212241828e+28', '41705118500557863903425612212.241828');
    T('1.015453056007471546100232031232797626130792432862e+30', '1015453056007471546100232031232.797626130792432862');
    T('2.8538363119129962635325743474766089129608347262536e+29', '285383631191299626353257434747.660891296083472625360');
    T('1.42167287636895617482014385649865679412e+27', '1421672876368956174820143856.49865679412');
    T('9.6100608486394273371410715209128478362564609e+29', '961006084863942733714107152091.28478362564609');
    T('6.628723659367639746219006678948604246e+24', '6628723659367639746219006.678948604246');
    T('1.91781433973790573018323517395847264353e+35', '191781433973790573018323517395847264.35300');
    T('3.36834833123607650204419305291838348810644243e+42', '3368348331236076502044193052918383488106442.43');
    T('1.71911767411984485012054040057806822618e+28', '17191176741198448501205404005.7806822618');
    T('3.6562357737624542715177216071738074863798786e+36', '3656235773762454271517721607173807486.3798786');
    T('8.57520635819763350659219863901837233e+21', '8575206358197633506592.19863901837233');
    T('1.245913688722124452316952395765916246e+21', '1245913688722124452316.9523957659162460');
    T('8.8964578294856908705314945178917896807516003057782324e+46', '88964578294856908705314945178917896807516003057.782324');
    T('1.5579884689150031101693496143656840264980386818704e+23', '155798846891500311016934.961436568402649803868187040');
    T('8.5051864582679908692564183699252612773409509082078e+37', '85051864582679908692564183699252612773.409509082078');
    T('8.8798692074080075787375315447486123809923959833e+26', '887986920740800757873753154.47486123809923959833');
    T('2.6484576511218782036901501152986249531234497168718e+40', '26484576511218782036901501152986249531234.497168718');
    T('7.6404110248649153016903650163544816581006668605e+23', '764041102486491530169036.50163544816581006668605');
    T('1.41787251451628994917275472e+24', '1417872514516289949172754.72');
    T('4.2104854597998748621925225253125873386e+31', '42104854597998748621925225253125.87338600');
    T('2.22735863520665290933246331848e+24', '2227358635206652909332463.31848');
    T('6.6860727859954777667223002708162369e+32', '668607278599547776672230027081623.69');
    T('6.8357371699714755863090081855483865237790749503e+22', '68357371699714755863090.081855483865237790749503');
    T('1.78557003827723798504978687588959254956675353035516771e+37', '17855700382772379850497868758895925495.6675353035516771');
    T('3.88694369953891826304770521327308322619393047272853992e+29', '388694369953891826304770521327.308322619393047272853992');
    T('6.53989976127167541385228442576702092890124e+35', '653989976127167541385228442576702092.89012400');
    T('1.80118254923064703459780878790624318318152203e+37', '18011825492306470345978087879062431831.8152203');
    T('2.029177448999173372119989892440779088e+22', '20291774489991733721199.89892440779088');
    T('7.078660611250891118657496594735238821341408353e+35', '707866061125089111865749659473523882.1341408353');
    T('1.096715852238427070115466117322983113926e+36', '1096715852238427070115466117322983113.926');
    T('2.86532834287791967206284176556306849118939923884e+42', '2865328342877919672062841765563068491189399.23884');
    T('9.4435575887407391033782269887533990447300682186075521e+24', '9443557588740739103378226.9887533990447300682186075521');
    T('2.196175657558897384981748559894e+29', '219617565755889738498174855989.4');
    T('1.7224191355912435440309996131683233957399227e+29', '172241913559124354403099961316.83233957399227');
    T('8.089765204288655830674576596713309516483099e+31', '80897652042886558306745765967133.09516483099');
    T('2.07166412218470429605806831507e+24', '2071664122184704296058068.31507');
    T('1.4327673900218857772756403845335511690820534667844161e+25', '14327673900218857772756403.845335511690820534667844161');
    T('5.96685124808828989098666066158574653883332e+34', '59668512480882898909866606615857465.3883332');
    T('3.1497590158477647299507840130228337905235603e+22', '31497590158477647299507.840130228337905235603');
    T('1.68055184413854558094765106936369527289778050531295766e+40', '16805518441385455809476510693636952728977.8050531295766');
    T('1.308323895602314056642638704891037710277185276986927e+40', '13083238956023140566426387048910377102771.85276986927');
    T('3.295254020832544012761679098484189727227833e+41', '329525402083254401276167909848418972722783.3');
    T('2.9072795594202554837396927026502083307998e+35', '290727955942025548373969270265020833.07998');
    T('1.3689991541714377699994556138826283759e+29', '136899915417143776999945561388.26283759');
    T('3.36806306935615523082781617061106400210297708457466e+40', '33680630693561552308278161706110640021029.7708457466');
    T('1.730864210471288302007789478210233615399858e+21', '1730864210471288302007.789478210233615399858');
    T('1.98572237681530700377986658329680798e+32', '198572237681530700377986658329680.798');
    T('1.279811707773498944767714003821019551877654490239992e+40', '12798117077734989447677140038210195518776.54490239992');
    T('3.8084703153428358911632007387325702215541573567757e+45', '3808470315342835891163200738732570221554157356.7757');
    T('1.3810837466649418967673665311541682533151e+37', '13810837466649418967673665311541682533.151');
    T('1.75045497942020277400523024600228150483494020715374e+39', '1750454979420202774005230246002281504834.94020715374');
    T('3.854570457401828825080672674176371617252885568525e+42', '3854570457401828825080672674176371617252885.568525');
    T('2.524007970392697273821209419290910149e+32', '252400797039269727382120941929091.0149');
    T('9.19536554437673037098591509995026767872538589562761e+45', '9195365544376730370985915099950267678725385895.62761');
    T('1.183552401830090152504539986275312716505e+23', '118355240183009015250453.9986275312716505');
    T('3.49082770706667347770412719905221035269e+36', '3490827707066673477704127199052210352.69');
    T('1.09667668559108738350612984427121459528827e+35', '109667668559108738350612984427121459.528827');
    T('4.7727335155560138656406364912e+21', '4772733515556013865640.6364912');
    T('1.39511686402859313308703279767446898138923566399e+34', '13951168640285931330870327976744689.8138923566399');
    T('1.83547377703310193838625323613810597146659646688e+38', '183547377703310193838625323613810597146.659646688');
    T('3.387626848249516099010371969816649097243645e+35', '338762684824951609901037196981664909.7243645');
    T('4.854485927348228918413753679671472155071e+35', '485448592734822891841375367967147215.5071');
    T('1.1145412703080371165560398973334199e+32', '111454127030803711655603989733341.99');
    T('2.130358009562539933673297313517219743395888826178226e+42', '2130358009562539933673297313517219743395888.826178226');
    T('1.26860370623505030126846090707878e+22', '12686037062350503012684.6090707878');
    T('3.717693087339892916526272044454e+24', '3717693087339892916526272.044454');
    T('1.866503037113138887457365815904225e+28', '18665030371131388874573658159.04225');

    T('0.0011263455635', '0.0011263455635000000000');
    T('0.00005599616782279678868859860419', '0.00005599616782279678868859860419000000000000000');
    T('0.9689457348938820467495', '0.9689457348938820467495000000000000');
    T('1', '1');
    T('0.2629', '0.262900000000000000000');
    T('0.0002393737516931411861504801546', '0.00023937375169314118615048015460000000000000000000');
    T('0.00009774061917141138033028467', '0.00009774061917141138033028467000000000');
    T('0.00292455', '0.0029245500000000');
    T('-0.00068986952351457757', '-0.00068986952351457757000000');
    T('0.07084936', '0.070849360000000000000');
    T('-0.373', '-0.373000');
    T('-2', '-2');
    T('0.0001519', '0.000151900000000000000000');
    T('0.04237079', '0.04237079000000000000000000');
    T('0.158559483548985350300576037', '0.1585594835489853503005760370000');
    T('0.030884214498496080583519', '0.0308842144984960805835190000');
    T('0.0003332979853556912152', '0.0003332979853556912152000000000000000000');
    T('0.00520795233040325458241', '0.0052079523304032545824100000000000000000000');
    T('0.99273493786', '0.9927349378600000000');
    T('-0.000056112029122076268731916105493', '-0.000056112029122076268731916105493000000000000000000000');
    T('0.000072668203', '0.0000726682030000000000000000');
    T('-0.0005728825407', '-0.0005728825407000000');
    T('-0.0028471515206570661019', '-0.0028471515206570661019000000');
    T('-0.0000050495', '-0.0000050495000');
    T('0.6814238', '0.68142380000000000000');
    T('-0.001801323516988438237306678', '-0.00180132351698843823730667800000000');
    T('0.00044672901248005231185', '0.00044672901248005231185000');
    T('-0.00659562', '-0.0065956200000');
    T('0.000005709242556800505995757422', '0.0000057092425568005059957574220000000000000');
    T('-0.03858', '-0.038580000000000000000');
    T('-0.0014652', '-0.0014652000000000');
    T('-0.000589007499920538307504', '-0.000589007499920538307504000000000000000');
    T('-0.0005315422668709676158', '-0.000531542266870967615800000000000');
    T('0.00013213666126560646', '0.0001321366612656064600');
    T('0.000004344703015318018265878045', '0.000004344703015318018265878045000000000000000000000');
    T('-0.00136764606625344', '-0.00136764606625344000000000000000000');
    T('-0.0000537651227073897413202', '-0.000053765122707389741320200');
    T('0.886613170228603', '0.88661317022860300000000000000000');
    T('0.3139844285751256457512672', '0.31398442857512564575126720000');
    T('-0.002851248', '-0.0028512480000000000000000');
    T('-0.0000042877', '-0.00000428770000000000000000');
    T('-0.03693105129', '-0.03693105129000000000');
    T('-0.000016644061440832683', '-0.000016644061440832683000000000000');
    T('5', '5');
    T('-0.0068772750612813', '-0.00687727506128130000000000');
    T('-0.00000417995882', '-0.00000417995882000000000');
    T('0.000051728443482958305115', '0.00005172844348295830511500000000000000');
    T('-0.63054490172322775078', '-0.63054490172322775078000');
    T('0.846227130773152', '0.846227130773152000000000000000000000');
    T('-0.00053925', '-0.00053925000000000000000');
    T('-0.00011657745', '-0.00011657745000000000');
    T('-0.0000606908449266106674509767236', '-0.000060690844926610667450976723600000000000000');
    T('-0.000015232774296786', '-0.00001523277429678600000000000');
    T('-0.0000018870130044533213759607', '-0.00000188701300445332137596070000');
    T('0.07387110922584445111868', '0.0738711092258444511186800');
    T('0.0028958950171847760130772342397', '0.00289589501718477601307723423970000000000000');
    T('0.07773', '0.07773000000000000000000');
    T('-0.15623754221748168238257', '-0.15623754221748168238257000000000');
    T('-0.000031014107607510859290785', '-0.00003101410760751085929078500000000000000000000');
    T('-0.155253876', '-0.155253876000000');
    T('-0.162423714137733125085121498', '-0.16242371413773312508512149800');
    T('0.627526444840677348430187497', '0.62752644484067734843018749700000000000000000000');
    T('-0.15349114378505726347993', '-0.1534911437850572634799300000000000000000');
    T('0.00000428050624985303744021063060711', '0.00000428050624985303744021063060711000000000');
    T('-0.0000017826243', '-0.00000178262430000000000000');
    T('-0.1325584873060896817812', '-0.132558487306089681781200000000');
    T('0.000008265906442925047', '0.0000082659064429250470000');
    T('-0.000037199177255', '-0.00003719917725500000000000');
    T('-0.0014975740625744085757661916', '-0.00149757406257440857576619160000000000000000');
    T('-0.00000104174992201057110845958171286', '-0.0000010417499220105711084595817128600000000000');
    T('0.0002657674796', '0.0002657674796000000000000000000');
    T('-0.000005691567765087952481381', '-0.0000056915677650879524813810000000000000000000');
    T('0.000001192218291518612772', '0.0000011922182915186127720000');
    T('-0.0000128575347', '-0.000012857534700000000000000000');
    T('0.00062701379', '0.000627013790000000000000000');
    T('-0.156608766578157915298', '-0.156608766578157915298000000');
    T('-0.001899267273700873', '-0.0018992672737008730000000000000000000');
    T('0.0000968', '0.00009680000000000000000000');
    T('0.00085424843402', '0.0008542484340200');
    T('0.000175', '0.00017500000');
    T('-0.17051', '-0.17051000');
    T('0.00113697', '0.00113697000000000000000000');
    T('0.000001488862050355755060487623167', '0.000001488862050355755060487623167000000000000');
    T('0.00002699569741159526', '0.00002699569741159526000');
    T('0.00001287192636853', '0.00001287192636853000000000000000000');
    T('-0.00000366090353062717043913357274082', '-0.0000036609035306271704391335727408200000');
    T('0.031338265111184040022', '0.0313382651111840400220000000');
    T('-0.00001653', '-0.000016530000000000000');
    T('-0.0133754851476993216067501924', '-0.0133754851476993216067501924000000000000000000');
    T('0.000005353', '0.00000535300000000000000000000');
    T('0.14873216211842', '0.14873216211842000');
    T('0.0001192511854', '0.000119251185400000000');
    T('0.01756492192', '0.017564921920000000000000000');
    T('-0.0000063762', '-0.000006376200000000000');
    T('0.000735826754123', '0.00073582675412300');
    T('-0.00485', '-0.0048500000');
    T('0.344385', '0.3443850000000');
    T('0.0430122427567419', '0.0430122427567419000000000');
    T('-0.0142796237025954885313450737', '-0.014279623702595488531345073700000000000000000000');
    T('0.006634970245679', '0.0066349702456790000000000');
    T('-0.114512015038681223032047', '-0.114512015038681223032047000000');
    T('-0.0000028785917141346585355976738197', '-0.000002878591714134658535597673819700000000000000000000');
    T('-0.000279430425345862869074928275', '-0.000279430425345862869074928275000000000');
    T('-0.00002942229173991521526962587123', '-0.00002942229173991521526962587123000000000000000');
    T('0.005067015345015442599363084', '0.005067015345015442599363084000000000000');
    T('0.005115013126', '0.00511501312600000000000000000000');
    T('-0.0000023463883841184598257656291715', '-0.000002346388384118459825765629171500');
    T('-0.00408188867653506526747439165461', '-0.0040818886765350652674743916546100000000');
    T('0.03283946746237808822', '0.0328394674623780882200000000000');
    T('0.00000121571653184750325515', '0.000001215716531847503255150000');
    T('-0.00116', '-0.00116000');
    T('-0.000120516661966204019689061641', '-0.00012051666196620401968906164100000000000000000');
    T('0.0184', '0.01840000000000000000000');
    T('0.0062145242', '0.0062145242000');
    T('0.000604475131718102196', '0.0006044751317181021960000000000000000');
    T('-0.1441651481585831', '-0.144165148158583100');
    T('-0.0000014631', '-0.000001463100000000000000000000');
    T('0.0279484047801525225287254316875', '0.0279484047801525225287254316875000000000000000000000');
    T('-0.00126806436344', '-0.001268064363440000000000000');
    T('162145242000', '00162145242000.0');

    T('0', '0.');
    T('0', '000.');
    T('1', '1.');
    T('12', '12.');
    T('9876543210', '9876543210.');
    T('0', '.0');
    T('0', '.00');
    T('0.2', '.2');
    T('0.34', '.34');
    T('0', '0.e0');
    T('0', '0.e+4');
    T('980', '98.e1');
    T('0.0003', '3.e-4');

    assertException(function () {new Big(undefined)}, "new Big(undefined)");
    assertException(function () {new Big(null)}, "new Big(null)");
    assertException(function () {new Big(NaN)}, "new Big(NaN)");
    assertException(function () {new Big('NaN')}, "new Big('NaN')");
    assertException(function () {new Big([])}, "new Big([])");
    assertException(function () {new Big({})}, "new Big({})");
    assertException(function () {new Big('')}, "new Big('')");
    assertException(function () {Big(' ')}, "new Big(' ')");
    assertException(function () {new Big('hello')}, "new Big('hello')");
    assertException(function () {new Big('\t')}, "new Big('\t')");
    assertException(function () {new Big(new Date)}, "new Big(new Date)");
    assertException(function () {new Big(new RegExp)}, "new Big(new RegExp)");
    assertException(function () {new Big(function () {})}, "new Big(function () {})");
    assertException(function () {new Big(' 0.1')}, "new Big(' 0.1')");
    assertException(function () {new Big('7.5 ')}, "new Big('7.5 ')");
    assertException(function () {Big(' 0 ')}, "new Big(' 0 ')");
    assertException(function () {new Big('+1')}, "new Big('+1')");
    assertException(function () {new Big(' +1.2')}, "new Big(' +1.2')");
    assertException(function () {new Big('- 99')}, "new Big('- 99')");
    assertException(function () {new Big('9.9.9')}, "new Big('9.9.9')");
    assertException(function () {new Big('10.1.0')}, "new Big('10.1.0')");
    assertException(function () {new Big('0x16')}, "new Big('0x16')");
    assertException(function () {new Big('1e')}, "new Big('1e')");
    assertException(function () {new Big('8 e')}, "new Big('8 e')");
    assertException(function () {new Big('77-e')}, "new Big('77-e')");
    assertException(function () {new Big('123e.0')}, "new Big('123e.0')");
    assertException(function () {new Big('4e1.')}, "new Big('4e1.')");
    assertException(function () {new Big('41a')}, "new Big('41a')");
    assertException(function () {new Big('99ee')}, "new Big('99ee')");
    assertException(function () {new Big('e0')}, "new Big('e0')");
    assertException(function () {Big(Infinity)}, "new Big(Infinity)");
    assertException(function () {new Big('-Infinity')}, "new Big('-Infinity')");

    Big.E_NEG = -10;
    Big.E_POS = 10;

    T('1234567890', '1234567890');
    T('1.2345678901e+10', '12345678901');
    T('0.000000001', '0.000000001');
    T('1e-11', '0.00000000001');

    log('\n ' + passed + ' of ' + total + ' tests passed in ' + (+new Date() - start) + ' ms \n');
    return [passed, total];;
})(this.Big);
if (typeof module !== 'undefined' && module.exports) module.exports = count;