#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=HTML-Template-Pluggable
PACKAGE=libhtml-template-pluggable-perl
VERSION=0.17
HELPERS_VERS=0.04
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/helpers/watch ${FD} ${NS} ${DD} ${US} ${HELPERS_VERS} && true;
    cd ${DESTDIR}
    HELPERS=`ls HTML-Template-Plugin-Dot-Helpers*.tar.gz`
    mv ${HELPERS} ${PACKAGE}_${VERSION}.orig-helpers.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/helpers/watch ${RS} ${DD} ${US} ${HELPERS_VERS} && true;
fi
