/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleListByPathRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesResult;
import com.amazonaws.services.identitymanagement.model.Role;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMRoleListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleListByPathRequest) {
            LOG.debug((Object)("List roles " + request));
            RoleListByPathRequest req = (RoleListByPathRequest)request;
            ListRolesRequest listRolesRequest = new ListRolesRequest();
            listRolesRequest.setPathPrefix(req.getListPath());
            listRolesRequest.setMarker(req.getMarker());
            listRolesRequest.setMaxItems(req.getMaxItems());
            LOG.debug((Object)"List roles by path prefix");
            ListRolesResult result = this.getClient().listRoles(listRolesRequest);
            for (Role role : result.getRoles()) {
                LOG.info((Object)role.getArn());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

