##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
Plugin.define "Squarespace" do
author "Brendan Coles <bcoles@gmail.com>" # 2011-03-03
version "0.1"
description "A fully hosted, completely managed environment for creating and maintaining a website, blog or portfolio. - Homepage: http://www.squarespace.com/"

# Google results as at 2011-03-03 #
# 116 for "This site is completely powered by the Squarespace platform."

# Examples #
examples %w|
www.squarespace.com
manual.squarespace.com
service.squarespace.com
developers.squarespace.com
american.squarespace.com
journal.squarespace.com
manual-old.squarespace.com
photogs.squarespace.com
diggnationlive.squarespace.com
www.believerschapel.org
dawnstoloffblog.com
firstsia.com
kylerranch.com
1neasalley.com
alisamurray.com
allcountywindowcleaning.com
amandadiva.squarespace.com
ashvegas.squarespace.com
basicinstructions.net
beartech.squarespace.com
bishophill.squarespace.com
blacksnob.com
blog.ideeli.com
blogs.parallels.com
blonde-designs.squarespace.com
brandonheath.net
callingallcrows.org
chrisdodd.com
dailybail.com
derbydolls.com
d-nice.com
doug-johnson.squarespace.com
ellenbarone.com
fishjobs.com
frederickgymnastics.com
heatherross.squarespace.com
hey.com
hibbingraceway.com
highscalability.com
hiphollywood.com
ilovewildfox.com
iplaywinner.com
jenniferrivera.squarespace.com
johnsauto.com
katiedid.squarespace.com
kevinrose.com
kimriddlebarger.squarespace.com
lacledecu.com
launch.is
lightechinc.com
lostandtaken.com
moabpaper.com
motobyron.com
mrs-o.org
niksargent.com
peach-tree.com
redmusiconline.com
rsjames.com
shuttersisters.com
snooperreport.com
steveboese.squarespace.com
supak.squarespace.com
sykart.com
texasprobate.com
thebellyfatcure.com
thecrossingsaustin.com
thefilmexperience.net
theitaliandishblog.com
theperennialplate.com
thirteenroses.squarespace.com
urbangrindcoffee.com
wasillaalaskaby300.squarespace.com
www.12403wc.com
www.3rdward.com
www.5starbaby.com
www.againfaster.com
www.alaskaportraits.com
www.alexa-vega.com
www.allaboardharvest.com
www.alleycattattoos.com
www.amatos.com
www.amavicellars.com
www.androidjones.com
www.andthankyouforflying.com
www.appleviewresort.com
www.arabist.net
www.autoextremist.com
www.baptiststoday.org
www.baseballanalytics.org
www.bayshoreteaparty.org
www.bbtia.com
www.beautifulmakeupsearch.com
www.bespokeinvest.com
www.bestofartists.com
www.bhamdining.com
www.bicyclefilmfestival.com
www.bigbrothergossip.com
www.bluemainsail.com
www.bobedwardsradio.com
www.bobparis.com
www.bocadeiguanas.com
www.bosnian-pyramid.com
www.brainstormk12.com
www.brigidashwood.com
www.calculus-help.com
www.carbon-fibre.me
www.castlefalls.com
www.castleunicorn.com
www.cavatappo.com
www.chapeldulcinea.org
www.charlestonsymphony.com
www.cheernation.net
www.chenahotsprings.com
www.chocolatefest.com
www.choochoobobs.com
www.chookooloonks.com
www.cinergycinemas.com
www.cinram.com
www.ciweb.org
www.clintonsparks.com
www.codinggreenrobots.com
www.coldwavesnowwear.com
www.compasschurch.com
www.conservativeblog.org
www.controlchaos.com
www.controlgeek.net
www.conversationblog.com
www.crabwizard.com
www.creaturecomfortsblog.com
www.crossfitfredericton.com
www.crossfitnorthatlanta.com
www.cutlerfarmdressage.com
www.danecook.com
www.darlingdexter.com
www.dearmrlevy.com
www.desiretoinspire.net
www.devilsdue.net
www.deyermondbooks.com
www.dianacamera.com
www.divorceonline.com
www.djcamilo.com
www.djsmallz.com
www.domesticviolence.org
www.drivebender.com
www.enduringamerica.com
www.entrepreneurialmd.com
www.e-xact.com
www.farm255.com
www.farmhousecheeses.com
www.ferrellhosp.org
www.figarospeech.com
www.finslippy.com
www.floridahighspeedrail.org
www.fpindustries.com
www.frogloop.com
www.fuckedinparkslope.com
www.funkybuddha.com
www.garynull.com
www.geoffshackelford.com
www.getthebigpicture.net
www.gillespiefishing.com
www.girltrashonline.com
www.girlzone.com
www.glenntilbrook.com
www.goldenearthworm.com
www.grandmasbriefs.com
www.grantham.ac.uk
www.greensburggreentown.org
www.greenvalleyspa.com
www.growinghomeinc.org
www.gwprescue.com
www.hebemedia.com
www.hilgraeve.com
www.hollywoodandvinewine.com
www.holyfamilycathedralschool.com
www.hoophall.com
www.hooterscalendar.com
www.houseofbedrooms.com
www.hubdub.com
www.icebulls.org
www.icethetics.info
www.ifss.edu.au
www.ihrsa.org
www.ihustlenation.com
www.ilovebacon.com
www.indiegamethemovie.com
www.inventorymagazine.com
www.ironridgeguns.com
www.islamophobia-watch.com
www.jamesrestaurantny.com
www.janestarrweils.com
www.jarsofclay.com
www.jessicaswift.com
www.jobsmn.com
www.johnsonliterary.com
www.jphs.org
www.lamafia.com
www.latriathlon.com
www.lillyollo.com
www.limarestaurant.com
www.linkingpage.com
www.lisaloeb.com
www.lisawilliamsmedium.com
www.lissaanglin.com
www.londonaudio.com
www.lovingraw.com
www.loyolahs.edu
www.lukeslobster.com
www.maratriangle.org
www.marceckoenterprises.com
www.mathewpacker.com
www.mayorkoch.com
www.mcferranonline.com
www.melaniefalickbooks.com
www.meltbarandgrilled.com
www.merlinmann.com
www.michelleobamawatch.com
www.misscellania.com
www.mnbound.com
www.moderncountryinteriors.com
www.modern-shed.com
www.monkeyinthepants.com
www.mtvnetworkscareers.com
www.myadventureisyouradvantage.com
www.noagendashow.com
www.nomiprins.com
www.norwalkjuicers.com
www.nuhw.org
www.odyssey-academy.com
www.pacificsportsllc.com
www.parkjets.com
www.parleecycles.com
www.pepperbridge.com
www.peterhajas.com
www.philhendrieshow.com
www.pintangle.com
www.pixelcorps.com
www.pizza-cottage.com
www.plp.org
www.pnlpaintball.com
www.poorbritney.com
www.praisefm.org
www.pricedigests.com
www.progressiveradionetwork.com
www.purlbee.com
www.radiuschurch.org
www.raisingwomensvoices.net
www.rakontur.com
www.redrockrunningcompany.com
www.roastdetroit.com
www.robbygordon.com
www.ryanchurch.com
www.salsasalsadancestudio.com
www.sandcastlemotel.net
www.santamonicapier.org
www.seabirdchronicles.com
www.seattleghost.com
www.secretsofparis.com
www.sleepingbeautysalon.com
www.smartbidnet.com
www.solaresystems.com
www.somekindofawesome.com
www.soshelli.com
www.soundmancaraudio.com
www.squarespace.com
www.squeezeofficial.com
www.ssekodesigns.com
www.staceyjay.com
www.steviesnacks.com
www.stircrazyblog.com
www.stuartwildeblog.com
www.sweetwaterisd.net
www.swg.com
www.swordandsworcery.com
www.swsmag.net
www.talkradionews.com
www.tasklighting.com
www.tasteontour.com
www.tavolinoristorante.com
www.teknicgear.com
www.textilesource.com
www.tgs.kent.sch.uk
www.thatcupoftea.com
www.thebible.com
www.thecubbyhole.com
www.thedieline.com
www.thekitchendesigner.org
www.thereseoflisieux.org
www.thumbcellular.com
www.tnimmigrant.org
www.tourofthebattenkill.com
www.traffic.org
www.trapcode.com
www.travelerslunchbox.com
www.tsalon.com
www.ucea.org
www.ultrabardc.com
www.undrcrwn.com
www.uswcc.org
www.vacher.com
www.valdostaconnect.com
www.valiantentertainment.com
www.vassagocycles.com
www.vectorunit.com
www.vervemag.com
www.victoryliner.com
www.warrguitars.com
www.washingtoncenter.org
www.webcomics.com
www.whataboutourdaughters.com
www.whiteoakschool.com
www.woollywormhead.com
www.yogaon6th.com
www.youthalive.org
www.zeroedgeaquarium.com
www.zootwoman.com
|

# Matches #
matches [

# Powered by text
{ :certainty=>75, :text=>"This site is completely powered by the Squarespace platform." },

# Default JavaScript
{ :text=>'new Squarespace.FixedPositionTip("Logout Successful", "You have been successfully logged out.", { xMargin: 15, yMargin: 15, icon: "/universal/images/helptip-info.png", orientation: "upper-right", viewportFixed: true, autoHide: 1800 }).show();' },

# favicon.ico
{ :url=>"favicon.ico", :md5=>"89cc5689b952ee12d13a68e98119183f" },

]

end


