/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.message;

import java.io.IOException;
import net.tinyos.message.Message;
import net.tinyos.message.SerialPacket;
import net.tinyos.packet.PhoenixSource;

public class Sender {
    private static final boolean VERBOSE = false;
    PhoenixSource sender;

    public Sender(PhoenixSource phoenixSource) {
        this.sender = phoenixSource;
    }

    public synchronized void send(int n, Message message) throws IOException {
        int n2 = message.amType();
        byte[] byArray = message.dataGet();
        if (n2 < 0) {
            throw new IOException("unknown AM type for message " + message.getClass().getName());
        }
        SerialPacket serialPacket = new SerialPacket(SerialPacket.offset_data(0) + byArray.length);
        serialPacket.set_header_dest(n);
        serialPacket.set_header_type((short)n2);
        serialPacket.set_header_length((short)byArray.length);
        serialPacket.dataSet(byArray, 0, SerialPacket.offset_data(0), byArray.length);
        byte[] byArray2 = serialPacket.dataGet();
        byte[] byArray3 = new byte[byArray2.length + 1];
        byArray3[0] = 0;
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        this.sender.writePacket(byArray3);
    }
}

