/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.parse.Atom;
import com.thaiopensource.xml.dtd.parse.AtomParser;
import com.thaiopensource.xml.dtd.parse.AtomStream;
import com.thaiopensource.xml.dtd.parse.Decl;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.Notation;
import com.thaiopensource.xml.dtd.parse.PrologParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DtdBuilder {
    private final Vector atoms;
    private final Vector decls = new Vector();
    private final Hashtable paramEntityTable = new Hashtable();
    private final Hashtable generalEntityTable = new Hashtable();
    private final Hashtable normalizedTable = new Hashtable();
    private final Hashtable notationTable = new Hashtable();
    private final Hashtable ambigNameTable = new Hashtable();

    DtdBuilder(Vector vector) {
        this.atoms = vector;
    }

    Vector getDecls() {
        return this.decls;
    }

    Entity lookupParamEntity(String string) {
        return (Entity)this.paramEntityTable.get(string);
    }

    Entity createParamEntity(String string) {
        Entity entity = new Entity(string, true);
        Entity entity2 = (Entity)this.paramEntityTable.get(string);
        if (entity2 != null) {
            while (entity2.overrides != null) {
                entity2 = entity2.overrides;
            }
            entity2.overrides = entity;
            entity.overridden = true;
        } else {
            this.paramEntityTable.put(string, entity);
        }
        return entity;
    }

    Entity lookupGeneralEntity(String string) {
        return (Entity)this.generalEntityTable.get(string);
    }

    Entity createGeneralEntity(String string) {
        Entity entity = new Entity(string, false);
        Entity entity2 = (Entity)this.generalEntityTable.get(string);
        if (entity2 != null) {
            while (entity2.overrides != null) {
                entity2 = entity2.overrides;
            }
            entity2.overrides = entity;
            entity.overridden = true;
        } else {
            this.generalEntityTable.put(string, entity);
        }
        return entity;
    }

    Notation lookupNotation(String string) {
        return (Notation)this.notationTable.get(string);
    }

    Notation createNotation(String string) {
        Notation notation = (Notation)this.notationTable.get(string);
        if (notation != null) {
            return null;
        }
        notation = new Notation(string);
        this.notationTable.put(string, notation);
        return notation;
    }

    void unexpandEntities() {
        Enumeration enumeration = this.paramEntityTable.elements();
        while (enumeration.hasMoreElements()) {
            ((Entity)enumeration.nextElement()).unexpandEntities();
        }
    }

    void createDecls() {
        new AtomParser(this, new AtomStream(this.atoms), new PrologParser(1), this.decls).parse();
    }

    void analyzeSemantics() {
        Enumeration enumeration = this.paramEntityTable.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            String string = entity.ambiguousNameSpec();
            if (string == null) continue;
            Entity entity2 = (Entity)this.ambigNameTable.get(string);
            if (entity2 != null) {
                entity2.maybeNameSpec = false;
                entity.maybeNameSpec = false;
                continue;
            }
            this.ambigNameTable.put(string, entity);
        }
        Decl.examineElementNames(this, this.decls.elements());
        enumeration = this.paramEntityTable.elements();
        while (enumeration.hasMoreElements()) {
            ((Entity)enumeration.nextElement()).analyzeSemantic();
        }
    }

    void noteElementName(String string, Entity entity) {
        Entity entity2 = (Entity)this.ambigNameTable.get(string);
        if (entity2 != null && entity2 != entity) {
            entity2.maybeNameSpec = false;
        }
    }

    Vector createTopLevel() {
        return Decl.declsToTopLevel(this, this.decls.elements());
    }

    void dump() {
        DtdBuilder.dumpEntity("#doc", this.atoms);
    }

    private static void dumpEntity(String string, Vector vector) {
        System.out.println("<e name=\"" + string + "\">");
        DtdBuilder.dumpAtoms(vector);
        System.out.println("</e>");
    }

    private static void dumpAtoms(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Atom atom = (Atom)vector.elementAt(i);
            Entity entity = atom.getEntity();
            if (entity != null) {
                DtdBuilder.dumpEntity(entity.name, entity.atoms);
                continue;
            }
            if (atom.getTokenType() == 18) continue;
            System.out.print("<t>");
            DtdBuilder.dumpString(atom.getToken());
            System.out.println("</t>");
        }
    }

    private static void dumpString(String string) {
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    System.out.print("&lt;");
                    continue block5;
                }
                case '>': {
                    System.out.print("&gt;");
                    continue block5;
                }
                case '&': {
                    System.out.print("&amp;");
                    continue block5;
                }
                default: {
                    System.out.print(string.charAt(i));
                }
            }
        }
    }

    void setNormalized(String string, String string2) {
        this.normalizedTable.put(string, string2);
    }

    String getNormalized(String string) {
        return (String)this.normalizedTable.get(string);
    }
}

