# Changelog

All notable changes to this project will be documented in this file.

## [0.3.2] - 2025-10-08

### 🚀 Features

- Support `emit_result` for `try_fn_stream` (#16)

## [0.3.1] - 2025-09-30

### 🐛 Bug Fixes

- Restore Send and Sync for streams (#13)
- Add missing auto-traits

### 📚 Documentation

- Fix intra-doc links

### ⚡ Performance

- Don't use mutex (#12)

## [0.3.0] - 2025-09-05

### 🚀 Features

- [**breaking**] The yielding is done in CollectFuture instead of `.emit()`
- Support internal concurrency within async stream closures
- Improve support for concurrency (#9)

### 🐛 Bug Fixes

- Call Waker from CollectFuture

### 🚜 Refactor

- Move synchronization logic to CollectFuture
- Don't clear waker in CollectFuture
- [**breaking**] Rename all instances of `Collect` to `Emit` (#10)

### 📚 Documentation

- Document concurrency support

### ⚡ Performance

- Avoid cloning Wakers when possible

### 🧪 Testing

- Add tests for structured concurrency

### ⚙️ Miscellaneous Tasks

- Enable clippy pedantic lints (#8)
- Fix lints
- Add a couple of benchmarks

## [0.2.2] - 2024-04-23

### 🚀 Features

- Implement emit_err for try_fn_stream

### 🚜 Refactor

- Use internal_emit instead of duplicate code

### 📚 Documentation

- Improve documentation and some panic messages

### 🧪 Testing

- Add test for emit_err

### ⚙️ Miscellaneous Tasks

- Bump version

## [0.2.1] - 2024-04-18

### 🚜 Refactor

- Replace futures by futures-util and futures-executor

### 📚 Documentation

- Replace futures by futures-util

### 🧪 Testing

- Remove unnecessary import

## [0.1.0] - 2022-07-07

<!-- generated by git-cliff -->
