# Advice to sites regarding `preferred` user verification

The default value for [user verification](https://www.w3.org/TR/webauthn/#enumdef-userverificationrequirement) in [Web Authentication](https://www.w3.org/TR/webauthn/)'s [create](https://www.w3.org/TR/webauthn/#createCredential) and [get](https://www.w3.org/TR/webauthn/#getAssertion) calls is `preferred`. The semantics of this have been surprising to several sites and so, if no value is provided, Blink will emit a warning in the Javascript console. This warning can be silenced by explicitly setting any valid value for `userVerification`. For a `create` call, this requires setting a value for publicKey.[authenticatorSelection](https://www.w3.org/TR/webauthn/#authenticatorSelection).[userVerification](https://www.w3.org/TR/webauthn/#dom-authenticatorselectioncriteria-userverification) and, for a `get` call, setting publicKey.[userVerification](https://www.w3.org/TR/webauthn/#dom-publickeycredentialrequestoptions-userverification). The valid values are enumerated as [UserVerificationRequirement](https://www.w3.org/TR/webauthn/#enumdef-userverificationrequirement).

The default, `preferred` value instructs the user-agent to acquire [user verification](https://www.w3.org/TR/webauthn/#user-verification) &ldquo;[if possible](https://www.w3.org/TR/webauthn/#dom-userverificationrequirement-preferred)&rdquo;. On modern versions of Windows this is interpreted such that a user will be prompted to configure a PIN during credential creation on an authenticator that supports it, and such that a user will be prompted for a PIN if one is already set. On other platforms, Chrome will not direct the user to create a PIN if one is not already set, but will be prompt for a PIN if one is configured. This is quite different from the traditional user experience of security keys.

The traditional user experience is best replicated by setting `userVerification` to `discouraged`. This does not preclude the [UV flag](https://www.w3.org/TR/webauthn/#flags) being set in a signature because some authenticators may always do user verification. (For example, a built-in fingerprint reader.) But it will prevent PIN prompts from appearing.

Sites that desire user verification should set `userVerification` to `required` to indicate this. This will, however, limit users to authenticators that support some form of user verification and many do not.

There is not currently a way in WebAuthn to express that a site would like user verification if it's low-cost for the user so that later reauthentication may use WebAuthn rather than a password.
