# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MediaLiveEventIngestHeartbeatEventData(Model):
    """Ingest fragment dropped event data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar track_name: Gets the track name.
    :vartype track_name: str
    :ivar bitrate: Gets the bitrate of the track.
    :vartype bitrate: long
    :ivar incoming_bitrate: Gets the incoming bitrate.
    :vartype incoming_bitrate: long
    :ivar last_timestamp: Gets the last timestamp.
    :vartype last_timestamp: str
    :ivar timescale: Gets the timescale of the last timestamp.
    :vartype timescale: str
    :ivar overlap_count: Gets the fragment Overlap count.
    :vartype overlap_count: long
    :ivar discontinuity_count: Gets the fragment Discontinuity count.
    :vartype discontinuity_count: long
    :ivar nonincreasing_count: Gets Non increasing count.
    :vartype nonincreasing_count: long
    :ivar unexpected_bitrate: Gets a value indicating whether unexpected
     bitrate is present or not.
    :vartype unexpected_bitrate: bool
    :ivar state: Gets the state of the live event.
    :vartype state: str
    :ivar healthy: Gets a value indicating whether preview is healthy or not.
    :vartype healthy: bool
    """

    _validation = {
        'track_type': {'readonly': True},
        'track_name': {'readonly': True},
        'bitrate': {'readonly': True},
        'incoming_bitrate': {'readonly': True},
        'last_timestamp': {'readonly': True},
        'timescale': {'readonly': True},
        'overlap_count': {'readonly': True},
        'discontinuity_count': {'readonly': True},
        'nonincreasing_count': {'readonly': True},
        'unexpected_bitrate': {'readonly': True},
        'state': {'readonly': True},
        'healthy': {'readonly': True},
    }

    _attribute_map = {
        'track_type': {'key': 'trackType', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'incoming_bitrate': {'key': 'incomingBitrate', 'type': 'long'},
        'last_timestamp': {'key': 'lastTimestamp', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
        'overlap_count': {'key': 'overlapCount', 'type': 'long'},
        'discontinuity_count': {'key': 'discontinuityCount', 'type': 'long'},
        'nonincreasing_count': {'key': 'nonincreasingCount', 'type': 'long'},
        'unexpected_bitrate': {'key': 'unexpectedBitrate', 'type': 'bool'},
        'state': {'key': 'state', 'type': 'str'},
        'healthy': {'key': 'healthy', 'type': 'bool'},
    }

    def __init__(self, **kwargs) -> None:
        super(MediaLiveEventIngestHeartbeatEventData, self).__init__(**kwargs)
        self.track_type = None
        self.track_name = None
        self.bitrate = None
        self.incoming_bitrate = None
        self.last_timestamp = None
        self.timescale = None
        self.overlap_count = None
        self.discontinuity_count = None
        self.nonincreasing_count = None
        self.unexpected_bitrate = None
        self.state = None
        self.healthy = None
