###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_subversion_binary_delta_parssing_vuln.nasl 3867 2009-08-19 15:50:22Z aug $
#
# Subversion Binary Delta Processing Multiple Integer Overflow Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101104);
  script_version("$ Revision:1.0 $");
  script_tag(name:"cvss_base", value:"8.5");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2411");
  script_bugtraq_id(35983);
  script_name("Subversion Binary Delta Processing Multiple Integer Overflow Vulnerabilities");
  desc = "

  Overview: The host is installed with Subversion and is prone to
  multiple Integer Overflow Vulnerabilities.

  Vulnerability Insight:
  The flaws are due to input validation errors in the processing of svndiff
  streams in the 'libsvn_delta' library.

  Impact:
  Attackers can exploit these issues to compromise an application using the library
  or crash the application, resulting into a denial of service conditions.

  Impact Level: Application

  Affected Software/OS:
  Subversion version 1.5.6 and prior
  Subversion version 1.6.0 through 1.6.3

  Fix: Apply the patch or Upgrade to Subversion version 1.5.7 or 1.6.4
  http://subversion.tigris.org/security/CVE-2009-2411-advisory.txt
  http://subversion.tigris.org/project_packages.html

  *****
  NOTE: Please ignore this warning if the patch is applied.
  *****

  References:
  http://secunia.com/advisories/36184/
  http://securitytracker.com/alerts/2009/Aug/1022697.html
  http://subversion.tigris.org/security/CVE-2009-2411-advisory.txt

  CVSS Score:
   CVSS Base Score       : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
   CVSS Temporal Score   : 6.3
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Subversion");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_subversion_detect.nasl");
  script_require_keys("Subversion/Ver");
  exit(0);
}


include("version_func.inc");

svnVer = get_kb_item("Subversion/Ver");
if(svnVer != NULL)
{
  if(version_is_less(version:svnVer, test_version:"1.5.7")||
     version_in_range(version:svnVer, test_version:"1.6",test_version2:"1.6.3")){
     security_hole(0);
  }
}
