###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_mult_vuln_dec08_lin.nasl 736 2008-12-22 17:43:12Z dec $
#
# Opera Web Browser Multiple Vulnerabilities - Dec08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900082);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5679", "CVE-2008-5680", "CVE-2008-5681",
                "CVE-2008-5682", "CVE-2008-5683");
  script_bugtraq_id(32864);
  script_name("Opera Web Browser Multiple Vulnerabilities - Dec08 (Linux)");
  desc = "

  Overview: The host is installed with Opera web browser and is prone to
  multiple Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to,
  - a buffer overflow error when handling certain text-area contents.
  - a memory corruption error when processing certain HTML constructs.
  - an input validation error in the feed preview feature when processing URLs.
  - an error in the built-in XSLT templates that incorrectly handle escaped
    content.
  - an error which could be exploited to reveal random data.
  - an error when processing SVG images embedded using img tags.

  Impact:
  Successful remote attack could inject arbitrary code, information disclosure,
  execute java or plugin content and can even crash the application.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 9.63 on Linux.

  Fix: Upgrade to Opera 9.63
  http://www.opera.com/download/

  References:
  http://www.opera.com/support/kb/view/920/
  http://www.opera.com/support/kb/view/921/
  http://www.opera.com/support/kb/view/923/
  http://www.opera.com/support/kb/view/924/
  http://www.opera.com/docs/changelogs/linux/963/

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less(version:operaVer, test_version:"9.63")){
  security_hole(0);
}
