###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ftpshell_client_pasv_bof_vuln.nasl 5061 2009-09-30 16:18:42Z sep $
#
# FTPShell Client PASV Command Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900962);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3364");
  script_bugtraq_id(36327);
  script_name("FTPShell Client PASV Command Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is running FTPShell Client and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A buffer overflow error occurs due to improper bounds checking when handling
  overly long PASV messages sent by the server.

  Impact:
  Successful exploitation will let the user execute arbitrary code and crash
  the application to cause denial of service.

  Affected Software/OS:
  FTPShell Client 4.1 RC2 and prior.

  Fix: No solution or patch is available as on 30th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.ftpshell.com/

  References:
  http://secunia.com/advisories/36628
  http://www.milw0rm.com/exploits/9613
  http://xforce.iss.net/xforce/xfdb/53126

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of FTPShell Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_ftpshell_client_detect.nasl");
  script_require_keys("FTPShell/Client/Ver");
  exit(0);
}


include("version_func.inc");

shellVer = get_kb_item("FTPShell/Client/Ver");
if(isnull(shellVer)){
  exit(0);
}

if(version_is_less_equal(version:shellVer, test_version:"4.1.RC2")){
  security_hole(0);
}
