###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_elecard_avchd_player_detect.nasl 1870 2009-04-28 09:07:05Z apr $
#
# Elecard AVC HD Player Application Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900628);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Elecard AVC HD Player Version Detection");
  desc = "

  Overview: The script detects the Elecard AVC HD Player installed on
  host and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of Elecard AVC HD Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

avcVer = registry_get_sz(key:"SOFTWARE\Elecard\Packages\Elecard AVC HD Player",
                         item:"Version");
if(avcVer){
   set_kb_item(name:"Elecard/AVC/HD/Ver", value:avcVer);
   security_note(data:"Elecard AVC HD Player version " + avcVer +
                                                  " was detected on the host");
}
