###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for Sun GigaSwift Ethernet 1.0 driver 118777-14
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855636);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "SUNSolve", value: "118777-14");
  script_name("Solaris Update for Sun GigaSwift Ethernet 1.0 driver 118777-14");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  Sun GigaSwift Ethernet 1.0 driver
  For more information please visit the below reference link.

  Affected Software/OS:
  Sun GigaSwift Ethernet 1.0 driver on solaris_5.10_sparc

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-118777-14-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Sun GigaSwift Ethernet 1.0 driver");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"sparc", patch:"118777-14", package:"SUNWcedu SUNWced.u SUNWcea SUNWced.v SUNWced.us") < 0)
{
  security_hole(0);
  exit(0);
}