###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_qtweb_js_n_data_uri_xss_vuln.nasl 4413 2009-09-07 11:09:26Z sep $
#
# QtWeb 'javascript:' And 'data:' URI XSS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800899);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3018");
  script_name("QtWeb 'javascript:' And 'data:' URI XSS Vulnerability");
  desc = "
  Overview: This host is installed with QtWeb Browser and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to sanitise the 'javascript:' and 'data:'
  URIs in Refresh headers or Location headers in HTTP responses, which can be
  exploited via vectors related to injecting a Refresh header or Location HTTP
  response header.

  Impact:
  Successful exploitation will let the attackers to conduct Cross-Site Scripting
  attacks in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  QtWeb version 3.0.0.145 on Windows.

  Fix: Upgrade to QtWeb version 3.2 or later
  For updates refer, http://www.qtweb.net/

  References:
  http://websecurity.com.ua/3386/
  http://xforce.iss.net/xforce/xfdb/52993

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of QtWeb");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_qtweb_detect.nasl");
  script_require_keys("QtWeb/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

# Get for QtWeb Browser
qtwebVer = get_kb_item("QtWeb/Ver");

if(qtwebVer)
{
  # Check for QtWeb Browser Version 3.0 Build 003/001 (3.0.0.3/3 3.0.0.1)
  if(version_is_equal(version:qtwebVer, test_version:"3.0.0.3")||
     version_is_equal(version:qtwebVer, test_version:"3.0.0.1")){
    security_warning(0);
  }
}
