###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Tomcat HPSBUX00249
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835152);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00249");
  script_cve_id("CAN-2003-0042", "CAN-2003-0043", "CAN-2003-0044");
  script_name( "HP-UX Update for Tomcat HPSBUX00249");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running HP 
  Tomcat v 3.3.1. This vulnerability may allow a remote user to gain 
  unauthorized access or execution of arbitrary code. 

  Impact:
  Remote unauthorized access or execution of arbitrary code.

  Affected Software/OS:
  Tomcat on
  HP-UX B.11.00, B.11.11, B.11.22 and B.11.23 running HP Tomcat version 3.3.1 
  or prior versions. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00943079-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Tomcat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.TOMCAT", revision:"3.3.1a", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.TOMCAT", revision:"3.3.1a", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.TOMCAT", revision:"3.3.1a", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.TOMCAT", revision:"3.3.1a", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"A.1.0.10.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT2", revision:"A.1.0.10.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}