#
#VID b1bcab7d-1880-11dd-a914-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60950);
 script_cve_id("CVE-2007-6697", "CVE-2008-0544");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: sdl_image";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: sdl_image

CVE-2007-6697
Buffer overflow in the LWZReadByte function in IMG_gif.c in SDL_image
before 1.2.7 allows remote attackers to cause a denial of service
(application crash) or possibly execute arbitrary code via a crafted
GIF file, a similar issue to CVE-2006-4484.  NOTE: some of these
details are obtained from third party information.

CVE-2008-0544
Heap-based buffer overflow in the IMG_LoadLBM_RW function in IMG_lbm.c
in SDL_image before 1.2.7 allows remote attackers to cause a denial of
service (application crash) or possibly execute arbitrary code via a
crafted IFF ILBM file.  NOTE: some of these details are obtained from
third party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/28640
http://www.vuxml.org/freebsd/b1bcab7d-1880-11dd-a914-0016179b2dd5.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: sdl_image";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sdl_image");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.6_1")<0) {
    security_note(0, data:"Package sdl_image version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
