#
#VID 1b3f854b-e4bd-11de-b276-000d8787e1be
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 1b3f854b-e4bd-11de-b276-000d8787e1be
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66614);
 script_cve_id("CVE-2009-3111");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("FreeBSD Ports: freeradius");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: freeradius

CVE-2009-3111
The rad_decode function in FreeRADIUS before 1.1.8 allows remote
attackers to cause a denial of service (radiusd crash) via zero-length
Tunnel-Password attributes.  NOTE: this is a regression error related
to CVE-2003-0967.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2009-3111
http://freeradius.org/security.html
http://www.milw0rm.com/exploits/9642
http://www.vuxml.org/freebsd/1b3f854b-e4bd-11de-b276-000d8787e1be.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: freeradius");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"freeradius");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.8")<0) {
    security_note(0, data:"Package freeradius version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
