# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1282-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58334);
 script_cve_id("CVE-2007-1286", "CVE-2007-1380", "CVE-2007-1521", "CVE-2007-1711", "CVE-2007-1718", "CVE-2007-1777");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1282-1 (php4)";
 script_name(name);

 desc = "The remote host is missing an update to php4
announced via advisory DSA 1282-1.

Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2007-1286
Stefan Esser discovered an overflow in the object reference handling
code of the unserialize() function, which allows the execution of
arbitrary code if malformed input is passed from an application.

CVE-2007-1380
Stefan Esser discovered that the session handler performs
insufficient validation of variable name length values, which allows
information disclosure through a heap information leak.

CVE-2007-1521
Stefan Esser discovered a double free vulnerability in the
session_regenerate_id() function, which allows the execution of
arbitrary code.

CVE-2007-1711
Stefan Esser discovered a double free vulnerability in the session
management code, which allows the execution of arbitrary code.

CVE-2007-1718
Stefan Esser discovered that the mail() function performs
insufficient validation of folded mail headers, which allows mail
header injection.

CVE-2007-1777
Stefan Esser discovered that the extension to handle ZIP archives
performs insufficient length checks, which allows the execution of
arbitrary code.

For the oldstable distribution (sarge) these problems have been fixed in
version 4.3.10-20.

For the stable distribution (etch) these problems have been fixed
in version 4.4.4-8+etch2.

For the unstable distribution (sid) these problems have been fixed in
version 4.4.6-1. php4 will be removed from sid; thus you are strongly
advised to migrate to php5 if you prefer to follow the unstable
distribution.

We recommend that you upgrade your PHP packages. Packages for the arm,

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201282-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1282-1 (php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-pear", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php4", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php4", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cli", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-common", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.3.10-20", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pear", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php4", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php4", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cli", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-common", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcrypt", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pgsql", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pspell", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-interbase", ver:"4.4.4-8+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
