# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1268-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58320);
 script_cve_id("CVE-2007-0002");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1268-1 (libwpd)";
 script_name(name);

 desc = "The remote host is missing an update to libwpd
announced via advisory DSA 1268-1.

iDefense reported several integer overflow bugs in libwpd, a library
for handling WordPerfect documents.  Attackers were able to exploit
these with carefully crafted Word Perfect files that could cause an
application linked with libwpd to crash or possibly execute arbitrary.

For the stable distribution (sarge) these problems have been fixed in
version 0.8.1-1sarge1.

For the testing distribution (etch) these problems have been fixed in
version 0.8.7-6.

For the unstable distribution (sid) these problems have been fixed in
version 0.8.7-6.

We recommend that you upgrade your libwpd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201268-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1268-1 (libwpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libwpd8-doc", ver:"0.8.1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd-stream8", ver:"0.8.1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd-tools", ver:"0.8.1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd8", ver:"0.8.1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd8-dev", ver:"0.8.1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd8-doc", ver:"0.8.7-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd-stream8c2a", ver:"0.8.7-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd-tools", ver:"0.8.7-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd8-dev", ver:"0.8.7-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwpd8c2a", ver:"0.8.7-6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
