# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1205-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57684);
 script_cve_id("CVE-2006-4248");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1205-2 (thttpd)";
 script_name(name);

 desc = "The remote host is missing an update to thttpd
announced via advisory DSA 1205-2.

Marco d'Itri discovered that thttpd, a small, fast and secure webserver,
makes use of insecure temporary files when its logfiles are rotated,
which might lead to a denial of service through a symlink attack.

The original advisory for this issue didn't contain fixed packages for all
supported architectures which are corrected in this update.

For the stable distribution (sarge) this problem has been fixed in
version 2.23beta1-3sarge2

For the unstable distribution (sid) this problem has been fixed in
version 2.23beta1-5

We recommend that you upgrade your thttpd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201205-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1205-2 (thttpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"thttpd", ver:"2.23beta1-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thttpd-util", ver:"2.23beta1-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
