'use strict';

/**
 * Module dependenices
 */

var isObject = require('is-plain-object');
var clone = require('shallow-clone');
var typeOf = require('kind-of');
var forOwn = require('for-own');

/**
 * Recursively clone native types.
 */

function cloneDeep(val, instanceClone) {
  switch (typeOf(val)) {
    case 'object':
      return cloneObjectDeep(val, instanceClone);
    case 'array':
      return cloneArrayDeep(val, instanceClone);
    default: {
      return clone(val);
    }
  }
}

function cloneObjectDeep(obj, instanceClone) {
  if (isObject(obj) || (instanceClone === true && typeOf(obj) === 'object')) {
    var res = {};
    forOwn(obj, function(val, key) {
      this[key] = cloneDeep(val, instanceClone);
    }, res);
    return res;
  }
  if (typeof instanceClone === 'function') {
    return instanceClone(obj);
  }
  return obj;
}

function cloneArrayDeep(arr, instanceClone) {
  var res = [];
  for (var i = 0; i < arr.length; i++) {
    res[i] = cloneDeep(arr[i], instanceClone);
  }
  return res;
}

/**
 * Expose `cloneDeep`
 */

module.exports = cloneDeep;
