/*
 * Copyright (C) 2025 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2025 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 08 апр. 2016 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_FLETCHER_MUNSON_H_
#define GENERATED_ISO226_FLETCHER_MUNSON_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const int16_t fletcher_munson_curve_0_phons[1383] =
    {
        -2383, -2387, -2389, -2396, -2403,
        -2413, -2417, -2426, -2429, -2440, -2446, -2454, -2460, -2467, -2472,
        -2483, -2488, -2492, -2497, -2501, -2511, -2515, -2521, -2531, -2537,
        -2542, -2547, -2552, -2556, -2567, -2579, -2590, -2599, -2609, -2619,
        -2621, -2630, -2636, -2644, -2651, -2659, -2665, -2673, -2684, -2683,
        -2688, -2706, -2709, -2715, -2717, -2726, -2735, -2739, -2746, -2751,
        -2756, -2763, -2768, -2776, -2786, -2788, -2798, -2798, -2804, -2808,
        -2813, -2819, -2825, -2836, -2838, -2848, -2854, -2859, -2869, -2875,
        -2882, -2894, -2896, -2906, -2918, -2917, -2926, -2935, -2945, -2955,
        -2954, -2964, -2973, -2980, -2985, -2989, -2994, -2998, -3004, -3007,
        -3017, -3018, -3028, -3033, -3038, -3044, -3049, -3056, -3065, -3073,
        -3076, -3088, -3096, -3100, -3110, -3114, -3121, -3131, -3133, -3142,
        -3152, -3154, -3160, -3168, -3178, -3177, -3185, -3197, -3199, -3214,
        -3227, -3232, -3240, -3254, -3267, -3271, -3281, -3286, -3291, -3297,
        -3303, -3309, -3314, -3319, -3325, -3333, -3336, -3346, -3351, -3355,
        -3362, -3369, -3376, -3386, -3397, -3410, -3417, -3424, -3435, -3443,
        -3452, -3461, -3466, -3477, -3479, -3490, -3501, -3511, -3519, -3529,
        -3533, -3537, -3542, -3552, -3559, -3566, -3574, -3580, -3590, -3601,
        -3609, -3617, -3621, -3630, -3639, -3646, -3656, -3665, -3663, -3669,
        -3677, -3686, -3688, -3698, -3710, -3720, -3727, -3734, -3747, -3761,
        -3765, -3778, -3790, -3803, -3815, -3826, -3838, -3851, -3861, -3871,
        -3880, -3886, -3890, -3899, -3907, -3909, -3916, -3925, -3931, -3930,
        -3937, -3946, -3956, -3956, -3969, -3982, -3992, -3995, -4001, -4007,
        -4013, -4022, -4031, -4043, -4050, -4061, -4067, -4078, -4088, -4096,
        -4108, -4119, -4125, -4135, -4148, -4158, -4174, -4184, -4195, -4206,
        -4217, -4228, -4239, -4250, -4261, -4271, -4282, -4292, -4304, -4317,
        -4326, -4337, -4347, -4348, -4356, -4366, -4367, -4376, -4387, -4398,
        -4409, -4419, -4431, -4443, -4454, -4465, -4477, -4489, -4500, -4510,
        -4514, -4520, -4532, -4542, -4542, -4552, -4563, -4575, -4587, -4597,
        -4606, -4620, -4630, -4639, -4646, -4653, -4660, -4669, -4681, -4691,
        -4702, -4712, -4717, -4728, -4737, -4747, -4756, -4761, -4767, -4776,
        -4776, -4780, -4787, -4793, -4804, -4815, -4826, -4836, -4842, -4854,
        -4863, -4863, -4870, -4875, -4873, -4883, -4891, -4887, -4894, -4904,
        -4913, -4916, -4928, -4942, -4953, -4967, -4980, -4986, -4993, -5000,
        -5012, -5018, -5023, -5038, -5044, -5050, -5061, -5068, -5076, -5089,
        -5095, -5099, -5103, -5112, -5117, -5122, -5130, -5142, -5150, -5158,
        -5163, -5174, -5183, -5194, -5203, -5213, -5218, -5228, -5238, -5250,
        -5263, -5273, -5283, -5293, -5304, -5315, -5327, -5337, -5347, -5357,
        -5367, -5380, -5390, -5400, -5410, -5422, -5432, -5442, -5455, -5467,
        -5478, -5488, -5498, -5508, -5508, -5518, -5528, -5537, -5537, -5547,
        -5557, -5568, -5579, -5590, -5602, -5612, -5624, -5633, -5638, -5647,
        -5646, -5655, -5660, -5660, -5674, -5681, -5687, -5693, -5699, -5703,
        -5713, -5728, -5740, -5750, -5756, -5766, -5776, -5782, -5782, -5791,
        -5798, -5806, -5815, -5822, -5832, -5843, -5854, -5865, -5876, -5887,
        -5897, -5907, -5918, -5929, -5940, -5952, -5962, -5961, -5971, -5979,
        -5982, -5991, -6001, -6011, -6014, -6022, -6028, -6038, -6049, -6062,
        -6074, -6088, -6102, -6115, -6125, -6135, -6142, -6152, -6162, -6171,
        -6180, -6190, -6200, -6210, -6220, -6231, -6243, -6255, -6270, -6279,
        -6291, -6302, -6312, -6322, -6328, -6335, -6348, -6355, -6361, -6372,
        -6384, -6391, -6401, -6412, -6421, -6429, -6440, -6448, -6459, -6470,
        -6481, -6490, -6499, -6509, -6518, -6527, -6536, -6545, -6554, -6563,
        -6571, -6580, -6588, -6598, -6608, -6616, -6625, -6632, -6639, -6644,
        -6641, -6648, -6654, -6660, -6668, -6669, -6670, -6677, -6686, -6695,
        -6702, -6711, -6720, -6728, -6738, -6748, -6757, -6765, -6772, -6780,
        -6789, -6798, -6808, -6816, -6823, -6830, -6837, -6844, -6850, -6859,
        -6863, -6867, -6877, -6884, -6893, -6900, -6909, -6920, -6932, -6944,
        -6955, -6965, -6974, -6984, -6992, -6999, -7007, -7015, -7022, -7029,
        -7036, -7046, -7054, -7060, -7067, -7075, -7084, -7094, -7105, -7116,
        -7126, -7137, -7147, -7158, -7169, -7181, -7192, -7201, -7211, -7218,
        -7227, -7238, -7247, -7254, -7261, -7271, -7279, -7288, -7296, -7304,
        -7313, -7323, -7332, -7339, -7348, -7358, -7368, -7378, -7389, -7401,
        -7410, -7419, -7429, -7439, -7444, -7449, -7456, -7465, -7472, -7478,
        -7485, -7496, -7507, -7518, -7529, -7540, -7549, -7556, -7564, -7571,
        -7581, -7590, -7600, -7609, -7618, -7624, -7631, -7639, -7647, -7655,
        -7663, -7669, -7677, -7685, -7694, -7700, -7707, -7713, -7723, -7731,
        -7737, -7742, -7750, -7757, -7763, -7770, -7779, -7785, -7792, -7798,
        -7807, -7815, -7820, -7826, -7835, -7843, -7850, -7855, -7863, -7876,
        -7885, -7892, -7897, -7904, -7915, -7925, -7930, -7934, -7942, -7950,
        -7960, -7969, -7974, -7982, -7989, -7996, -8001, -8006, -8010, -8015,
        -8020, -8026, -8033, -8039, -8045, -8052, -8058, -8063, -8071, -8077,
        -8086, -8093, -8100, -8104, -8112, -8117, -8125, -8133, -8138, -8146,
        -8147, -8148, -8156, -8157, -8164, -8174, -8183, -8190, -8197, -8204,
        -8204, -8211, -8213, -8215, -8223, -8225, -8233, -8236, -8243, -8251,
        -8257, -8266, -8267, -8275, -8276, -8277, -8276, -8276, -8276, -8279,
        -8278, -8278, -8280, -8283, -8287, -8291, -8294, -8300, -8301, -8301,
        -8309, -8313, -8318, -8321, -8321, -8325, -8333, -8338, -8338, -8338,
        -8338, -8338, -8337, -8337, -8337, -8336, -8336, -8336, -8336, -8336,
        -8336, -8336, -8336, -8336, -8336, -8336, -8336, -8334, -8327, -8325,
        -8318, -8318, -8312, -8312, -8312, -8311, -8311, -8310, -8310, -8310,
        -8310, -8311, -8315, -8315, -8315, -8314, -8309, -8304, -8303, -8295,
        -8291, -8287, -8281, -8279, -8280, -8278, -8276, -8276, -8270, -8268,
        -8268, -8268, -8268, -8268, -8269, -8269, -8269, -8260, -8258, -8258,
        -8258, -8248, -8248, -8248, -8248, -8248, -8248, -8247, -8247, -8247,
        -8247, -8242, -8237, -8236, -8227, -8226, -8227, -8227, -8234, -8236,
        -8243, -8244, -8244, -8244, -8244, -8244, -8244, -8245, -8245, -8246,
        -8255, -8250, -8250, -8259, -8255, -8255, -8260, -8260, -8260, -8261,
        -8266, -8269, -8271, -8271, -8270, -8269, -8268, -8271, -8273, -8270,
        -8271, -8273, -8276, -8280, -8278, -8275, -8277, -8274, -8272, -8278,
        -8280, -8288, -8291, -8296, -8298, -8305, -8306, -8314, -8314, -8320,
        -8322, -8322, -8330, -8326, -8322, -8324, -8328, -8337, -8337, -8341,
        -8346, -8346, -8353, -8346, -8353, -8355, -8358, -8355, -8362, -8362,
        -8371, -8371, -8374, -8380, -8380, -8382, -8378, -8382, -8385, -8386,
        -8391, -8395, -8403, -8405, -8404, -8406, -8412, -8417, -8416, -8419,
        -8423, -8428, -8434, -8438, -8443, -8441, -8444, -8448, -8459, -8464,
        -8471, -8475, -8481, -8487, -8490, -8492, -8489, -8497, -8491, -8497,
        -8495, -8496, -8500, -8497, -8501, -8497, -8502, -8506, -8513, -8516,
        -8525, -8527, -8535, -8539, -8544, -8544, -8544, -8551, -8547, -8552,
        -8558, -8566, -8570, -8574, -8581, -8583, -8581, -8577, -8581, -8580,
        -8588, -8591, -8592, -8597, -8599, -8599, -8601, -8604, -8604, -8611,
        -8613, -8613, -8616, -8616, -8619, -8625, -8634, -8639, -8640, -8639,
        -8637, -8635, -8630, -8632, -8628, -8631, -8631, -8633, -8641, -8640,
        -8644, -8645, -8646, -8641, -8638, -8639, -8631, -8624, -8630, -8627,
        -8624, -8623, -8619, -8613, -8613, -8615, -8614, -8621, -8617, -8622,
        -8625, -8622, -8622, -8617, -8611, -8612, -8606, -8604, -8602, -8598,
        -8596, -8596, -8597, -8595, -8594, -8592, -8589, -8589, -8586, -8582,
        -8582, -8578, -8572, -8571, -8562, -8557, -8551, -8546, -8546, -8546,
        -8546, -8546, -8546, -8545, -8535, -8535, -8535, -8520, -8516, -8510,
        -8504, -8501, -8501, -8501, -8501, -8501, -8501, -8501, -8501, -8500,
        -8488, -8481, -8478, -8468, -8461, -8455, -8451, -8450, -8443, -8446,
        -8445, -8445, -8445, -8441, -8440, -8440, -8440, -8440, -8435, -8434,
        -8432, -8431, -8430, -8427, -8426, -8421, -8418, -8415, -8413, -8412,
        -8407, -8403, -8400, -8402, -8407, -8406, -8405, -8402, -8408, -8413,
        -8410, -8410, -8405, -8408, -8408, -8413, -8414, -8415, -8412, -8406,
        -8406, -8411, -8416, -8419, -8423, -8426, -8426, -8438, -8435, -8435,
        -8435, -8434, -8442, -8439, -8443, -8451, -8449, -8451, -8457, -8474,
        -8483, -8482, -8490, -8496, -8502, -8518, -8527, -8524, -8527, -8539,
        -8539, -8533, -8531, -8537, -8547, -8554, -8555, -8556, -8567, -8578,
        -8588, -8590, -8591, -8598, -8604, -8602, -8596, -8599, -8600, -8603,
        -8609, -8603, -8604, -8605, -8632, -8627, -8623, -8622, -8655, -8657,
        -8659, -8660, -8661, -8665, -8669, -8667, -8659, -8660, -8664, -8664,
        -8664, -8666, -8661, -8657, -8652, -8652, -8651, -8643, -8642, -8644,
        -8642, -8635, -8631, -8624, -8621, -8617, -8614, -8610, -8602, -8599,
        -8591, -8589, -8589, -8591, -8591, -8584, -8582, -8579, -8578, -8574,
        -8579, -8580, -8575, -8569, -8568, -8564, -8565, -8568, -8562, -8558,
        -8557, -8555, -8551, -8543, -8547, -8539, -8541, -8542, -8542, -8542,
        -8541, -8540, -8536, -8531, -8527, -8524, -8524, -8523, -8518, -8514,
        -8509, -8514, -8515, -8518, -8526, -8526, -8526, -8526, -8525, -8525,
        -8519, -8519, -8514, -8514, -8515, -8515, -8517, -8517, -8518, -8517,
        -8519, -8520, -8522, -8525, -8526, -8527, -8527, -8525, -8525, -8524,
        -8523, -8522, -8522, -8520, -8520, -8518, -8515, -8515, -8513, -8507,
        -8501, -8498, -8495, -8500, -8498, -8498, -8496, -8491, -8496, -8496,
        -8492, -8484, -8488, -8480, -8482, -8479, -8479, -8474, -8473, -8472,
        -8469, -8465, -8459, -8452, -8448, -8446, -8449, -8446, -8444, -8448,
        -8452, -8446, -8443, -8432, -8422, -8417, -8413, -8409, -8396, -8390,
        -8386, -8384, -8380, -8372, -8363, -8363, -8360, -8359, -8363, -8355,
        -8344, -8341, -8328, -8323, -8320, -8316, -8310, -8306, -8294, -8297,
        -8302, -8294, -8283, -8277, -8268, -8263, -8255, -8249, -8245, -8247,
        -8238, -8235, -8237, -8236, -8233, -8219, -8211, -8201, -8192, -8184,
        -8176, -8163, -8160, -8149, -8143, -8134, -8129, -8125
    };

    static const int16_t fletcher_munson_curve_10_phons[1383] =
    {
        -1950, -1953, -1955, -1962, -1969,
        -1980, -1983, -1992, -1994, -2004, -2008, -2018, -2022, -2027, -2031,
        -2038, -2042, -2047, -2052, -2055, -2061, -2066, -2071, -2081, -2087,
        -2093, -2097, -2104, -2109, -2118, -2129, -2137, -2146, -2153, -2163,
        -2162, -2173, -2181, -2187, -2193, -2200, -2206, -2211, -2218, -2219,
        -2226, -2240, -2242, -2250, -2253, -2262, -2269, -2275, -2282, -2288,
        -2293, -2299, -2305, -2312, -2323, -2325, -2335, -2335, -2336, -2340,
        -2345, -2350, -2352, -2361, -2362, -2372, -2377, -2381, -2390, -2392,
        -2398, -2409, -2410, -2415, -2427, -2424, -2430, -2440, -2447, -2455,
        -2454, -2461, -2471, -2479, -2481, -2485, -2489, -2494, -2499, -2503,
        -2511, -2511, -2518, -2523, -2528, -2534, -2540, -2547, -2556, -2564,
        -2564, -2574, -2579, -2583, -2592, -2596, -2602, -2609, -2609, -2618,
        -2628, -2629, -2632, -2637, -2646, -2645, -2651, -2662, -2662, -2673,
        -2685, -2687, -2693, -2705, -2717, -2719, -2728, -2732, -2736, -2741,
        -2747, -2752, -2756, -2761, -2767, -2774, -2776, -2787, -2791, -2796,
        -2804, -2811, -2819, -2829, -2839, -2851, -2857, -2862, -2871, -2875,
        -2882, -2890, -2895, -2906, -2907, -2914, -2925, -2932, -2942, -2950,
        -2954, -2959, -2965, -2972, -2976, -2984, -2991, -2995, -3003, -3012,
        -3019, -3028, -3030, -3037, -3046, -3055, -3065, -3073, -3069, -3077,
        -3085, -3093, -3093, -3102, -3112, -3121, -3126, -3131, -3141, -3152,
        -3155, -3165, -3176, -3190, -3201, -3211, -3222, -3233, -3242, -3250,
        -3260, -3266, -3269, -3279, -3289, -3290, -3297, -3307, -3313, -3312,
        -3320, -3329, -3339, -3337, -3347, -3357, -3366, -3368, -3373, -3379,
        -3381, -3389, -3395, -3405, -3410, -3420, -3425, -3436, -3444, -3448,
        -3458, -3467, -3471, -3480, -3490, -3499, -3513, -3522, -3532, -3542,
        -3553, -3564, -3573, -3583, -3593, -3603, -3614, -3623, -3634, -3645,
        -3654, -3665, -3674, -3676, -3683, -3691, -3691, -3699, -3709, -3719,
        -3730, -3739, -3749, -3758, -3768, -3778, -3789, -3799, -3808, -3815,
        -3819, -3825, -3836, -3844, -3844, -3853, -3864, -3873, -3883, -3893,
        -3900, -3913, -3922, -3931, -3938, -3946, -3955, -3963, -3977, -3987,
        -3999, -4010, -4014, -4024, -4029, -4038, -4046, -4050, -4053, -4062,
        -4062, -4066, -4071, -4075, -4085, -4096, -4106, -4116, -4124, -4134,
        -4142, -4142, -4150, -4157, -4156, -4162, -4170, -4168, -4176, -4187,
        -4193, -4196, -4207, -4219, -4229, -4240, -4249, -4256, -4263, -4270,
        -4279, -4285, -4288, -4300, -4306, -4311, -4321, -4329, -4339, -4350,
        -4356, -4361, -4367, -4378, -4382, -4386, -4394, -4402, -4408, -4413,
        -4418, -4425, -4433, -4442, -4451, -4460, -4464, -4474, -4484, -4495,
        -4506, -4516, -4525, -4535, -4546, -4555, -4563, -4573, -4579, -4587,
        -4595, -4606, -4614, -4620, -4628, -4639, -4646, -4654, -4666, -4675,
        -4685, -4694, -4703, -4712, -4711, -4721, -4731, -4737, -4737, -4747,
        -4755, -4765, -4775, -4785, -4794, -4804, -4815, -4825, -4832, -4842,
        -4840, -4847, -4854, -4854, -4867, -4873, -4877, -4885, -4892, -4897,
        -4906, -4916, -4926, -4935, -4939, -4949, -4959, -4964, -4965, -4974,
        -4982, -4990, -4996, -5002, -5012, -5022, -5029, -5038, -5048, -5059,
        -5068, -5078, -5089, -5098, -5109, -5122, -5131, -5131, -5141, -5148,
        -5152, -5162, -5172, -5177, -5183, -5192, -5200, -5208, -5216, -5227,
        -5238, -5250, -5257, -5269, -5279, -5289, -5296, -5304, -5312, -5322,
        -5332, -5341, -5350, -5358, -5367, -5377, -5388, -5399, -5414, -5423,
        -5435, -5446, -5456, -5465, -5471, -5477, -5488, -5495, -5499, -5510,
        -5520, -5526, -5534, -5543, -5553, -5561, -5570, -5579, -5591, -5602,
        -5612, -5617, -5625, -5635, -5644, -5649, -5659, -5668, -5675, -5682,
        -5691, -5700, -5705, -5714, -5724, -5733, -5738, -5746, -5754, -5761,
        -5759, -5764, -5771, -5778, -5787, -5789, -5789, -5797, -5806, -5815,
        -5824, -5834, -5843, -5852, -5861, -5868, -5875, -5882, -5889, -5896,
        -5905, -5914, -5920, -5930, -5939, -5947, -5955, -5964, -5973, -5983,
        -5988, -5990, -6000, -6007, -6012, -6021, -6030, -6036, -6046, -6057,
        -6067, -6076, -6084, -6091, -6099, -6108, -6117, -6125, -6130, -6137,
        -6146, -6155, -6163, -6168, -6176, -6184, -6194, -6201, -6211, -6221,
        -6231, -6242, -6252, -6262, -6270, -6280, -6288, -6296, -6302, -6309,
        -6316, -6325, -6332, -6340, -6348, -6355, -6364, -6373, -6382, -6391,
        -6398, -6405, -6412, -6420, -6428, -6436, -6445, -6453, -6460, -6472,
        -6481, -6490, -6497, -6505, -6512, -6518, -6523, -6530, -6537, -6544,
        -6548, -6558, -6568, -6579, -6587, -6599, -6610, -6618, -6627, -6633,
        -6638, -6647, -6653, -6660, -6669, -6674, -6682, -6691, -6699, -6706,
        -6715, -6721, -6727, -6736, -6743, -6748, -6756, -6759, -6768, -6777,
        -6782, -6787, -6793, -6799, -6807, -6812, -6820, -6827, -6836, -6840,
        -6848, -6855, -6861, -6867, -6873, -6880, -6886, -6891, -6897, -6907,
        -6915, -6919, -6925, -6929, -6939, -6947, -6951, -6954, -6960, -6966,
        -6974, -6981, -6985, -6992, -6998, -7004, -7009, -7013, -7018, -7023,
        -7027, -7035, -7040, -7046, -7053, -7057, -7065, -7067, -7076, -7080,
        -7086, -7092, -7097, -7100, -7106, -7109, -7117, -7122, -7129, -7133,
        -7138, -7141, -7147, -7148, -7154, -7159, -7166, -7170, -7177, -7181,
        -7183, -7189, -7191, -7195, -7200, -7205, -7210, -7213, -7220, -7226,
        -7230, -7240, -7240, -7247, -7249, -7251, -7253, -7255, -7256, -7259,
        -7259, -7259, -7264, -7266, -7268, -7275, -7277, -7285, -7285, -7288,
        -7295, -7301, -7306, -7311, -7312, -7314, -7317, -7320, -7322, -7325,
        -7325, -7329, -7328, -7328, -7328, -7328, -7327, -7327, -7327, -7327,
        -7327, -7327, -7327, -7327, -7327, -7327, -7327, -7326, -7322, -7321,
        -7318, -7318, -7312, -7312, -7312, -7311, -7311, -7310, -7310, -7310,
        -7310, -7311, -7315, -7315, -7315, -7312, -7309, -7305, -7303, -7299,
        -7296, -7292, -7288, -7283, -7281, -7279, -7277, -7277, -7271, -7269,
        -7268, -7267, -7266, -7266, -7267, -7266, -7266, -7257, -7255, -7257,
        -7258, -7248, -7246, -7245, -7246, -7246, -7246, -7247, -7247, -7247,
        -7247, -7242, -7237, -7237, -7227, -7226, -7227, -7227, -7230, -7231,
        -7235, -7238, -7239, -7242, -7245, -7245, -7245, -7245, -7245, -7245,
        -7250, -7245, -7247, -7255, -7251, -7253, -7260, -7260, -7260, -7261,
        -7263, -7264, -7267, -7268, -7267, -7269, -7268, -7271, -7274, -7272,
        -7274, -7277, -7280, -7283, -7279, -7278, -7281, -7279, -7277, -7282,
        -7284, -7290, -7294, -7297, -7300, -7307, -7308, -7314, -7314, -7317,
        -7322, -7322, -7326, -7321, -7323, -7322, -7326, -7332, -7339, -7343,
        -7346, -7349, -7354, -7345, -7349, -7355, -7353, -7349, -7354, -7357,
        -7362, -7364, -7368, -7371, -7373, -7373, -7370, -7373, -7376, -7376,
        -7381, -7385, -7392, -7395, -7392, -7395, -7402, -7407, -7407, -7408,
        -7410, -7414, -7417, -7421, -7423, -7419, -7420, -7424, -7429, -7434,
        -7439, -7443, -7447, -7454, -7457, -7459, -7455, -7463, -7458, -7463,
        -7462, -7463, -7467, -7464, -7467, -7461, -7466, -7469, -7473, -7475,
        -7481, -7485, -7489, -7492, -7498, -7495, -7497, -7501, -7498, -7502,
        -7507, -7514, -7518, -7523, -7526, -7528, -7524, -7525, -7526, -7524,
        -7528, -7533, -7533, -7537, -7539, -7537, -7541, -7543, -7543, -7551,
        -7553, -7553, -7556, -7554, -7553, -7556, -7563, -7566, -7564, -7562,
        -7560, -7557, -7552, -7550, -7546, -7548, -7545, -7547, -7551, -7548,
        -7547, -7545, -7546, -7538, -7540, -7537, -7528, -7519, -7523, -7519,
        -7512, -7512, -7507, -7501, -7501, -7500, -7499, -7503, -7499, -7501,
        -7507, -7501, -7502, -7499, -7493, -7493, -7487, -7484, -7483, -7479,
        -7475, -7477, -7476, -7476, -7473, -7471, -7470, -7469, -7465, -7460,
        -7460, -7456, -7450, -7449, -7440, -7436, -7430, -7424, -7425, -7426,
        -7426, -7425, -7425, -7425, -7415, -7415, -7414, -7401, -7399, -7396,
        -7395, -7393, -7393, -7393, -7393, -7391, -7391, -7391, -7391, -7391,
        -7383, -7376, -7374, -7368, -7360, -7357, -7355, -7355, -7350, -7347,
        -7347, -7346, -7342, -7340, -7340, -7339, -7339, -7339, -7337, -7334,
        -7329, -7327, -7328, -7324, -7323, -7319, -7315, -7314, -7312, -7310,
        -7308, -7305, -7302, -7304, -7305, -7303, -7303, -7300, -7305, -7306,
        -7305, -7304, -7299, -7304, -7302, -7303, -7304, -7304, -7299, -7294,
        -7294, -7296, -7303, -7305, -7308, -7308, -7308, -7321, -7316, -7313,
        -7311, -7309, -7318, -7316, -7316, -7323, -7325, -7328, -7334, -7350,
        -7360, -7358, -7367, -7369, -7374, -7388, -7396, -7394, -7398, -7410,
        -7410, -7407, -7404, -7411, -7419, -7425, -7426, -7431, -7442, -7453,
        -7462, -7461, -7468, -7475, -7474, -7468, -7459, -7468, -7474, -7477,
        -7485, -7478, -7480, -7481, -7509, -7503, -7496, -7496, -7528, -7527,
        -7527, -7530, -7531, -7538, -7541, -7539, -7535, -7537, -7542, -7543,
        -7542, -7548, -7543, -7540, -7538, -7536, -7533, -7526, -7526, -7528,
        -7525, -7519, -7517, -7511, -7508, -7505, -7504, -7499, -7492, -7491,
        -7485, -7483, -7484, -7485, -7486, -7481, -7483, -7482, -7482, -7480,
        -7485, -7484, -7479, -7473, -7472, -7469, -7469, -7471, -7466, -7463,
        -7461, -7457, -7452, -7447, -7452, -7446, -7447, -7451, -7449, -7449,
        -7447, -7445, -7441, -7437, -7433, -7432, -7432, -7428, -7424, -7422,
        -7416, -7423, -7424, -7427, -7434, -7434, -7432, -7430, -7427, -7425,
        -7422, -7423, -7422, -7423, -7424, -7422, -7421, -7419, -7417, -7417,
        -7419, -7421, -7423, -7426, -7427, -7427, -7427, -7426, -7426, -7426,
        -7425, -7425, -7425, -7424, -7424, -7424, -7423, -7422, -7424, -7421,
        -7420, -7419, -7416, -7422, -7421, -7423, -7425, -7423, -7428, -7428,
        -7427, -7422, -7427, -7422, -7425, -7426, -7424, -7421, -7423, -7425,
        -7424, -7419, -7414, -7408, -7406, -7408, -7411, -7409, -7409, -7413,
        -7417, -7410, -7408, -7402, -7396, -7394, -7388, -7386, -7375, -7372,
        -7367, -7365, -7362, -7353, -7344, -7347, -7345, -7347, -7353, -7349,
        -7337, -7335, -7325, -7321, -7314, -7309, -7302, -7301, -7289, -7290,
        -7293, -7286, -7278, -7273, -7266, -7257, -7250, -7248, -7246, -7246,
        -7239, -7232, -7236, -7234, -7229, -7215, -7209, -7201, -7191, -7187,
        -7176, -7164, -7163, -7151, -7145, -7139, -7137, -7136
    };

    static const int16_t fletcher_munson_curve_20_phons[1383] =
    {
        -1516, -1520, -1520, -1527, -1535,
        -1546, -1549, -1557, -1559, -1568, -1570, -1581, -1585, -1588, -1590,
        -1593, -1597, -1601, -1607, -1609, -1611, -1616, -1622, -1631, -1638,
        -1643, -1647, -1657, -1661, -1669, -1679, -1684, -1693, -1698, -1706,
        -1703, -1716, -1726, -1731, -1736, -1741, -1746, -1749, -1752, -1754,
        -1764, -1775, -1775, -1785, -1790, -1798, -1804, -1811, -1818, -1826,
        -1830, -1836, -1841, -1849, -1860, -1862, -1873, -1872, -1868, -1871,
        -1876, -1880, -1880, -1886, -1886, -1895, -1900, -1904, -1911, -1910,
        -1915, -1924, -1924, -1924, -1935, -1930, -1935, -1945, -1949, -1955,
        -1954, -1959, -1969, -1978, -1978, -1981, -1985, -1990, -1995, -1998,
        -2004, -2004, -2009, -2014, -2018, -2024, -2031, -2038, -2046, -2054,
        -2052, -2060, -2063, -2065, -2075, -2078, -2084, -2087, -2086, -2095,
        -2104, -2104, -2104, -2107, -2114, -2113, -2118, -2127, -2125, -2132,
        -2142, -2142, -2147, -2157, -2166, -2166, -2175, -2177, -2182, -2185,
        -2192, -2194, -2199, -2204, -2209, -2216, -2217, -2227, -2232, -2237,
        -2246, -2252, -2262, -2272, -2282, -2291, -2298, -2301, -2308, -2307,
        -2312, -2320, -2324, -2334, -2335, -2339, -2348, -2354, -2364, -2371,
        -2375, -2381, -2389, -2392, -2394, -2401, -2409, -2411, -2417, -2424,
        -2430, -2438, -2439, -2444, -2454, -2464, -2473, -2480, -2474, -2484,
        -2493, -2499, -2499, -2505, -2514, -2522, -2525, -2528, -2536, -2544,
        -2545, -2553, -2562, -2576, -2587, -2596, -2606, -2616, -2623, -2628,
        -2639, -2646, -2649, -2659, -2670, -2671, -2679, -2689, -2694, -2694,
        -2703, -2712, -2721, -2718, -2725, -2732, -2739, -2740, -2745, -2750,
        -2749, -2755, -2759, -2768, -2771, -2780, -2784, -2795, -2801, -2800,
        -2807, -2814, -2818, -2825, -2833, -2839, -2852, -2860, -2870, -2879,
        -2889, -2899, -2907, -2916, -2924, -2934, -2945, -2955, -2964, -2974,
        -2982, -2993, -3002, -3003, -3009, -3016, -3015, -3021, -3031, -3040,
        -3051, -3059, -3066, -3074, -3081, -3090, -3101, -3110, -3116, -3121,
        -3124, -3130, -3140, -3146, -3145, -3154, -3164, -3171, -3179, -3188,
        -3195, -3207, -3215, -3223, -3231, -3240, -3249, -3258, -3273, -3282,
        -3296, -3309, -3312, -3320, -3320, -3329, -3336, -3340, -3340, -3349,
        -3348, -3353, -3356, -3358, -3366, -3377, -3386, -3396, -3405, -3414,
        -3421, -3421, -3430, -3439, -3439, -3442, -3450, -3450, -3459, -3469,
        -3474, -3475, -3485, -3495, -3504, -3514, -3519, -3525, -3534, -3540,
        -3546, -3552, -3553, -3563, -3567, -3572, -3581, -3591, -3601, -3611,
        -3617, -3623, -3630, -3643, -3647, -3650, -3658, -3662, -3667, -3669,
        -3673, -3676, -3684, -3691, -3699, -3707, -3710, -3719, -3729, -3740,
        -3750, -3758, -3768, -3778, -3787, -3795, -3799, -3808, -3812, -3817,
        -3822, -3832, -3837, -3840, -3846, -3856, -3861, -3866, -3877, -3883,
        -3892, -3901, -3909, -3915, -3913, -3923, -3934, -3936, -3937, -3947,
        -3952, -3962, -3971, -3979, -3987, -3996, -4007, -4016, -4026, -4036,
        -4034, -4039, -4048, -4048, -4060, -4065, -4068, -4076, -4086, -4091,
        -4098, -4104, -4112, -4120, -4123, -4132, -4141, -4147, -4149, -4158,
        -4167, -4173, -4177, -4182, -4191, -4201, -4204, -4211, -4220, -4231,
        -4239, -4249, -4259, -4268, -4278, -4291, -4301, -4301, -4311, -4316,
        -4321, -4332, -4342, -4344, -4352, -4363, -4372, -4378, -4383, -4393,
        -4402, -4411, -4413, -4423, -4432, -4442, -4450, -4456, -4463, -4473,
        -4483, -4492, -4500, -4507, -4513, -4523, -4532, -4543, -4558, -4567,
        -4579, -4591, -4599, -4608, -4614, -4619, -4628, -4634, -4638, -4647,
        -4656, -4662, -4667, -4675, -4684, -4692, -4700, -4710, -4724, -4734,
        -4743, -4743, -4752, -4762, -4770, -4772, -4782, -4791, -4796, -4801,
        -4811, -4821, -4821, -4831, -4840, -4849, -4852, -4859, -4869, -4877,
        -4877, -4881, -4888, -4897, -4906, -4909, -4908, -4917, -4926, -4935,
        -4946, -4957, -4966, -4975, -4983, -4988, -4993, -4999, -5007, -5011,
        -5022, -5030, -5033, -5044, -5055, -5065, -5074, -5084, -5096, -5107,
        -5113, -5114, -5124, -5131, -5132, -5142, -5151, -5153, -5161, -5170,
        -5179, -5187, -5193, -5198, -5207, -5216, -5226, -5235, -5238, -5246,
        -5256, -5265, -5273, -5275, -5285, -5294, -5303, -5308, -5318, -5327,
        -5337, -5347, -5356, -5365, -5371, -5380, -5383, -5391, -5393, -5400,
        -5405, -5412, -5417, -5426, -5435, -5440, -5448, -5458, -5468, -5478,
        -5482, -5488, -5493, -5500, -5507, -5513, -5522, -5528, -5532, -5542,
        -5552, -5560, -5565, -5571, -5579, -5586, -5590, -5594, -5602, -5609,
        -5610, -5619, -5630, -5640, -5645, -5657, -5671, -5679, -5689, -5694,
        -5695, -5704, -5705, -5710, -5719, -5724, -5734, -5743, -5751, -5758,
        -5767, -5773, -5777, -5786, -5791, -5795, -5804, -5806, -5814, -5823,
        -5827, -5832, -5837, -5841, -5850, -5854, -5861, -5870, -5880, -5881,
        -5889, -5895, -5902, -5907, -5912, -5917, -5922, -5926, -5931, -5938,
        -5945, -5945, -5953, -5954, -5963, -5969, -5971, -5973, -5978, -5982,
        -5988, -5992, -5997, -6002, -6008, -6012, -6017, -6021, -6025, -6030,
        -6035, -6044, -6047, -6053, -6061, -6063, -6071, -6072, -6080, -6082,
        -6087, -6091, -6095, -6095, -6100, -6101, -6110, -6110, -6119, -6119,
        -6129, -6134, -6138, -6138, -6144, -6144, -6149, -6150, -6158, -6158,
        -6163, -6167, -6169, -6176, -6178, -6186, -6187, -6189, -6197, -6201,
        -6203, -6214, -6212, -6219, -6221, -6226, -6230, -6235, -6235, -6239,
        -6241, -6240, -6248, -6248, -6249, -6259, -6260, -6270, -6269, -6275,
        -6281, -6290, -6295, -6301, -6303, -6302, -6302, -6302, -6306, -6311,
        -6311, -6320, -6319, -6319, -6319, -6319, -6319, -6318, -6318, -6318,
        -6318, -6318, -6318, -6318, -6318, -6318, -6318, -6318, -6318, -6318,
        -6318, -6318, -6313, -6312, -6312, -6311, -6311, -6311, -6311, -6311,
        -6310, -6311, -6316, -6315, -6315, -6310, -6310, -6305, -6303, -6303,
        -6301, -6297, -6295, -6287, -6283, -6280, -6278, -6277, -6272, -6269,
        -6268, -6266, -6265, -6265, -6264, -6263, -6264, -6254, -6253, -6256,
        -6258, -6247, -6244, -6243, -6244, -6245, -6244, -6247, -6247, -6247,
        -6247, -6242, -6237, -6237, -6227, -6227, -6227, -6227, -6226, -6226,
        -6226, -6231, -6233, -6240, -6245, -6245, -6245, -6245, -6245, -6245,
        -6246, -6241, -6243, -6251, -6247, -6251, -6261, -6261, -6261, -6261,
        -6261, -6259, -6264, -6265, -6264, -6269, -6268, -6271, -6276, -6274,
        -6277, -6282, -6284, -6286, -6281, -6281, -6284, -6283, -6283, -6285,
        -6289, -6293, -6297, -6299, -6302, -6308, -6310, -6314, -6314, -6314,
        -6322, -6322, -6322, -6316, -6325, -6320, -6323, -6328, -6341, -6346,
        -6346, -6352, -6354, -6345, -6345, -6354, -6349, -6343, -6347, -6352,
        -6353, -6357, -6362, -6362, -6366, -6364, -6361, -6364, -6366, -6366,
        -6371, -6376, -6381, -6385, -6381, -6384, -6393, -6397, -6397, -6397,
        -6397, -6400, -6401, -6404, -6404, -6397, -6396, -6399, -6400, -6404,
        -6407, -6411, -6413, -6421, -6423, -6425, -6420, -6429, -6425, -6429,
        -6429, -6429, -6434, -6432, -6432, -6424, -6431, -6432, -6432, -6433,
        -6437, -6443, -6443, -6445, -6452, -6446, -6450, -6452, -6449, -6451,
        -6456, -6462, -6466, -6471, -6472, -6472, -6468, -6472, -6472, -6468,
        -6468, -6476, -6474, -6477, -6479, -6476, -6481, -6481, -6482, -6492,
        -6494, -6493, -6495, -6492, -6488, -6488, -6491, -6493, -6487, -6486,
        -6483, -6479, -6474, -6468, -6464, -6464, -6459, -6462, -6461, -6455,
        -6450, -6446, -6445, -6436, -6442, -6435, -6425, -6415, -6416, -6410,
        -6400, -6400, -6395, -6390, -6390, -6384, -6384, -6384, -6381, -6380,
        -6389, -6380, -6381, -6380, -6375, -6375, -6368, -6364, -6364, -6359,
        -6355, -6357, -6356, -6356, -6353, -6350, -6350, -6348, -6344, -6339,
        -6338, -6334, -6328, -6328, -6318, -6315, -6309, -6303, -6304, -6306,
        -6306, -6305, -6305, -6305, -6294, -6294, -6294, -6282, -6281, -6282,
        -6286, -6286, -6286, -6286, -6286, -6282, -6282, -6282, -6282, -6282,
        -6278, -6271, -6271, -6267, -6260, -6259, -6259, -6259, -6257, -6249,
        -6249, -6247, -6239, -6239, -6239, -6239, -6239, -6239, -6239, -6235,
        -6226, -6224, -6225, -6221, -6221, -6217, -6213, -6214, -6211, -6209,
        -6209, -6207, -6204, -6205, -6202, -6200, -6201, -6199, -6202, -6199,
        -6200, -6198, -6194, -6199, -6195, -6192, -6194, -6192, -6186, -6181,
        -6181, -6182, -6189, -6191, -6194, -6190, -6191, -6203, -6197, -6191,
        -6186, -6183, -6193, -6193, -6189, -6195, -6202, -6205, -6211, -6227,
        -6236, -6234, -6244, -6243, -6246, -6258, -6265, -6264, -6268, -6281,
        -6281, -6282, -6278, -6286, -6292, -6297, -6298, -6305, -6317, -6328,
        -6336, -6331, -6345, -6352, -6344, -6334, -6323, -6337, -6349, -6351,
        -6361, -6353, -6356, -6357, -6387, -6378, -6369, -6370, -6401, -6396,
        -6396, -6400, -6400, -6410, -6413, -6411, -6410, -6415, -6420, -6422,
        -6420, -6429, -6424, -6424, -6424, -6419, -6414, -6410, -6410, -6411,
        -6409, -6402, -6404, -6399, -6395, -6393, -6393, -6388, -6381, -6383,
        -6378, -6377, -6379, -6378, -6382, -6379, -6383, -6385, -6386, -6385,
        -6391, -6388, -6383, -6378, -6377, -6375, -6373, -6374, -6371, -6368,
        -6364, -6359, -6352, -6350, -6356, -6353, -6354, -6361, -6357, -6356,
        -6353, -6350, -6347, -6344, -6340, -6340, -6340, -6333, -6330, -6330,
        -6322, -6331, -6332, -6336, -6343, -6343, -6338, -6334, -6329, -6324,
        -6325, -6327, -6330, -6332, -6332, -6328, -6325, -6321, -6317, -6317,
        -6320, -6322, -6324, -6327, -6327, -6328, -6328, -6327, -6327, -6327,
        -6327, -6327, -6327, -6328, -6329, -6329, -6330, -6330, -6335, -6335,
        -6339, -6339, -6338, -6344, -6344, -6349, -6354, -6355, -6360, -6360,
        -6362, -6361, -6367, -6364, -6369, -6372, -6369, -6368, -6373, -6378,
        -6379, -6374, -6369, -6365, -6364, -6369, -6374, -6373, -6373, -6379,
        -6381, -6375, -6372, -6372, -6370, -6371, -6364, -6363, -6354, -6353,
        -6349, -6346, -6343, -6335, -6325, -6332, -6329, -6334, -6343, -6343,
        -6329, -6330, -6321, -6318, -6308, -6301, -6295, -6296, -6284, -6283,
        -6284, -6279, -6272, -6269, -6264, -6250, -6245, -6246, -6247, -6245,
        -6239, -6230, -6234, -6233, -6225, -6211, -6206, -6201, -6190, -6189,
        -6177, -6165, -6165, -6154, -6147, -6144, -6146, -6148
    };

    static const int16_t fletcher_munson_curve_30_phons[1383] =
    {
        -1216, -1218, -1219, -1223, -1229,
        -1238, -1241, -1247, -1248, -1257, -1259, -1266, -1268, -1272, -1275,
        -1275, -1279, -1279, -1285, -1288, -1291, -1294, -1299, -1303, -1307,
        -1310, -1312, -1319, -1321, -1325, -1331, -1333, -1339, -1344, -1350,
        -1348, -1358, -1365, -1370, -1375, -1380, -1382, -1384, -1390, -1391,
        -1399, -1409, -1410, -1417, -1422, -1429, -1434, -1441, -1448, -1454,
        -1457, -1464, -1469, -1477, -1484, -1484, -1494, -1490, -1489, -1492,
        -1493, -1497, -1497, -1502, -1502, -1511, -1512, -1516, -1524, -1525,
        -1526, -1536, -1536, -1537, -1547, -1544, -1551, -1559, -1563, -1571,
        -1571, -1578, -1584, -1593, -1595, -1599, -1602, -1606, -1611, -1615,
        -1620, -1620, -1623, -1628, -1630, -1633, -1638, -1641, -1649, -1652,
        -1652, -1658, -1661, -1661, -1669, -1671, -1678, -1684, -1680, -1688,
        -1698, -1698, -1699, -1701, -1710, -1709, -1714, -1723, -1720, -1728,
        -1738, -1740, -1744, -1752, -1760, -1760, -1769, -1772, -1777, -1777,
        -1782, -1786, -1790, -1794, -1796, -1803, -1805, -1815, -1817, -1822,
        -1831, -1838, -1846, -1856, -1865, -1871, -1878, -1880, -1884, -1885,
        -1889, -1893, -1897, -1903, -1903, -1909, -1916, -1923, -1933, -1941,
        -1946, -1952, -1960, -1966, -1969, -1976, -1983, -1985, -1990, -1997,
        -2002, -2007, -2010, -2015, -2022, -2032, -2040, -2046, -2042, -2050,
        -2057, -2065, -2064, -2068, -2078, -2087, -2087, -2090, -2099, -2104,
        -2105, -2112, -2122, -2130, -2140, -2149, -2155, -2164, -2170, -2175,
        -2185, -2189, -2191, -2200, -2208, -2208, -2215, -2223, -2228, -2228,
        -2237, -2242, -2251, -2249, -2257, -2262, -2269, -2270, -2274, -2279,
        -2277, -2283, -2286, -2295, -2297, -2302, -2305, -2314, -2320, -2319,
        -2325, -2332, -2333, -2338, -2346, -2351, -2364, -2372, -2379, -2389,
        -2398, -2408, -2415, -2424, -2433, -2442, -2451, -2460, -2466, -2476,
        -2484, -2491, -2499, -2500, -2506, -2513, -2513, -2521, -2531, -2541,
        -2553, -2561, -2571, -2579, -2585, -2592, -2602, -2608, -2616, -2621,
        -2621, -2627, -2637, -2643, -2642, -2650, -2660, -2668, -2677, -2683,
        -2690, -2701, -2708, -2717, -2723, -2731, -2740, -2747, -2759, -2769,
        -2781, -2792, -2793, -2801, -2802, -2810, -2818, -2821, -2822, -2828,
        -2827, -2828, -2831, -2830, -2839, -2849, -2854, -2864, -2873, -2881,
        -2888, -2887, -2896, -2902, -2901, -2904, -2911, -2911, -2917, -2927,
        -2933, -2934, -2944, -2954, -2963, -2970, -2976, -2982, -2989, -2994,
        -3001, -3005, -3005, -3013, -3016, -3017, -3027, -3036, -3042, -3049,
        -3053, -3054, -3059, -3070, -3073, -3075, -3082, -3088, -3092, -3095,
        -3100, -3101, -3109, -3115, -3122, -3127, -3128, -3135, -3142, -3153,
        -3163, -3169, -3179, -3189, -3199, -3207, -3214, -3223, -3228, -3232,
        -3239, -3248, -3252, -3259, -3265, -3271, -3279, -3284, -3292, -3298,
        -3305, -3312, -3318, -3324, -3320, -3328, -3336, -3338, -3338, -3346,
        -3352, -3359, -3366, -3373, -3382, -3390, -3398, -3406, -3417, -3425,
        -3423, -3428, -3436, -3434, -3444, -3451, -3453, -3460, -3467, -3473,
        -3479, -3485, -3493, -3500, -3503, -3511, -3520, -3526, -3526, -3535,
        -3546, -3553, -3560, -3565, -3571, -3580, -3586, -3592, -3599, -3607,
        -3614, -3621, -3629, -3638, -3647, -3656, -3664, -3664, -3673, -3679,
        -3682, -3692, -3699, -3704, -3713, -3720, -3728, -3736, -3741, -3749,
        -3758, -3765, -3769, -3779, -3786, -3794, -3802, -3807, -3813, -3820,
        -3828, -3835, -3843, -3848, -3855, -3863, -3870, -3878, -3891, -3898,
        -3907, -3917, -3923, -3930, -3933, -3936, -3944, -3945, -3948, -3953,
        -3959, -3963, -3968, -3974, -3981, -3990, -3999, -4008, -4016, -4026,
        -4033, -4035, -4042, -4050, -4057, -4060, -4069, -4077, -4082, -4086,
        -4095, -4101, -4104, -4112, -4119, -4126, -4129, -4136, -4143, -4151,
        -4147, -4153, -4160, -4167, -4174, -4175, -4175, -4184, -4190, -4198,
        -4205, -4215, -4223, -4230, -4237, -4243, -4248, -4254, -4260, -4265,
        -4273, -4280, -4284, -4293, -4303, -4310, -4318, -4325, -4334, -4342,
        -4347, -4351, -4359, -4364, -4367, -4375, -4384, -4389, -4394, -4403,
        -4412, -4417, -4424, -4429, -4433, -4442, -4448, -4455, -4459, -4465,
        -4472, -4477, -4486, -4487, -4497, -4504, -4509, -4516, -4521, -4530,
        -4535, -4545, -4550, -4557, -4563, -4570, -4574, -4582, -4584, -4592,
        -4596, -4604, -4611, -4616, -4625, -4632, -4639, -4646, -4653, -4658,
        -4662, -4668, -4674, -4680, -4687, -4694, -4700, -4708, -4714, -4722,
        -4730, -4738, -4745, -4751, -4757, -4762, -4765, -4770, -4775, -4781,
        -4783, -4791, -4799, -4806, -4812, -4821, -4831, -4839, -4849, -4854,
        -4859, -4867, -4872, -4878, -4883, -4889, -4896, -4901, -4909, -4913,
        -4922, -4925, -4932, -4937, -4943, -4947, -4955, -4958, -4963, -4969,
        -4977, -4980, -4983, -4989, -4994, -4998, -5005, -5009, -5017, -5020,
        -5024, -5027, -5035, -5037, -5040, -5043, -5050, -5052, -5058, -5065,
        -5070, -5073, -5077, -5082, -5088, -5094, -5097, -5097, -5099, -5106,
        -5109, -5111, -5115, -5120, -5124, -5126, -5133, -5135, -5139, -5144,
        -5146, -5151, -5153, -5156, -5161, -5162, -5167, -5168, -5174, -5175,
        -5178, -5182, -5184, -5183, -5187, -5187, -5192, -5192, -5197, -5197,
        -5206, -5209, -5211, -5212, -5219, -5220, -5222, -5222, -5226, -5226,
        -5229, -5231, -5232, -5236, -5237, -5241, -5242, -5243, -5248, -5251,
        -5253, -5260, -5257, -5261, -5263, -5265, -5267, -5269, -5269, -5271,
        -5270, -5270, -5273, -5273, -5274, -5280, -5281, -5286, -5285, -5289,
        -5296, -5302, -5308, -5312, -5313, -5313, -5313, -5314, -5316, -5319,
        -5320, -5324, -5326, -5326, -5326, -5326, -5327, -5327, -5327, -5327,
        -5327, -5328, -5327, -5325, -5325, -5323, -5323, -5323, -5320, -5320,
        -5318, -5318, -5313, -5312, -5312, -5311, -5311, -5311, -5311, -5311,
        -5310, -5311, -5313, -5313, -5313, -5308, -5305, -5302, -5301, -5301,
        -5298, -5295, -5293, -5289, -5289, -5286, -5284, -5287, -5281, -5278,
        -5277, -5277, -5276, -5276, -5276, -5275, -5277, -5267, -5265, -5266,
        -5267, -5257, -5256, -5255, -5256, -5257, -5257, -5259, -5259, -5257,
        -5257, -5251, -5245, -5246, -5236, -5236, -5236, -5236, -5236, -5236,
        -5236, -5238, -5237, -5236, -5237, -5236, -5236, -5236, -5236, -5236,
        -5237, -5232, -5233, -5237, -5233, -5235, -5242, -5242, -5242, -5242,
        -5242, -5241, -5242, -5242, -5241, -5242, -5241, -5242, -5244, -5242,
        -5243, -5245, -5246, -5247, -5242, -5239, -5241, -5238, -5235, -5236,
        -5237, -5238, -5239, -5240, -5242, -5245, -5246, -5248, -5248, -5248,
        -5252, -5252, -5251, -5247, -5247, -5242, -5244, -5249, -5257, -5262,
        -5264, -5267, -5268, -5258, -5260, -5267, -5263, -5261, -5263, -5266,
        -5268, -5270, -5273, -5275, -5279, -5277, -5274, -5277, -5277, -5277,
        -5281, -5283, -5289, -5292, -5288, -5291, -5299, -5304, -5301, -5303,
        -5303, -5309, -5310, -5311, -5312, -5305, -5302, -5308, -5309, -5316,
        -5319, -5323, -5326, -5333, -5335, -5334, -5333, -5338, -5332, -5338,
        -5335, -5336, -5339, -5335, -5338, -5331, -5335, -5336, -5336, -5337,
        -5339, -5342, -5343, -5344, -5350, -5345, -5346, -5349, -5347, -5351,
        -5358, -5363, -5368, -5373, -5376, -5378, -5376, -5378, -5378, -5377,
        -5377, -5380, -5378, -5379, -5379, -5375, -5379, -5379, -5377, -5385,
        -5384, -5384, -5387, -5383, -5379, -5379, -5380, -5385, -5382, -5382,
        -5378, -5375, -5370, -5365, -5361, -5361, -5356, -5357, -5357, -5351,
        -5347, -5343, -5340, -5331, -5332, -5323, -5313, -5303, -5304, -5298,
        -5288, -5288, -5283, -5278, -5278, -5272, -5270, -5270, -5265, -5264,
        -5268, -5259, -5264, -5262, -5257, -5256, -5250, -5250, -5248, -5243,
        -5238, -5239, -5237, -5235, -5232, -5229, -5227, -5225, -5220, -5216,
        -5215, -5211, -5205, -5204, -5195, -5191, -5185, -5179, -5180, -5181,
        -5181, -5180, -5181, -5182, -5172, -5172, -5171, -5160, -5160, -5160,
        -5162, -5161, -5162, -5162, -5163, -5161, -5160, -5160, -5160, -5159,
        -5155, -5148, -5148, -5144, -5136, -5134, -5136, -5135, -5135, -5130,
        -5130, -5129, -5125, -5125, -5125, -5123, -5123, -5123, -5121, -5116,
        -5112, -5112, -5114, -5111, -5110, -5107, -5105, -5106, -5104, -5102,
        -5099, -5097, -5096, -5096, -5095, -5093, -5094, -5091, -5093, -5092,
        -5094, -5095, -5093, -5098, -5096, -5095, -5097, -5096, -5090, -5085,
        -5084, -5085, -5090, -5089, -5091, -5089, -5088, -5102, -5097, -5093,
        -5089, -5084, -5102, -5100, -5099, -5106, -5108, -5109, -5111, -5124,
        -5127, -5122, -5129, -5133, -5140, -5152, -5160, -5161, -5168, -5182,
        -5185, -5186, -5183, -5190, -5194, -5197, -5200, -5203, -5210, -5218,
        -5227, -5215, -5226, -5231, -5228, -5220, -5213, -5222, -5232, -5233,
        -5239, -5235, -5239, -5241, -5268, -5260, -5253, -5253, -5285, -5280,
        -5279, -5282, -5286, -5292, -5297, -5296, -5294, -5294, -5299, -5297,
        -5295, -5299, -5292, -5292, -5294, -5294, -5291, -5289, -5289, -5292,
        -5290, -5285, -5285, -5280, -5276, -5274, -5274, -5270, -5264, -5262,
        -5260, -5256, -5258, -5255, -5258, -5253, -5258, -5255, -5256, -5255,
        -5259, -5257, -5255, -5248, -5249, -5247, -5248, -5251, -5247, -5243,
        -5239, -5234, -5230, -5225, -5230, -5225, -5226, -5231, -5228, -5226,
        -5223, -5221, -5219, -5217, -5215, -5213, -5212, -5209, -5207, -5206,
        -5201, -5209, -5209, -5210, -5215, -5213, -5208, -5206, -5203, -5201,
        -5202, -5204, -5207, -5208, -5207, -5203, -5200, -5196, -5194, -5194,
        -5196, -5199, -5201, -5204, -5204, -5204, -5204, -5204, -5204, -5204,
        -5204, -5206, -5209, -5212, -5215, -5215, -5216, -5216, -5218, -5218,
        -5221, -5221, -5220, -5226, -5226, -5230, -5236, -5236, -5241, -5240,
        -5242, -5241, -5249, -5248, -5254, -5257, -5257, -5255, -5260, -5265,
        -5267, -5267, -5266, -5263, -5264, -5268, -5273, -5270, -5271, -5279,
        -5282, -5278, -5275, -5272, -5272, -5275, -5271, -5269, -5261, -5258,
        -5253, -5251, -5250, -5245, -5238, -5245, -5245, -5250, -5256, -5253,
        -5247, -5247, -5238, -5234, -5227, -5223, -5221, -5218, -5209, -5210,
        -5213, -5206, -5200, -5196, -5190, -5182, -5174, -5175, -5178, -5178,
        -5176, -5170, -5171, -5166, -5161, -5154, -5149, -5146, -5138, -5136,
        -5126, -5114, -5109, -5097, -5093, -5087, -5084, -5086
    };

    static const int16_t fletcher_munson_curve_40_phons[1383] =
    {
        -916, -917, -918, -919, -922,
        -930, -932, -937, -937, -946, -948, -950, -951, -956, -961,
        -958, -962, -958, -963, -967, -971, -972, -977, -975, -976,
        -976, -976, -981, -980, -981, -983, -981, -985, -990, -994,
        -994, -1000, -1005, -1010, -1015, -1019, -1018, -1020, -1028, -1028,
        -1034, -1044, -1044, -1050, -1055, -1060, -1064, -1071, -1078, -1083,
        -1084, -1092, -1097, -1104, -1108, -1105, -1115, -1108, -1110, -1112,
        -1110, -1113, -1114, -1118, -1118, -1128, -1124, -1128, -1138, -1140,
        -1138, -1148, -1148, -1150, -1158, -1158, -1168, -1173, -1178, -1188,
        -1188, -1197, -1198, -1208, -1211, -1217, -1219, -1222, -1228, -1233,
        -1237, -1237, -1238, -1242, -1242, -1242, -1246, -1244, -1252, -1251,
        -1252, -1257, -1258, -1258, -1263, -1265, -1271, -1280, -1274, -1282,
        -1291, -1291, -1295, -1296, -1306, -1305, -1310, -1318, -1315, -1324,
        -1334, -1337, -1342, -1348, -1354, -1354, -1362, -1367, -1372, -1369,
        -1372, -1377, -1381, -1384, -1383, -1390, -1392, -1402, -1401, -1407,
        -1416, -1423, -1431, -1441, -1447, -1452, -1457, -1458, -1461, -1463,
        -1466, -1466, -1469, -1473, -1472, -1480, -1483, -1492, -1501, -1511,
        -1517, -1523, -1530, -1539, -1544, -1551, -1557, -1559, -1563, -1570,
        -1574, -1575, -1581, -1587, -1590, -1600, -1606, -1611, -1611, -1616,
        -1621, -1631, -1629, -1632, -1642, -1651, -1649, -1652, -1661, -1664,
        -1664, -1672, -1681, -1684, -1692, -1701, -1704, -1712, -1717, -1723,
        -1731, -1732, -1732, -1741, -1746, -1744, -1752, -1757, -1762, -1762,
        -1771, -1773, -1781, -1781, -1789, -1791, -1798, -1800, -1804, -1807,
        -1804, -1812, -1814, -1823, -1823, -1824, -1826, -1832, -1839, -1838,
        -1843, -1850, -1848, -1852, -1858, -1863, -1877, -1884, -1888, -1898,
        -1908, -1917, -1923, -1933, -1942, -1950, -1958, -1965, -1968, -1978,
        -1986, -1989, -1997, -1997, -2002, -2011, -2011, -2021, -2031, -2041,
        -2055, -2063, -2075, -2084, -2089, -2095, -2104, -2106, -2116, -2121,
        -2119, -2125, -2135, -2140, -2139, -2145, -2155, -2164, -2174, -2178,
        -2186, -2196, -2201, -2211, -2215, -2221, -2231, -2237, -2246, -2256,
        -2265, -2275, -2274, -2283, -2284, -2292, -2300, -2303, -2305, -2308,
        -2306, -2303, -2306, -2303, -2312, -2321, -2322, -2332, -2341, -2349,
        -2356, -2354, -2362, -2366, -2362, -2367, -2372, -2372, -2375, -2384,
        -2392, -2393, -2403, -2413, -2422, -2427, -2433, -2439, -2443, -2449,
        -2456, -2458, -2457, -2463, -2466, -2462, -2472, -2480, -2483, -2488,
        -2489, -2484, -2487, -2497, -2500, -2499, -2507, -2513, -2518, -2522,
        -2527, -2527, -2535, -2539, -2544, -2547, -2546, -2550, -2556, -2566,
        -2576, -2580, -2590, -2599, -2610, -2619, -2630, -2639, -2644, -2648,
        -2657, -2665, -2668, -2677, -2684, -2687, -2696, -2701, -2708, -2712,
        -2718, -2723, -2728, -2733, -2727, -2733, -2738, -2741, -2738, -2745,
        -2751, -2757, -2762, -2767, -2777, -2783, -2789, -2797, -2807, -2815,
        -2812, -2816, -2824, -2819, -2828, -2837, -2839, -2843, -2849, -2854,
        -2860, -2866, -2873, -2880, -2883, -2891, -2898, -2905, -2904, -2913,
        -2925, -2934, -2942, -2947, -2951, -2959, -2968, -2973, -2978, -2983,
        -2988, -2993, -2999, -3008, -3015, -3020, -3027, -3027, -3036, -3041,
        -3043, -3051, -3055, -3065, -3074, -3078, -3084, -3095, -3099, -3105,
        -3114, -3119, -3125, -3135, -3140, -3146, -3155, -3157, -3163, -3167,
        -3174, -3177, -3186, -3189, -3198, -3203, -3208, -3214, -3224, -3230,
        -3234, -3243, -3247, -3252, -3253, -3252, -3259, -3256, -3258, -3259,
        -3263, -3265, -3269, -3273, -3278, -3288, -3297, -3307, -3308, -3318,
        -3323, -3327, -3332, -3338, -3343, -3349, -3356, -3362, -3367, -3372,
        -3378, -3382, -3387, -3392, -3397, -3402, -3407, -3412, -3417, -3425,
        -3417, -3426, -3432, -3437, -3442, -3442, -3442, -3451, -3454, -3462,
        -3465, -3473, -3479, -3486, -3491, -3498, -3503, -3509, -3514, -3518,
        -3524, -3529, -3535, -3542, -3551, -3556, -3563, -3567, -3572, -3578,
        -3581, -3589, -3593, -3598, -3602, -3608, -3617, -3625, -3627, -3636,
        -3645, -3647, -3654, -3659, -3659, -3668, -3669, -3674, -3679, -3684,
        -3689, -3690, -3699, -3700, -3709, -3714, -3715, -3724, -3725, -3733,
        -3734, -3743, -3744, -3749, -3755, -3760, -3765, -3773, -3776, -3785,
        -3787, -3796, -3804, -3806, -3816, -3825, -3829, -3833, -3838, -3838,
        -3842, -3848, -3854, -3861, -3868, -3874, -3878, -3887, -3896, -3902,
        -3908, -3917, -3924, -3931, -3935, -3938, -3940, -3945, -3949, -3952,
        -3956, -3962, -3968, -3973, -3979, -3985, -3991, -3999, -4009, -4015,
        -4023, -4031, -4039, -4046, -4048, -4054, -4058, -4060, -4067, -4068,
        -4077, -4078, -4087, -4088, -4094, -4098, -4106, -4111, -4111, -4115,
        -4127, -4129, -4129, -4138, -4138, -4142, -4148, -4148, -4154, -4159,
        -4159, -4159, -4168, -4168, -4168, -4169, -4178, -4178, -4184, -4191,
        -4196, -4201, -4201, -4210, -4214, -4219, -4223, -4220, -4220, -4229,
        -4230, -4230, -4232, -4239, -4240, -4241, -4249, -4249, -4254, -4258,
        -4258, -4258, -4259, -4260, -4260, -4262, -4263, -4264, -4268, -4269,
        -4270, -4273, -4274, -4271, -4273, -4274, -4275, -4275, -4275, -4275,
        -4283, -4284, -4284, -4285, -4295, -4295, -4295, -4295, -4295, -4295,
        -4295, -4295, -4295, -4295, -4296, -4296, -4297, -4298, -4298, -4301,
        -4303, -4305, -4303, -4304, -4304, -4304, -4303, -4303, -4303, -4303,
        -4300, -4299, -4298, -4298, -4299, -4300, -4301, -4302, -4301, -4303,
        -4312, -4313, -4322, -4322, -4324, -4324, -4325, -4325, -4325, -4327,
        -4328, -4329, -4332, -4333, -4333, -4334, -4336, -4336, -4336, -4336,
        -4336, -4337, -4336, -4332, -4332, -4328, -4328, -4328, -4322, -4322,
        -4318, -4318, -4313, -4312, -4312, -4311, -4311, -4311, -4311, -4311,
        -4310, -4311, -4311, -4311, -4311, -4305, -4301, -4300, -4299, -4299,
        -4296, -4293, -4291, -4292, -4296, -4293, -4291, -4296, -4290, -4287,
        -4287, -4287, -4287, -4287, -4287, -4288, -4290, -4280, -4277, -4277,
        -4277, -4267, -4268, -4267, -4267, -4269, -4270, -4272, -4271, -4266,
        -4266, -4260, -4253, -4255, -4245, -4245, -4245, -4245, -4245, -4245,
        -4245, -4245, -4240, -4232, -4229, -4226, -4226, -4226, -4226, -4227,
        -4228, -4223, -4222, -4223, -4219, -4219, -4224, -4224, -4224, -4224,
        -4224, -4223, -4220, -4219, -4218, -4215, -4213, -4213, -4212, -4210,
        -4209, -4209, -4208, -4208, -4203, -4198, -4198, -4193, -4187, -4187,
        -4185, -4184, -4182, -4181, -4182, -4182, -4182, -4182, -4182, -4183,
        -4182, -4181, -4181, -4179, -4170, -4164, -4164, -4169, -4173, -4179,
        -4182, -4182, -4181, -4171, -4176, -4180, -4177, -4179, -4179, -4180,
        -4183, -4183, -4183, -4188, -4192, -4190, -4187, -4191, -4188, -4188,
        -4190, -4190, -4198, -4198, -4196, -4197, -4206, -4210, -4206, -4209,
        -4209, -4218, -4218, -4218, -4221, -4213, -4208, -4216, -4218, -4228,
        -4230, -4235, -4239, -4244, -4248, -4243, -4246, -4247, -4239, -4246,
        -4241, -4242, -4245, -4238, -4245, -4238, -4239, -4240, -4240, -4241,
        -4242, -4242, -4242, -4242, -4247, -4245, -4242, -4246, -4246, -4250,
        -4259, -4265, -4270, -4274, -4280, -4285, -4285, -4285, -4285, -4285,
        -4286, -4285, -4282, -4282, -4278, -4274, -4277, -4276, -4272, -4277,
        -4273, -4274, -4278, -4273, -4270, -4269, -4270, -4278, -4277, -4278,
        -4272, -4271, -4265, -4262, -4258, -4258, -4253, -4253, -4254, -4248,
        -4245, -4240, -4235, -4225, -4222, -4212, -4201, -4192, -4192, -4186,
        -4177, -4176, -4171, -4166, -4166, -4160, -4156, -4156, -4149, -4147,
        -4147, -4139, -4147, -4144, -4138, -4137, -4131, -4136, -4131, -4126,
        -4122, -4120, -4117, -4115, -4111, -4108, -4104, -4102, -4097, -4093,
        -4092, -4088, -4082, -4081, -4072, -4067, -4061, -4056, -4056, -4056,
        -4056, -4056, -4057, -4059, -4050, -4049, -4049, -4039, -4039, -4039,
        -4038, -4036, -4037, -4039, -4039, -4039, -4038, -4038, -4039, -4037,
        -4032, -4025, -4024, -4020, -4013, -4008, -4012, -4012, -4012, -4011,
        -4011, -4011, -4011, -4011, -4011, -4006, -4007, -4006, -4004, -3998,
        -3998, -3999, -4002, -4000, -3998, -3997, -3996, -3998, -3997, -3994,
        -3988, -3987, -3989, -3987, -3987, -3986, -3987, -3984, -3983, -3986,
        -3987, -3992, -3992, -3997, -3997, -3997, -4001, -3999, -3995, -3989,
        -3986, -3987, -3990, -3988, -3989, -3987, -3986, -4000, -3998, -3996,
        -3992, -3986, -4010, -4008, -4009, -4017, -4014, -4014, -4011, -4022,
        -4017, -4010, -4015, -4024, -4034, -4046, -4056, -4058, -4069, -4084,
        -4088, -4090, -4088, -4094, -4096, -4098, -4102, -4100, -4103, -4108,
        -4117, -4098, -4108, -4110, -4111, -4106, -4103, -4108, -4116, -4114,
        -4117, -4118, -4121, -4124, -4149, -4141, -4136, -4136, -4168, -4163,
        -4163, -4163, -4172, -4173, -4182, -4182, -4177, -4173, -4177, -4173,
        -4170, -4169, -4160, -4161, -4164, -4168, -4168, -4168, -4169, -4173,
        -4171, -4168, -4167, -4161, -4157, -4155, -4155, -4152, -4147, -4141,
        -4141, -4135, -4137, -4132, -4135, -4128, -4132, -4125, -4125, -4125,
        -4127, -4127, -4127, -4117, -4122, -4119, -4122, -4127, -4123, -4118,
        -4113, -4108, -4108, -4100, -4105, -4097, -4099, -4101, -4099, -4096,
        -4093, -4093, -4092, -4090, -4090, -4087, -4084, -4084, -4084, -4082,
        -4080, -4086, -4086, -4085, -4087, -4083, -4078, -4078, -4078, -4078,
        -4078, -4081, -4083, -4085, -4081, -4077, -4074, -4070, -4071, -4071,
        -4073, -4076, -4078, -4080, -4081, -4081, -4081, -4081, -4081, -4081,
        -4081, -4085, -4090, -4095, -4100, -4101, -4102, -4102, -4102, -4102,
        -4102, -4102, -4102, -4107, -4107, -4112, -4117, -4117, -4122, -4121,
        -4121, -4122, -4130, -4133, -4139, -4142, -4144, -4142, -4147, -4152,
        -4155, -4160, -4162, -4161, -4164, -4168, -4173, -4167, -4168, -4178,
        -4183, -4181, -4178, -4173, -4173, -4179, -4177, -4176, -4167, -4163,
        -4158, -4157, -4156, -4155, -4152, -4158, -4160, -4167, -4168, -4164,
        -4165, -4165, -4155, -4149, -4146, -4146, -4146, -4140, -4133, -4136,
        -4142, -4132, -4127, -4123, -4116, -4113, -4102, -4104, -4110, -4112,
        -4112, -4110, -4107, -4100, -4097, -4097, -4093, -4091, -4086, -4083,
        -4076, -4063, -4053, -4040, -4038, -4030, -4023, -4024
    };

    static const int16_t fletcher_munson_curve_50_phons[1383] =
    {
        -717, -718, -719, -721, -721,
        -729, -731, -733, -734, -743, -740, -745, -747, -749, -753,
        -754, -755, -754, -760, -761, -764, -764, -767, -765, -765,
        -766, -764, -768, -766, -767, -767, -766, -768, -770, -777,
        -775, -781, -785, -789, -791, -798, -797, -796, -803, -803,
        -806, -815, -814, -821, -822, -828, -831, -836, -841, -846,
        -847, -853, -857, -864, -869, -867, -875, -867, -869, -868,
        -867, -869, -868, -874, -872, -879, -877, -879, -887, -890,
        -889, -897, -895, -898, -907, -905, -912, -917, -923, -930,
        -927, -935, -938, -945, -947, -953, -953, -955, -959, -961,
        -967, -965, -968, -970, -970, -970, -972, -975, -979, -981,
        -978, -983, -984, -982, -987, -987, -993, -999, -995, -1003,
        -1010, -1008, -1010, -1011, -1019, -1016, -1020, -1026, -1023, -1030,
        -1037, -1038, -1041, -1047, -1052, -1050, -1056, -1059, -1061, -1059,
        -1061, -1067, -1069, -1070, -1072, -1080, -1080, -1087, -1087, -1089,
        -1097, -1100, -1107, -1114, -1120, -1125, -1128, -1129, -1132, -1134,
        -1135, -1137, -1138, -1143, -1141, -1147, -1149, -1158, -1165, -1173,
        -1178, -1181, -1188, -1194, -1197, -1204, -1209, -1210, -1214, -1219,
        -1223, -1226, -1229, -1234, -1239, -1247, -1252, -1259, -1256, -1262,
        -1268, -1275, -1273, -1276, -1286, -1293, -1293, -1293, -1301, -1305,
        -1303, -1309, -1317, -1320, -1328, -1334, -1338, -1344, -1348, -1355,
        -1359, -1361, -1360, -1367, -1376, -1375, -1378, -1385, -1388, -1385,
        -1392, -1393, -1399, -1397, -1401, -1407, -1410, -1409, -1411, -1412,
        -1411, -1417, -1417, -1425, -1424, -1427, -1426, -1431, -1435, -1434,
        -1438, -1442, -1443, -1444, -1451, -1454, -1466, -1473, -1477, -1484,
        -1492, -1500, -1505, -1513, -1520, -1526, -1534, -1539, -1543, -1551,
        -1555, -1562, -1566, -1564, -1568, -1575, -1573, -1580, -1588, -1596,
        -1608, -1613, -1623, -1628, -1633, -1638, -1648, -1649, -1659, -1662,
        -1662, -1665, -1674, -1678, -1676, -1680, -1689, -1695, -1704, -1708,
        -1715, -1725, -1731, -1738, -1740, -1748, -1754, -1757, -1766, -1771,
        -1778, -1785, -1783, -1790, -1791, -1796, -1803, -1803, -1804, -1808,
        -1804, -1803, -1802, -1802, -1808, -1817, -1818, -1827, -1833, -1841,
        -1845, -1844, -1850, -1854, -1851, -1856, -1861, -1858, -1862, -1873,
        -1879, -1879, -1888, -1897, -1902, -1909, -1912, -1919, -1923, -1925,
        -1934, -1934, -1930, -1938, -1937, -1934, -1942, -1949, -1953, -1958,
        -1960, -1956, -1957, -1965, -1964, -1965, -1970, -1973, -1975, -1980,
        -1982, -1981, -1984, -1991, -1994, -1996, -1996, -1998, -2003, -2011,
        -2020, -2025, -2033, -2040, -2049, -2055, -2065, -2070, -2073, -2075,
        -2080, -2089, -2090, -2095, -2098, -2103, -2110, -2115, -2123, -2127,
        -2133, -2136, -2142, -2146, -2138, -2143, -2147, -2149, -2144, -2150,
        -2155, -2160, -2166, -2169, -2179, -2182, -2190, -2194, -2204, -2211,
        -2204, -2206, -2210, -2203, -2209, -2216, -2218, -2223, -2230, -2233,
        -2239, -2244, -2250, -2255, -2253, -2259, -2265, -2268, -2266, -2273,
        -2279, -2283, -2292, -2293, -2295, -2302, -2308, -2311, -2316, -2321,
        -2324, -2329, -2334, -2339, -2346, -2350, -2353, -2349, -2354, -2357,
        -2357, -2363, -2367, -2375, -2380, -2387, -2390, -2401, -2403, -2411,
        -2416, -2421, -2426, -2435, -2439, -2445, -2452, -2458, -2463, -2467,
        -2474, -2478, -2485, -2490, -2497, -2502, -2507, -2513, -2523, -2526,
        -2533, -2538, -2542, -2546, -2546, -2548, -2552, -2552, -2551, -2554,
        -2557, -2557, -2562, -2565, -2568, -2573, -2580, -2586, -2592, -2599,
        -2601, -2604, -2606, -2611, -2617, -2620, -2628, -2631, -2636, -2639,
        -2647, -2649, -2652, -2658, -2662, -2665, -2669, -2672, -2678, -2681,
        -2674, -2680, -2685, -2687, -2690, -2685, -2682, -2691, -2693, -2697,
        -2699, -2708, -2711, -2714, -2717, -2721, -2723, -2726, -2728, -2731,
        -2739, -2742, -2746, -2754, -2759, -2762, -2766, -2768, -2770, -2778,
        -2780, -2783, -2790, -2792, -2794, -2801, -2806, -2812, -2816, -2821,
        -2826, -2827, -2830, -2832, -2833, -2837, -2843, -2845, -2850, -2855,
        -2859, -2861, -2866, -2869, -2876, -2878, -2880, -2886, -2889, -2893,
        -2895, -2903, -2904, -2907, -2914, -2917, -2925, -2932, -2935, -2942,
        -2948, -2953, -2958, -2959, -2968, -2973, -2975, -2977, -2980, -2980,
        -2982, -2988, -2993, -2998, -3002, -3010, -3013, -3018, -3022, -3030,
        -3033, -3038, -3042, -3050, -3052, -3052, -3052, -3060, -3061, -3062,
        -3063, -3070, -3075, -3078, -3082, -3090, -3093, -3097, -3107, -3111,
        -3117, -3121, -3130, -3133, -3135, -3140, -3145, -3146, -3150, -3153,
        -3159, -3160, -3165, -3166, -3170, -3172, -3177, -3181, -3181, -3182,
        -3187, -3188, -3188, -3193, -3193, -3200, -3203, -3203, -3211, -3214,
        -3214, -3214, -3218, -3218, -3218, -3219, -3223, -3223, -3227, -3232,
        -3235, -3237, -3237, -3242, -3246, -3249, -3250, -3247, -3247, -3252,
        -3257, -3257, -3258, -3262, -3267, -3268, -3272, -3272, -3274, -3276,
        -3276, -3276, -3277, -3277, -3279, -3281, -3282, -3282, -3286, -3288,
        -3290, -3292, -3292, -3289, -3292, -3293, -3295, -3295, -3295, -3295,
        -3302, -3303, -3303, -3303, -3313, -3313, -3313, -3313, -3313, -3313,
        -3313, -3313, -3313, -3314, -3319, -3319, -3322, -3325, -3325, -3329,
        -3330, -3333, -3331, -3333, -3333, -3333, -3333, -3333, -3333, -3333,
        -3330, -3329, -3326, -3326, -3327, -3328, -3329, -3329, -3329, -3328,
        -3336, -3338, -3342, -3341, -3340, -3338, -3339, -3339, -3339, -3339,
        -3338, -3338, -3337, -3337, -3337, -3336, -3336, -3337, -3337, -3336,
        -3337, -3337, -3336, -3334, -3334, -3332, -3332, -3332, -3327, -3327,
        -3325, -3325, -3319, -3317, -3316, -3313, -3313, -3311, -3311, -3311,
        -3310, -3311, -3313, -3311, -3311, -3305, -3303, -3300, -3299, -3298,
        -3294, -3286, -3284, -3283, -3285, -3282, -3280, -3282, -3276, -3278,
        -3278, -3281, -3281, -3281, -3281, -3281, -3282, -3272, -3268, -3268,
        -3269, -3260, -3260, -3260, -3259, -3260, -3261, -3260, -3259, -3257,
        -3256, -3251, -3245, -3246, -3236, -3236, -3236, -3236, -3236, -3236,
        -3236, -3236, -3233, -3229, -3228, -3226, -3226, -3226, -3226, -3227,
        -3232, -3227, -3227, -3232, -3228, -3228, -3233, -3233, -3233, -3233,
        -3233, -3232, -3229, -3228, -3227, -3224, -3223, -3223, -3221, -3219,
        -3218, -3218, -3217, -3217, -3213, -3207, -3207, -3202, -3196, -3196,
        -3196, -3197, -3196, -3192, -3191, -3191, -3191, -3191, -3189, -3188,
        -3186, -3185, -3185, -3181, -3172, -3165, -3164, -3166, -3168, -3171,
        -3173, -3173, -3172, -3162, -3164, -3167, -3162, -3161, -3161, -3161,
        -3163, -3163, -3163, -3165, -3167, -3163, -3158, -3159, -3156, -3153,
        -3154, -3153, -3157, -3157, -3151, -3152, -3156, -3158, -3153, -3152,
        -3152, -3157, -3157, -3156, -3157, -3149, -3144, -3148, -3149, -3154,
        -3155, -3157, -3159, -3162, -3162, -3156, -3156, -3157, -3150, -3155,
        -3150, -3148, -3150, -3146, -3149, -3141, -3142, -3147, -3147, -3150,
        -3153, -3153, -3156, -3156, -3158, -3153, -3150, -3154, -3153, -3154,
        -3159, -3167, -3169, -3172, -3177, -3182, -3181, -3182, -3182, -3184,
        -3185, -3184, -3184, -3186, -3183, -3179, -3183, -3182, -3179, -3184,
        -3182, -3181, -3186, -3182, -3180, -3182, -3185, -3189, -3189, -3189,
        -3183, -3183, -3178, -3173, -3171, -3171, -3168, -3169, -3172, -3166,
        -3165, -3163, -3159, -3152, -3150, -3144, -3135, -3126, -3128, -3123,
        -3113, -3112, -3107, -3102, -3102, -3096, -3094, -3097, -3092, -3092,
        -3095, -3088, -3095, -3093, -3088, -3087, -3081, -3081, -3076, -3071,
        -3067, -3068, -3067, -3066, -3066, -3062, -3058, -3056, -3052, -3047,
        -3046, -3042, -3036, -3035, -3026, -3022, -3015, -3010, -3010, -3010,
        -3010, -3010, -3011, -3011, -3002, -3001, -3001, -2992, -2993, -2993,
        -2993, -2992, -2993, -2994, -2994, -2994, -2993, -2993, -2994, -2992,
        -2988, -2981, -2980, -2976, -2966, -2963, -2963, -2962, -2962, -2959,
        -2958, -2956, -2956, -2956, -2956, -2954, -2954, -2954, -2952, -2950,
        -2950, -2951, -2954, -2953, -2952, -2952, -2952, -2951, -2949, -2946,
        -2941, -2941, -2943, -2941, -2942, -2940, -2941, -2940, -2942, -2941,
        -2942, -2947, -2947, -2951, -2949, -2949, -2951, -2947, -2943, -2938,
        -2936, -2937, -2939, -2938, -2938, -2937, -2938, -2949, -2947, -2945,
        -2943, -2940, -2960, -2960, -2960, -2959, -2953, -2953, -2952, -2961,
        -2960, -2955, -2958, -2964, -2973, -2989, -2992, -2990, -2997, -3010,
        -3013, -3010, -3002, -3008, -3012, -3013, -3014, -3011, -3017, -3024,
        -3026, -3021, -3026, -3027, -3029, -3025, -3024, -3028, -3033, -3029,
        -3030, -3028, -3030, -3031, -3056, -3050, -3045, -3045, -3079, -3074,
        -3072, -3071, -3079, -3083, -3089, -3087, -3084, -3082, -3085, -3081,
        -3080, -3082, -3075, -3076, -3077, -3079, -3077, -3077, -3080, -3084,
        -3084, -3082, -3082, -3078, -3075, -3074, -3076, -3072, -3070, -3068,
        -3065, -3064, -3066, -3061, -3067, -3062, -3066, -3063, -3066, -3068,
        -3074, -3077, -3077, -3069, -3069, -3069, -3072, -3077, -3075, -3070,
        -3067, -3065, -3065, -3061, -3068, -3062, -3064, -3069, -3068, -3067,
        -3067, -3067, -3066, -3065, -3066, -3065, -3064, -3063, -3063, -3062,
        -3062, -3070, -3072, -3073, -3078, -3076, -3073, -3073, -3073, -3073,
        -3074, -3076, -3079, -3080, -3079, -3077, -3076, -3074, -3075, -3075,
        -3078, -3080, -3082, -3085, -3085, -3086, -3085, -3085, -3085, -3085,
        -3085, -3088, -3090, -3095, -3100, -3103, -3106, -3106, -3106, -3106,
        -3106, -3106, -3106, -3111, -3111, -3114, -3119, -3119, -3123, -3120,
        -3122, -3123, -3128, -3130, -3135, -3137, -3137, -3132, -3137, -3142,
        -3144, -3146, -3146, -3142, -3143, -3147, -3154, -3149, -3148, -3157,
        -3160, -3158, -3155, -3153, -3153, -3157, -3152, -3151, -3142, -3138,
        -3132, -3134, -3132, -3132, -3127, -3131, -3134, -3141, -3140, -3135,
        -3135, -3135, -3125, -3120, -3112, -3111, -3111, -3107, -3098, -3100,
        -3105, -3099, -3096, -3093, -3088, -3085, -3076, -3078, -3082, -3082,
        -3080, -3081, -3077, -3070, -3068, -3066, -3063, -3059, -3052, -3049,
        -3040, -3028, -3023, -3010, -3006, -3002, -2997, -2999
    };

    static const int16_t fletcher_munson_curve_60_phons[1383] =
    {
        -517, -520, -520, -524, -520,
        -528, -529, -530, -531, -540, -533, -540, -544, -542, -545,
        -551, -548, -551, -557, -554, -557, -556, -557, -556, -554,
        -556, -552, -556, -552, -553, -551, -551, -552, -551, -560,
        -557, -562, -566, -567, -568, -577, -577, -572, -577, -578,
        -578, -586, -583, -592, -589, -596, -599, -601, -604, -609,
        -609, -615, -617, -625, -629, -629, -635, -625, -629, -625,
        -625, -625, -623, -629, -625, -630, -630, -631, -636, -640,
        -640, -646, -642, -646, -655, -651, -656, -661, -667, -672,
        -667, -672, -677, -683, -682, -688, -687, -688, -689, -688,
        -698, -693, -698, -699, -699, -699, -698, -705, -707, -710,
        -704, -709, -710, -706, -712, -708, -714, -719, -716, -724,
        -730, -725, -725, -726, -732, -727, -730, -734, -730, -735,
        -740, -739, -740, -746, -750, -746, -749, -751, -751, -748,
        -751, -756, -756, -757, -761, -769, -767, -772, -772, -772,
        -777, -777, -782, -788, -793, -798, -799, -799, -803, -805,
        -804, -808, -806, -814, -810, -814, -815, -824, -828, -835,
        -840, -838, -845, -850, -851, -858, -861, -861, -865, -869,
        -872, -876, -878, -882, -887, -893, -898, -907, -901, -908,
        -914, -919, -918, -921, -929, -934, -936, -935, -940, -945,
        -943, -946, -952, -956, -965, -966, -971, -977, -979, -987,
        -987, -989, -988, -993, -1005, -1005, -1004, -1013, -1014, -1009,
        -1013, -1014, -1018, -1013, -1014, -1023, -1022, -1019, -1019, -1017,
        -1018, -1023, -1020, -1028, -1026, -1030, -1027, -1029, -1031, -1030,
        -1034, -1034, -1037, -1035, -1043, -1045, -1056, -1061, -1066, -1071,
        -1076, -1082, -1087, -1093, -1098, -1103, -1111, -1113, -1118, -1124,
        -1124, -1134, -1134, -1132, -1134, -1139, -1135, -1139, -1145, -1150,
        -1160, -1163, -1171, -1171, -1176, -1182, -1192, -1192, -1202, -1203,
        -1206, -1204, -1213, -1216, -1213, -1215, -1223, -1226, -1234, -1239,
        -1245, -1255, -1260, -1266, -1266, -1274, -1276, -1276, -1286, -1287,
        -1291, -1296, -1292, -1297, -1298, -1300, -1306, -1303, -1304, -1308,
        -1303, -1302, -1299, -1302, -1304, -1312, -1314, -1322, -1325, -1333,
        -1335, -1333, -1338, -1342, -1339, -1344, -1349, -1345, -1350, -1362,
        -1365, -1365, -1373, -1381, -1382, -1391, -1392, -1399, -1402, -1402,
        -1411, -1409, -1404, -1412, -1407, -1407, -1412, -1418, -1423, -1429,
        -1432, -1428, -1427, -1433, -1428, -1430, -1434, -1434, -1433, -1439,
        -1436, -1434, -1434, -1444, -1444, -1445, -1446, -1445, -1450, -1457,
        -1464, -1470, -1476, -1481, -1488, -1492, -1501, -1502, -1502, -1502,
        -1502, -1512, -1512, -1512, -1512, -1520, -1523, -1528, -1539, -1542,
        -1549, -1549, -1556, -1559, -1549, -1553, -1557, -1557, -1549, -1555,
        -1560, -1564, -1570, -1572, -1580, -1581, -1591, -1591, -1601, -1606,
        -1597, -1596, -1596, -1587, -1590, -1595, -1598, -1602, -1611, -1613,
        -1617, -1622, -1626, -1629, -1623, -1628, -1633, -1631, -1628, -1633,
        -1633, -1633, -1641, -1639, -1638, -1644, -1649, -1649, -1654, -1659,
        -1659, -1665, -1670, -1670, -1677, -1680, -1680, -1671, -1673, -1672,
        -1672, -1675, -1680, -1685, -1686, -1696, -1696, -1706, -1707, -1717,
        -1717, -1723, -1728, -1735, -1738, -1745, -1748, -1758, -1764, -1768,
        -1775, -1779, -1785, -1791, -1796, -1801, -1806, -1812, -1822, -1823,
        -1832, -1832, -1836, -1841, -1839, -1843, -1846, -1849, -1843, -1849,
        -1852, -1849, -1856, -1857, -1858, -1858, -1862, -1865, -1875, -1880,
        -1880, -1880, -1880, -1885, -1890, -1891, -1900, -1901, -1904, -1906,
        -1916, -1917, -1918, -1923, -1927, -1927, -1931, -1933, -1938, -1937,
        -1931, -1934, -1938, -1938, -1937, -1928, -1922, -1932, -1932, -1932,
        -1933, -1943, -1943, -1943, -1943, -1943, -1943, -1943, -1943, -1944,
        -1953, -1954, -1958, -1966, -1968, -1969, -1969, -1969, -1969, -1979,
        -1978, -1977, -1986, -1986, -1986, -1995, -1996, -1999, -2006, -2006,
        -2006, -2006, -2006, -2006, -2006, -2006, -2016, -2016, -2021, -2027,
        -2029, -2032, -2033, -2039, -2043, -2043, -2046, -2048, -2052, -2053,
        -2056, -2062, -2064, -2065, -2074, -2075, -2084, -2090, -2095, -2100,
        -2109, -2111, -2111, -2112, -2121, -2121, -2121, -2121, -2121, -2121,
        -2121, -2128, -2132, -2135, -2137, -2147, -2148, -2148, -2148, -2159,
        -2159, -2159, -2160, -2169, -2168, -2166, -2164, -2174, -2173, -2171,
        -2170, -2178, -2182, -2183, -2184, -2195, -2195, -2195, -2205, -2206,
        -2211, -2211, -2221, -2221, -2222, -2226, -2231, -2232, -2233, -2237,
        -2241, -2242, -2243, -2244, -2245, -2247, -2248, -2251, -2251, -2249,
        -2248, -2247, -2247, -2247, -2248, -2258, -2258, -2258, -2268, -2268,
        -2268, -2268, -2268, -2268, -2269, -2269, -2269, -2269, -2269, -2273,
        -2274, -2274, -2274, -2274, -2278, -2279, -2277, -2275, -2274, -2276,
        -2285, -2284, -2284, -2285, -2294, -2295, -2295, -2295, -2295, -2295,
        -2295, -2295, -2295, -2295, -2297, -2300, -2300, -2300, -2305, -2308,
        -2310, -2311, -2310, -2308, -2310, -2311, -2316, -2316, -2316, -2316,
        -2321, -2321, -2321, -2321, -2331, -2332, -2332, -2332, -2332, -2332,
        -2332, -2332, -2332, -2333, -2342, -2342, -2347, -2353, -2353, -2356,
        -2358, -2360, -2358, -2363, -2363, -2363, -2363, -2363, -2363, -2362,
        -2359, -2359, -2353, -2353, -2354, -2355, -2356, -2357, -2356, -2353,
        -2360, -2363, -2363, -2361, -2355, -2353, -2353, -2353, -2353, -2351,
        -2349, -2347, -2342, -2342, -2342, -2337, -2337, -2337, -2337, -2337,
        -2337, -2337, -2337, -2337, -2337, -2337, -2337, -2337, -2332, -2332,
        -2332, -2332, -2326, -2321, -2321, -2316, -2316, -2311, -2311, -2311,
        -2310, -2311, -2316, -2311, -2311, -2305, -2305, -2300, -2299, -2298,
        -2291, -2279, -2277, -2273, -2273, -2270, -2268, -2268, -2262, -2269,
        -2269, -2274, -2274, -2274, -2274, -2274, -2274, -2264, -2260, -2260,
        -2261, -2252, -2253, -2252, -2251, -2251, -2251, -2249, -2247, -2247,
        -2247, -2241, -2236, -2237, -2227, -2227, -2228, -2227, -2227, -2226,
        -2226, -2226, -2226, -2226, -2226, -2226, -2226, -2226, -2226, -2227,
        -2236, -2232, -2232, -2241, -2237, -2237, -2242, -2242, -2242, -2242,
        -2242, -2241, -2238, -2237, -2237, -2233, -2232, -2232, -2231, -2228,
        -2227, -2227, -2227, -2226, -2222, -2216, -2216, -2211, -2205, -2206,
        -2208, -2211, -2210, -2203, -2200, -2200, -2200, -2200, -2195, -2193,
        -2190, -2190, -2189, -2184, -2174, -2166, -2164, -2164, -2163, -2163,
        -2163, -2163, -2163, -2153, -2153, -2153, -2148, -2142, -2142, -2142,
        -2142, -2142, -2142, -2142, -2142, -2136, -2128, -2127, -2124, -2119,
        -2117, -2116, -2116, -2116, -2107, -2106, -2106, -2105, -2100, -2095,
        -2095, -2095, -2095, -2095, -2093, -2085, -2080, -2079, -2079, -2079,
        -2079, -2079, -2079, -2079, -2077, -2070, -2067, -2068, -2062, -2064,
        -2058, -2053, -2055, -2053, -2053, -2045, -2044, -2053, -2053, -2058,
        -2063, -2064, -2069, -2069, -2069, -2062, -2058, -2063, -2059, -2058,
        -2059, -2069, -2069, -2069, -2075, -2079, -2078, -2079, -2079, -2082,
        -2085, -2084, -2086, -2090, -2087, -2083, -2089, -2089, -2085, -2092,
        -2091, -2087, -2095, -2091, -2091, -2095, -2100, -2100, -2101, -2100,
        -2094, -2096, -2091, -2085, -2083, -2085, -2082, -2084, -2091, -2085,
        -2085, -2085, -2083, -2079, -2077, -2076, -2069, -2060, -2064, -2061,
        -2049, -2048, -2043, -2037, -2037, -2032, -2032, -2037, -2034, -2038,
        -2042, -2038, -2043, -2043, -2037, -2037, -2031, -2026, -2022, -2017,
        -2012, -2016, -2017, -2018, -2020, -2016, -2012, -2011, -2006, -2001,
        -2000, -1996, -1990, -1990, -1980, -1976, -1969, -1964, -1964, -1964,
        -1964, -1964, -1964, -1963, -1954, -1953, -1953, -1944, -1947, -1948,
        -1948, -1948, -1948, -1948, -1948, -1948, -1948, -1948, -1948, -1948,
        -1944, -1937, -1936, -1932, -1919, -1917, -1913, -1912, -1912, -1906,
        -1905, -1901, -1901, -1901, -1901, -1901, -1901, -1901, -1901, -1901,
        -1901, -1903, -1906, -1906, -1906, -1906, -1907, -1904, -1901, -1899,
        -1894, -1896, -1898, -1896, -1898, -1895, -1895, -1897, -1901, -1897,
        -1896, -1901, -1901, -1906, -1901, -1901, -1900, -1895, -1891, -1886,
        -1886, -1887, -1888, -1888, -1887, -1886, -1890, -1898, -1897, -1894,
        -1894, -1894, -1910, -1911, -1912, -1902, -1891, -1891, -1893, -1899,
        -1903, -1900, -1900, -1905, -1913, -1931, -1928, -1922, -1925, -1936,
        -1938, -1929, -1916, -1921, -1929, -1927, -1926, -1922, -1931, -1940,
        -1936, -1943, -1943, -1945, -1946, -1945, -1944, -1947, -1950, -1944,
        -1943, -1939, -1939, -1937, -1963, -1959, -1954, -1954, -1990, -1985,
        -1980, -1979, -1987, -1993, -1995, -1992, -1990, -1991, -1992, -1990,
        -1990, -1995, -1990, -1990, -1990, -1990, -1986, -1986, -1991, -1995,
        -1998, -1996, -1998, -1995, -1992, -1992, -1996, -1993, -1992, -1995,
        -1990, -1993, -1994, -1990, -1998, -1995, -1999, -2002, -2007, -2011,
        -2021, -2026, -2027, -2021, -2017, -2019, -2022, -2027, -2027, -2022,
        -2022, -2022, -2022, -2022, -2031, -2027, -2030, -2038, -2038, -2038,
        -2040, -2042, -2041, -2041, -2042, -2043, -2043, -2043, -2043, -2042,
        -2043, -2053, -2058, -2061, -2069, -2069, -2069, -2069, -2068, -2068,
        -2069, -2071, -2074, -2076, -2076, -2077, -2079, -2079, -2079, -2080,
        -2082, -2084, -2087, -2089, -2090, -2090, -2090, -2090, -2090, -2090,
        -2090, -2090, -2090, -2095, -2100, -2105, -2111, -2111, -2111, -2111,
        -2111, -2111, -2111, -2116, -2116, -2116, -2121, -2121, -2125, -2120,
        -2123, -2124, -2125, -2127, -2131, -2131, -2129, -2122, -2127, -2132,
        -2133, -2132, -2131, -2123, -2123, -2127, -2135, -2130, -2127, -2135,
        -2137, -2135, -2132, -2132, -2132, -2134, -2127, -2125, -2117, -2112,
        -2107, -2110, -2108, -2109, -2102, -2104, -2108, -2114, -2112, -2105,
        -2105, -2105, -2096, -2091, -2079, -2077, -2076, -2073, -2062, -2063,
        -2069, -2065, -2064, -2063, -2059, -2057, -2050, -2051, -2055, -2053,
        -2048, -2051, -2048, -2040, -2038, -2036, -2033, -2027, -2018, -2016,
        -2003, -1993, -1993, -1981, -1975, -1975, -1972, -1975
    };

    static const int16_t fletcher_munson_curve_70_phons[1383] =
    {
        -292, -294, -294, -296, -294,
        -298, -299, -300, -300, -305, -301, -305, -307, -306, -308,
        -312, -310, -312, -315, -313, -315, -315, -315, -314, -313,
        -314, -312, -314, -312, -313, -312, -312, -312, -312, -317,
        -315, -318, -320, -321, -321, -326, -326, -323, -326, -326,
        -327, -331, -330, -335, -333, -337, -338, -340, -341, -344,
        -344, -348, -349, -353, -356, -356, -359, -354, -356, -353,
        -353, -353, -352, -356, -353, -356, -356, -357, -359, -362,
        -362, -365, -363, -365, -370, -368, -371, -374, -377, -380,
        -377, -380, -383, -386, -386, -389, -389, -389, -390, -389,
        -394, -392, -395, -395, -395, -395, -394, -398, -400, -402,
        -398, -401, -401, -399, -403, -400, -404, -406, -404, -409,
        -412, -410, -410, -410, -414, -411, -413, -415, -413, -416,
        -418, -418, -418, -421, -424, -422, -423, -424, -424, -423,
        -424, -427, -427, -428, -430, -435, -433, -436, -436, -436,
        -439, -439, -442, -445, -448, -451, -452, -452, -454, -455,
        -455, -457, -456, -460, -458, -460, -461, -466, -468, -472,
        -475, -474, -478, -480, -481, -485, -487, -487, -489, -491,
        -493, -495, -496, -498, -501, -505, -508, -513, -509, -513,
        -517, -519, -519, -521, -525, -528, -529, -528, -531, -534,
        -533, -535, -538, -540, -545, -546, -549, -552, -553, -558,
        -558, -559, -558, -561, -568, -568, -567, -573, -573, -570,
        -573, -573, -575, -573, -573, -578, -578, -576, -576, -575,
        -576, -578, -576, -581, -580, -582, -580, -582, -583, -582,
        -585, -584, -586, -585, -590, -591, -597, -600, -603, -605,
        -608, -611, -614, -618, -620, -623, -628, -629, -632, -635,
        -635, -641, -641, -640, -641, -644, -641, -644, -647, -650,
        -656, -657, -662, -662, -665, -668, -674, -674, -680, -680,
        -681, -681, -686, -687, -686, -687, -691, -693, -697, -700,
        -704, -709, -712, -715, -715, -720, -721, -721, -727, -727,
        -729, -733, -730, -733, -733, -735, -738, -737, -737, -739,
        -736, -736, -734, -736, -737, -742, -743, -747, -749, -754,
        -754, -754, -756, -759, -757, -760, -763, -760, -763, -770,
        -772, -772, -776, -780, -781, -786, -787, -791, -792, -793,
        -798, -796, -793, -798, -795, -795, -798, -801, -804, -808,
        -809, -807, -806, -810, -807, -808, -810, -810, -810, -813,
        -812, -811, -811, -816, -816, -817, -817, -817, -820, -823,
        -828, -831, -834, -837, -841, -843, -848, -849, -849, -849,
        -849, -855, -855, -855, -855, -859, -861, -864, -870, -872,
        -875, -876, -879, -881, -876, -878, -880, -880, -876, -879,
        -882, -884, -887, -888, -893, -893, -899, -899, -905, -908,
        -903, -902, -902, -897, -899, -901, -903, -905, -911, -911,
        -914, -917, -919, -921, -917, -920, -923, -922, -920, -923,
        -923, -923, -928, -926, -926, -929, -932, -932, -935, -938,
        -938, -941, -944, -944, -948, -950, -950, -944, -946, -945,
        -945, -947, -950, -953, -953, -959, -959, -964, -965, -970,
        -971, -974, -976, -981, -982, -986, -988, -994, -997, -999,
        -1003, -1006, -1009, -1012, -1015, -1018, -1021, -1024, -1030, -1030,
        -1036, -1036, -1038, -1040, -1040, -1042, -1043, -1045, -1042, -1045,
        -1047, -1045, -1049, -1050, -1050, -1050, -1053, -1054, -1060, -1063,
        -1063, -1063, -1063, -1066, -1068, -1069, -1074, -1074, -1076, -1078,
        -1083, -1083, -1084, -1087, -1089, -1089, -1092, -1092, -1095, -1095,
        -1092, -1093, -1095, -1095, -1095, -1089, -1087, -1092, -1092, -1092,
        -1093, -1098, -1098, -1098, -1098, -1098, -1098, -1098, -1098, -1099,
        -1104, -1104, -1107, -1111, -1112, -1113, -1113, -1113, -1113, -1119,
        -1118, -1117, -1123, -1122, -1122, -1128, -1128, -1130, -1134, -1134,
        -1134, -1134, -1134, -1134, -1134, -1134, -1140, -1140, -1142, -1146,
        -1147, -1149, -1149, -1152, -1155, -1155, -1156, -1158, -1160, -1161,
        -1162, -1166, -1166, -1167, -1172, -1173, -1178, -1181, -1184, -1187,
        -1192, -1193, -1193, -1194, -1199, -1199, -1199, -1199, -1199, -1199,
        -1199, -1203, -1205, -1207, -1208, -1214, -1214, -1214, -1214, -1220,
        -1220, -1220, -1221, -1226, -1225, -1224, -1223, -1229, -1228, -1227,
        -1227, -1231, -1233, -1234, -1235, -1240, -1241, -1241, -1246, -1247,
        -1250, -1250, -1255, -1255, -1256, -1258, -1261, -1261, -1262, -1264,
        -1267, -1267, -1268, -1268, -1269, -1270, -1271, -1272, -1272, -1271,
        -1270, -1270, -1270, -1270, -1271, -1276, -1276, -1276, -1282, -1282,
        -1282, -1282, -1282, -1282, -1282, -1282, -1283, -1282, -1282, -1285,
        -1285, -1285, -1285, -1285, -1287, -1288, -1287, -1286, -1286, -1286,
        -1291, -1291, -1291, -1291, -1297, -1297, -1297, -1297, -1297, -1297,
        -1297, -1297, -1297, -1297, -1298, -1300, -1300, -1300, -1303, -1304,
        -1306, -1306, -1305, -1304, -1306, -1306, -1309, -1309, -1309, -1309,
        -1312, -1312, -1312, -1312, -1318, -1318, -1318, -1318, -1318, -1318,
        -1318, -1318, -1318, -1319, -1324, -1324, -1327, -1330, -1330, -1332,
        -1333, -1334, -1333, -1336, -1336, -1336, -1336, -1335, -1335, -1335,
        -1333, -1333, -1330, -1330, -1331, -1331, -1332, -1332, -1332, -1330,
        -1334, -1336, -1336, -1334, -1331, -1330, -1330, -1330, -1330, -1329,
        -1328, -1327, -1324, -1324, -1324, -1321, -1321, -1321, -1321, -1321,
        -1321, -1321, -1321, -1321, -1321, -1321, -1321, -1321, -1318, -1318,
        -1318, -1318, -1315, -1312, -1312, -1309, -1309, -1306, -1306, -1306,
        -1306, -1306, -1309, -1306, -1306, -1303, -1303, -1300, -1299, -1299,
        -1295, -1288, -1287, -1285, -1285, -1283, -1282, -1282, -1279, -1282,
        -1282, -1285, -1285, -1285, -1285, -1285, -1285, -1280, -1277, -1277,
        -1278, -1273, -1273, -1273, -1272, -1272, -1272, -1271, -1270, -1270,
        -1270, -1267, -1264, -1264, -1259, -1259, -1259, -1259, -1258, -1258,
        -1258, -1258, -1258, -1258, -1258, -1258, -1258, -1258, -1258, -1259,
        -1264, -1261, -1262, -1267, -1265, -1264, -1267, -1267, -1267, -1267,
        -1267, -1267, -1265, -1265, -1264, -1262, -1261, -1261, -1261, -1259,
        -1259, -1259, -1258, -1258, -1256, -1253, -1253, -1250, -1247, -1247,
        -1248, -1249, -1249, -1245, -1244, -1244, -1244, -1243, -1241, -1240,
        -1238, -1238, -1237, -1234, -1229, -1224, -1223, -1223, -1223, -1223,
        -1223, -1223, -1222, -1217, -1217, -1217, -1214, -1211, -1211, -1211,
        -1211, -1211, -1211, -1211, -1210, -1207, -1203, -1202, -1200, -1198,
        -1197, -1196, -1196, -1196, -1191, -1190, -1190, -1190, -1187, -1184,
        -1184, -1184, -1184, -1184, -1183, -1178, -1176, -1175, -1175, -1175,
        -1175, -1175, -1175, -1175, -1174, -1170, -1168, -1169, -1166, -1166,
        -1163, -1161, -1162, -1160, -1160, -1156, -1155, -1160, -1161, -1163,
        -1166, -1167, -1169, -1169, -1169, -1166, -1163, -1166, -1164, -1163,
        -1164, -1169, -1169, -1169, -1173, -1175, -1174, -1175, -1175, -1177,
        -1178, -1178, -1179, -1181, -1179, -1177, -1181, -1181, -1179, -1182,
        -1182, -1180, -1184, -1182, -1182, -1184, -1187, -1187, -1187, -1187,
        -1184, -1185, -1182, -1178, -1177, -1178, -1177, -1178, -1182, -1179,
        -1178, -1179, -1177, -1175, -1174, -1173, -1169, -1164, -1166, -1165,
        -1158, -1158, -1155, -1152, -1152, -1148, -1149, -1151, -1150, -1152,
        -1154, -1152, -1155, -1155, -1152, -1151, -1148, -1145, -1143, -1140,
        -1137, -1139, -1140, -1141, -1142, -1140, -1137, -1136, -1134, -1131,
        -1131, -1128, -1125, -1125, -1119, -1117, -1113, -1110, -1110, -1110,
        -1110, -1110, -1110, -1110, -1104, -1104, -1104, -1099, -1101, -1101,
        -1101, -1101, -1101, -1101, -1101, -1101, -1101, -1101, -1101, -1101,
        -1099, -1095, -1094, -1092, -1085, -1084, -1082, -1080, -1080, -1078,
        -1077, -1075, -1075, -1075, -1075, -1075, -1075, -1075, -1075, -1075,
        -1075, -1075, -1077, -1077, -1077, -1077, -1078, -1076, -1075, -1073,
        -1071, -1071, -1073, -1071, -1073, -1071, -1071, -1072, -1074, -1072,
        -1072, -1074, -1074, -1077, -1075, -1075, -1074, -1071, -1069, -1066,
        -1066, -1066, -1067, -1067, -1066, -1066, -1068, -1073, -1072, -1071,
        -1071, -1071, -1079, -1080, -1080, -1075, -1069, -1069, -1070, -1073,
        -1076, -1074, -1074, -1077, -1081, -1092, -1090, -1086, -1088, -1094,
        -1095, -1090, -1083, -1086, -1090, -1089, -1089, -1086, -1092, -1096,
        -1094, -1098, -1098, -1099, -1100, -1099, -1099, -1101, -1102, -1099,
        -1098, -1096, -1096, -1095, -1109, -1107, -1104, -1104, -1125, -1122,
        -1119, -1119, -1123, -1126, -1128, -1126, -1125, -1126, -1126, -1125,
        -1125, -1128, -1125, -1125, -1125, -1125, -1123, -1123, -1125, -1128,
        -1129, -1128, -1129, -1128, -1126, -1126, -1128, -1127, -1126, -1128,
        -1125, -1127, -1127, -1125, -1129, -1128, -1130, -1131, -1134, -1137,
        -1142, -1145, -1145, -1142, -1140, -1141, -1143, -1145, -1145, -1143,
        -1143, -1143, -1143, -1143, -1148, -1146, -1147, -1152, -1152, -1152,
        -1153, -1154, -1154, -1153, -1154, -1155, -1155, -1155, -1155, -1154,
        -1155, -1160, -1163, -1165, -1169, -1169, -1169, -1169, -1169, -1169,
        -1169, -1171, -1172, -1173, -1174, -1174, -1175, -1175, -1175, -1175,
        -1177, -1178, -1179, -1181, -1181, -1181, -1181, -1181, -1181, -1181,
        -1181, -1181, -1181, -1184, -1187, -1190, -1193, -1193, -1193, -1193,
        -1193, -1193, -1193, -1196, -1196, -1196, -1199, -1199, -1201, -1198,
        -1200, -1201, -1201, -1202, -1205, -1205, -1204, -1200, -1202, -1205,
        -1206, -1205, -1204, -1200, -1200, -1202, -1207, -1204, -1202, -1207,
        -1208, -1207, -1205, -1205, -1205, -1206, -1202, -1201, -1196, -1194,
        -1191, -1193, -1191, -1192, -1188, -1189, -1192, -1195, -1194, -1190,
        -1190, -1190, -1185, -1182, -1175, -1174, -1173, -1172, -1166, -1166,
        -1169, -1167, -1167, -1166, -1164, -1163, -1159, -1159, -1161, -1160,
        -1158, -1159, -1157, -1153, -1152, -1151, -1149, -1146, -1141, -1139,
        -1132, -1126, -1127, -1120, -1116, -1116, -1115, -1116
    };

    static const int16_t fletcher_munson_curve_80_phons[1383] =
    {
        -67, -68, -68, -68, -68,
        -69, -69, -69, -69, -70, -69, -70, -71, -71, -71,
        -72, -71, -72, -73, -72, -73, -73, -73, -73, -72,
        -73, -72, -72, -72, -72, -72, -72, -72, -72, -73,
        -73, -73, -74, -74, -74, -75, -75, -75, -75, -75,
        -75, -76, -76, -77, -77, -78, -78, -78, -79, -79,
        -79, -80, -80, -81, -82, -82, -83, -82, -82, -82,
        -82, -82, -81, -82, -82, -82, -82, -82, -83, -84,
        -84, -84, -84, -84, -85, -85, -86, -86, -87, -88,
        -87, -88, -88, -89, -89, -90, -90, -90, -90, -90,
        -91, -90, -91, -91, -91, -91, -91, -92, -92, -93,
        -92, -92, -93, -92, -93, -92, -93, -94, -93, -94,
        -95, -95, -95, -95, -96, -95, -95, -96, -95, -96,
        -97, -96, -97, -97, -98, -97, -98, -98, -98, -98,
        -98, -99, -99, -99, -99, -100, -100, -101, -101, -101,
        -101, -101, -102, -103, -103, -104, -104, -104, -105, -105,
        -105, -105, -105, -106, -106, -106, -106, -108, -108, -109,
        -110, -109, -110, -111, -111, -112, -112, -112, -113, -113,
        -114, -114, -114, -115, -116, -116, -117, -118, -118, -118,
        -119, -120, -120, -120, -121, -122, -122, -122, -123, -123,
        -123, -123, -124, -125, -126, -126, -127, -127, -128, -129,
        -129, -129, -129, -130, -131, -131, -131, -132, -132, -132,
        -132, -132, -133, -132, -132, -133, -133, -133, -133, -133,
        -133, -133, -133, -134, -134, -134, -134, -134, -134, -134,
        -135, -135, -135, -135, -136, -136, -138, -138, -139, -140,
        -140, -141, -142, -143, -143, -144, -145, -145, -146, -147,
        -147, -148, -148, -148, -148, -149, -148, -149, -149, -150,
        -151, -152, -153, -153, -153, -154, -155, -156, -157, -157,
        -157, -157, -158, -159, -158, -158, -160, -160, -161, -162,
        -162, -164, -164, -165, -165, -166, -166, -166, -168, -168,
        -168, -169, -169, -169, -169, -170, -170, -170, -170, -171,
        -170, -170, -169, -170, -170, -171, -171, -172, -173, -174,
        -174, -174, -174, -175, -175, -175, -176, -175, -176, -178,
        -178, -178, -179, -180, -180, -181, -182, -183, -183, -183,
        -184, -184, -183, -184, -184, -183, -184, -185, -186, -186,
        -187, -186, -186, -187, -186, -187, -187, -187, -187, -188,
        -187, -187, -187, -188, -188, -189, -189, -189, -189, -190,
        -191, -192, -192, -193, -194, -195, -196, -196, -196, -196,
        -196, -197, -197, -197, -197, -198, -199, -199, -201, -201,
        -202, -202, -203, -203, -202, -203, -203, -203, -202, -203,
        -203, -204, -205, -205, -206, -206, -207, -208, -209, -210,
        -208, -208, -208, -207, -207, -208, -208, -209, -210, -210,
        -211, -212, -212, -213, -212, -212, -213, -213, -212, -213,
        -213, -213, -214, -214, -214, -214, -215, -215, -216, -216,
        -216, -217, -218, -218, -219, -219, -219, -218, -218, -218,
        -218, -219, -219, -220, -220, -221, -221, -223, -223, -224,
        -224, -225, -225, -226, -227, -228, -228, -229, -230, -231,
        -231, -232, -233, -234, -234, -235, -236, -236, -238, -238,
        -239, -239, -240, -240, -240, -240, -241, -241, -240, -241,
        -242, -241, -242, -242, -242, -242, -243, -243, -245, -245,
        -245, -245, -245, -246, -247, -247, -248, -248, -248, -249,
        -250, -250, -250, -251, -251, -251, -252, -252, -253, -253,
        -252, -252, -253, -253, -253, -251, -251, -252, -252, -252,
        -252, -253, -253, -253, -253, -253, -253, -253, -253, -254,
        -255, -255, -255, -256, -257, -257, -257, -257, -257, -258,
        -258, -258, -259, -259, -259, -260, -260, -261, -262, -262,
        -262, -262, -262, -262, -262, -262, -263, -263, -264, -264,
        -265, -265, -265, -266, -266, -266, -267, -267, -268, -268,
        -268, -269, -269, -269, -271, -271, -272, -273, -273, -274,
        -275, -275, -275, -275, -277, -277, -277, -277, -277, -277,
        -277, -278, -278, -278, -279, -280, -280, -280, -280, -282,
        -282, -282, -282, -283, -283, -283, -282, -284, -283, -283,
        -283, -284, -285, -285, -285, -286, -286, -286, -288, -288,
        -288, -288, -290, -290, -290, -290, -291, -291, -291, -292,
        -292, -292, -293, -293, -293, -293, -293, -294, -294, -293,
        -293, -293, -293, -293, -293, -294, -295, -295, -296, -296,
        -296, -296, -296, -296, -296, -296, -296, -296, -296, -297,
        -297, -297, -297, -297, -297, -297, -297, -297, -297, -297,
        -298, -298, -298, -298, -299, -299, -299, -299, -299, -299,
        -299, -299, -299, -299, -300, -300, -300, -300, -301, -301,
        -301, -301, -301, -301, -301, -301, -302, -302, -302, -302,
        -303, -303, -303, -303, -304, -304, -304, -304, -304, -304,
        -304, -304, -304, -304, -305, -305, -306, -307, -307, -307,
        -308, -308, -308, -308, -308, -308, -308, -308, -308, -308,
        -308, -308, -307, -307, -307, -307, -307, -307, -307, -307,
        -308, -308, -308, -308, -307, -307, -307, -307, -307, -307,
        -306, -306, -305, -305, -305, -305, -305, -305, -305, -305,
        -305, -305, -305, -305, -305, -305, -305, -305, -304, -304,
        -304, -304, -303, -303, -303, -302, -302, -301, -301, -301,
        -301, -301, -302, -301, -301, -301, -301, -300, -300, -300,
        -299, -297, -297, -297, -296, -296, -296, -296, -295, -296,
        -296, -297, -297, -297, -297, -297, -297, -295, -295, -295,
        -295, -294, -294, -294, -294, -294, -294, -293, -293, -293,
        -293, -292, -292, -292, -291, -290, -291, -290, -290, -290,
        -290, -290, -290, -290, -290, -290, -290, -290, -290, -290,
        -292, -291, -291, -292, -292, -292, -292, -292, -292, -292,
        -292, -292, -292, -292, -292, -291, -291, -291, -291, -291,
        -290, -290, -290, -290, -290, -289, -289, -288, -288, -288,
        -288, -288, -288, -287, -287, -287, -287, -287, -286, -286,
        -286, -286, -286, -285, -284, -282, -282, -282, -282, -282,
        -282, -282, -282, -281, -281, -281, -280, -279, -279, -279,
        -279, -279, -279, -279, -279, -279, -278, -277, -277, -276,
        -276, -276, -276, -276, -275, -275, -275, -275, -274, -273,
        -273, -273, -273, -273, -273, -272, -271, -271, -271, -271,
        -271, -271, -271, -271, -271, -270, -270, -270, -269, -269,
        -268, -268, -268, -268, -268, -267, -267, -268, -268, -268,
        -269, -269, -270, -270, -270, -269, -268, -269, -269, -268,
        -269, -270, -270, -270, -271, -271, -271, -271, -271, -272,
        -272, -272, -272, -273, -272, -272, -273, -272, -272, -273,
        -273, -272, -273, -273, -273, -273, -274, -274, -274, -274,
        -273, -273, -273, -272, -272, -272, -272, -272, -273, -272,
        -272, -272, -272, -271, -271, -271, -270, -269, -269, -269,
        -267, -267, -267, -266, -266, -265, -265, -266, -265, -266,
        -266, -266, -266, -266, -266, -266, -265, -264, -264, -263,
        -262, -263, -263, -263, -263, -263, -262, -262, -262, -261,
        -261, -260, -260, -260, -258, -258, -257, -256, -256, -256,
        -256, -256, -256, -256, -255, -255, -255, -254, -254, -254,
        -254, -254, -254, -254, -254, -254, -254, -254, -254, -254,
        -254, -253, -253, -252, -250, -250, -250, -249, -249, -249,
        -248, -248, -248, -248, -248, -248, -248, -248, -248, -248,
        -248, -248, -249, -249, -249, -249, -249, -248, -248, -248,
        -247, -247, -248, -247, -248, -247, -247, -247, -248, -247,
        -247, -248, -248, -249, -248, -248, -248, -247, -247, -246,
        -246, -246, -246, -246, -246, -246, -247, -248, -247, -247,
        -247, -247, -249, -249, -249, -248, -247, -247, -247, -248,
        -248, -248, -248, -249, -249, -252, -252, -251, -251, -253,
        -253, -252, -250, -251, -252, -251, -251, -251, -252, -253,
        -252, -253, -253, -254, -254, -254, -254, -254, -254, -254,
        -253, -253, -253, -253, -256, -256, -255, -255, -260, -259,
        -258, -258, -259, -260, -260, -260, -260, -260, -260, -260,
        -260, -260, -260, -260, -260, -260, -259, -259, -260, -260,
        -261, -260, -261, -260, -260, -260, -260, -260, -260, -260,
        -260, -260, -260, -260, -261, -260, -261, -261, -262, -262,
        -264, -264, -264, -264, -263, -263, -264, -264, -264, -264,
        -264, -264, -264, -264, -265, -264, -265, -266, -266, -266,
        -266, -266, -266, -266, -266, -266, -266, -266, -266, -266,
        -267, -268, -268, -269, -270, -270, -270, -270, -270, -270,
        -270, -270, -271, -271, -271, -271, -271, -271, -271, -271,
        -272, -272, -272, -273, -273, -273, -273, -273, -273, -273,
        -273, -273, -273, -273, -274, -275, -275, -275, -275, -275,
        -275, -275, -275, -276, -276, -276, -277, -277, -277, -277,
        -277, -277, -277, -277, -278, -278, -278, -277, -277, -278,
        -278, -278, -278, -277, -277, -277, -279, -278, -277, -279,
        -279, -278, -278, -278, -278, -278, -277, -277, -276, -276,
        -275, -275, -275, -275, -274, -274, -275, -276, -275, -275,
        -275, -275, -273, -273, -271, -271, -271, -270, -269, -269,
        -270, -269, -269, -269, -269, -268, -267, -267, -268, -268,
        -267, -268, -267, -266, -266, -266, -265, -264, -263, -263,
        -261, -260, -260, -258, -258, -258, -257, -258
    };

    static const int16_t fletcher_munson_curve_90_phons[1383] =
    {
        157, 158, 158, 159, 158,
        161, 161, 161, 162, 164, 162, 164, 166, 165, 166,
        168, 167, 168, 169, 169, 169, 169, 169, 169, 169,
        169, 168, 169, 168, 168, 168, 168, 168, 168, 170,
        169, 171, 172, 173, 173, 175, 175, 174, 176, 176,
        176, 178, 178, 180, 179, 181, 182, 183, 184, 185,
        185, 187, 188, 190, 192, 191, 193, 190, 191, 190,
        190, 190, 189, 191, 190, 192, 192, 192, 193, 195,
        195, 196, 195, 197, 199, 198, 200, 201, 203, 204,
        203, 205, 206, 208, 208, 209, 209, 209, 210, 209,
        212, 211, 212, 213, 213, 213, 212, 215, 215, 216,
        214, 216, 216, 215, 217, 216, 217, 219, 218, 220,
        222, 221, 221, 221, 223, 221, 222, 224, 222, 224,
        225, 225, 225, 227, 228, 227, 228, 228, 229, 228,
        229, 230, 230, 230, 232, 234, 233, 235, 235, 235,
        237, 237, 238, 240, 241, 243, 243, 243, 244, 245,
        245, 246, 245, 248, 246, 248, 248, 251, 252, 254,
        256, 255, 257, 259, 259, 261, 262, 262, 263, 265,
        266, 267, 267, 268, 270, 272, 273, 276, 274, 276,
        278, 280, 279, 280, 283, 284, 285, 285, 286, 288,
        287, 288, 290, 291, 294, 294, 296, 297, 298, 300,
        300, 301, 301, 302, 306, 306, 305, 308, 309, 307,
        308, 308, 310, 308, 309, 311, 311, 310, 310, 310,
        310, 311, 310, 313, 312, 313, 312, 313, 314, 313,
        315, 315, 316, 315, 317, 318, 321, 323, 324, 326,
        328, 329, 331, 333, 334, 336, 338, 339, 340, 342,
        342, 345, 345, 344, 345, 347, 345, 347, 349, 350,
        353, 354, 356, 357, 358, 360, 363, 363, 366, 366,
        367, 367, 369, 370, 369, 370, 372, 373, 376, 377,
        379, 382, 384, 385, 385, 388, 388, 388, 391, 392,
        393, 395, 393, 395, 395, 396, 398, 397, 397, 398,
        396, 396, 395, 396, 397, 399, 400, 402, 403, 406,
        406, 406, 407, 409, 408, 409, 411, 409, 411, 415,
        415, 416, 418, 420, 420, 423, 424, 426, 427, 427,
        429, 429, 427, 430, 428, 428, 430, 431, 433, 435,
        436, 435, 434, 436, 435, 435, 436, 436, 436, 438,
        437, 437, 437, 439, 439, 440, 440, 440, 441, 443,
        446, 448, 449, 451, 453, 454, 457, 457, 457, 457,
        457, 460, 460, 460, 460, 463, 464, 465, 468, 469,
        471, 472, 474, 475, 472, 473, 474, 474, 472, 473,
        475, 476, 478, 478, 481, 481, 484, 484, 487, 489,
        486, 486, 486, 483, 484, 485, 486, 487, 490, 491,
        492, 494, 495, 496, 494, 495, 497, 496, 495, 497,
        497, 497, 499, 499, 499, 500, 502, 502, 503, 505,
        505, 507, 508, 508, 511, 511, 511, 508, 509, 509,
        509, 510, 511, 513, 513, 516, 516, 519, 520, 523,
        523, 524, 526, 528, 529, 531, 532, 535, 537, 538,
        540, 541, 543, 545, 547, 548, 550, 552, 555, 555,
        558, 558, 559, 560, 560, 561, 562, 563, 561, 563,
        564, 563, 565, 565, 565, 566, 567, 568, 571, 572,
        572, 572, 572, 574, 575, 575, 578, 579, 580, 580,
        583, 583, 584, 585, 587, 587, 588, 588, 590, 589,
        588, 589, 590, 590, 589, 587, 585, 588, 588, 588,
        588, 591, 591, 591, 591, 591, 591, 591, 591, 592,
        594, 595, 596, 598, 599, 599, 599, 599, 599, 602,
        602, 602, 604, 604, 604, 607, 607, 609, 610, 610,
        610, 611, 611, 611, 611, 611, 614, 614, 615, 617,
        617, 618, 619, 620, 622, 622, 623, 623, 625, 625,
        626, 628, 628, 629, 631, 631, 634, 636, 638, 639,
        642, 642, 642, 643, 646, 646, 646, 646, 646, 646,
        646, 648, 649, 650, 650, 653, 654, 654, 654, 657,
        657, 657, 657, 660, 660, 659, 659, 662, 661, 661,
        661, 663, 664, 664, 665, 668, 668, 668, 671, 671,
        673, 673, 676, 676, 676, 678, 679, 679, 680, 681,
        682, 682, 683, 683, 683, 684, 684, 685, 685, 685,
        684, 684, 684, 684, 684, 687, 687, 687, 690, 690,
        690, 690, 690, 690, 690, 691, 691, 690, 691, 692,
        692, 692, 692, 692, 693, 694, 693, 692, 692, 693,
        695, 695, 695, 695, 698, 698, 698, 698, 698, 698,
        698, 698, 698, 698, 699, 700, 700, 700, 701, 702,
        703, 703, 703, 702, 703, 703, 705, 705, 705, 705,
        706, 706, 706, 706, 710, 710, 710, 710, 710, 710,
        710, 710, 710, 710, 713, 713, 714, 716, 716, 717,
        718, 718, 718, 719, 719, 719, 719, 719, 719, 719,
        718, 718, 716, 716, 716, 717, 717, 717, 717, 716,
        718, 719, 719, 718, 717, 716, 716, 716, 716, 716,
        715, 714, 713, 713, 713, 711, 711, 711, 711, 711,
        711, 711, 711, 711, 711, 711, 711, 711, 710, 710,
        710, 710, 708, 706, 706, 705, 705, 703, 703, 703,
        703, 703, 705, 703, 703, 702, 702, 700, 700, 699,
        697, 694, 693, 692, 692, 691, 690, 690, 689, 691,
        690, 692, 692, 692, 692, 692, 692, 689, 688, 688,
        688, 686, 686, 685, 685, 685, 685, 684, 684, 684,
        684, 682, 681, 681, 678, 678, 678, 678, 678, 678,
        678, 678, 678, 678, 678, 678, 678, 678, 678, 678,
        681, 679, 679, 682, 681, 681, 682, 682, 682, 682,
        682, 682, 681, 681, 681, 680, 679, 679, 679, 678,
        678, 678, 678, 678, 676, 674, 674, 673, 671, 671,
        672, 673, 673, 670, 670, 670, 670, 669, 668, 668,
        667, 666, 666, 665, 662, 659, 658, 658, 658, 658,
        658, 658, 658, 655, 655, 655, 654, 652, 652, 652,
        652, 652, 652, 652, 652, 650, 648, 647, 646, 645,
        644, 644, 644, 644, 641, 641, 641, 641, 639, 638,
        638, 638, 638, 638, 637, 634, 633, 633, 633, 633,
        633, 633, 633, 633, 632, 630, 629, 629, 628, 628,
        626, 625, 626, 625, 625, 622, 622, 625, 625, 626,
        628, 628, 630, 630, 630, 628, 626, 628, 627, 626,
        627, 630, 630, 630, 631, 633, 632, 633, 633, 634,
        634, 634, 635, 636, 635, 634, 636, 636, 635, 637,
        636, 635, 638, 636, 636, 638, 639, 639, 639, 639,
        637, 638, 636, 634, 634, 634, 634, 634, 636, 635,
        634, 635, 634, 633, 632, 632, 630, 627, 628, 627,
        624, 623, 622, 620, 620, 618, 618, 620, 619, 620,
        621, 620, 622, 622, 620, 620, 618, 617, 615, 614,
        612, 614, 614, 614, 615, 614, 612, 612, 610, 609,
        609, 608, 606, 606, 603, 601, 599, 598, 598, 598,
        598, 598, 598, 598, 595, 595, 594, 592, 593, 593,
        593, 593, 593, 593, 593, 593, 593, 593, 593, 593,
        592, 590, 589, 588, 584, 584, 582, 582, 582, 580,
        580, 579, 579, 579, 579, 579, 579, 579, 579, 579,
        579, 579, 580, 580, 580, 580, 580, 579, 579, 578,
        576, 577, 578, 577, 578, 577, 577, 577, 579, 577,
        577, 579, 579, 580, 579, 579, 578, 577, 575, 574,
        574, 574, 575, 575, 574, 574, 575, 578, 577, 577,
        577, 577, 581, 582, 582, 579, 576, 576, 576, 578,
        579, 578, 578, 580, 582, 588, 587, 585, 586, 589,
        590, 587, 583, 585, 587, 587, 586, 585, 588, 590,
        589, 591, 591, 592, 592, 592, 592, 593, 593, 592,
        591, 590, 590, 590, 597, 596, 595, 595, 606, 604,
        603, 602, 605, 606, 607, 606, 606, 606, 606, 606,
        606, 607, 606, 606, 606, 606, 604, 604, 606, 607,
        608, 607, 608, 607, 606, 606, 608, 607, 606, 607,
        606, 607, 607, 606, 608, 607, 609, 609, 611, 612,
        615, 617, 617, 615, 614, 614, 615, 617, 617, 615,
        615, 615, 615, 616, 618, 617, 618, 620, 620, 620,
        621, 621, 621, 621, 622, 622, 622, 622, 622, 621,
        622, 625, 626, 627, 630, 630, 630, 630, 630, 630,
        630, 630, 631, 632, 632, 632, 633, 633, 633, 633,
        634, 634, 635, 636, 636, 636, 636, 636, 636, 636,
        636, 636, 636, 638, 639, 641, 642, 642, 642, 642,
        642, 642, 642, 644, 644, 644, 646, 646, 647, 645,
        646, 647, 647, 647, 649, 649, 648, 646, 647, 649,
        649, 649, 649, 646, 646, 647, 650, 648, 647, 650,
        650, 650, 649, 649, 649, 649, 647, 647, 644, 643,
        641, 642, 641, 642, 640, 640, 642, 644, 643, 641,
        641, 641, 638, 636, 633, 632, 632, 631, 628, 628,
        630, 629, 628, 628, 627, 626, 624, 624, 625, 625,
        623, 624, 623, 621, 620, 620, 619, 617, 614, 614,
        610, 607, 607, 603, 601, 601, 600, 601
    };

    static const int16_t * const fletcher_munson_curves[] =
    {
        fletcher_munson_curve_0_phons,
        fletcher_munson_curve_10_phons,
        fletcher_munson_curve_20_phons,
        fletcher_munson_curve_30_phons,
        fletcher_munson_curve_40_phons,
        fletcher_munson_curve_50_phons,
        fletcher_munson_curve_60_phons,
        fletcher_munson_curve_70_phons,
        fletcher_munson_curve_80_phons,
        fletcher_munson_curve_90_phons
    };

    static const freq_curve_t fletcher_munson_curve =
    {
        24.85, // fmin
        16075.11, // fmax
        0.00, // amin
        90.00, // amax
        1383, // hdots
        10, // curves
        fletcher_munson_curves // curve data
    };

} /* namespace lsp */

#endif /* GENERATED_ISO226_FLETCHER_MUNSON_H_ */
