/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyManager {
    private Properties properties = this.initProperties();
    private Properties defaultProperties;

    private Properties initProperties() {
        this.defaultProperties = new Properties();
        this.defaultProperties.put("model.name", "Poincare model");
        this.defaultProperties.put("model.class", "hypergraph.hyperbolic.PoincareModel");
        this.defaultProperties.put("projector.class", "hypergraph.hyperbolic.PoincareProjector");
        this.defaultProperties.put("linerenderer.class", "hypergraph.hyperbolic.DefaultLineRenderer");
        this.defaultProperties.put("textrenderer.class", "hypergraph.hyperbolic.DefaultTextRenderer");
        this.defaultProperties.put("hypergraph.hyperbolic.background.color", "white");
        this.defaultProperties.put("hypergraph.hyperbolic.text.color", "black");
        return new Properties(this.defaultProperties);
    }

    public Object getProperty(String string) {
        Object object = this.properties.get(string);
        if (object == null) {
            object = this.properties.getProperty(string);
        }
        return object;
    }

    public Object setProperty(String string, Object object) {
        return this.properties.put(string, object);
    }

    public Class getClass(String string) throws ClassNotFoundException {
        String string2 = this.getString(string);
        Class<?> clazz = null;
        try {
            clazz = (Class<?>)this.getProperty(string2);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        clazz = Class.forName(string2);
        if (clazz != null) {
            this.properties.put(string2, clazz);
        }
        return clazz;
    }

    public String getString(String string) {
        Object object = this.getProperty(string);
        return object instanceof String ? (String)object : null;
    }

    public Double getDouble(String string, Double d) {
        Object object = this.getProperty(string);
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            if (object instanceof String) {
                return new Double((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void list(PrintStream printStream) {
        this.properties.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.properties.list(printWriter);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
    }

    public Enumeration propertyNames() {
        return this.properties.propertyNames();
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, string);
    }
}

