/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.HelpUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersValidatorCommandProcessor
implements CommandProcessor {
    @Override
    public Command process(Command process) throws CliCommandoException {
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        Vector<String> missingParameters = new Vector<String>();
        Collection<ParamConfig> parameters = commandConfig.getArgumentsSortedByIndex();
        for (ParamConfig param : parameters) {
            if (!param.isRequired().booleanValue() || !StringUtils.isEmpty(param.getValue())) continue;
            missingParameters.add(HelpUtils.printLongOrShortValueOption("", param));
        }
        parameters = commandConfig.getParamsSortedByOptions();
        for (ParamConfig param : parameters) {
            if (param.getType().equals((Object)ParamConfig.Type.MULTIPLE)) {
                if (!param.isRequired().booleanValue() || param.isSpecified().booleanValue()) continue;
                missingParameters.add(HelpUtils.printLongOrShortValueOption("", param));
                continue;
            }
            if (!param.isRequired().booleanValue() || this.hasDefinedValue(param)) continue;
            missingParameters.add(HelpUtils.printLongOrShortValueOption("", param));
        }
        if (missingParameters.size() == 0) {
            return process;
        }
        throw new BadInputException(ErrorMessages.ErrorCode.MISSING_ARGUMENT, this.createMissingParametersList(missingParameters));
    }

    private String createMissingParametersList(List<String> missingArguments) {
        StringBuilder sb = new StringBuilder();
        for (String val : missingArguments) {
            if (val == null) continue;
            sb.append(val + " ");
        }
        return sb.toString();
    }

    private boolean hasDefinedValue(ParamConfig paramConfig) {
        return StringUtils.notEmpty(paramConfig.getValue()) || StringUtils.notEmpty(paramConfig.getValues()) || paramConfig.getValuesMap().size() > 0;
    }
}

