/*
 * Copyright (C) 2009 Intel Corp.
 * Author: Forrest Zhao <forrest.zhao@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __engine_h__
#define __engine_h__
#include "config.h"

typedef void *handle_t;

typedef enum
{
  CLUTTER_EVENT = 0,
  GESTURE_EVENT
} event_type_t;

#define IN_MT_GESTURE (1<<0)

#define DEFAULT_TOUCH_HOLD_INTERVAL 800
#define DEFAULT_TOUCH_HOLD_RADIUS   20

typedef gboolean (*recognize_callback_t) (ClutterActor *target_actor,
                event_type_t event_type, guint flag, GSList *event_list,
                gint number, void *data);

handle_t engine_init(recognize_callback_t cb, void *data);
void engine_shutdown(handle_t handle);

gint set_gesture_mask(handle_t handle, ClutterActor *target_actor, guint mask);
gint get_gesture_mask(handle_t handle, ClutterActor *target_actor, guint *mask);
gboolean set_hold_timeout(handle_t handle, ClutterActor *target_actor, guint interval);
gboolean get_hold_timeout(handle_t handle, ClutterActor *target_actor, guint *interval);
gboolean set_hold_radius(handle_t handle, ClutterActor *target_actor, guint radius);
gboolean get_hold_radius(handle_t handle, ClutterActor *target_actor, guint *radius);
gboolean fill_event(handle_t handle, ClutterActor *target_actor,
                        ClutterEvent *event);

#endif
