#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

# Check content_path_default explicit failure on missing CONTENT_PATH_DEFAULT.
test_content_path_default_required() {
	local \
		CONTENT_PATH_DEFAULT \
		CONTENT_PATH_DEFAULT_0 \
		PLAYIT_CONTEXT_ARCHIVE \
		CONTENT_PATH_DEFAULT_0

	CONTENT_PATH_DEFAULT='some/path'
	content_path_default=$(content_path_default)
	assertEquals \
		'content_path_default failed to get an explicitly set value from CONTENT_PATH_DEFAULT.' \
		'some/path' "$content_path_default"
	unset CONTENT_PATH_DEFAULT

	set_current_archive 'ARCHIVE_BASE_0'
	CONTENT_PATH_DEFAULT_0='some/other/path'
	content_path_default=$(content_path_default)
	assertEquals \
		'content_path_default failed to get a contextual value for CONTENT_PATH_DEFAULT.' \
		'some/other/path' "$content_path_default"
	unset PLAYIT_CONTEXT_ARCHIVE CONTENT_PATH_DEFAULT_0

	assertFalse \
		'content_path_default did not fail, despite no value being set for CONTENT_PATH_DEFAULT.' \
		'content_path_default'

	return 0
}
