/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-indicator-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_INDICATOR_CONTEXT_H
#define __UNITY_WEBAPPS_INDICATOR_CONTEXT_H

typedef struct _UnityWebappsIndicatorContext UnityWebappsIndicatorContext;

#include "unity-webapps-context.h"

typedef void (*UnityWebappsIndicatorCallback) (UnityWebappsContext *context, gpointer user_data);

void unity_webapps_indicator_show_indicator (UnityWebappsContext *context, const gchar *name);
void unity_webapps_indicator_clear_indicator (UnityWebappsContext *context, const gchar *name);
void unity_webapps_indicator_clear_indicators (UnityWebappsContext *context);
void unity_webapps_indicator_set_callback (UnityWebappsContext *context, const gchar *name, UnityWebappsIndicatorCallback callback, gpointer user_data);
void unity_webapps_indicator_set_property (UnityWebappsContext *context, const gchar *name, const gchar *property, const gchar *value);
void unity_webapps_indicator_set_property_icon (UnityWebappsContext *context, const gchar *name, const gchar *property, const gchar *icon_url);

void unity_webapps_indicator_add_action (UnityWebappsContext *context, const gchar *label, UnityWebappsIndicatorCallback callback, gpointer user_data);
void unity_webapps_indicator_remove_action (UnityWebappsContext *context, const gchar *label);
void unity_webapps_indicator_remove_actions (UnityWebappsContext *context);

gchar *unity_webapps_indicator_get_presence (UnityWebappsContext *context);

void unity_webapps_indicator_on_presence_changed_callback (UnityWebappsContext *context,
														   UnityWebappsIndicatorCallback callback,
														   gpointer user_data);

gboolean unity_webapps_context_shutdown (UnityWebappsContext *context);


#endif
