#############################################################
#
# zlib
#
#############################################################
ifneq ($(USE_CVS),true)
ZLIB_SOURCE=zlib.tar.gz
ZLIB_SITE=http://aleron.dl.sourceforge.net/sourceforge/libpng
ZLIB_DIR=$(BUILD_DIR)/zlib
else
ZLIB_DIR=$(BUILD_DIR)/zlib
endif

ZLIB_CFLAGS= $(TARGET_CFLAGS) -fPIC
ifeq ($(strip $(BUILD_WITH_LARGEFILE)),true)
ZLIB_CFLAGS+= -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64
endif

ifneq ($(USE_CVS),true)
zlib-fetch:
	$(WGET) -P $(DL_DIR) $(ZLIB_SITE)/$(ZLIB_SOURCE)
endif

ZLIB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d zlib $(CVS_TAG) $(CVS_PREFIX)zlib

zlib-checkout:
	@$(ZLIB_CVSCO)

$(ZLIB_DIR)/.source: $(DL_DIR)/$(ZLIB_SOURCE)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(ZLIB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ZLIB_CVSCO)
endif
	touch $(ZLIB_DIR)/.source

$(ZLIB_DIR)/.configured: $(ZLIB_DIR)/.source
	(cd $(ZLIB_DIR); \
		./configure \
		--shared \
		--prefix=/usr \
		--exec-prefix=$(STAGING_DIR)/usr/bin \
		--libdir=$(STAGING_DIR)/lib \
		--includedir=$(STAGING_DIR)/usr/include \
	);
	touch $(ZLIB_DIR)/.configured;

$(ZLIB_DIR)/libz.so.1.1.4: $(ZLIB_DIR)/.configured
	$(MAKE) LDSHARED="$(TARGET_CROSS)ld -shared -soname,libz.so.1" \
		CFLAGS="$(ZLIB_CFLAGS)" CC=$(TARGET_CC) -C $(ZLIB_DIR) all libz.a;
	touch -c $(ZLIB_DIR)/libz.so.1.1.4

$(STAGING_DIR)/lib/libz.so.1.1.4: $(ZLIB_DIR)/libz.so.1.1.4
	cp -dpf $(ZLIB_DIR)/libz.a $(STAGING_DIR)/lib;
	cp -dpf $(ZLIB_DIR)/zlib.h $(STAGING_DIR)/usr/include;
	cp -dpf $(ZLIB_DIR)/zconf.h $(STAGING_DIR)/usr/include;
	cp -dpf $(ZLIB_DIR)/libz.so* $(STAGING_DIR)/lib;
	(cd $(STAGING_DIR)/lib; ln -fs libz.so.1.1.4 libz.so.1);
	chmod a-x $(STAGING_DIR)/lib/libz.so.1.1.4
	touch -c $(STAGING_DIR)/lib/libz.so.1.1.4

$(TARGET_DIR)/lib/libz.so.1.1.4: $(STAGING_DIR)/lib/libz.so.1.1.4
	cp -dpf $(STAGING_DIR)/lib/libz.so* $(TARGET_DIR)/lib;
	-$(STRIP) --strip-unneeded $(TARGET_DIR)/lib/libz.so*
	touch -c $(TARGET_DIR)/lib/libz.so.1.1.4
	install -m0644 $(ZLIB_DIR)/zlib.3 $(TARGET_DIR)/usr/man/man3/
	mkdir -p $(DOC_DIR)/doc/zlib
	for f in README FAQ ; do \
	    install -m0644 $(ZLIB_DIR)/$$f $(DOC_DIR)/doc/zlib/ ; \
	done

$(TARGET_DIR)/usr/lib/libz.a: $(STAGING_DIR)/lib/libz.so.1.1.4
	mkdir -p $(TARGET_DIR)/usr/include
	cp -dpf $(STAGING_DIR)/usr/include/zlib.h $(TARGET_DIR)/usr/include/
	cp -dpf $(STAGING_DIR)/usr/include/zconf.h $(TARGET_DIR)/usr/include/
	cp -dpf $(STAGING_DIR)/lib/libz.a $(TARGET_DIR)/usr/lib/
	rm -f $(TARGET_DIR)/lib/libz.so
	(cd $(TARGET_DIR)/usr/lib; ln -fs /lib/libz.so.1.1.4 libz.so)
	touch -c $(TARGET_DIR)/usr/lib/libz.a

zlib-headers: $(TARGET_DIR)/usr/lib/libz.a

zlib: uclibc $(TARGET_DIR)/lib/libz.so.1.1.4

zlib-source: $(DL_DIR)/$(ZLIB_SOURCE)

zlib-clean:
	rm -f $(TARGET_DIR)/lib/libz.so*
	-$(MAKE) -C $(ZLIB_DIR) clean
	rm -rf $(DOC_DIR)/doc/zlib

zlib-dirclean:
	rm -rf $(ZLIB_DIR)

