#############################################################
#
# quota
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
QUOTA_SOURCE:=quota.tar.gz
QUOTA_CAT:=zcat
endif

QUOTA_DIR:=$(BUILD_DIR)/quota
QUOTA_BINARY:=quota
QUOTA_TARGET_BINARY:=usr/bin/quota

ifneq ($(USE_CVS),true)
quota-source: $(DL_DIR)/$(QUOTA_SOURCE)
else
quota-source:
endif

QUOTA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d quota $(CVS_TAG) $(CVS_PREFIX)quota

quota-checkout:
	@$(QUOTA_CVSCO)

$(QUOTA_DIR)/.unpacked: $(DL_DIR)/$(QUOTA_SOURCE)
ifneq ($(USE_CVS),true)
	$(QUOTA_CAT) $(DL_DIR)/$(QUOTA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(QUOTA_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(QUOTA_DIR)/
	touch $(QUOTA_DIR)/.unpacked

$(QUOTA_DIR)/.configured: $(QUOTA_DIR)/.unpacked
	(cd $(QUOTA_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS)  \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(QUOTA_DIR)/.configured

$(QUOTA_DIR)/$(QUOTA_BINARY): $(QUOTA_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(QUOTA_DIR)

$(TARGET_DIR)/$(QUOTA_TARGET_BINARY): $(QUOTA_DIR)/$(QUOTA_BINARY)
	$(MAKE) \
		STRIP=$(TARGET_CROSS)strip \
		ROOTDIR=$(TARGET_DIR) \
		-C $(QUOTA_DIR) \
		install
	install -d $(DOC_DIR)/doc/quota
	@for f in README.mailserver ; do \
		install -m0644 $(QUOTA_DIR)/$$f $(DOC_DIR)/doc/quota/$$f ;\
	done

quota: uclibc $(TARGET_DIR)/$(QUOTA_TARGET_BINARY)

quota-clean:
	-rm -f $(TARGET_DIR)/$(QUOTA_TARGET_BINARY)
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(QUOTA_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/quota
	-$(MAKE) -C $(QUOTA_DIR) clean

quota-dirclean:
	rm -rf $(QUOTA_DIR)
endif

