#############################################################
#
# pciutils
#
#############################################################

ifneq ($(USE_CVS), true)
PCIUTILS_SOURCE:=pciutils.tar.gz
PCIUTILS_CAT:=zcat
endif

PCIUTILS_DIR:=$(BUILD_DIR)/pciutils
PCIUTILS_BINARY:=lspci
PCIUTILS_TARGET_BINARY:=usr/sbin/lspci

PCIUTILS_DEFS:= PREFIX='/usr'

PCIUTILS_INSTALL_DIRS := SBINDIR="$(TARGET_DIR)/sbin" \
			 SHAREDIR="$(TARGET_DIR)/usr/share" \
			 MANDIR="$(TARGET_DIR)/usr/share/man"

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(PCIUTILS_SOURCE):

pciutils-source: $(DL_DIR)/$(PCIUTILS_SOURCE)
else
pciutils-source:
endif

PCIUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pciutils $(CVS_TAG) $(CVS_PREFIX)pciutils

pciutils-checkout:
	@$(PCIUTILS_CVSCO)

$(PCIUTILS_DIR)/.unpacked: $(DL_DIR)/$(PCIUTILS_SOURCE)
ifneq ($(USE_CVS), true)
	$(PCIUTILS_CAT) $(DL_DIR)/$(PCIUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PCIUTILS_CVSCO)
endif
	-cat $(SOURCE_DIR)/pciutils.patch | patch -p0 -d $(PCIUTILS_DIR)/lib
	touch  $(PCIUTILS_DIR)/.unpacked

$(PCIUTILS_DIR)/.configured: $(PCIUTILS_DIR)/.unpacked
	touch $(PCIUTILS_DIR)/.configured

$(PCIUTILS_DIR)/$(PCIUTILS_BINARY): $(PCIUTILS_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(PCIUTILS_DIR)

$(TARGET_DIR)/$(PCIUTILS_TARGET_BINARY): $(PCIUTILS_DIR)/$(PCIUTILS_BINARY)
	$(MAKE) \
		STRIP=$(TARGET_CROSS)strip \
		$(PCIUTILS_INSTALL_DIRS) \
		-C $(PCIUTILS_DIR) \
		install

pciutils: uclibc $(TARGET_DIR)/$(PCIUTILS_TARGET_BINARY)

pciutils-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(PCIUTILS_DIR) uninstall
	-$(MAKE) -C $(PCIUTILS_DIR) clean

pciutils-dirclean:
	rm -rf $(PCIUTILS_DIR)

