#############################################################
#
# net-tools
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
NET-TOOLS_SOURCE:=net-tools.tar.gz
NET-TOOLS_SITE:=ftp://ftp.gnu.org/gnu/net-tools
NET-TOOLS_CAT:=zcat
endif

NET-TOOLS_DIR:=$(BUILD_DIR)/net-tools
NET-TOOLS_BINARY:=hostname
NET-TOOLS_TARGET_BINARY:=bin

ifneq ($(USE_CVS),true)
net-tools-fetch:
	 $(WGET) -P $(DL_DIR) $(NET-TOOLS_SITE)/$(NET-TOOLS_SOURCE)

net-tools-source: $(DL_DIR)/$(NET-TOOLS_SOURCE)
else
net-tools-source:
endif

NET-TOOLS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d net-tools $(CVS_TAG) $(CVS_PREFIX)net-tools

net-tools-checkout:
	@$(NET-TOOLS_CVSCO)

$(NET-TOOLS_DIR)/.unpacked: $(DL_DIR)/$(NET-TOOLS_SOURCE)
ifneq ($(USE_CVS),true)
	$(NET-TOOLS_CAT) $(DL_DIR)/$(NET-TOOLS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NET-TOOLS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(NET-TOOLS_DIR)/
	touch $(NET-TOOLS_DIR)/.unpacked

$(NET-TOOLS_DIR)/.configured2: $(NET-TOOLS_DIR)/.unpacked
	(cd $(NET-TOOLS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure.sh \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(NET-TOOLS_DIR)/.configured

$(NET-TOOLS_DIR)/.configured: $(NET-TOOLS_DIR)/.unpacked
	cp $(SOURCE_DIR)/net-tools-config.h $(NET-TOOLS_DIR)/config.h
	touch $(NET-TOOLS_DIR)/.configured

$(NET-TOOLS_DIR)/$(NET-TOOLS_BINARY): $(NET-TOOLS_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(NET-TOOLS_DIR)

$(TARGET_DIR)/$(NET-TOOLS_TARGET_BINARY): $(NET-TOOLS_DIR)/$(NET-TOOLS_BINARY)
	$(MAKE) BASEDIR=$(TARGET_DIR) -C $(NET-TOOLS_DIR) install
	install -d $(DOC_DIR)/doc/net-tools
	@for f in COPYING README ; do \
		install -m0644 $(NET-TOOLS_DIR)/$$f $(DOC_DIR)/doc/net-tools/$$f ;\
	done

net-tools: uclibc $(TARGET_DIR)/$(NET-TOOLS_TARGET_BINARY)

net-tools-clean:
	-rm -f $(TARGET_DIR)/$(NET-TOOLS_TARGET_BINARY)
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	@echo "FIXME: net-tools can't uninstall itself
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	-rm -rf $(DOC_DIR)/doc/net-tools
	-$(MAKE) -C $(NET-TOOLS_DIR) clean

net-tools-dirclean:
	rm -rf $(NET-TOOLS_DIR)
endif

