#############################################################
#
# gdbm
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
GDBM_SOURCE:=gdbm.tar.gz
GDBM_SITE:=ftp://ftp.gnu.org/gnu/gdbm
GDBM_CAT:=zcat
endif

GDBM_DIR:=$(BUILD_DIR)/gdbm
GDBM_BINARY:=.libs/libgdbm.so.3.0.0
GDBM_TARGET_BINARY:=usr/lib/libgdbm.so.3.0.0

ifneq ($(USE_CVS),true)
gdbm-fetch:
	 $(WGET) -P $(DL_DIR) $(GDBM_SITE)/$(GDBM_SOURCE)

gdbm-source: $(DL_DIR)/$(GDBM_SOURCE)
else
gdbm-source:
endif

GDBM_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d gdbm $(CVS_TAG) $(CVS_PREFIX)gdbm

gdbm-checkout:
	@$(GDBM_CVSCO)

$(GDBM_DIR)/.unpacked: $(DL_DIR)/$(GDBM_SOURCE)
ifneq ($(USE_CVS),true)
	$(GDBM_CAT) $(DL_DIR)/$(GDBM_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GDBM_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(GDBM_DIR)/
	touch $(GDBM_DIR)/.unpacked

$(GDBM_DIR)/.configured: $(GDBM_DIR)/.unpacked
	(cd $(GDBM_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(GDBM_DIR)/.configured

$(GDBM_DIR)/$(GDBM_BINARY): $(GDBM_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(GDBM_DIR)

$(STAGING_DIR)/$(GDBM_TARGET_BINARY): $(GDBM_DIR)/$(GDBM_BINARY)
	$(MAKE) INSTALL_ROOT=$(STAGING_DIR) -C $(GDBM_DIR) install
	$(STRIP) $@

$(TARGET_DIR)/$(GDBM_TARGET_BINARY): $(STAGING_DIR)/$(GDBM_TARGET_BINARY)
	$(MAKE) INSTALL_ROOT=$(TARGET_DIR) -C $(GDBM_DIR) install
	@rm -f $(TARGET_DIR)/usr/lib/libgdbm.*a
	$(STRIP) $@
	install -d $(DOC_DIR)/doc/gdbm
	@for f in COPYING NEWS ; do \
		install -m0644 $(GDBM_DIR)/$$f $(DOC_DIR)/doc/gdbm/$$f ;\
	done

gdbm: uclibc $(TARGET_DIR)/$(GDBM_TARGET_BINARY)

gdbm-clean:
	-rm -f $(TARGET_DIR)/usr/lib/libgdbm.so*
	-rm -f $(TARGET_DIR)/usr/man/man3/gdbm.3
	-rm -f $(STAGING_DIR)/usr/lib/libgdbm*
	-rm -rf $(STAGING_DIR)/usr/include/gdbm*
	-rm -f $(STAGING_DIR)/usr/man/man3/gdbm.3
	-rm -rf $(DOC_DIR)/doc/gdbm
	-$(MAKE) -C $(GDBM_DIR) clean

gdbm-dirclean:
	rm -rf $(GDBM_DIR)
endif

