;; This file contains a sort of "object-oriented" definition of a cell.
;; The "cell" can be thought of as place marker for a square on a canvas.

(require 'debug)

;; some object utilities:

;; send makes object syntax a bit easier; instead of saying
;;     ((my-cell 'set-x!) 4)
;; you can say
;;    (send my-cell 'set-x! 4)
(define (send obj . args)
  (let ((first-eval (apply obj (list (car args)))))
    (if (null? (cdr args))
	(first-eval)
	(apply first-eval (cdr args)))))



;; (the-x, the-y) is the initial position of the cell.
;; the-color is a string representing a color; must be something Tk can grok.
;; square-size is the size of the square that gets drawn.
;; (sizex, sizey) is the size of the matrix.
(define (MAKE-CELL the-x the-y the-color square-size sizex sizey the-canvas-w)
  (define (get-x) the-x)
  (define (get-y) the-y)

  (define (set-x! new-x)
    (set! the-x new-x)
    the-x)
  (define (set-y! new-y)
    (set! the-y new-y)
    the-y)
  (define (color) the-color)
  (define (set-color! new-color)
    (set! the-color new-color)
    the-color)
  (define (next!)
    (set! the-x (+ the-x 1))
    (if (>= the-x sizex)
	(begin
	  (set! the-x 0)
	  (set! the-y (+ the-y 1))))
	(if (>= the-y sizey)
	    (begin
	      (display "CELL next!: value of y is too big; not changing it\n")
	      (set! the-y (- the-y 1))))
	(cons the-x the-y))
  (define (draw)
    (let* ((x0 (* the-x square-size))
	   (y0 (* the-y square-size))
	   (x1 (+ x0 square-size))
	   (y1 (+ y0 square-size))
	   (my-canvas (cond ((string? the-canvas-w)
			     (eval (string->symbol the-canvas-w)))
			    ((symbol? the-canvas-w)
			     (eval the-canvas-w))
			    (else
			     the-canvas-w))))
      (my-canvas 'create 'rectangle x0 y0 x1 y1 :fill the-color)
      ))

  ;; self is the dispatch procedure
  (define (self message)
    (case message
      ((x)            get-x)
      ((y)            get-y)
      ((set-x!)       set-x!)
      ((set-y!)       set-y!)
      ((color)        get-color)
      ((set-color!)   set-color!)
      ((next!)        next!)
      ((draw)         draw)
      (else (error "CELL: Unknown message -> " message))))
  ;; and now return the dispatch procedure
  self
  )

;; prepare-cell-canvas is a routine that sets up a canvas widget under
;; the specified top level widget.
(require 'Gwish)

(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

(frame '.button-bar) :relief 'raised :bd 2)
(pack '.button-bar :side 'top)
(button '.button-bar.quit :text "quit"
	:command (tcl-lambda () (destroy ".")))
(pack '.button-bar.quit)

(define canvas-w 'bogus)
(define square-size 10)

(define (prepare-cell-canvas top-w sizex sizey)
  (let* ((top-name (if (string? top-w) top-w (symbol->string top-w)))
	 (canvas-name (string-append top-name "." "cell-canvas")))
    (print top-name canvas-name)
    (define canvas-s (string->symbol canvas-name))
    (canvas canvas-s :width (* sizex square-size)
	    :height (* sizey square-size))
    (set! canvas-w (eval canvas-s))
    (pack canvas-w)
;;    (canvas-w 'create 'rectangle 0 0 20 20 :fill 'black)
    ))

(load "mat")

(prepare-cell-canvas "" (length (car sample-m)) (length sample-m))
(print canvas-w)


;; here's an example of the use of cell objects; other examples
;; can be found in mat.scm.
(define c (MAKE-CELL 0 0 "green" square-size
		     (length (car sample-m)) (length sample-m)
		     canvas-w))
((c 'draw))

((c 'next!))
((c 'set-color!) "red")
((c 'draw))
((c 'next!))
((c 'set-color!) "blue")
((c 'draw))
((c 'next!))
((c 'set-color!) "brown")
((c 'draw))
((c 'next!))
((c 'set-color!) "black")
((c 'draw))
((c 'next!))
((c 'set-color!) "orange")
((c 'draw))
((c 'next!))
((c 'set-color!) "yellow")
((c 'draw))

(tk-main-loop)
