#include <stdio.h>

/* the include file for guile */
#include <gscm.h>

static GSCM_status guile_init()
{

#if 0				/* don't need any of these extra packages */
  scm_init_ctax();
  scm_init_unix();
  scm_init_posix();
  scm_init_ioext();
  scm_init_gtcl();
  scm_init_gtk();
#endif /* 0 */
}

main(int argc, char *argv[])
{
  GSCM_status status;
  GSCM_top_level toplev;
  char input_str[200];
  int done;
  char **answer;

  printf("hello guile\n");

  /* start a scheme interpreter */
  status = gscm_run_scm(argc, argv, 0, stdout, stderr, guile_init, 0, "#t");
  if (status != GSCM_OK) {
    fputs(gscm_error_msg(status), stderr);
    fputc('\n', stderr);
    exit(1);
  }

  /* create the top level environment */
  status = gscm_create_top_level(&toplev);
  if (status != GSCM_OK) {
    fputs(gscm_error_msg(status), stderr);
    fputc('\n', stderr);
    exit(1);
  }

  /* for fun, evaluate some simple scheme expressions here */
  status = gscm_eval_str(NULL, toplev, "(define (square x) (* x x))");
  status = gscm_eval_str(NULL, toplev, "(define (factorial n) (if (= n 1) 1 (* n (factorial (- n 1)))))");
  status = gscm_eval_str(NULL, toplev, "(square 9)");
  status = gscm_eval_str(NULL, toplev, "(factorial 100)");

  /* now sit in a scheme eval loop: I input the expressions, have guile
   * evaluate them, and then get another expression.
   */
  done = 0;
  fputs("learn0> ", stdout);
  while (fgets(input_str, 199, stdin) != NULL) {
    status = gscm_eval_str(answer, toplev, input_str);
    printf("%s", *answer);
    free(*answer);
    fputs("learn0> ", stdout);
  }

  /* now clean up and quit */
  gscm_destroy_top_level(toplev);
  exit(0);
}
