;; Usage: (require 'Gwish).  Set up interface.
;; Then call (tk-main-loop)

(require 'Gtcl)
(require 'Gtk)

(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

;;; {The Interpreter}
;;;

(set! the-interpreter (tcl-create-interp))
(let ((init-status (tk-init-main-window the-interpreter (or (getenv "DISPLAY") ":0") "gwish" "Gwish")))
  (if (not (eq? #t init-status))
      (error init-status)))

;;; {Namespace cleaning}
;;;

;; These are the names of procedures already defined 
;; in Scheme but which, in this context, ought to refer
;; to Tcl/Tk commands.

(define override-scheme-list '(bind))


(for-each
 (lambda (name)
   (eval `(set! ,name (reify-tcl-command the-interpreter ',name))))
 override-scheme-list)

(provide 'Gwish)
