/* classes: h_files */

#ifndef IOEXTH
#define IOEXTH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"





#ifdef __STDC__
extern SCM scm_read_line (SCM port);
extern SCM scm_read_line_x (SCM str, SCM port);
extern SCM scm_write_line (SCM obj, SCM port);
extern SCM scm_sys_ftell (SCM port);
extern SCM scm_sys_fseek (SCM port, SCM offset, SCM whence);
extern SCM scm_sys_freopen (SCM filename, SCM modes, SCM port);
extern SCM scm_sys_duplicate_port (SCM oldpt, SCM modes);
extern SCM scm_sys_redirect_port (SCM into_pt, SCM from_pt);
extern SCM scm_sys_opendir (SCM dirname);
extern SCM scm_sys_readdir (SCM port);
extern SCM scm_rewinddir (SCM port);
extern SCM scm_sys_closedir (SCM port);
extern SCM scm_sys_mkdir (SCM path, SCM mode);
extern SCM scm_sys_rmdir (SCM path);
extern SCM scm_sys_chdir (SCM str);
extern SCM scm_sys_getcwd (void);
extern SCM scm_sys_chmod (SCM port_or_path, SCM mode);
extern SCM scm_sys_utime (SCM pathname, SCM actime, SCM modtime);
extern SCM scm_umask (SCM mode);
extern SCM scm_sys_rename (SCM oldname, SCM newname);
extern SCM scm_sys_fileno (SCM port);
extern SCM scm_sys_isatty (SCM port);
extern SCM scm_sys_fdopen (SCM fdes, SCM modes);
extern SCM scm_sys_primitive_move_to_fdes (SCM port, SCM fd);
extern SCM scm_sys_access (SCM path, SCM how);
extern SCM scm_sys_stat (SCM port_or_path);
extern SCM scm_stat2scm (struct stat *stat_temp);
extern SCM scm_getpid (void);
extern SCM scm_sys_putenv (SCM str);

#else /* STDC */
extern SCM scm_read_line ();
extern SCM scm_read_line_x ();
extern SCM scm_write_line ();
extern SCM scm_sys_ftell ();
extern SCM scm_sys_fseek ();
extern SCM scm_sys_freopen ();
extern SCM scm_sys_duplicate_port ();
extern SCM scm_sys_redirect_port ();
extern SCM scm_sys_opendir ();
extern SCM scm_sys_readdir ();
extern SCM scm_rewinddir ();
extern SCM scm_sys_closedir ();
extern SCM scm_sys_mkdir ();
extern SCM scm_sys_rmdir ();
extern SCM scm_sys_chdir ();
extern SCM scm_sys_getcwd ();
extern SCM scm_sys_chmod ();
extern SCM scm_sys_utime ();
extern SCM scm_umask ();
extern SCM scm_sys_rename ();
extern SCM scm_sys_fileno ();
extern SCM scm_sys_isatty ();
extern SCM scm_sys_fdopen ();
extern SCM scm_sys_primitive_move_to_fdes ();
extern SCM scm_sys_access ();
extern SCM scm_sys_stat ();
extern SCM scm_stat2scm ();
extern SCM scm_getpid ();
extern SCM scm_sys_putenv ();

#endif /* STDC */




#endif  /* IOEXTH */
