;;;; 	Copyright (C) 1995 Free Software Foundation, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 



(in-package guile)
(export-library guile (slib-hooks))
(in-module guile)
(export-interface slib-hooks
		  ((quit slib:exit)
		   (error slib:error)
		   (eval slib:eval)
		   (eval defmacro:eval)
		   (logand logical:logand)
		   (logior logical:logior)
		   (logxor logical:logxor)
		   (lognot logical:lognot)
		   (ash logical:ash)
		   (logcount logical:logcount)
		   (integer-length logical:integer-length)
		   (bit-extract logical:bit-extract)
		   (integer-expt logical:integer-expt)
		   (ipow-by-squaring logical:ipow-by-squaring)
		   (eval-load slib:eval-load)
		   slib:tab
		   slib:form-feed
		   slib:load
		   slib:load-source
		   defmacro:load
		   slib:features))


(define slib:tab #\tab)
(define slib:form-feed #\page)
(define slib:load load)
(define slib:load-source load)
(define defmacro:load load)


;;; {Features}
;;;
;;; Features are named options which may or may not be present
;;; in an interpreter.  They can be tested for either by code or
;;; by conditional forms (e.g. "#- hash (load-slib-hash)" )
;;;




;;; {For the SLIB Require System}
;;;

(define %system-features
  (append '(abort
	    alist
	    defmacro
	    delay
	    dynamic-wind
	    full-continuation
	    hash
	    hash-table
	    line-i/o
	    logical
	    multiarg/and-
	    multiarg-apply
	    promise
	    rev2-procedures
	    rev4-optional-procedures
	    string-port
	    with-file
	     )

	  (if (defined? getenv)
	      '(getenv)
	      '())

	  (if (defined? current-time)
	      '(current-time)
	      '())

	  (if (defined? system)
	      '(system)
	      '())

	  (if (defined? array?)
	      '(array)
	      '())

	  (if (defined? char-ready?)
	      '(char-ready?)
	      '())

	  (if (defined? array-for-each)
	      '(array-for-each)
	      '())

	  (if (and (string->number "0.0") (inexact? (string->number "0.0")))
	      '(inexact)
	      '())

	  (if (rational? (string->number "1/19"))
	      '(rational)
	      '())

	  (if (real? (string->number "0.0"))
	      '(real)
	      ())

	  (if (complex? (string->number "1+i"))
	      '(complex)
	      '())

	  (let ((n (string->number "9999999999999999999999999999999")))
	    (if (and n (exact? n))
		'(bignum)
		'()))))





(define slib:features (append '(source
				eval)
			      %system-features))
			


