/* page.h: MN10300 page table definitions
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_PAGE_H
#define _ASM_PAGE_H

/* PAGE_SHIFT determines the page size */
#define PAGE_SHIFT	12

#ifndef __ASSEMBLY__
#define PAGE_SIZE	(1UL << PAGE_SHIFT)
#define PAGE_MASK	(~(PAGE_SIZE-1))
#else
#define PAGE_SIZE	+(1 << PAGE_SHIFT)	/* unary plus marks an immediate val not an addr */
#define PAGE_MASK	+(~(PAGE_SIZE-1))
#endif

/*
 * These are used to make use of C type-checking..
 */
typedef struct { unsigned long pte; } pte_t;
typedef struct { unsigned long pgd; } pgd_t;
typedef struct { unsigned long pgprot; } pgprot_t;

#endif /* _ASM_PAGE_H */
