/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import spec.jbb.Address;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.District;
import spec.jbb.History;
import spec.jbb.JBButil;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class PaymentTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private byte districtId;
    private boolean home;
    private char use_customerId;
    private String cust_last_name;
    private short customerId;
    private short customerWarehouseId;
    private byte customerDistrictId;
    private BigDecimal paymentAmount;
    private Date paymentTime;
    private Warehouse warehousePtr;
    private District districtPtr;
    private Customer customerPtr;
    private TransactionLogBuffer initLog;
    private TransactionLogBuffer paymentLog;
    private XMLTransactionLog xmlPaymentLog;
    String[] validationLog = new String[]{"                                     Payment", "Date: 13-04-2000 11:03:14", "", "Warehouse:    1                          District:  2", "mypIw7RUtW7hoQdmASd                      tNLmWyOsX24ecS      ", "vIfg0HYwMq                               L1Z5ItczBCNAU33y    ", "PWBAjD5CvVrZNaS      Vv 76447-9863       j4h9MghrbPuGahsw     MO 65513-2224", "", "Customer:    4  Cust-Warehouse:    1  Cust-District:  2", "Name:   hkEGDlBmY        OE BARBARPRI            Since:  13-04-2000", "        uocINc31tj7haFutp                        Credit: GC", "        5vCd1B7isyiCPeg7afQU                     %Disc:  33.99", "        6bMzHApngp           Ox 43760-8175       Phone:  308878-613-628-8473", "", "Amount Paid      $200.00           New Cust-Balance:    -./0.00", "Credit Limit    $50000.00", "", "Cust-Data:", "", "", "", "", "", ""};
    boolean[] checkLine = new boolean[]{true, false, true, true, true, true, true, true, true, false, true, true, true, true, false, true, true, true, true, true, true, true, true, true};

    public PaymentTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.warehousePtr = this.company.getWarehousePtr(this.warehouseId, false);
        this.paymentLog = new TransactionLogBuffer();
        this.setupPaymentLog();
        this.xmlPaymentLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.paymentLog);
        this.setupInitLog();
    }

    private void setupPaymentLog() {
        this.paymentLog.putText("Payment", 37, 0, 7);
        this.paymentLog.putText("Date:", 0, 1, 5);
        this.paymentLog.putText("Warehouse:", 0, 3, 10);
        this.paymentLog.putText("District:", 41, 3, 9);
        this.paymentLog.putText("Customer:", 0, 8, 9);
        this.paymentLog.putText("Cust-Warehouse:", 16, 8, 15);
        this.paymentLog.putText("Cust-District:", 38, 8, 14);
        this.paymentLog.putText("Name:", 0, 9, 5);
        this.paymentLog.putText("Since:", 49, 9, 6);
        this.paymentLog.putText("Credit:", 49, 10, 7);
        this.paymentLog.putText("%Disc:", 49, 11, 6);
        this.paymentLog.putText("Phone:", 49, 12, 6);
        this.paymentLog.putText("Amount Paid:", 0, 14, 11);
        this.paymentLog.putText("New Cust-Balance:", 36, 14, 17);
        this.paymentLog.putText("Credit Limit:", 0, 15, 12);
        this.paymentLog.putText("Cust-Data:", 0, 17, 10);
    }

    private void setupInitLog() {
        this.initLog.putText("DD-MM-YYYY", 6, 1, 10);
        this.initLog.putText("hh:mm:ss", 17, 1, 8);
        this.initLog.putCharFill('9', 11, 3, 4);
        this.initLog.putCharFill('9', 51, 3, 2);
        this.initLog.putCharFill('X', 0, 4, 20);
        this.initLog.putCharFill('X', 41, 4, 20);
        this.initLog.putCharFill('X', 0, 5, 20);
        this.initLog.putCharFill('X', 41, 5, 20);
        this.initLog.putCharFill('X', 0, 6, 20);
        this.initLog.putCharFill('X', 21, 6, 2);
        this.initLog.putText("XXXXX-XXXX", 24, 6, 10);
        this.initLog.putCharFill('X', 41, 6, 20);
        this.initLog.putCharFill('X', 62, 6, 2);
        this.initLog.putText("XXXXX-XXXX", 65, 6, 10);
        this.initLog.putCharFill('9', 10, 8, 4);
        this.initLog.putCharFill('9', 32, 8, 4);
        this.initLog.putCharFill('9', 53, 8, 2);
        this.initLog.putCharFill('X', 8, 9, 16);
        this.initLog.putCharFill('X', 25, 9, 2);
        this.initLog.putCharFill('X', 28, 9, 16);
        this.initLog.putText("DD-MM-YYYY", 57, 9, 10);
        this.initLog.putCharFill('X', 8, 10, 20);
        this.initLog.putCharFill('X', 57, 10, 2);
        this.initLog.putCharFill('X', 8, 11, 20);
        this.initLog.putText("99.99", 57, 11, 5);
        this.initLog.putCharFill('X', 8, 12, 20);
        this.initLog.putCharFill('X', 29, 12, 2);
        this.initLog.putText("XXXXX-XXXX", 32, 12, 10);
        this.initLog.putText("XXXXXX-XXX-XXX-XXXX", 57, 12, 19);
        this.initLog.putText("$9999.99", 17, 14, 8);
        this.initLog.putText("$-99999.99", 54, 14, 10);
        this.initLog.putText("$99999.99", 16, 15, 9);
        this.initLog.putCharFill('X', 11, 17, 50);
        this.initLog.putCharFill('X', 11, 18, 50);
        this.initLog.putCharFill('X', 11, 19, 50);
        this.initLog.putCharFill('X', 11, 20, 50);
    }

    public String getMenuName() {
        return "Payment";
    }

    public synchronized void delete() {
    }

    public synchronized void init() {
        JBButil.getLog().entering("spec.jbb.PaymentTransaction", "init");
        this.districtId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
        this.districtPtr = this.warehousePtr.getDistrictPtr(this.districtId, false);
        int n = JBButil.random(1, 100, this.warehouseId);
        int n2 = JBButil.random(1, 100, this.warehouseId);
        if (n2 <= 60) {
            this.cust_last_name = JBButil.choose_random_last_name(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = (char)70;
        } else {
            this.customerId = JBButil.create_random_customer_id(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = (char)84;
        }
        if (n <= 85) {
            this.customerDistrictId = this.districtId;
            this.customerWarehouseId = this.warehouseId;
        } else {
            this.customerDistrictId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
            short s = this.company.getMaxWarehouses();
            this.customerWarehouseId = (short)JBButil.random(1, (int)s, this.warehouseId);
            while (this.customerWarehouseId == this.warehouseId && s > 1) {
                this.customerWarehouseId = (short)JBButil.random(1, (int)s, this.warehouseId);
            }
        }
        this.paymentAmount = BigDecimal.valueOf(20000L, 2);
        this.home = this.customerWarehouseId == this.warehouseId;
        JBButil.getLog().exiting("spec.jbb.PaymentTransaction", "init");
    }

    public boolean process() {
        JBButil.getLog().entering("spec.jbb.PaymentTransaction", "process");
        this.warehousePtr.receivePayment(this.paymentAmount);
        String string = this.warehousePtr.getName();
        this.districtPtr.receivePayment(this.paymentAmount);
        switch (this.use_customerId) {
            case 'T': {
                long l = this.company.buildUniqueCustomerKey(this.customerWarehouseId, this.customerDistrictId, this.customerId);
                this.customerPtr = this.company.getCustomer(l, true);
                break;
            }
            case 'F': {
                this.customerPtr = this.company.getCustomerByLastName(this.customerWarehouseId, this.customerDistrictId, this.cust_last_name);
            }
        }
        if (this.customerPtr != null) {
            this.customerPtr.adjustBalance(this.paymentAmount.negate());
            this.customerPtr.increaseYTD(this.paymentAmount);
            this.customerPtr.incrementPaymentCount();
            if (this.customerPtr.getCreditStatus() == "BC") {
                String string2 = " " + this.customerPtr.getId() + " " + this.customerPtr.getDistrictId() + " " + this.customerPtr.getWarehouseId() + " " + this.districtId + " " + this.warehouseId + " " + this.paymentAmount + " ";
                this.customerPtr.updateCustomerData(string2);
            }
            this.paymentTime = new Date();
            History history = new History(this.customerPtr.getId(), this.customerPtr.getDistrictId(), this.customerPtr.getWarehouseId(), this.districtId, this.warehouseId, this.paymentTime, BigDecimal.valueOf(0L, 2), null);
            history.buildData(string, this.districtPtr.getName());
            this.warehousePtr.updateHistory(history);
            if (Transaction.steadyStateMem) {
                this.warehousePtr.removeOldestHistory();
            }
        }
        JBButil.getLog().exiting("spec.jbb.PaymentTransaction", "process");
        return true;
    }

    public synchronized void display() {
        System.out.println("PaymentTransaction Display **********************");
        System.out.println("Warehouse ID is " + this.warehouseId + " ******************");
        System.out.println("District  ID is " + this.districtId + " ******************");
        System.out.println("Customer  ID is " + this.customerId + " ******************");
        System.out.println("**************************************************");
    }

    public synchronized void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.PaymentTransaction", "initializeTransactionLog");
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.PaymentTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        CharSequence charSequence;
        Comparable<Date> comparable;
        String[] stringArray;
        JBButil.getLog().entering("spec.jbb.PaymentTransaction", "processTransactionLog");
        this.paymentLog.clearBuffer();
        this.xmlPaymentLog.clear();
        this.setupPaymentLog();
        Address address = this.warehousePtr.getAddress();
        Address address2 = this.districtPtr.getAddress();
        this.paymentLog.putDate(this.paymentTime, 6, 1, 10);
        this.paymentLog.putTime(this.paymentTime, 17, 1, 8);
        this.paymentLog.putInt(this.warehouseId, 11, 3, 4);
        this.paymentLog.putInt(this.districtId, 51, 3, 2);
        this.paymentLog.putText(address.getStreet1(), 0, 4, 20);
        this.paymentLog.putText(address2.getStreet1(), 41, 4, 20);
        this.paymentLog.putText(address.getStreet2(), 0, 5, 20);
        this.paymentLog.putText(address2.getStreet2(), 41, 5, 20);
        this.paymentLog.putText(address.getCity(), 0, 6, 20);
        this.paymentLog.putText(address.getState(), 21, 6, 2);
        String string = address.getZip();
        this.paymentLog.putSubstring(string, 24, 6, 0, 5);
        this.paymentLog.putChar('-', 29, 6);
        this.paymentLog.putSubstring(string, 30, 6, 5, 4);
        this.paymentLog.putText(address2.getCity(), 41, 6, 20);
        this.paymentLog.putText(address2.getState(), 62, 6, 2);
        string = address2.getZip();
        this.paymentLog.putSubstring(string, 65, 6, 0, 5);
        this.paymentLog.putChar('-', 70, 6);
        this.paymentLog.putSubstring(string, 71, 6, 5, 4);
        if (this.customerPtr != null) {
            stringArray = this.customerPtr.getAddress();
            comparable = this.customerPtr.getSince();
            this.paymentLog.putInt(this.customerPtr.getId(), 10, 8, 4);
            this.paymentLog.putInt(this.customerPtr.getWarehouseId(), 32, 8, 4);
            this.paymentLog.putInt(this.customerPtr.getDistrictId(), 53, 8, 2);
            this.paymentLog.putText(this.customerPtr.getFirstName(), 8, 9, 16);
            this.paymentLog.putText(this.customerPtr.getMiddleName(), 25, 9, 2);
            this.paymentLog.putText(this.customerPtr.getLastName(), 28, 9, 16);
            this.paymentLog.putDate((Date)comparable, 57, 9, 10);
            this.paymentLog.putText(stringArray.getStreet1(), 8, 10, 20);
            this.paymentLog.putText(this.customerPtr.getCreditStatus(), 57, 10, 2);
            this.paymentLog.putText(stringArray.getStreet2(), 8, 11, 20);
            this.paymentLog.putDouble(this.customerPtr.getDiscountRate().movePointRight(2).toString(), 57, 11, 5);
            this.paymentLog.putText(stringArray.getCity(), 8, 12, 20);
            this.paymentLog.putText(stringArray.getState(), 29, 12, 2);
            string = stringArray.getZip();
            String string2 = this.customerPtr.getPhone();
            this.paymentLog.putSubstring(string, 32, 12, 0, 5);
            this.paymentLog.putChar('-', 37, 12);
            this.paymentLog.putSubstring(string, 38, 12, 5, 4);
            this.paymentLog.putSubstring(string2, 57, 12, 0, 6);
            this.paymentLog.putChar('-', 63, 12);
            this.paymentLog.putSubstring(string2, 64, 12, 6, 3);
            this.paymentLog.putChar('-', 67, 12);
            this.paymentLog.putSubstring(string2, 68, 12, 9, 3);
            this.paymentLog.putChar('-', 71, 12);
            this.paymentLog.putSubstring(string2, 72, 12, 12, 4);
            this.paymentLog.putDollars(this.paymentAmount, 17, 14, 8);
            this.paymentLog.putDollars(this.customerPtr.getBalance(), 54, 14, 10);
            this.paymentLog.putDollars(this.customerPtr.getCreditLimit(), 16, 15, 9);
            if (this.customerPtr.getCreditStatus().equals("BC")) {
                charSequence = this.customerPtr.getCustomerDataParts();
                this.paymentLog.putSubstring((String)charSequence, 11, 17, 0, 50);
                this.paymentLog.putSubstring((String)charSequence, 11, 18, 50, 50);
                this.paymentLog.putSubstring((String)charSequence, 11, 19, 100, 50);
                this.paymentLog.putSubstring((String)charSequence, 11, 20, 150, 50);
            }
        } else {
            this.paymentLog.putText("No customer found for last name =", 11, 17, 35);
            this.paymentLog.putText(this.cust_last_name, 46, 17, 16);
            this.paymentLog.putText("District :", 11, 18, 10);
            this.paymentLog.putInt(this.districtId, 22, 18, 2);
            this.paymentLog.putText("Warehouse:", 11, 19, 10);
            this.paymentLog.putInt(this.warehouseId, 22, 19, 4);
            this.paymentLog.putText("No payment processed.", 11, 20, 25);
        }
        this.xmlPaymentLog.populateXML(this.paymentLog);
        if (Transaction.enableLogWrite) {
            this.paymentLog.display();
        }
        if (Transaction.validationFlag) {
            stringArray = this.paymentLog.validate();
            if (stringArray.length != this.validationLog.length) {
                comparable = new StringBuffer(200);
                ((StringBuffer)comparable).append("VALIDATION ERROR:  mismatch in screen lengths for PaymentTransaction");
                ((StringBuffer)comparable).append(System.getProperty("line.separator"));
                ((StringBuffer)comparable).append("    Screen length should be:  " + this.validationLog.length);
                ((StringBuffer)comparable).append(System.getProperty("line.separator"));
                ((StringBuffer)comparable).append("    Screen length is:  " + stringArray.length);
                ((StringBuffer)comparable).append(System.getProperty("line.separator"));
                JBButil.getLog().warning(((StringBuffer)comparable).toString());
                Transaction.invalidateRun();
            }
            for (int i = 0; i < this.validationLog.length; ++i) {
                if (!this.checkLine[i] || stringArray[i].equals(this.validationLog[i])) continue;
                charSequence = new StringBuffer(200);
                charSequence.append("VALIDATION ERROR:  incorrect output for PaymentTransaction");
                charSequence.append(System.getProperty("line.separator"));
                charSequence.append("    Line " + (i + 1) + " should be:  |" + this.validationLog[i] + "|");
                charSequence.append(System.getProperty("line.separator"));
                charSequence.append("    Line " + (i + 1) + " is:  |" + stringArray[i] + "|");
                charSequence.append(System.getProperty("line.separator"));
                JBButil.getLog().warning(charSequence.toString());
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.PaymentTransaction", "processTransactionLog");
    }
}

