
Contributing to Sonic Visualiser
================================

Sonic Visualiser was devised and developed initially in academia, and
is now maintained "as time permits" with very limited funding.

Development focuses mainly on **stability** and **consistent
cross-platform behaviour**.

## Bug reports

Please file bug reports using the [Github issue
tracker](https://github.com/sonic-visualiser/sonic-visualiser/issues)
where practical. Include information about the version of Sonic
Visualiser you are using, the operating system platform and version,
and how to reproduce the problem.

Bug reports are generally very welcome! Bugs are not always as obvious
to the developer as you might expect, and for every user who files a
report there are many who suffer in silence. If in doubt, please
report it.

However, please also be aware that developer time is limited and
nobody can promise to respond to an issue or fix it to any particular
deadline. Issues can remain open for a long time without any
resolution, even when everybody agrees that they are important. Please
be understanding about this.

## Feature requests

Feature requests should also go in the [Github
tracker](https://github.com/sonic-visualiser/sonic-visualiser/issues). Again
we can't guarantee any particular response, especially as most
developer focus is on stability rather than new features - but we do
enjoy reading and thinking about them!

## Code contributions, pull requests, copyright, etc

Github pull requests are accepted in principle, subject to developer
time to review (again with the remark about prioritising stability).

Sonic Visualiser is licensed under the GNU General Public License, v2
or newer, and your contributions will be distributed under those
terms. However, copyright remains with the contributor. There is no
CLA (contributor license agreement) or copyright transfer required for
contribution to Sonic Visualiser.

## Financial contributions

A most effective way to contribute to Sonic Visualiser and its related
projects is financially:

 * If you have a specific requirement you would like consultancy for,
please contact [Particular Programs
Ltd](https://particularprograms.co.uk).

 * If you would like to contribute to development and maintenance in
general, please consider [sponsoring the main
developer](https://github.com/sponsors/cannam) through Github.
