#######################################################################
# This file is part of crlibm, the correctly rounded mathematical library,
# which has been developed by the Arénaire project at École normale supérieure
# de Lyon.
#
# Copyright (C) 2004-2011 David Defour, Catherine Daramy-Loirat,
# Florent de Dinechin, Matthieu Gallet, Nicolas Gast, Christoph Quirin Lauter,
# and Jean-Michel Muller
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# To use:
# restart; read "sqrt.mpl";
Digits := 120:

interface(quiet=true):

read "common-procedures.mpl":
read "triple-double.mpl":
mkdir("TEMPSQRT"):

polyDegree := 4:

ERecSqrtmMin := 0.707:
ERecSqrtmMax := 1.4143:

xErrMin := evalf((1/(ERecSqrtmMax^2))):
xErrMax := evalf((1/(ERecSqrtmMin^2))):

printf("Using a %d degree polynomial for computing the iteration seed\n",polyDegree);

polyExact := numapprox[minimax](1/sqrt(x),x=1/2..2,[polyDegree,0],1,'err'):
poly := poly_exact(polyExact):
eps := numapprox[infnorm]((poly*sqrt(x))-1,x=xErrMin..xErrMax):

printf("Relative approximation error eps = 2^(%f)\n",log[2](abs(eps))):

printf("Writing tables...\n");

filename:="TEMPSQRT/sqrt.h":
fd:=fopen(filename, WRITE, TEXT):

fprintf(fd, "\n/* File generated by maple/sqrt.mpl */\n"):

for i from 0 to polyDegree do
	fprintf(fd, "\#define SQRTPOLYC%d %1.50e\n",i,coeff(poly,x,i)):
od:
fprintf(fd, "\#define TWO52 %1.50e\n",evalf(2^(52))):


fclose(fd):

filename:="TEMPSQRT/sqrt.sed":
fd:=fopen(filename, WRITE, TEXT):

fprintf(fd, "s/_epsilonApprox/%1.50e/g\n",eps):
fprintf(fd, "s/_ERecSqrtmMin/%1.50e/g\n",ERecSqrtmMin):
fprintf(fd, "s/_ERecSqrtmMax/%1.50e/g\n",ERecSqrtmMax):


for i from 0 to polyDegree do
   fprintf(fd, "s/_SQRTPOLYC%d/%1.50e/g\n",i,coeff(poly,x,i)):
od:

fclose(fd):

printf("... done\n");