/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_k_zlp.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t10, t11;
  double t13, t14, t15, t16, t17, t19, t20, t23;
  double t25, tzk0;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t10 = POW_1_3(p->zeta_threshold);
  t11 = t10 * t10;
  t13 = my_piecewise3(0.1e1 <= p->zeta_threshold, t11 * p->zeta_threshold, 1);
  t14 = POW_1_3(rho[0]);
  t15 = t14 * t14;
  t16 = t13 * t15;
  t17 = 0.1e1 / t14;
  t19 = 0.1e1 + 0.5102040816326530612e3 * t17;
  t20 = log(t19);
  t23 = 0.1e1 - 0.196e-2 * t14 * t20;
  t25 = t8 * t16 * t23;
  tzk0 = 0.10790666666666666667e1 * t25;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t10, t11;
  double t13, t14, t15, t16, t17, t19, t20, t23;
  double t25, tzk0;

  double t27, t29, t30, t35, t38, tvrho0;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t10 = POW_1_3(p->zeta_threshold);
  t11 = t10 * t10;
  t13 = my_piecewise3(0.1e1 <= p->zeta_threshold, t11 * p->zeta_threshold, 1);
  t14 = POW_1_3(rho[0]);
  t15 = t14 * t14;
  t16 = t13 * t15;
  t17 = 0.1e1 / t14;
  t19 = 0.1e1 + 0.5102040816326530612e3 * t17;
  t20 = log(t19);
  t23 = 0.1e1 - 0.196e-2 * t14 * t20;
  t25 = t8 * t16 * t23;
  tzk0 = 0.10790666666666666667e1 * t25;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t27 = t15 * rho[0];
  t29 = t27 * t2 * t5;
  t30 = t7 * t13;
  t35 = 0.1e1 / t19;
  t38 = -0.65333333333333333333e-3 / t15 * t20 + 0.33333333333333333331e0 / rho[0] * t35;
  tvrho0 = 0.17984444444444444445e1 * t25 + 0.10790666666666666667e1 * t29 * t30 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t10, t11;
  double t13, t14, t15, t16, t17, t19, t20, t23;
  double t25, tzk0;

  double t27, t29, t30, t35, t38, tvrho0;

  double t42, t52, t57, t58, t59, t62, tv2rho20;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t10 = POW_1_3(p->zeta_threshold);
  t11 = t10 * t10;
  t13 = my_piecewise3(0.1e1 <= p->zeta_threshold, t11 * p->zeta_threshold, 1);
  t14 = POW_1_3(rho[0]);
  t15 = t14 * t14;
  t16 = t13 * t15;
  t17 = 0.1e1 / t14;
  t19 = 0.1e1 + 0.5102040816326530612e3 * t17;
  t20 = log(t19);
  t23 = 0.1e1 - 0.196e-2 * t14 * t20;
  t25 = t8 * t16 * t23;
  tzk0 = 0.10790666666666666667e1 * t25;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t27 = t15 * rho[0];
  t29 = t27 * t2 * t5;
  t30 = t7 * t13;
  t35 = 0.1e1 / t19;
  t38 = -0.65333333333333333333e-3 / t15 * t20 + 0.33333333333333333331e0 / rho[0] * t35;
  tvrho0 = 0.17984444444444444445e1 * t25 + 0.10790666666666666667e1 * t29 * t30 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t42 = t13 * t17;
  t52 = rho[0] * rho[0];
  t57 = 0.1e1 / t14 / t52;
  t58 = t19 * t19;
  t59 = 0.1e1 / t58;
  t62 = 0.43555555555555555555e-3 / t27 * t20 - 0.22222222222222222221e0 / t52 * t35 + 0.56689342403628117906e2 * t57 * t59;
  tv2rho20 = 0.1198962962962962963e1 * t8 * t42 * t23 + 0.3596888888888888889e1 * t8 * t16 * t38 + 0.10790666666666666667e1 * t29 * t30 * t62;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t10, t11;
  double t13, t14, t15, t16, t17, t19, t20, t23;
  double t25, tzk0;

  double t27, t29, t30, t35, t38, tvrho0;

  double t42, t52, t57, t58, t59, t62, tv2rho20;

  double t68, t82, t91, t93, t96, tv3rho30;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t10 = POW_1_3(p->zeta_threshold);
  t11 = t10 * t10;
  t13 = my_piecewise3(0.1e1 <= p->zeta_threshold, t11 * p->zeta_threshold, 1);
  t14 = POW_1_3(rho[0]);
  t15 = t14 * t14;
  t16 = t13 * t15;
  t17 = 0.1e1 / t14;
  t19 = 0.1e1 + 0.5102040816326530612e3 * t17;
  t20 = log(t19);
  t23 = 0.1e1 - 0.196e-2 * t14 * t20;
  t25 = t8 * t16 * t23;
  tzk0 = 0.10790666666666666667e1 * t25;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t27 = t15 * rho[0];
  t29 = t27 * t2 * t5;
  t30 = t7 * t13;
  t35 = 0.1e1 / t19;
  t38 = -0.65333333333333333333e-3 / t15 * t20 + 0.33333333333333333331e0 / rho[0] * t35;
  tvrho0 = 0.17984444444444444445e1 * t25 + 0.10790666666666666667e1 * t29 * t30 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t42 = t13 * t17;
  t52 = rho[0] * rho[0];
  t57 = 0.1e1 / t14 / t52;
  t58 = t19 * t19;
  t59 = 0.1e1 / t58;
  t62 = 0.43555555555555555555e-3 / t27 * t20 - 0.22222222222222222221e0 / t52 * t35 + 0.56689342403628117906e2 * t57 * t59;
  tv2rho20 = 0.1198962962962962963e1 * t8 * t42 * t23 + 0.3596888888888888889e1 * t8 * t16 * t38 + 0.10790666666666666667e1 * t29 * t30 * t62;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t68 = t13 / t14 / rho[0];
  t82 = t52 * rho[0];
  t91 = 0.1e1 / t15 / t82;
  t93 = 0.1e1 / t58 / t19;
  t96 = -0.72592592592592592592e-3 / t15 / t52 * t20 + 0.37037037037037037035e0 / t82 * t35 - 0.17006802721088435372e3 / t14 / t82 * t59 + 0.1928208925293473398e5 * t91 * t93;
  tv3rho30 = -0.399654320987654321e0 * t8 * t68 * t23 + 0.3596888888888888889e1 * t8 * t42 * t38 + 0.53953333333333333335e1 * t8 * t16 * t62 + 0.10790666666666666667e1 * t29 * t30 * t96;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t10, t11;
  double t13, t14, t15, t16, t17, t19, t20, t23;
  double t25, tzk0;

  double t27, t29, t30, t35, t38, tvrho0;

  double t42, t52, t57, t58, t59, t62, tv2rho20;

  double t68, t82, t91, t93, t96, tv3rho30;

  double t115, t129, tv4rho40;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t10 = POW_1_3(p->zeta_threshold);
  t11 = t10 * t10;
  t13 = my_piecewise3(0.1e1 <= p->zeta_threshold, t11 * p->zeta_threshold, 1);
  t14 = POW_1_3(rho[0]);
  t15 = t14 * t14;
  t16 = t13 * t15;
  t17 = 0.1e1 / t14;
  t19 = 0.1e1 + 0.5102040816326530612e3 * t17;
  t20 = log(t19);
  t23 = 0.1e1 - 0.196e-2 * t14 * t20;
  t25 = t8 * t16 * t23;
  tzk0 = 0.10790666666666666667e1 * t25;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t27 = t15 * rho[0];
  t29 = t27 * t2 * t5;
  t30 = t7 * t13;
  t35 = 0.1e1 / t19;
  t38 = -0.65333333333333333333e-3 / t15 * t20 + 0.33333333333333333331e0 / rho[0] * t35;
  tvrho0 = 0.17984444444444444445e1 * t25 + 0.10790666666666666667e1 * t29 * t30 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t42 = t13 * t17;
  t52 = rho[0] * rho[0];
  t57 = 0.1e1 / t14 / t52;
  t58 = t19 * t19;
  t59 = 0.1e1 / t58;
  t62 = 0.43555555555555555555e-3 / t27 * t20 - 0.22222222222222222221e0 / t52 * t35 + 0.56689342403628117906e2 * t57 * t59;
  tv2rho20 = 0.1198962962962962963e1 * t8 * t42 * t23 + 0.3596888888888888889e1 * t8 * t16 * t38 + 0.10790666666666666667e1 * t29 * t30 * t62;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t68 = t13 / t14 / rho[0];
  t82 = t52 * rho[0];
  t91 = 0.1e1 / t15 / t82;
  t93 = 0.1e1 / t58 / t19;
  t96 = -0.72592592592592592592e-3 / t15 / t52 * t20 + 0.37037037037037037035e0 / t82 * t35 - 0.17006802721088435372e3 / t14 / t82 * t59 + 0.1928208925293473398e5 * t91 * t93;
  tv3rho30 = -0.399654320987654321e0 * t8 * t68 * t23 + 0.3596888888888888889e1 * t8 * t42 * t38 + 0.53953333333333333335e1 * t8 * t16 * t62 + 0.10790666666666666667e1 * t29 * t30 * t96;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t115 = t52 * t52;
  t129 = t58 * t58;
  tv4rho40 = 0.53287242798353909467e0 * t8 * t13 * t57 * t23 - 0.1598617283950617284e1 * t8 * t68 * t38 + 0.7193777777777777778e1 * t8 * t42 * t62 + 0.7193777777777777778e1 * t8 * t16 * t96 + 0.10790666666666666667e1 * t29 * t30 * (0.19358024691358024691e-2 * t91 * t20 - 0.98765432098765432089e0 / t115 * t35 + 0.62988158226253464341e3 / t14 / t115 * t59 - 0.12854726168623155987e6 / t15 / t115 * t93 + 0.98378006392524152953e7 / t115 / rho[0] / t129);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t27, t29;
  double t30, t31, t32, t33, t35, t36, t39, t41;
  double tzk0;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t9 = rho[0] - rho[1];
  t10 = rho[0] + rho[1];
  t11 = 0.1e1 / t10;
  t12 = t9 * t11;
  t13 = 0.1e1 + t12;
  t14 = t13 <= p->zeta_threshold;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t17 = t16 * p->zeta_threshold;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t14, t17, t19 * t13);
  t22 = 0.1e1 - t12;
  t23 = t22 <= p->zeta_threshold;
  t24 = POW_1_3(t22);
  t25 = t24 * t24;
  t27 = my_piecewise3(t23, t17, t25 * t22);
  t29 = t21 / 0.2e1 + t27 / 0.2e1;
  t30 = POW_1_3(t10);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = 0.1e1 / t30;
  t35 = 0.1e1 + 0.5102040816326530612e3 * t33;
  t36 = log(t35);
  t39 = 0.1e1 - 0.196e-2 * t30 * t36;
  t41 = t8 * t32 * t39;
  tzk0 = 0.10790666666666666667e1 * t41;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t27, t29;
  double t30, t31, t32, t33, t35, t36, t39, t41;
  double tzk0;

  double t42, t43, t45, t46, t47, t48, t49, t52;
  double t53, t56, t58, t59, t63, t67, t70, t73;
  double tvrho0, t74, t77, t78, t81, t84, t85, tvrho1;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t9 = rho[0] - rho[1];
  t10 = rho[0] + rho[1];
  t11 = 0.1e1 / t10;
  t12 = t9 * t11;
  t13 = 0.1e1 + t12;
  t14 = t13 <= p->zeta_threshold;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t17 = t16 * p->zeta_threshold;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t14, t17, t19 * t13);
  t22 = 0.1e1 - t12;
  t23 = t22 <= p->zeta_threshold;
  t24 = POW_1_3(t22);
  t25 = t24 * t24;
  t27 = my_piecewise3(t23, t17, t25 * t22);
  t29 = t21 / 0.2e1 + t27 / 0.2e1;
  t30 = POW_1_3(t10);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = 0.1e1 / t30;
  t35 = 0.1e1 + 0.5102040816326530612e3 * t33;
  t36 = log(t35);
  t39 = 0.1e1 - 0.196e-2 * t30 * t36;
  t41 = t8 * t32 * t39;
  tzk0 = 0.10790666666666666667e1 * t41;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = 0.17984444444444444445e1 * t41;
  t43 = t31 * t10;
  t45 = t43 * t2 * t5;
  t46 = t10 * t10;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t49 = t11 - t48;
  t52 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t49);
  t53 = -t49;
  t56 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t53);
  t58 = t52 / 0.2e1 + t56 / 0.2e1;
  t59 = t7 * t58;
  t63 = t7 * t29;
  t67 = 0.1e1 / t35;
  t70 = -0.65333333333333333333e-3 / t31 * t36 + 0.33333333333333333331e0 * t11 * t67;
  t73 = 0.10790666666666666667e1 * t45 * t63 * t70;
  tvrho0 = t42 + 0.10790666666666666667e1 * t45 * t59 * t39 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = -t11 - t48;
  t77 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t74);
  t78 = -t74;
  t81 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t78);
  t84 = t7 * (t77 / 0.2e1 + t81 / 0.2e1);
  t85 = t84 * t39;
  tvrho1 = t42 + 0.10790666666666666667e1 * t45 * t85 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t27, t29;
  double t30, t31, t32, t33, t35, t36, t39, t41;
  double tzk0;

  double t42, t43, t45, t46, t47, t48, t49, t52;
  double t53, t56, t58, t59, t63, t67, t70, t73;
  double tvrho0, t74, t77, t78, t81, t84, t85, tvrho1;

  double t88, t90, t92, t95, t98, t99, t100, t103;
  double t104, t105, t107, t111, t112, t113, t116, t120;
  double t122, t123, t128, t136, t137, t138, t141, t144;
  double tv2rho20, t147, t148, t150, t153, t157, t158, t161;
  double t165, t168, t169, t172, t173, tv2rho21, t177, t181;
  double t185, t186, t189, t193, t196, t197, tv2rho22;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t9 = rho[0] - rho[1];
  t10 = rho[0] + rho[1];
  t11 = 0.1e1 / t10;
  t12 = t9 * t11;
  t13 = 0.1e1 + t12;
  t14 = t13 <= p->zeta_threshold;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t17 = t16 * p->zeta_threshold;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t14, t17, t19 * t13);
  t22 = 0.1e1 - t12;
  t23 = t22 <= p->zeta_threshold;
  t24 = POW_1_3(t22);
  t25 = t24 * t24;
  t27 = my_piecewise3(t23, t17, t25 * t22);
  t29 = t21 / 0.2e1 + t27 / 0.2e1;
  t30 = POW_1_3(t10);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = 0.1e1 / t30;
  t35 = 0.1e1 + 0.5102040816326530612e3 * t33;
  t36 = log(t35);
  t39 = 0.1e1 - 0.196e-2 * t30 * t36;
  t41 = t8 * t32 * t39;
  tzk0 = 0.10790666666666666667e1 * t41;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = 0.17984444444444444445e1 * t41;
  t43 = t31 * t10;
  t45 = t43 * t2 * t5;
  t46 = t10 * t10;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t49 = t11 - t48;
  t52 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t49);
  t53 = -t49;
  t56 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t53);
  t58 = t52 / 0.2e1 + t56 / 0.2e1;
  t59 = t7 * t58;
  t63 = t7 * t29;
  t67 = 0.1e1 / t35;
  t70 = -0.65333333333333333333e-3 / t31 * t36 + 0.33333333333333333331e0 * t11 * t67;
  t73 = 0.10790666666666666667e1 * t45 * t63 * t70;
  tvrho0 = t42 + 0.10790666666666666667e1 * t45 * t59 * t39 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = -t11 - t48;
  t77 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t74);
  t78 = -t74;
  t81 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t78);
  t84 = t7 * (t77 / 0.2e1 + t81 / 0.2e1);
  t85 = t84 * t39;
  tvrho1 = t42 + 0.10790666666666666667e1 * t45 * t85 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = t58 * t31;
  t90 = t8 * t88 * t39;
  t92 = t29 * t33;
  t95 = 0.1198962962962962963e1 * t8 * t92 * t39;
  t98 = 0.3596888888888888889e1 * t8 * t32 * t70;
  t99 = 0.1e1 / t18;
  t100 = t49 * t49;
  t103 = t46 * t10;
  t104 = 0.1e1 / t103;
  t105 = t9 * t104;
  t107 = -0.2e1 * t47 + 0.2e1 * t105;
  t111 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t100 + 0.5e1 / 0.3e1 * t19 * t107);
  t112 = 0.1e1 / t24;
  t113 = t53 * t53;
  t116 = -t107;
  t120 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t113 + 0.5e1 / 0.3e1 * t25 * t116);
  t122 = t111 / 0.2e1 + t120 / 0.2e1;
  t123 = t7 * t122;
  t128 = t45 * t59 * t70;
  t136 = 0.1e1 / t30 / t46;
  t137 = t35 * t35;
  t138 = 0.1e1 / t137;
  t141 = 0.43555555555555555555e-3 / t43 * t36 - 0.22222222222222222221e0 * t47 * t67 + 0.56689342403628117906e2 * t136 * t138;
  t144 = 0.10790666666666666667e1 * t45 * t63 * t141;
  tv2rho20 = 0.3596888888888888889e1 * t90 + t95 + t98 + 0.10790666666666666667e1 * t45 * t123 * t39 + 0.21581333333333333334e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t31 * t2 * t5;
  t148 = t147 * t85;
  t150 = t99 * t74;
  t153 = t19 * t9;
  t157 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t150 * t49 + 0.1e2 / 0.3e1 * t153 * t104);
  t158 = t112 * t78;
  t161 = t25 * t9;
  t165 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t158 * t53 - 0.1e2 / 0.3e1 * t161 * t104);
  t168 = t7 * (t157 / 0.2e1 + t165 / 0.2e1);
  t169 = t168 * t39;
  t172 = t84 * t70;
  t173 = t45 * t172;
  tv2rho21 = 0.17984444444444444445e1 * t90 + t95 + t98 + 0.17984444444444444445e1 * t148 + 0.10790666666666666667e1 * t45 * t169 + 0.10790666666666666667e1 * t173 + 0.10790666666666666667e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t177 = t74 * t74;
  t181 = 0.2e1 * t47 + 0.2e1 * t105;
  t185 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t177 + 0.5e1 / 0.3e1 * t19 * t181);
  t186 = t78 * t78;
  t189 = -t181;
  t193 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t186 + 0.5e1 / 0.3e1 * t25 * t189);
  t196 = t7 * (t185 / 0.2e1 + t193 / 0.2e1);
  t197 = t196 * t39;
  tv2rho22 = 0.3596888888888888889e1 * t148 + t95 + t98 + 0.10790666666666666667e1 * t45 * t197 + 0.21581333333333333334e1 * t173 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t27, t29;
  double t30, t31, t32, t33, t35, t36, t39, t41;
  double tzk0;

  double t42, t43, t45, t46, t47, t48, t49, t52;
  double t53, t56, t58, t59, t63, t67, t70, t73;
  double tvrho0, t74, t77, t78, t81, t84, t85, tvrho1;

  double t88, t90, t92, t95, t98, t99, t100, t103;
  double t104, t105, t107, t111, t112, t113, t116, t120;
  double t122, t123, t128, t136, t137, t138, t141, t144;
  double tv2rho20, t147, t148, t150, t153, t157, t158, t161;
  double t165, t168, t169, t172, t173, tv2rho21, t177, t181;
  double t185, t186, t189, t193, t196, t197, tv2rho22;

  double t201, t203, t205, t207, t210, t213, t214, t217;
  double t220, t223, t225, t226, t229, t232, t233, t234;
  double t236, t240, t242, t243, t246, t249, t253, t255;
  double t256, t261, t264, t277, t279, t282, t285, tv3rho30;
  double t290, t291, t294, t295, t297, t300, t311, t312;
  double t315, t326, t329, t330, t333, t335, t336, t337;
  double tv3rho31, t345, t347, t352, t357, t361, t362, t367;
  double t370, t374, t377, t378, t381, t382, tv3rho32, t389;
  double t395, t399, t400, t405, t409, t412, t413, tv3rho33;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t9 = rho[0] - rho[1];
  t10 = rho[0] + rho[1];
  t11 = 0.1e1 / t10;
  t12 = t9 * t11;
  t13 = 0.1e1 + t12;
  t14 = t13 <= p->zeta_threshold;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t17 = t16 * p->zeta_threshold;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t14, t17, t19 * t13);
  t22 = 0.1e1 - t12;
  t23 = t22 <= p->zeta_threshold;
  t24 = POW_1_3(t22);
  t25 = t24 * t24;
  t27 = my_piecewise3(t23, t17, t25 * t22);
  t29 = t21 / 0.2e1 + t27 / 0.2e1;
  t30 = POW_1_3(t10);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = 0.1e1 / t30;
  t35 = 0.1e1 + 0.5102040816326530612e3 * t33;
  t36 = log(t35);
  t39 = 0.1e1 - 0.196e-2 * t30 * t36;
  t41 = t8 * t32 * t39;
  tzk0 = 0.10790666666666666667e1 * t41;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = 0.17984444444444444445e1 * t41;
  t43 = t31 * t10;
  t45 = t43 * t2 * t5;
  t46 = t10 * t10;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t49 = t11 - t48;
  t52 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t49);
  t53 = -t49;
  t56 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t53);
  t58 = t52 / 0.2e1 + t56 / 0.2e1;
  t59 = t7 * t58;
  t63 = t7 * t29;
  t67 = 0.1e1 / t35;
  t70 = -0.65333333333333333333e-3 / t31 * t36 + 0.33333333333333333331e0 * t11 * t67;
  t73 = 0.10790666666666666667e1 * t45 * t63 * t70;
  tvrho0 = t42 + 0.10790666666666666667e1 * t45 * t59 * t39 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = -t11 - t48;
  t77 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t74);
  t78 = -t74;
  t81 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t78);
  t84 = t7 * (t77 / 0.2e1 + t81 / 0.2e1);
  t85 = t84 * t39;
  tvrho1 = t42 + 0.10790666666666666667e1 * t45 * t85 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = t58 * t31;
  t90 = t8 * t88 * t39;
  t92 = t29 * t33;
  t95 = 0.1198962962962962963e1 * t8 * t92 * t39;
  t98 = 0.3596888888888888889e1 * t8 * t32 * t70;
  t99 = 0.1e1 / t18;
  t100 = t49 * t49;
  t103 = t46 * t10;
  t104 = 0.1e1 / t103;
  t105 = t9 * t104;
  t107 = -0.2e1 * t47 + 0.2e1 * t105;
  t111 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t100 + 0.5e1 / 0.3e1 * t19 * t107);
  t112 = 0.1e1 / t24;
  t113 = t53 * t53;
  t116 = -t107;
  t120 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t113 + 0.5e1 / 0.3e1 * t25 * t116);
  t122 = t111 / 0.2e1 + t120 / 0.2e1;
  t123 = t7 * t122;
  t128 = t45 * t59 * t70;
  t136 = 0.1e1 / t30 / t46;
  t137 = t35 * t35;
  t138 = 0.1e1 / t137;
  t141 = 0.43555555555555555555e-3 / t43 * t36 - 0.22222222222222222221e0 * t47 * t67 + 0.56689342403628117906e2 * t136 * t138;
  t144 = 0.10790666666666666667e1 * t45 * t63 * t141;
  tv2rho20 = 0.3596888888888888889e1 * t90 + t95 + t98 + 0.10790666666666666667e1 * t45 * t123 * t39 + 0.21581333333333333334e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t31 * t2 * t5;
  t148 = t147 * t85;
  t150 = t99 * t74;
  t153 = t19 * t9;
  t157 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t150 * t49 + 0.1e2 / 0.3e1 * t153 * t104);
  t158 = t112 * t78;
  t161 = t25 * t9;
  t165 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t158 * t53 - 0.1e2 / 0.3e1 * t161 * t104);
  t168 = t7 * (t157 / 0.2e1 + t165 / 0.2e1);
  t169 = t168 * t39;
  t172 = t84 * t70;
  t173 = t45 * t172;
  tv2rho21 = 0.17984444444444444445e1 * t90 + t95 + t98 + 0.17984444444444444445e1 * t148 + 0.10790666666666666667e1 * t45 * t169 + 0.10790666666666666667e1 * t173 + 0.10790666666666666667e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t177 = t74 * t74;
  t181 = 0.2e1 * t47 + 0.2e1 * t105;
  t185 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t177 + 0.5e1 / 0.3e1 * t19 * t181);
  t186 = t78 * t78;
  t189 = -t181;
  t193 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t186 + 0.5e1 / 0.3e1 * t25 * t189);
  t196 = t7 * (t185 / 0.2e1 + t193 / 0.2e1);
  t197 = t196 * t39;
  tv2rho22 = 0.3596888888888888889e1 * t148 + t95 + t98 + 0.10790666666666666667e1 * t45 * t197 + 0.21581333333333333334e1 * t173 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t201 = t122 * t31;
  t203 = t8 * t201 * t39;
  t205 = t58 * t33;
  t207 = t8 * t205 * t39;
  t210 = t8 * t88 * t70;
  t213 = 0.1e1 / t30 / t10;
  t214 = t29 * t213;
  t217 = 0.399654320987654321e0 * t8 * t214 * t39;
  t220 = 0.3596888888888888889e1 * t8 * t92 * t70;
  t223 = 0.53953333333333333335e1 * t8 * t32 * t141;
  t225 = 0.1e1 / t18 / t13;
  t226 = t100 * t49;
  t229 = t99 * t49;
  t232 = t46 * t46;
  t233 = 0.1e1 / t232;
  t234 = t9 * t233;
  t236 = 0.6e1 * t104 - 0.6e1 * t234;
  t240 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t225 * t226 + 0.1e2 / 0.3e1 * t229 * t107 + 0.5e1 / 0.3e1 * t19 * t236);
  t242 = 0.1e1 / t24 / t22;
  t243 = t113 * t53;
  t246 = t112 * t53;
  t249 = -t236;
  t253 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t242 * t243 + 0.1e2 / 0.3e1 * t246 * t116 + 0.5e1 / 0.3e1 * t25 * t249);
  t255 = t240 / 0.2e1 + t253 / 0.2e1;
  t256 = t7 * t255;
  t261 = t45 * t123 * t70;
  t264 = t45 * t59 * t141;
  t277 = 0.1e1 / t31 / t103;
  t279 = 0.1e1 / t137 / t35;
  t282 = -0.72592592592592592592e-3 / t31 / t46 * t36 + 0.37037037037037037035e0 * t104 * t67 - 0.17006802721088435372e3 / t30 / t103 * t138 + 0.1928208925293473398e5 * t277 * t279;
  t285 = 0.10790666666666666667e1 * t45 * t63 * t282;
  tv3rho30 = 0.53953333333333333335e1 * t203 + 0.3596888888888888889e1 * t207 + 0.10790666666666666667e2 * t210 - t217 + t220 + t223 + 0.10790666666666666667e1 * t45 * t256 * t39 + 0.32372000000000000001e1 * t261 + 0.32372000000000000001e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t290 = t33 * t2 * t5;
  t291 = t290 * t85;
  t294 = 0.3596888888888888889e1 * t147 * t169;
  t295 = t147 * t172;
  t297 = t225 * t74;
  t300 = t99 * t9;
  t311 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t297 * t100 + 0.4e2 / 0.9e1 * t300 * t104 * t49 + 0.1e2 / 0.9e1 * t150 * t107 + 0.1e2 / 0.3e1 * t19 * t104 - 0.1e2 * t153 * t233);
  t312 = t242 * t78;
  t315 = t112 * t9;
  t326 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t312 * t113 - 0.4e2 / 0.9e1 * t315 * t104 * t53 + 0.1e2 / 0.9e1 * t158 * t116 - 0.1e2 / 0.3e1 * t25 * t104 + 0.1e2 * t161 * t233);
  t329 = t7 * (t311 / 0.2e1 + t326 / 0.2e1);
  t330 = t329 * t39;
  t333 = t168 * t70;
  t335 = 0.21581333333333333334e1 * t45 * t333;
  t336 = t84 * t141;
  t337 = t45 * t336;
  tv3rho31 = 0.17984444444444444445e1 * t203 + 0.2397925925925925926e1 * t207 + 0.7193777777777777778e1 * t210 - t217 + t220 + t223 + 0.1198962962962962963e1 * t291 + t294 + 0.3596888888888888889e1 * t295 + 0.10790666666666666667e1 * t45 * t330 + t335 + 0.10790666666666666667e1 * t337 + 0.10790666666666666667e1 * t261 + 0.21581333333333333334e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t345 = t147 * t197;
  t347 = t225 * t177;
  t352 = t99 * t181;
  t357 = -0.2e1 * t104 - 0.6e1 * t234;
  t361 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t347 * t49 + 0.4e2 / 0.9e1 * t150 * t105 + 0.1e2 / 0.9e1 * t352 * t49 + 0.5e1 / 0.3e1 * t19 * t357);
  t362 = t242 * t186;
  t367 = t112 * t189;
  t370 = -t357;
  t374 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t362 * t53 - 0.4e2 / 0.9e1 * t158 * t105 + 0.1e2 / 0.9e1 * t367 * t53 + 0.5e1 / 0.3e1 * t25 * t370);
  t377 = t7 * (t361 / 0.2e1 + t374 / 0.2e1);
  t378 = t377 * t39;
  t381 = t196 * t70;
  t382 = t45 * t381;
  tv3rho32 = 0.2397925925925925926e1 * t291 + t294 + 0.7193777777777777778e1 * t295 + 0.1198962962962962963e1 * t207 - t217 + t220 + 0.3596888888888888889e1 * t210 + t223 + 0.17984444444444444445e1 * t345 + 0.10790666666666666667e1 * t45 * t378 + 0.10790666666666666667e1 * t382 + t335 + 0.21581333333333333334e1 * t337 + 0.10790666666666666667e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t389 = t177 * t74;
  t395 = -0.6e1 * t104 - 0.6e1 * t234;
  t399 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t225 * t389 + 0.1e2 / 0.3e1 * t150 * t181 + 0.5e1 / 0.3e1 * t19 * t395);
  t400 = t186 * t78;
  t405 = -t395;
  t409 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t242 * t400 + 0.1e2 / 0.3e1 * t158 * t189 + 0.5e1 / 0.3e1 * t25 * t405);
  t412 = t7 * (t399 / 0.2e1 + t409 / 0.2e1);
  t413 = t412 * t39;
  tv3rho33 = 0.3596888888888888889e1 * t291 + 0.53953333333333333335e1 * t345 + 0.10790666666666666667e2 * t295 - t217 + t220 + t223 + 0.10790666666666666667e1 * t45 * t413 + 0.32372000000000000001e1 * t382 + 0.32372000000000000001e1 * t337 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t27, t29;
  double t30, t31, t32, t33, t35, t36, t39, t41;
  double tzk0;

  double t42, t43, t45, t46, t47, t48, t49, t52;
  double t53, t56, t58, t59, t63, t67, t70, t73;
  double tvrho0, t74, t77, t78, t81, t84, t85, tvrho1;

  double t88, t90, t92, t95, t98, t99, t100, t103;
  double t104, t105, t107, t111, t112, t113, t116, t120;
  double t122, t123, t128, t136, t137, t138, t141, t144;
  double tv2rho20, t147, t148, t150, t153, t157, t158, t161;
  double t165, t168, t169, t172, t173, tv2rho21, t177, t181;
  double t185, t186, t189, t193, t196, t197, tv2rho22;

  double t201, t203, t205, t207, t210, t213, t214, t217;
  double t220, t223, t225, t226, t229, t232, t233, t234;
  double t236, t240, t242, t243, t246, t249, t253, t255;
  double t256, t261, t264, t277, t279, t282, t285, tv3rho30;
  double t290, t291, t294, t295, t297, t300, t311, t312;
  double t315, t326, t329, t330, t333, t335, t336, t337;
  double tv3rho31, t345, t347, t352, t357, t361, t362, t367;
  double t370, t374, t377, t378, t381, t382, tv3rho32, t389;
  double t395, t399, t400, t405, t409, t412, t413, tv3rho33;

  double t420, t424, t429, t432, t435, t438, t441, t445;
  double t448, t451, t452, t454, t455, t461, t467, t468;
  double t470, t474, t475, t477, t478, t484, t493, t501;
  double t504, t507, t521, t528, tv4rho40, t533, t540, t543;
  double t544, t545, t547, t549, t550, t551, t577, t579;
  double t604, t606, t614, t617, t618, t620, t622, tv4rho41;
  double t631, t640, t642, t644, t655, t658, t674, t700;
  double t708, t711, t713, tv4rho42, t720, t746, t750, t771;
  double t779, t781, t783, tv4rho43, t792, t797, t803, t807;
  double t808, t813, t822, tv4rho44;


  t1 = M_CBRT3;
  t2 = t1 * t1;
  t4 = POW_1_3(0.1e1 / M_PI);
  t5 = 0.1e1 / t4;
  t7 = M_CBRT4;
  t8 = t2 * t5 * t7;
  t9 = rho[0] - rho[1];
  t10 = rho[0] + rho[1];
  t11 = 0.1e1 / t10;
  t12 = t9 * t11;
  t13 = 0.1e1 + t12;
  t14 = t13 <= p->zeta_threshold;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t17 = t16 * p->zeta_threshold;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t14, t17, t19 * t13);
  t22 = 0.1e1 - t12;
  t23 = t22 <= p->zeta_threshold;
  t24 = POW_1_3(t22);
  t25 = t24 * t24;
  t27 = my_piecewise3(t23, t17, t25 * t22);
  t29 = t21 / 0.2e1 + t27 / 0.2e1;
  t30 = POW_1_3(t10);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = 0.1e1 / t30;
  t35 = 0.1e1 + 0.5102040816326530612e3 * t33;
  t36 = log(t35);
  t39 = 0.1e1 - 0.196e-2 * t30 * t36;
  t41 = t8 * t32 * t39;
  tzk0 = 0.10790666666666666667e1 * t41;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = 0.17984444444444444445e1 * t41;
  t43 = t31 * t10;
  t45 = t43 * t2 * t5;
  t46 = t10 * t10;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t49 = t11 - t48;
  t52 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t49);
  t53 = -t49;
  t56 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t53);
  t58 = t52 / 0.2e1 + t56 / 0.2e1;
  t59 = t7 * t58;
  t63 = t7 * t29;
  t67 = 0.1e1 / t35;
  t70 = -0.65333333333333333333e-3 / t31 * t36 + 0.33333333333333333331e0 * t11 * t67;
  t73 = 0.10790666666666666667e1 * t45 * t63 * t70;
  tvrho0 = t42 + 0.10790666666666666667e1 * t45 * t59 * t39 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = -t11 - t48;
  t77 = my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t74);
  t78 = -t74;
  t81 = my_piecewise3(t23, 0, 0.5e1 / 0.3e1 * t25 * t78);
  t84 = t7 * (t77 / 0.2e1 + t81 / 0.2e1);
  t85 = t84 * t39;
  tvrho1 = t42 + 0.10790666666666666667e1 * t45 * t85 + t73;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = t58 * t31;
  t90 = t8 * t88 * t39;
  t92 = t29 * t33;
  t95 = 0.1198962962962962963e1 * t8 * t92 * t39;
  t98 = 0.3596888888888888889e1 * t8 * t32 * t70;
  t99 = 0.1e1 / t18;
  t100 = t49 * t49;
  t103 = t46 * t10;
  t104 = 0.1e1 / t103;
  t105 = t9 * t104;
  t107 = -0.2e1 * t47 + 0.2e1 * t105;
  t111 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t100 + 0.5e1 / 0.3e1 * t19 * t107);
  t112 = 0.1e1 / t24;
  t113 = t53 * t53;
  t116 = -t107;
  t120 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t113 + 0.5e1 / 0.3e1 * t25 * t116);
  t122 = t111 / 0.2e1 + t120 / 0.2e1;
  t123 = t7 * t122;
  t128 = t45 * t59 * t70;
  t136 = 0.1e1 / t30 / t46;
  t137 = t35 * t35;
  t138 = 0.1e1 / t137;
  t141 = 0.43555555555555555555e-3 / t43 * t36 - 0.22222222222222222221e0 * t47 * t67 + 0.56689342403628117906e2 * t136 * t138;
  t144 = 0.10790666666666666667e1 * t45 * t63 * t141;
  tv2rho20 = 0.3596888888888888889e1 * t90 + t95 + t98 + 0.10790666666666666667e1 * t45 * t123 * t39 + 0.21581333333333333334e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t31 * t2 * t5;
  t148 = t147 * t85;
  t150 = t99 * t74;
  t153 = t19 * t9;
  t157 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t150 * t49 + 0.1e2 / 0.3e1 * t153 * t104);
  t158 = t112 * t78;
  t161 = t25 * t9;
  t165 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t158 * t53 - 0.1e2 / 0.3e1 * t161 * t104);
  t168 = t7 * (t157 / 0.2e1 + t165 / 0.2e1);
  t169 = t168 * t39;
  t172 = t84 * t70;
  t173 = t45 * t172;
  tv2rho21 = 0.17984444444444444445e1 * t90 + t95 + t98 + 0.17984444444444444445e1 * t148 + 0.10790666666666666667e1 * t45 * t169 + 0.10790666666666666667e1 * t173 + 0.10790666666666666667e1 * t128 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t177 = t74 * t74;
  t181 = 0.2e1 * t47 + 0.2e1 * t105;
  t185 = my_piecewise3(t14, 0, 0.1e2 / 0.9e1 * t99 * t177 + 0.5e1 / 0.3e1 * t19 * t181);
  t186 = t78 * t78;
  t189 = -t181;
  t193 = my_piecewise3(t23, 0, 0.1e2 / 0.9e1 * t112 * t186 + 0.5e1 / 0.3e1 * t25 * t189);
  t196 = t7 * (t185 / 0.2e1 + t193 / 0.2e1);
  t197 = t196 * t39;
  tv2rho22 = 0.3596888888888888889e1 * t148 + t95 + t98 + 0.10790666666666666667e1 * t45 * t197 + 0.21581333333333333334e1 * t173 + t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t201 = t122 * t31;
  t203 = t8 * t201 * t39;
  t205 = t58 * t33;
  t207 = t8 * t205 * t39;
  t210 = t8 * t88 * t70;
  t213 = 0.1e1 / t30 / t10;
  t214 = t29 * t213;
  t217 = 0.399654320987654321e0 * t8 * t214 * t39;
  t220 = 0.3596888888888888889e1 * t8 * t92 * t70;
  t223 = 0.53953333333333333335e1 * t8 * t32 * t141;
  t225 = 0.1e1 / t18 / t13;
  t226 = t100 * t49;
  t229 = t99 * t49;
  t232 = t46 * t46;
  t233 = 0.1e1 / t232;
  t234 = t9 * t233;
  t236 = 0.6e1 * t104 - 0.6e1 * t234;
  t240 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t225 * t226 + 0.1e2 / 0.3e1 * t229 * t107 + 0.5e1 / 0.3e1 * t19 * t236);
  t242 = 0.1e1 / t24 / t22;
  t243 = t113 * t53;
  t246 = t112 * t53;
  t249 = -t236;
  t253 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t242 * t243 + 0.1e2 / 0.3e1 * t246 * t116 + 0.5e1 / 0.3e1 * t25 * t249);
  t255 = t240 / 0.2e1 + t253 / 0.2e1;
  t256 = t7 * t255;
  t261 = t45 * t123 * t70;
  t264 = t45 * t59 * t141;
  t277 = 0.1e1 / t31 / t103;
  t279 = 0.1e1 / t137 / t35;
  t282 = -0.72592592592592592592e-3 / t31 / t46 * t36 + 0.37037037037037037035e0 * t104 * t67 - 0.17006802721088435372e3 / t30 / t103 * t138 + 0.1928208925293473398e5 * t277 * t279;
  t285 = 0.10790666666666666667e1 * t45 * t63 * t282;
  tv3rho30 = 0.53953333333333333335e1 * t203 + 0.3596888888888888889e1 * t207 + 0.10790666666666666667e2 * t210 - t217 + t220 + t223 + 0.10790666666666666667e1 * t45 * t256 * t39 + 0.32372000000000000001e1 * t261 + 0.32372000000000000001e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t290 = t33 * t2 * t5;
  t291 = t290 * t85;
  t294 = 0.3596888888888888889e1 * t147 * t169;
  t295 = t147 * t172;
  t297 = t225 * t74;
  t300 = t99 * t9;
  t311 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t297 * t100 + 0.4e2 / 0.9e1 * t300 * t104 * t49 + 0.1e2 / 0.9e1 * t150 * t107 + 0.1e2 / 0.3e1 * t19 * t104 - 0.1e2 * t153 * t233);
  t312 = t242 * t78;
  t315 = t112 * t9;
  t326 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t312 * t113 - 0.4e2 / 0.9e1 * t315 * t104 * t53 + 0.1e2 / 0.9e1 * t158 * t116 - 0.1e2 / 0.3e1 * t25 * t104 + 0.1e2 * t161 * t233);
  t329 = t7 * (t311 / 0.2e1 + t326 / 0.2e1);
  t330 = t329 * t39;
  t333 = t168 * t70;
  t335 = 0.21581333333333333334e1 * t45 * t333;
  t336 = t84 * t141;
  t337 = t45 * t336;
  tv3rho31 = 0.17984444444444444445e1 * t203 + 0.2397925925925925926e1 * t207 + 0.7193777777777777778e1 * t210 - t217 + t220 + t223 + 0.1198962962962962963e1 * t291 + t294 + 0.3596888888888888889e1 * t295 + 0.10790666666666666667e1 * t45 * t330 + t335 + 0.10790666666666666667e1 * t337 + 0.10790666666666666667e1 * t261 + 0.21581333333333333334e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t345 = t147 * t197;
  t347 = t225 * t177;
  t352 = t99 * t181;
  t357 = -0.2e1 * t104 - 0.6e1 * t234;
  t361 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t347 * t49 + 0.4e2 / 0.9e1 * t150 * t105 + 0.1e2 / 0.9e1 * t352 * t49 + 0.5e1 / 0.3e1 * t19 * t357);
  t362 = t242 * t186;
  t367 = t112 * t189;
  t370 = -t357;
  t374 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t362 * t53 - 0.4e2 / 0.9e1 * t158 * t105 + 0.1e2 / 0.9e1 * t367 * t53 + 0.5e1 / 0.3e1 * t25 * t370);
  t377 = t7 * (t361 / 0.2e1 + t374 / 0.2e1);
  t378 = t377 * t39;
  t381 = t196 * t70;
  t382 = t45 * t381;
  tv3rho32 = 0.2397925925925925926e1 * t291 + t294 + 0.7193777777777777778e1 * t295 + 0.1198962962962962963e1 * t207 - t217 + t220 + 0.3596888888888888889e1 * t210 + t223 + 0.17984444444444444445e1 * t345 + 0.10790666666666666667e1 * t45 * t378 + 0.10790666666666666667e1 * t382 + t335 + 0.21581333333333333334e1 * t337 + 0.10790666666666666667e1 * t264 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t389 = t177 * t74;
  t395 = -0.6e1 * t104 - 0.6e1 * t234;
  t399 = my_piecewise3(t14, 0, -0.1e2 / 0.27e2 * t225 * t389 + 0.1e2 / 0.3e1 * t150 * t181 + 0.5e1 / 0.3e1 * t19 * t395);
  t400 = t186 * t78;
  t405 = -t395;
  t409 = my_piecewise3(t23, 0, -0.1e2 / 0.27e2 * t242 * t400 + 0.1e2 / 0.3e1 * t158 * t189 + 0.5e1 / 0.3e1 * t25 * t405);
  t412 = t7 * (t399 / 0.2e1 + t409 / 0.2e1);
  t413 = t412 * t39;
  tv3rho33 = 0.3596888888888888889e1 * t291 + 0.53953333333333333335e1 * t345 + 0.10790666666666666667e2 * t295 - t217 + t220 + t223 + 0.10790666666666666667e1 * t45 * t413 + 0.32372000000000000001e1 * t382 + 0.32372000000000000001e1 * t337 + t285;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t420 = t8 * t122 * t33 * t39;
  t424 = t8 * t58 * t213 * t39;
  t429 = 0.53287242798353909467e0 * t8 * t29 * t136 * t39;
  t432 = t8 * t255 * t31 * t39;
  t435 = t8 * t201 * t70;
  t438 = t8 * t205 * t70;
  t441 = t8 * t88 * t141;
  t445 = 0.1598617283950617284e1 * t8 * t214 * t70;
  t448 = 0.7193777777777777778e1 * t8 * t92 * t141;
  t451 = 0.7193777777777777778e1 * t8 * t32 * t282;
  t452 = t13 * t13;
  t454 = 0.1e1 / t18 / t452;
  t455 = t100 * t100;
  t461 = t107 * t107;
  t467 = 0.1e1 / t232 / t10;
  t468 = t9 * t467;
  t470 = -0.24e2 * t233 + 0.24e2 * t468;
  t474 = my_piecewise3(t14, 0, 0.4e2 / 0.81e2 * t454 * t455 - 0.2e2 / 0.9e1 * t225 * t100 * t107 + 0.1e2 / 0.3e1 * t99 * t461 + 0.4e2 / 0.9e1 * t229 * t236 + 0.5e1 / 0.3e1 * t19 * t470);
  t475 = t22 * t22;
  t477 = 0.1e1 / t24 / t475;
  t478 = t113 * t113;
  t484 = t116 * t116;
  t493 = my_piecewise3(t23, 0, 0.4e2 / 0.81e2 * t477 * t478 - 0.2e2 / 0.9e1 * t242 * t113 * t116 + 0.1e2 / 0.3e1 * t112 * t484 + 0.4e2 / 0.9e1 * t246 * t249 - 0.5e1 / 0.3e1 * t25 * t470);
  t501 = t45 * t256 * t70;
  t504 = t45 * t123 * t141;
  t507 = t45 * t59 * t282;
  t521 = t137 * t137;
  t528 = 0.10790666666666666667e1 * t45 * t63 * (0.19358024691358024691e-2 * t277 * t36 - 0.98765432098765432089e0 * t233 * t67 + 0.62988158226253464341e3 / t30 / t232 * t138 - 0.12854726168623155987e6 / t31 / t232 * t279 + 0.98378006392524152953e7 * t467 / t521);
  tv4rho40 = 0.7193777777777777778e1 * t420 - 0.1598617283950617284e1 * t424 + t429 + 0.7193777777777777778e1 * t432 + 0.21581333333333333334e2 * t435 + 0.14387555555555555556e2 * t438 + 0.21581333333333333334e2 * t441 - t445 + t448 + t451 + 0.10790666666666666667e1 * t45 * t7 * (t474 / 0.2e1 + t493 / 0.2e1) * t39 + 0.43162666666666666668e1 * t501 + 0.64744000000000000002e1 * t504 + 0.43162666666666666668e1 * t507 + t528;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t533 = t213 * t2 * t5 * t85;
  t540 = 0.3596888888888888889e1 * t420 - 0.1198962962962962963e1 * t424 + t429 - 0.399654320987654321e0 * t533 + 0.17984444444444444445e1 * t432 + 0.10790666666666666667e2 * t435 + 0.10790666666666666667e2 * t438 + 0.16186000000000000001e2 * t441 - t445 + t448 + t451 + 0.10790666666666666667e1 * t501;
  t543 = t290 * t169;
  t544 = 0.3596888888888888889e1 * t543;
  t545 = t290 * t172;
  t547 = t147 * t330;
  t549 = t147 * t333;
  t550 = 0.10790666666666666667e2 * t549;
  t551 = t147 * t336;
  t577 = 0.4e2 * t153 * t467;
  t579 = my_piecewise3(t14, 0, 0.4e2 / 0.81e2 * t454 * t74 * t226 - 0.2e2 / 0.9e1 * t225 * t9 * t104 * t100 - 0.1e2 / 0.9e1 * t297 * t49 * t107 + 0.2e2 / 0.3e1 * t99 * t104 * t49 - 0.2e2 * t300 * t233 * t49 + 0.2e2 / 0.3e1 * t300 * t104 * t107 + 0.1e2 / 0.9e1 * t150 * t236 - 0.2e2 * t19 * t233 + t577);
  t604 = 0.4e2 * t161 * t467;
  t606 = my_piecewise3(t23, 0, 0.4e2 / 0.81e2 * t477 * t78 * t243 + 0.2e2 / 0.9e1 * t242 * t9 * t104 * t113 - 0.1e2 / 0.9e1 * t312 * t53 * t116 - 0.2e2 / 0.3e1 * t112 * t104 * t53 + 0.2e2 * t315 * t233 * t53 - 0.2e2 / 0.3e1 * t315 * t104 * t116 + 0.1e2 / 0.9e1 * t158 * t249 + 0.2e2 * t25 * t233 - t604);
  t614 = t45 * t329 * t70;
  t617 = t45 * t168 * t141;
  t618 = 0.32372000000000000001e1 * t617;
  t620 = t45 * t84 * t282;
  t622 = 0.32372000000000000001e1 * t504 + 0.32372000000000000001e1 * t507 + t528 + t544 + 0.3596888888888888889e1 * t545 + 0.53953333333333333335e1 * t547 + t550 + 0.53953333333333333335e1 * t551 + 0.10790666666666666667e1 * t45 * t7 * (t579 / 0.2e1 + t606 / 0.2e1) * t39 + 0.32372000000000000001e1 * t614 + t618 + 0.10790666666666666667e1 * t620;
  tv4rho41 = t540 + t622;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t631 = 0.1198962962962962963e1 * t420 - 0.799308641975308642e0 * t424 + t429 + 0.3596888888888888889e1 * t435 + 0.7193777777777777778e1 * t438 + 0.10790666666666666667e2 * t441 - t445 + t448 + t451 + 0.10790666666666666667e1 * t504 + 0.21581333333333333334e1 * t507 + t528 - 0.799308641975308642e0 * t533;
  t640 = t290 * t197;
  t642 = t147 * t378;
  t644 = t147 * t381;
  t655 = t9 * t9;
  t658 = 0.1e1 / t232 / t46;
  t674 = my_piecewise3(t14, 0, 0.4e2 / 0.81e2 * t454 * t177 * t100 - 0.8e2 / 0.27e2 * t297 * t49 * t9 * t104 - 0.1e2 / 0.27e2 * t347 * t107 + 0.8e2 / 0.9e1 * t99 * t655 * t658 + 0.4e2 / 0.9e1 * t150 * t104 - 0.4e2 / 0.3e1 * t150 * t234 - 0.1e2 / 0.27e2 * t225 * t181 * t100 + 0.2e2 / 0.9e1 * t99 * t357 * t49 + 0.1e2 / 0.9e1 * t352 * t107 + t577);
  t700 = my_piecewise3(t23, 0, 0.4e2 / 0.81e2 * t477 * t186 * t113 + 0.8e2 / 0.27e2 * t312 * t53 * t9 * t104 - 0.1e2 / 0.27e2 * t362 * t116 + 0.8e2 / 0.9e1 * t112 * t655 * t658 - 0.4e2 / 0.9e1 * t158 * t104 + 0.4e2 / 0.3e1 * t158 * t234 - 0.1e2 / 0.27e2 * t242 * t189 * t113 + 0.2e2 / 0.9e1 * t112 * t370 * t53 + 0.1e2 / 0.9e1 * t367 * t116 - t604);
  t708 = t45 * t377 * t70;
  t711 = t45 * t196 * t141;
  t713 = 0.4795851851851851852e1 * t543 + 0.7193777777777777778e1 * t545 + 0.3596888888888888889e1 * t547 + 0.14387555555555555556e2 * t549 + 0.10790666666666666667e2 * t551 + 0.21581333333333333334e1 * t614 + 0.43162666666666666668e1 * t617 + 0.21581333333333333334e1 * t620 + 0.1198962962962962963e1 * t640 + 0.3596888888888888889e1 * t642 + 0.3596888888888888889e1 * t644 + 0.10790666666666666667e1 * t45 * t7 * (t674 / 0.2e1 + t700 / 0.2e1) * t39 + 0.21581333333333333334e1 * t708 + 0.10790666666666666667e1 * t711;
  tv4rho42 = t631 + t713;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t720 = -0.399654320987654321e0 * t424 + t429 - 0.1198962962962962963e1 * t533 + 0.3596888888888888889e1 * t640 + 0.3596888888888888889e1 * t438 + 0.53953333333333333335e1 * t441 - t445 + t448 + t451 + 0.10790666666666666667e1 * t507 + t528 + t544;
  t746 = 0.12e2 * t233 + 0.24e2 * t468;
  t750 = my_piecewise3(t14, 0, 0.4e2 / 0.81e2 * t454 * t389 * t49 - 0.2e2 / 0.9e1 * t347 * t105 - 0.1e2 / 0.9e1 * t297 * t181 * t49 + 0.2e2 / 0.3e1 * t300 * t104 * t181 + 0.1e2 / 0.3e1 * t150 * t357 + 0.1e2 / 0.9e1 * t99 * t395 * t49 + 0.5e1 / 0.3e1 * t19 * t746);
  t771 = my_piecewise3(t23, 0, 0.4e2 / 0.81e2 * t477 * t400 * t53 + 0.2e2 / 0.9e1 * t362 * t105 - 0.1e2 / 0.9e1 * t312 * t189 * t53 - 0.2e2 / 0.3e1 * t315 * t104 * t189 + 0.1e2 / 0.3e1 * t158 * t370 + 0.1e2 / 0.9e1 * t112 * t405 * t53 - 0.5e1 / 0.3e1 * t25 * t746);
  t779 = t45 * t412 * t70;
  t781 = t147 * t413;
  t783 = 0.10790666666666666667e2 * t545 + t550 + 0.16186e2 * t551 + t618 + 0.32372000000000000001e1 * t620 + 0.53953333333333333335e1 * t642 + 0.10790666666666666667e2 * t644 + 0.32372000000000000001e1 * t708 + 0.32372000000000000001e1 * t711 + 0.10790666666666666667e1 * t45 * t7 * (t750 / 0.2e1 + t771 / 0.2e1) * t39 + 0.10790666666666666667e1 * t779 + 0.17984444444444444445e1 * t781;
  tv4rho43 = t720 + t783;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t792 = t177 * t177;
  t797 = t181 * t181;
  t803 = 0.24e2 * t233 + 0.24e2 * t468;
  t807 = my_piecewise3(t14, 0, 0.4e2 / 0.81e2 * t454 * t792 - 0.2e2 / 0.9e1 * t347 * t181 + 0.1e2 / 0.3e1 * t99 * t797 + 0.4e2 / 0.9e1 * t150 * t395 + 0.5e1 / 0.3e1 * t19 * t803);
  t808 = t186 * t186;
  t813 = t189 * t189;
  t822 = my_piecewise3(t23, 0, 0.4e2 / 0.81e2 * t477 * t808 - 0.2e2 / 0.9e1 * t362 * t189 + 0.1e2 / 0.3e1 * t112 * t813 + 0.4e2 / 0.9e1 * t158 * t405 - 0.5e1 / 0.3e1 * t25 * t803);
  tv4rho44 = t429 - 0.1598617283950617284e1 * t533 + 0.7193777777777777778e1 * t640 - t445 + t448 + t451 + t528 + 0.14387555555555555556e2 * t545 + 0.21581333333333333334e2 * t551 + 0.43162666666666666668e1 * t620 + 0.21581333333333333334e2 * t644 + 0.64744000000000000002e1 * t711 + 0.43162666666666666668e1 * t779 + 0.10790666666666666667e1 * t45 * t7 * (t807 / 0.2e1 + t822 / 0.2e1) * t39 + 0.7193777777777777778e1 * t781;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

