// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2014 Konrad Twardowski

#pragma once

#include <QColor>

class MainWindow;

class Mod final {
public:
	static void applyMainWindowColors(MainWindow *mainWindow);
	static QVariant get(const QString &name, const QVariant &defaultValue);
	static bool getBool(const QString &name, const bool defaultValue = false);
	static QColor getColor(const QString &name, const QColor &defaultValue);
	static QString getString(const QString &name, const QString &defaultValue);
	static void init();
private:
	Q_DISABLE_COPY(Mod)
	explicit Mod() { }
	inline static QHash<QString, QVariant> *m_map = nullptr;
	static QColor getContrastBW(const QColor &base);
};
