#
# KIM-API: An API for interatomic models
# Copyright (c) 2013--2022, Regents of the University of Minnesota.
# All rights reserved.
#
# Contributors:
#    Ryan S. Elliott
#
# SPDX-License-Identifier: LGPL-2.1-or-later
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#

#
# Release: This file is part of the kim-api.git repository.
#

import subprocess
import shutil

analyticsScript = '''\
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async
src="https://www.googletagmanager.com/gtag/js?id=G-HT7Y2LG7BB"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-HT7Y2LG7BB');
</script>
'''

script=open('script.html', 'w')
script.write(analyticsScript)
script.close()

subprocess.call('conda install -y cmake', shell=True)
subprocess.call('conda env export -n root', shell=True)
subprocess.call('doxygen -w html orig_header.html orig_footer.html orig_stylesheet.css', shell=True)
subprocess.call('cat script.html orig_footer.html > footer.html', shell=True)
subprocess.call('rm -rf build; mkdir build; cd build; FC=true cmake ../../../ -DREADTHEDOCS=ON; make docs', shell=True)
html_extra_path = ['./build/docs/html']


### Sphinx keep overwriting the index.html
### This will keep a kopy of the original html file, and restore it in the end

# -------------------------------------------------------
shutil.copy(html_extra_path[0] + "/index.html", html_extra_path[0] + "/index.html_bak")

def restore_index_html(app, exception):
    sphinx_output_path = app.outdir
    shutil.copy(html_extra_path[0] + "/index.html_bak", f"{sphinx_output_path}/index.html")

def setup(app):
    app.connect("build-finished", restore_index_html)

# ----------------------------------------------------------

################################################################################

project = u'kim-api'
author = u'Ryan S. Elliott'

# The suffix(es) of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = [u'_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


